/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.operation.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.bd.entity.property.RequireTypeProp;
import kd.bos.ext.mmc.business.helper.RequireTypeHelper;
import kd.bos.ext.mmc.cache.ManustrConfigCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CheckRequireTypeRangeValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(CheckRequireTypeRangeValidator.class);
    private static final String DOT = ".";
    private static final String ID_SUFFIX = ".id";

    public Set<String> preparePropertys() {
        Set prepareProperties = super.preparePropertys();
        String entityName = this.getValidateContext().getEntityNumber();
        Map<String, Object> manustrConfigFieldMap = ManustrConfigCache.getManustrConfigFieldMap(entityName);
        if (manustrConfigFieldMap == null || manustrConfigFieldMap.isEmpty()) {
            return prepareProperties;
        }
        List fieldMapList = manustrConfigFieldMap.getOrDefault("filedMapList", new ArrayList());
        if (fieldMapList.isEmpty()) {
            return prepareProperties;
        }
        for (Map fieldMap : fieldMapList) {
            HashSet<String> fieldKeys = new HashSet<String>();
            if (!fieldMap.containsKey("GZ009")) continue;
            for (String field : fieldMap.values()) {
                if (field == null || "".equals(field) || prepareProperties.contains(field = RequireTypeHelper.removeIdSuffix(field))) continue;
                fieldKeys.add(field);
                String[] splitFields = field.split("\\.");
                fieldKeys.addAll(Arrays.asList(splitFields));
            }
            prepareProperties.addAll(fieldKeys);
        }
        return prepareProperties;
    }

    public void validate() {
        try {
            this.innerValidate();
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception exception) {
            logger.error("\u9700\u6c42\u7c7b\u578b\u53ef\u9009\u8303\u56f4\u6821\u9a8c\u53d1\u751f\u9519\u8bef", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u9700\u6c42\u7c7b\u578b\u53ef\u9009\u8303\u56f4\u6821\u9a8c\u53d1\u751f\u9519\u8bef\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"CheckRequireTypeRangeValidator_0", (String)"bos-ext-mmc", (Object[])new Object[0]));
        }
    }

    private void innerValidate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String entityName = this.getEntityKey();
        Map<String, Object> manustrConfigFieldMap = ManustrConfigCache.getManustrConfigFieldMap(entityName);
        if (manustrConfigFieldMap == null || manustrConfigFieldMap.isEmpty()) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u627e\u5230\u5df2\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u5236\u9020\u7b56\u7565\u7ef4\u5ea6\u914d\u7f6e\u3002", (String)"CheckRequireTypeRangeValidator_1", (String)"bos-ext-mmc", (Object[])new Object[0]));
            }
            return;
        }
        List dimList = manustrConfigFieldMap.getOrDefault("filedMapList", new ArrayList());
        if (dimList.isEmpty()) {
            return;
        }
        logger.info("\u89e3\u6790\u5236\u9020\u7b56\u7565\u7ef4\u5ea6\u914d\u7f6e\uff0c\u5f97\u5230\u7ef4\u5ea6\u6620\u5c04\uff1a{}", (Object)dimList);
        boolean existRequireTypeConfig = this.validateExistRequireTypeConfig(dimList);
        if (!existRequireTypeConfig) {
            return;
        }
        this.validateRequireTypeRange(dimList);
    }

    private void validateRequireTypeRange(List<Map<String, String>> dimList) {
        HashMap<Long, Set<Long>> orgMaterialMap = new HashMap<Long, Set<Long>>(16);
        HashSet<Long> materialInvSet = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            for (Map<String, String> dimMap : dimList) {
                String requireTypeKey = dimMap.getOrDefault("GZ009", "");
                if (StringUtils.isBlank((CharSequence)requireTypeKey)) continue;
                requireTypeKey = RequireTypeHelper.removeIdSuffix(requireTypeKey);
                HashMap<String, Integer> entryIndexMap = new HashMap<String, Integer>(4);
                RequireTypeHelper.recursiveCollectDimValue(bill, requireTypeKey, entryIndexMap, dimMap, bill, orgMaterialMap, materialInvSet);
            }
        }
        HashMap<String, Long> orgMatToManuStrGroupMap = new HashMap<String, Long>(16);
        HashSet<Long> manuStrGroupIdSet = new HashSet<Long>(16);
        for (Map.Entry entry : orgMaterialMap.entrySet()) {
            Map<String, Long> manuStrGroupMap = RequireTypeHelper.queryManuStrGroup((Long)entry.getKey(), (Set)entry.getValue());
            if (manuStrGroupMap.isEmpty()) continue;
            orgMatToManuStrGroupMap.putAll(manuStrGroupMap);
            manuStrGroupIdSet.addAll(manuStrGroupMap.values());
        }
        Map<Long, Long> matInvToManuStrGroupMap = RequireTypeHelper.queryManuStrGroup(materialInvSet);
        manuStrGroupIdSet.addAll(matInvToManuStrGroupMap.values());
        Map<Long, Set<Long>> requireTypeRangeMap = RequireTypeHelper.queryRequireTypeRange(manuStrGroupIdSet);
        Map<String, Map<String, String>> fieldDisplayNameMap = this.getFieldDisplayNameMap(dimList);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            for (Map<String, String> dimMap : dimList) {
                String requireTypeKey = dimMap.getOrDefault("GZ009", "");
                Map<String, String> displayNameMap = fieldDisplayNameMap.get(requireTypeKey);
                HashMap<String, Integer> entryIndexMap = new HashMap<String, Integer>(4);
                requireTypeKey = RequireTypeHelper.removeIdSuffix(requireTypeKey);
                StringBuilder msg = new StringBuilder();
                this.recursiveValidateRequireTypeRange(bill, requireTypeKey, entryIndexMap, dimMap, bill, orgMatToManuStrGroupMap, matInvToManuStrGroupMap, requireTypeRangeMap, displayNameMap, msg, dataEntity);
            }
        }
    }

    private void recursiveValidateRequireTypeRange(DynamicObject parent, String fieldKey, Map<String, Integer> entryIndexMap, Map<String, String> dimMap, DynamicObject bill, Map<String, Long> orgMatToManuStrGroupMap, Map<Long, Long> matInvToManuStrGroupMap, Map<Long, Set<Long>> requireTypeRangeMap, Map<String, String> displayNameMap, StringBuilder msg, ExtendedDataEntity dataEntity) {
        if (!fieldKey.contains(DOT)) {
            IDataEntityType dataEntityType = parent.getDataEntityType();
            boolean isExist = dataEntityType.getProperties().containsKey((Object)fieldKey);
            if (!isExist) {
                return;
            }
            Long requireTypeId = this.getId(parent.get(fieldKey));
            if (requireTypeId == 0L) {
                return;
            }
            String requireTypeDisplayName = displayNameMap.get(fieldKey);
            requireTypeDisplayName = requireTypeDisplayName == null ? ResManager.loadKDString((String)"\u9700\u6c42\u7c7b\u578b", (String)"CheckRequireTypeRangeValidator_3", (String)"bos-ext-mmc", (Object[])new Object[0]) : requireTypeDisplayName;
            msg.append(String.format("\u201c%s\u201d", requireTypeDisplayName));
            this.validateRequireTypeRange(dimMap, entryIndexMap, bill, orgMatToManuStrGroupMap, matInvToManuStrGroupMap, requireTypeRangeMap, msg, dataEntity, requireTypeId);
            return;
        }
        int index = fieldKey.indexOf(DOT);
        String subFieldKey = fieldKey.substring(0, index);
        Object obj = parent.get(subFieldKey);
        fieldKey = fieldKey.substring(index + 1);
        if (obj instanceof DynamicObjectCollection) {
            DynamicObjectCollection entry = (DynamicObjectCollection)obj;
            for (int i = 0; i < entry.size(); ++i) {
                entryIndexMap.put(subFieldKey, i);
                String entryDisplayName = displayNameMap.get(subFieldKey);
                entryDisplayName = entryDisplayName == null ? ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"CheckRequireTypeRangeValidator_2", (String)"bos-ext-mmc", (Object[])new Object[0]) : entryDisplayName;
                StringBuilder msgCopy = new StringBuilder(msg);
                msgCopy.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c%2$s\u884c", (String)"CheckRequireTypeRangeValidator_4", (String)"bos-ext-mmc", (Object[])new Object[0]), entryDisplayName, i + 1));
                DynamicObject row = (DynamicObject)entry.get(i);
                this.recursiveValidateRequireTypeRange(row, fieldKey, entryIndexMap, dimMap, bill, orgMatToManuStrGroupMap, matInvToManuStrGroupMap, requireTypeRangeMap, displayNameMap, msgCopy, dataEntity);
            }
        }
    }

    private void validateRequireTypeRange(Map<String, String> dimMap, Map<String, Integer> entryIndexMap, DynamicObject bill, Map<String, Long> orgMatToManuStrGroupMap, Map<Long, Long> matInvToManuStrGroupMap, Map<Long, Set<Long>> requireTypeRangeMap, StringBuilder msg, ExtendedDataEntity dataEntity, long requireTypeId) {
        Map<String, Object> dimValueMap = RequireTypeHelper.getDimValue(dimMap, entryIndexMap, bill);
        Object materialInvValue = dimValueMap.get("GZ007");
        Object orgValue = dimValueMap.get("GZ004");
        Object materialValue = dimValueMap.get("GZ005");
        String errMsg = String.format(ResManager.loadKDString((String)"%s\uff1a\u8d85\u51fa\u7269\u6599\u5236\u9020\u7b56\u7565\u7ec4\u8bbe\u5b9a\u7684\u9700\u6c42\u7c7b\u578b\u8303\u56f4\u3002", (String)"CheckRequireTypeRangeValidator_5", (String)"bos-ext-mmc", (Object[])new Object[0]), msg.toString());
        Long manuStrGroupId = 0L;
        if (materialInvValue != null) {
            long materialInvId = this.getId(materialInvValue);
            manuStrGroupId = matInvToManuStrGroupMap.getOrDefault(materialInvId, 0L);
        } else if (materialValue != null && orgValue != null) {
            long materialId = this.getId(materialValue);
            long orgId = this.getId(orgValue);
            String keyStr = RequireTypeHelper.buildMapKey(orgId, materialId);
            manuStrGroupId = orgMatToManuStrGroupMap.getOrDefault(keyStr, 0L);
        }
        if (manuStrGroupId > 0L) {
            Set<Long> requireTypeRange = requireTypeRangeMap.get(manuStrGroupId);
            if (requireTypeRange != null && !requireTypeRange.isEmpty() && !requireTypeRange.contains(requireTypeId)) {
                this.addErrorMessage(dataEntity, errMsg);
            }
        } else if (requireTypeId > 0L) {
            this.addErrorMessage(dataEntity, errMsg);
        }
    }

    private long getId(Object object) {
        if (object instanceof DynamicObject) {
            return ((DynamicObject)object).getLong("id");
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        return 0L;
    }

    private boolean validateExistRequireTypeConfig(List<Map<String, String>> dimList) {
        ExtendedDataEntity[] dataEntities;
        Set<String> requireTypeFieldSet = this.parsingRequireTypeField();
        logger.info("\u89e3\u6790\u5f97\u5230\u5355\u636e\u4e0a\u9700\u6c42\u7c7b\u578b\u5b57\u6bb5\u6807\u8bc6\u4e3a\u3010{}\u3011", requireTypeFieldSet);
        HashSet<String> notConfigFieldSet = new HashSet<String>(16);
        for (String field : requireTypeFieldSet) {
            boolean existConfig = false;
            for (Map<String, String> dimMap : dimList) {
                String dimKey = dimMap.getOrDefault("GZ009", "");
                if (!dimKey.contains(field)) continue;
                existConfig = true;
                break;
            }
            if (existConfig) continue;
            notConfigFieldSet.add(field);
        }
        if (notConfigFieldSet.isEmpty()) {
            return true;
        }
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5236\u9020\u7b56\u7565\u7ef4\u5ea6\u914d\u7f6e\u4e2d\u672a\u627e\u5230\u4ee5\u4e0b\u5b57\u6bb5\u7684\u914d\u7f6e\uff1a%s\u3002", (String)"CheckRequireTypeRangeValidator_8", (String)"bos-ext-mmc", (Object[])new Object[0]), notConfigFieldSet));
        }
        return false;
    }

    private Set<String> parsingRequireTypeField() {
        HashSet<String> requireTypeFieldSet = new HashSet<String>(16);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityKey());
        Map allEntities = mainEntityType.getAllEntities();
        for (EntityType entityType : allEntities.values()) {
            Map fieldMap = entityType.getFields();
            for (IDataEntityProperty prop : fieldMap.values()) {
                if (!(prop instanceof RequireTypeProp)) continue;
                String propName = prop.getName();
                requireTypeFieldSet.add(propName);
            }
        }
        return requireTypeFieldSet;
    }

    private Map<String, Map<String, String>> getFieldDisplayNameMap(List<Map<String, String>> dimList) {
        HashMap<String, Map<String, String>> displayNameMap = new HashMap<String, Map<String, String>>(16);
        for (Map<String, String> dimMap : dimList) {
            String requireTypeKey = dimMap.get("GZ009");
            Map<String, String> fieldDisplayName = this.getFieldDisplayNameMap(requireTypeKey);
            displayNameMap.put(requireTypeKey, fieldDisplayName);
        }
        return displayNameMap;
    }

    private Map<String, String> getFieldDisplayNameMap(String requireTypeKey) {
        HashMap<String, String> displayNameMap = new HashMap<String, String>(8);
        requireTypeKey = RequireTypeHelper.removeIdSuffix(requireTypeKey);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getEntityKey());
        DataEntityPropertyCollection properties = entityType.getProperties();
        int i = requireTypeKey.indexOf(DOT);
        while (i != -1) {
            String subKey = requireTypeKey.substring(0, i);
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)subKey);
            if (property == null) {
                logger.info("\u6839\u636e\u9700\u6c42\u7c7b\u578b\u7ef4\u5ea6\u6620\u5c04\u5b57\u6bb5\u3010{}\u3011\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5b57\u6bb5", (Object)subKey);
                displayNameMap.put(subKey, ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"CheckRequireTypeRangeValidator_2", (String)"bos-ext-mmc", (Object[])new Object[0]));
                return displayNameMap;
            }
            LocaleString displayName = property.getDisplayName();
            if (displayName == null || displayName.isEmpty()) {
                displayNameMap.put(subKey, ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"CheckRequireTypeRangeValidator_2", (String)"bos-ext-mmc", (Object[])new Object[0]));
            } else {
                displayNameMap.put(subKey, displayName.getLocaleValue());
            }
            EntryProp entryProp = (EntryProp)property;
            DynamicObjectType entryItemType = entryProp.getDynamicCollectionItemPropertyType();
            properties = entryItemType.getProperties();
            requireTypeKey = requireTypeKey.substring(i + 1);
            i = requireTypeKey.indexOf(DOT);
        }
        IDataEntityProperty requireTypeProp = (IDataEntityProperty)properties.get((Object)requireTypeKey);
        if (requireTypeProp == null) {
            logger.info("\u6839\u636e\u9700\u6c42\u7c7b\u578b\u7ef4\u5ea6\u6620\u5c04\u5b57\u6bb5\u3010{}\u3011\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5b57\u6bb5", (Object)requireTypeKey);
            displayNameMap.put(requireTypeKey, ResManager.loadKDString((String)"\u9700\u6c42\u7c7b\u578b", (String)"CheckRequireTypeRangeValidator_3", (String)"bos-ext-mmc", (Object[])new Object[0]));
            return displayNameMap;
        }
        LocaleString displayName = requireTypeProp.getDisplayName();
        if (displayName == null || displayName.isEmpty()) {
            displayNameMap.put(requireTypeKey, ResManager.loadKDString((String)"\u9700\u6c42\u7c7b\u578b", (String)"CheckRequireTypeRangeValidator_3", (String)"bos-ext-mmc", (Object[])new Object[0]));
        } else {
            displayNameMap.put(requireTypeKey, displayName.getLocaleValue());
        }
        return displayNameMap;
    }
}

