/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.operation.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ProjectAndWbsValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(ProjectAndWbsValidator.class);

    public Set<String> preparePropertys() {
        List parameterlist;
        Set prepareProperties = super.preparePropertys();
        Map validation = this.getValidation();
        String paramValue = (String)validation.get("parameter");
        if (paramValue != null && !(parameterlist = (List)SerializationUtils.fromJsonString((String)paramValue, List.class)).isEmpty()) {
            for (Map parameterMap : parameterlist) {
                String projectnumber;
                String wbsnumber = (String)parameterMap.get("wbsnumber");
                if (wbsnumber != null && !wbsnumber.isEmpty()) {
                    prepareProperties.addAll(this.getProPertys(wbsnumber));
                }
                if ((projectnumber = (String)parameterMap.get("projectnumber")) == null || projectnumber.isEmpty()) continue;
                prepareProperties.addAll(this.getProPertys(projectnumber));
            }
        }
        return prepareProperties;
    }

    private List<String> getProPertys(String name) {
        ArrayList<String> list = new ArrayList<String>(8);
        String[] names = name.split("\\.");
        if (names.length == 1) {
            list.add(name);
        } else if (names.length == 2) {
            list.add(names[0]);
            list.add(names[1]);
            list.add(name);
        } else if (names.length == 3) {
            list.add(names[0]);
            list.add(names[0] + "." + names[1]);
            list.add(name);
            list.add(names[2]);
            list.add(names[1]);
        }
        return list;
    }

    public void validate() {
        List parameterlist;
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        Map validation = this.getValidation();
        String paramValue = (String)validation.get("parameter");
        if (paramValue != null && !(parameterlist = (List)SerializationUtils.fromJsonString((String)paramValue, List.class)).isEmpty()) {
            HashSet<String> wbsParameterSet = new HashSet<String>(parameterlist.size());
            for (Map parameterMap : parameterlist) {
                wbsParameterSet.add((String)parameterMap.get("wbsnumber"));
            }
            Set<Long> wbsIds = this.getwbsId(dataEntities, wbsParameterSet);
            if (!wbsIds.isEmpty()) {
                Map<Long, Long> wbsProjectMap = this.getwbsProjectMap(wbsIds);
                this.checkWbsProject(dataEntities, wbsProjectMap, parameterlist);
            }
        }
    }

    private void checkWbsProject(ExtendedDataEntity[] dataEntities, Map<Long, Long> wbsProjectMap, List<Map<String, String>> parameterlist) {
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            for (Map<String, String> parameter : parameterlist) {
                DynamicObjectCollection entryentity;
                String[] wbsParameterSp = parameter.get("wbsnumber").split("\\.");
                String[] projectParameterSp = parameter.get("projectnumber").split("\\.");
                if (wbsParameterSp.length == 1) {
                    Long wbsid = data.getLong(wbsParameterSp[0] + ".id");
                    if (wbsid == null || wbsid == 0L) continue;
                    Long projectId = data.getLong(projectParameterSp[0] + ".id");
                    if (!projectId.equals(wbsProjectMap.get(wbsid))) {
                        this.addLog(extendedDataEntity, data.getString(projectParameterSp[0] + ".number"), data.getLong(projectParameterSp[0] + ".id"), data.getString(wbsParameterSp[0] + ".number"), data.getLong(wbsParameterSp[0] + ".id"), false);
                        this.addErrorMessage(extendedDataEntity, data.getString(projectParameterSp[0] + ".number"), data.getString(wbsParameterSp[0] + ".number"));
                        continue;
                    }
                    this.addLog(extendedDataEntity, data.getString(projectParameterSp[0] + ".number"), data.getLong(projectParameterSp[0] + ".id"), data.getString(wbsParameterSp[0] + ".number"), data.getLong(wbsParameterSp[0] + ".id"), true);
                    continue;
                }
                if (wbsParameterSp.length == 2) {
                    entryentity = data.getDynamicObjectCollection(wbsParameterSp[0]);
                    for (DynamicObject dynamicObject : entryentity) {
                        Long projectId;
                        Long wbsid = dynamicObject.getLong(wbsParameterSp[1] + ".id");
                        if (wbsid == null || wbsid == 0L) continue;
                        if (projectParameterSp.length == 1) {
                            projectId = data.getLong(projectParameterSp[0] + ".id");
                            if (!projectId.equals(wbsProjectMap.get(wbsid))) {
                                this.addLog(extendedDataEntity, data.getString(projectParameterSp[0] + ".number"), data.getLong(projectParameterSp[0] + ".id"), dynamicObject.getString(wbsParameterSp[1] + ".number"), dynamicObject.getLong(wbsParameterSp[1] + ".id"), false);
                                this.addErrorMessage(extendedDataEntity, data.getString(projectParameterSp[0] + ".number"), dynamicObject.getString(wbsParameterSp[1] + ".number"));
                                continue;
                            }
                            this.addLog(extendedDataEntity, data.getString(projectParameterSp[0] + ".number"), data.getLong(projectParameterSp[0] + ".id"), dynamicObject.getString(wbsParameterSp[1] + ".number"), dynamicObject.getLong(wbsParameterSp[1] + ".id"), true);
                            continue;
                        }
                        if (projectParameterSp.length != 2) continue;
                        projectId = dynamicObject.getLong(projectParameterSp[1] + ".id");
                        if (!projectId.equals(wbsProjectMap.get(wbsid))) {
                            this.addLog(extendedDataEntity, dynamicObject.getString(projectParameterSp[1] + ".number"), dynamicObject.getLong(projectParameterSp[1] + ".id"), dynamicObject.getString(wbsParameterSp[1] + ".number"), dynamicObject.getLong(wbsParameterSp[1] + ".id"), false);
                            this.addErrorMessage(extendedDataEntity, dynamicObject.getString(projectParameterSp[1] + ".number"), dynamicObject.getString(wbsParameterSp[1] + ".number"));
                            continue;
                        }
                        this.addLog(extendedDataEntity, dynamicObject.getString(projectParameterSp[1] + ".number"), dynamicObject.getLong(projectParameterSp[1] + ".id"), dynamicObject.getString(wbsParameterSp[1] + ".number"), dynamicObject.getLong(wbsParameterSp[1] + ".id"), true);
                    }
                    continue;
                }
                if (wbsParameterSp.length != 3) continue;
                entryentity = data.getDynamicObjectCollection(wbsParameterSp[0]);
                for (DynamicObject entry2dynamicObject : entryentity) {
                    DynamicObjectCollection entry3dynamicObjectColl = entry2dynamicObject.getDynamicObjectCollection(wbsParameterSp[1]);
                    for (DynamicObject entry3dynamicObject : entry3dynamicObjectColl) {
                        Long projectId;
                        Long wbsid = entry3dynamicObject.getLong(wbsParameterSp[2] + ".id");
                        if (wbsid == null || wbsid == 0L) continue;
                        if (projectParameterSp.length == 1) {
                            projectId = data.getLong(projectParameterSp[0] + ".id");
                            if (!projectId.equals(wbsProjectMap.get(wbsid))) {
                                this.addLog(extendedDataEntity, data.getString(projectParameterSp[0] + ".number"), data.getLong(projectParameterSp[0] + ".id"), entry3dynamicObject.getString(wbsParameterSp[2] + ".number"), entry3dynamicObject.getLong(wbsParameterSp[2] + ".id"), false);
                                this.addErrorMessage(extendedDataEntity, data.getString(projectParameterSp[0] + ".number"), entry3dynamicObject.getString(wbsParameterSp[2] + ".number"));
                                continue;
                            }
                            this.addLog(extendedDataEntity, data.getString(projectParameterSp[0] + ".number"), data.getLong(projectParameterSp[0] + ".id"), entry3dynamicObject.getString(wbsParameterSp[2] + ".number"), entry3dynamicObject.getLong(wbsParameterSp[2] + ".id"), true);
                            continue;
                        }
                        if (projectParameterSp.length == 2) {
                            projectId = entry2dynamicObject.getLong(projectParameterSp[1] + ".id");
                            if (!projectId.equals(wbsProjectMap.get(wbsid))) {
                                this.addLog(extendedDataEntity, entry2dynamicObject.getString(projectParameterSp[1] + ".number"), entry2dynamicObject.getLong(projectParameterSp[1] + ".id"), entry3dynamicObject.getString(wbsParameterSp[2] + ".number"), entry3dynamicObject.getLong(wbsParameterSp[2] + ".id"), false);
                                this.addErrorMessage(extendedDataEntity, entry2dynamicObject.getString(projectParameterSp[1] + ".number"), entry3dynamicObject.getString(wbsParameterSp[2] + ".number"));
                                continue;
                            }
                            this.addLog(extendedDataEntity, entry2dynamicObject.getString(projectParameterSp[1] + ".number"), entry2dynamicObject.getLong(projectParameterSp[1] + ".id"), entry3dynamicObject.getString(wbsParameterSp[2] + ".number"), entry3dynamicObject.getLong(wbsParameterSp[2] + ".id"), true);
                            continue;
                        }
                        if (projectParameterSp.length != 3) continue;
                        projectId = entry3dynamicObject.getLong(projectParameterSp[2] + ".id");
                        if (!projectId.equals(wbsProjectMap.get(wbsid))) {
                            this.addLog(extendedDataEntity, entry3dynamicObject.getString(projectParameterSp[2] + ".number"), entry3dynamicObject.getLong(projectParameterSp[2] + ".id"), entry3dynamicObject.getString(wbsParameterSp[2] + ".number"), entry3dynamicObject.getLong(wbsParameterSp[2] + ".id"), false);
                            this.addErrorMessage(extendedDataEntity, entry3dynamicObject.getString(projectParameterSp[2] + ".number"), entry3dynamicObject.getString(wbsParameterSp[2] + ".number"));
                            continue;
                        }
                        this.addLog(extendedDataEntity, entry3dynamicObject.getString(projectParameterSp[2] + ".number"), entry3dynamicObject.getLong(projectParameterSp[2] + ".id"), entry3dynamicObject.getString(wbsParameterSp[2] + ".number"), entry3dynamicObject.getLong(wbsParameterSp[2] + ".id"), true);
                    }
                }
            }
        }
    }

    private void addLog(ExtendedDataEntity extendedDataEntity, String project, Long projectId, String wbs, Long wbsId, boolean success) {
        String su = success ? "success" : "faild";
        logger.warn(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u4e2d\u9879\u76ee\u53f7\u201c%2$s\u201d\u201c%3$s\u201d\u548cWBS\u53f7\u201c%4$s\u201d\u201c%5$s\u201d\u5339\u914d%6$s\uff0c", (String)"ProjectAndWbsValidator_2", (String)"bos-ext-mmc", (Object[])new Object[0]), extendedDataEntity.getBillNo(), project, projectId, wbs, wbsId, su));
    }

    private void addErrorMessage(ExtendedDataEntity extendedDataEntity, String project, String wbs) {
        String op = this.getOperationName();
        this.addMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u9879\u76ee\u53f7\u201c%1$s\u201d\u548cWBS\u53f7\u201c%2$s\u201d\u4e0d\u5339\u914d\uff0c\u4e0d\u5141\u8bb8%3$s\u3002", (String)"ProjectAndWbsValidator_1", (String)"bos-ext-mmc", (Object[])new Object[0]), project == null ? "" : project, wbs, op));
    }

    private Map<Long, Long> getwbsProjectMap(Set<Long> wbsIds) {
        HashMap<Long, Long> wbsProjectMap = new HashMap<Long, Long>(wbsIds.size());
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", wbsIds)};
        DynamicObjectCollection wbsDynCosll = QueryServiceHelper.query((String)"bd_wbs", (String)"id,project.id", (QFilter[])filters);
        for (DynamicObject wbsDyn : wbsDynCosll) {
            wbsProjectMap.put(wbsDyn.getLong("id"), wbsDyn.getLong("project.id"));
        }
        return wbsProjectMap;
    }

    private Set<Long> getwbsId(ExtendedDataEntity[] dataEntities, Set<String> wbsParameterSet) {
        HashSet<Long> wbsIds = new HashSet<Long>(8);
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            for (String wbsParameter : wbsParameterSet) {
                DynamicObjectCollection entryentity;
                String[] wbsParameterSp = wbsParameter.split("\\.");
                if (wbsParameterSp.length == 1) {
                    wbsIds.add(data.getLong(wbsParameter + ".id"));
                    continue;
                }
                if (wbsParameterSp.length == 2) {
                    entryentity = data.getDynamicObjectCollection(wbsParameterSp[0]);
                    for (DynamicObject dynamicObject : entryentity) {
                        wbsIds.add(dynamicObject.getLong(wbsParameterSp[1] + ".id"));
                    }
                    continue;
                }
                if (wbsParameterSp.length != 3) continue;
                entryentity = data.getDynamicObjectCollection(wbsParameterSp[0]);
                for (DynamicObject entry2dynamicObject : entryentity) {
                    DynamicObjectCollection entry3dynamicObjectColl = entry2dynamicObject.getDynamicObjectCollection(wbsParameterSp[1]);
                    for (DynamicObject entry3dynamicObject : entry3dynamicObjectColl) {
                        wbsIds.add(entry3dynamicObject.getLong(wbsParameterSp[2] + ".id"));
                    }
                }
            }
        }
        return wbsIds;
    }
}

