/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.plugin;

import java.util.EventObject;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.mmc.util.MetaDataHelper;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;

public class GetBizDefaultTransType
extends AbstractFuncParamPlugIn {
    private static final String ORG = "org";
    private static final String BIZTYPE = "biztype";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{ORG});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)ORG)) {
            this.showSelectFieldForm(ORG);
        }
    }

    private void showSelectFieldForm(String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        TreeNode fieldNodes = this.getVarNodes();
        String formId = fieldNodes.getId();
        MainEntityType dataEntityType = MetaDataHelper.getDataEntityType(formId, MetaCategory.Form);
        this.removeNotOrgNode(fieldNodes, dataEntityType);
        String nodesJson = SerializationUtils.toJsonString((Object)fieldNodes);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void removeNotOrgNode(TreeNode treeNode, MainEntityType dataEntityType) {
        List children = treeNode.getChildren();
        String nodeId = treeNode.getId();
        if (children != null && !children.isEmpty()) {
            DynamicProperty property = this.getProperty(nodeId, dataEntityType);
            if (property instanceof OrgProp) {
                treeNode.setChildren(null);
            } else {
                for (TreeNode child : children) {
                    this.removeNotOrgNode(child, dataEntityType);
                }
                ListIterator listIterator = children.listIterator();
                while (listIterator.hasNext()) {
                    Object data = ((TreeNode)listIterator.next()).getData();
                    if (!"toremove".equals(data)) continue;
                    listIterator.remove();
                }
                if (children.isEmpty()) {
                    this.removeNotOrgNode(treeNode, dataEntityType);
                }
            }
        } else {
            String[] split = nodeId.split("[.]");
            DynamicProperty property = this.getProperty(split[0], dataEntityType);
            if (!(property instanceof OrgProp)) {
                treeNode.setData((Object)"toremove");
            }
        }
    }

    private DynamicProperty getProperty(String propName, MainEntityType dt) {
        DynamicProperty property = dt.getProperty(propName);
        if (property == null) {
            DataEntityPropertyCollection properties = dt.getProperties();
            for (IDataEntityProperty pro : properties) {
                if (!(pro instanceof EntryProp) || pro instanceof LinkEntryProp) continue;
                EntryProp entryProp = (EntryProp)pro;
                property = entryProp._collectionItemPropertyType.getProperty(propName);
                if (property == null) continue;
                return property;
            }
        }
        return property;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)ORG)) {
            this.getModel().setValue(ORG, closedCallBackEvent.getReturnData());
        }
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        String org = (String)this.getModel().getValue(ORG);
        Object bizTypeObj = this.getModel().getValue(BIZTYPE);
        if (StringUtils.isBlank((CharSequence)org)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ec4\u7ec7\u3002", (String)"GetBizDefaultTransType_0", (String)"bos-ext-mmc", (Object[])new Object[0]));
            return false;
        }
        if (Objects.isNull(bizTypeObj)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"GetBizDefaultTransType_1", (String)"bos-ext-mmc", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public String getSetting() {
        String orgId = (String)this.getModel().getValue(ORG);
        if (StringUtils.isBlank((CharSequence)orgId)) {
            orgId = "0";
        }
        Object bizTypeId = 0L;
        Object bizTypeObj = this.getModel().getValue(BIZTYPE);
        if (!Objects.isNull(bizTypeObj)) {
            bizTypeId = ((DynamicObject)bizTypeObj).getPkValue();
        }
        String setting = String.format("%s(%s, %s)", this.getFuncId(), orgId, bizTypeId);
        return setting;
    }
}

