/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hrswc.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.ext.hrswc.thread.ISWCUnifiedTaskType;
import kd.bos.unifiedthreadpool.api.PoolRejectedExecutionHandler;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.unifiedthreadpool.api.ThreadPoolFactory;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategy;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategyFactory;
import kd.bos.unifiedthreadpool.policy.AbortPolicy;
import kd.bos.unifiedthreadpool.tasktype.Priority;
import kd.bos.unifiedthreadpool.tasktype.TaskType;

public class SWCThreadExecutorService {
    private static final ThreadExecutorService SERVICE = ThreadPoolFactory.create((String)"swc", (String)"swc-threadpool", (ThreadPoolStrategy)SWCThreadExecutorService.getDefaultThreadPoolStrategy());

    private static ThreadPoolStrategy getDefaultThreadPoolStrategy() {
        ThreadPoolStrategy strategy = ThreadPoolStrategyFactory.create();
        strategy.setMinThreadNum(50).setMaxThreadNum(150).setOverflowThreadNum(20).setThreadIdeMinutes(1L);
        strategy.setRejectedExecutionHandler((PoolRejectedExecutionHandler)new AbortPolicy());
        strategy.register(new TaskType("swc.commontask", Priority.FIVE));
        return strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ThreadExecutorService get(ISWCUnifiedTaskType taskTypeEnum) {
        TaskType taskType = SWCThreadExecutorService.getTaskType(taskTypeEnum);
        if (taskType == null) {
            ISWCUnifiedTaskType iSWCUnifiedTaskType = taskTypeEnum;
            synchronized (iSWCUnifiedTaskType) {
                taskType = SWCThreadExecutorService.getTaskType(taskTypeEnum);
                if (taskType == null) {
                    taskType = new TaskType(taskTypeEnum.getName(), taskTypeEnum.getPriority(), taskTypeEnum.getThreadLimitedModel(), (Object)taskTypeEnum.getThreadLimitedValue(), taskTypeEnum.getTaskQueueMaxSize());
                    SERVICE.addTaskType(taskType);
                }
            }
        }
        return SERVICE;
    }

    private static TaskType getTaskType(ISWCUnifiedTaskType taskTypeEnum) {
        TaskType taskType = null;
        try {
            taskType = SERVICE.getTaskType(taskTypeEnum.getName());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return taskType;
    }

    public static void execute(Runnable runnable, ISWCUnifiedTaskType taskTypeEnum, RequestContext requestContext, OperationContext operationContext) {
        SWCThreadExecutorService.get(taskTypeEnum).execute(runnable, taskTypeEnum.getName(), requestContext, operationContext);
    }

    public static <T> Future<T> submit(Callable<T> calltable, ISWCUnifiedTaskType taskTypeEnum, RequestContext requestContext, OperationContext operationContext) {
        return SWCThreadExecutorService.get(taskTypeEnum).submit(calltable, taskTypeEnum.getName(), requestContext, operationContext);
    }
}

