/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.occ.action.common;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.occ.action.common.AbstractAction;
import kd.bos.ext.occ.action.common.ActionResult;
import kd.bos.ext.occ.action.common.CodeMsg;
import kd.bos.ext.occ.action.common.ResultInfoDTO;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BaseAction
extends AbstractAction {
    private static final Log LOGGER = LogFactory.getLog(BaseAction.class);
    private static final String ORDER_BIZ_EXCEPTION = " OrderBizException";
    private static final String EXCEPTION = " Exception";

    public <P, R> ActionResult actionHandler(Class<P> paramClass, Function<P, R> function, HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.actionHandler(paramClass, function, true, request, response);
    }

    public <P, R> ActionResult actionHandler(Class<P> paramClass, Function<P, R> function, boolean printLog, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ActionResult<?> result;
        long startTime = System.currentTimeMillis();
        String actionName = this.getParentActionName();
        try {
            String requestJson = this.getRequestJson(request);
            LOGGER.info("{} request:{}", (Object)actionName, (Object)requestJson);
            Object param = JSON.parseObject((String)requestJson, paramClass);
            R res = function.apply(param);
            result = this.getActionResult(res);
            this.responseLog(printLog, result, actionName);
        }
        catch (KDBizException e) {
            LOGGER.warn(actionName + ORDER_BIZ_EXCEPTION, (Throwable)e);
            result = ActionResult.fail((String)e.getMessage(), null);
        }
        catch (Exception e) {
            LOGGER.error(actionName + EXCEPTION, (Throwable)e);
            result = ActionResult.fail((String)e.getMessage(), null);
        }
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)new ObjectMapper().writeValueAsString(result));
        LOGGER.info("{} \u8017\u65f6:{} ms", (Object)actionName, (Object)(System.currentTimeMillis() - startTime));
        return result;
    }

    private String getParentActionName() {
        try {
            return Thread.currentThread().getStackTrace()[3].getMethodName();
        }
        catch (Exception ex) {
            LOGGER.info("getParentActionName error");
            return "";
        }
    }

    private <R> ActionResult<?> getActionResult(R res) {
        if (res instanceof ActionResult) {
            return (ActionResult)res;
        }
        if (res instanceof ResultInfoDTO) {
            ResultInfoDTO resultInfoDTO = (ResultInfoDTO)res;
            return new ActionResult(resultInfoDTO.getCode(), resultInfoDTO.getMsg(), resultInfoDTO.getData());
        }
        return ActionResult.success((CodeMsg)CodeMsg.SUCCESS, res);
    }

    public <R> ActionResult actionHandler(Supplier<R> supplier, HttpServletResponse response) throws IOException {
        ActionResult result;
        long startTime = System.currentTimeMillis();
        String actionName = this.getParentActionName();
        try {
            R res = supplier.get();
            result = this.getActionResult(res);
            this.responseLog(true, result, actionName);
        }
        catch (KDBizException e) {
            LOGGER.warn(actionName + ORDER_BIZ_EXCEPTION, (Throwable)e);
            result = ActionResult.fail((String)e.getMessage(), null);
        }
        catch (Exception e) {
            LOGGER.error(actionName + EXCEPTION, (Throwable)e);
            result = ActionResult.fail((String)CodeMsg.SERVER_ERROR.getMsg(), null);
        }
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)new ObjectMapper().writeValueAsString((Object)result));
        LOGGER.info("{} \u8017\u65f6:{} ms", (Object)actionName, (Object)(System.currentTimeMillis() - startTime));
        return result;
    }

    public <P, R> ActionResult actionHandler(Class<P> paramClass, String key, Function<P, R> function, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ActionResult<?> result;
        long startTime = System.currentTimeMillis();
        String actionName = this.getParentActionName();
        try {
            String paramStr = request.getParameter(key);
            LOGGER.info("{} request:{}={}", new Object[]{actionName, key, paramStr});
            if (paramStr == null) {
                ActionResult result2 = ActionResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"BaseAction_0", (String)"bos-ext-occ", (Object[])new Object[]{key}), null);
                ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)new ObjectMapper().writeValueAsString((Object)result2));
                return result2;
            }
            Object param = JSON.parseObject((String)paramStr, paramClass);
            R res = function.apply(param);
            result = this.getActionResult(res);
            this.responseLog(true, result, actionName);
        }
        catch (KDBizException e) {
            LOGGER.warn(actionName + ORDER_BIZ_EXCEPTION, (Throwable)e);
            result = ActionResult.fail((String)e.getMessage(), null);
        }
        catch (Exception e) {
            LOGGER.error(actionName + EXCEPTION, (Throwable)e);
            result = ActionResult.fail((String)CodeMsg.SERVER_ERROR.getMsg(), null);
        }
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)new ObjectMapper().writeValueAsString((Object)result));
        LOGGER.info("{} \u8017\u65f6:{} ms", (Object)actionName, (Object)(System.currentTimeMillis() - startTime));
        return result;
    }

    private void responseLog(boolean printLog, ActionResult<?> result, String actionName) {
        if (!printLog) {
            return;
        }
        String resultJson = JSON.toJSONString(result);
        LOGGER.info("{} Response:{}", (Object)actionName, (Object)resultJson);
    }
}

