/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.occ.plugin.func;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;

public class GetChannelByCustomerIdPlugIn
extends AbstractFuncParamPlugIn {
    private static final String KEY_CUSTOMERID = "customerid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_CUSTOMERID});
    }

    public void click(EventObject e) {
        super.click(e);
        Control ctrl = (Control)e.getSource();
        String key = ctrl.getKey();
        if (KEY_CUSTOMERID.equals(key)) {
            this.showSelectFieldForm(key);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        String actionId = e.getActionId();
        if (KEY_CUSTOMERID.equals(actionId)) {
            this.getModel().setValue(actionId, returnData);
        }
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String customerId = dataEntity.getString(KEY_CUSTOMERID);
        if (StringUtils.isBlank((CharSequence)customerId)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5ba2\u6237id\u3002", (String)"GetChannelByCustomerIdPlugIn_0", (String)"bos-ext-occ", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getSetting() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String customerId = dataEntity.getString(KEY_CUSTOMERID);
        return String.format("%s(%s)", this.getFuncId(), customerId);
    }

    private void showSelectFieldForm(String sourceCtrlKey) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("botp_selectfield");
        TreeNode treeNode = this.getVarNodes();
        String node = SerializationUtils.toJsonString((Object)treeNode);
        parameter.getCustomParams().put("treenodes", node);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }
}

