/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.data.idi.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.data.idi.formplugin.SmartPanelPlugin;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.servicehelper.image.ImageServiceNewHelper;
import kd.bos.util.CollectionUtils;

public class AISmartPanelPlugin
extends SmartPanelPlugin {
    private static final Log logger = LogFactory.getLog(AISmartPanelPlugin.class);
    protected static final String KEY_VIEWAUDITELEMENT = "viewAuditElement";
    protected static final String KEY_FILTERRESULT = "filterResult";
    protected static final String KEY_FILTERRESULTBYAI = "filterResultByAi";
    protected static final String KEY_INQUIRIESAI = "inquiriesAi";
    protected static final String KEY_FILTERTYPE = "filterType";
    protected static final String KEY_FILTERAI = "filterAI";
    protected static final String KEY_VIEWATTACHMENT = "viewAttachment";
    protected static final String KEY_NEEDAITIPS = "needAiTips";
    protected static final String KEY_PREPROCESSATTACHMENT = "preprocessAttachment";
    protected static final String KEY_PREPROCESSSCOPE = "scope";
    protected static final String KEY_VIEWNEEDREFRESHBTN = "viewNeedRefreshBtn";

    @Override
    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String customKey = e.getKey();
        if (this.getSmartPanelKey().equals(customKey)) {
            String eventName;
            switch (eventName = e.getEventName()) {
                case "viewAuditElement": {
                    this.viewAuditElement();
                    break;
                }
                case "filterResult": {
                    this.filterResult(e.getEventArgs());
                    break;
                }
                case "filterResultByAi": {
                    this.filterResultByAI(e.getEventArgs());
                    break;
                }
                case "inquiriesAi": {
                    this.inquiriesAi();
                    break;
                }
                case "viewAttachment": {
                    this.viewAttachment(e.getEventArgs());
                    break;
                }
                case "preprocessAttachment": {
                    this.preprocessAttachment();
                }
            }
        }
    }

    protected void preprocessAttachment() {
        Map resultMap;
        String billType = this.getPageCache().get("billType");
        billType = kd.bos.util.StringUtils.isNotEmpty((String)billType) ? FormMetadataCache.getFormConfig((String)billType).getEntityTypeId() : billType;
        String billId = this.getPageCache().get("billId");
        logger.info("billty : " + billType);
        Object id = this.castId(billType, (Object)billId);
        Map<String, Object> paramMap = this.achieveCustomParamMap();
        String scope = (String)paramMap.get(KEY_PREPROCESSSCOPE);
        try {
            resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fgptas", (String)"BillAuditService", (String)"manualRetryBillAudit", (Object[])new Object[]{billType, id, scope});
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            resultMap = new HashMap<String, Object>(3);
            resultMap.put("success", false);
            resultMap.put("errMsg", e.getMessage());
        }
        if (resultMap != null && !resultMap.isEmpty() && ((Boolean)resultMap.get("success")).booleanValue()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("action", "refreshResult");
            map.put("version", String.valueOf(System.nanoTime()));
            CustomControl control = (CustomControl)this.getView().getControl(this.getSmartPanelKey());
            control.setData(map);
        } else {
            this.getView().showErrorNotification((String)paramMap.get("errMsg"));
        }
    }

    protected void viewAttachment(String paramStr) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)paramStr)) {
            JSONArray paramJsonArray = JSONObject.parseArray((String)paramStr);
            if (paramJsonArray == null || paramJsonArray.isEmpty()) {
                return;
            }
            JSONObject paramJson = paramJsonArray.getJSONObject(0);
            int sourceType = paramJson.getIntValue("sourceType");
            if (1 == sourceType) {
                String previewUrl = paramJson.getString("url");
                if (kd.bos.util.StringUtils.isEmpty((String)previewUrl)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u9884\u89c8\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u5728\u9644\u4ef6\u6a21\u677f\u68c0\u67e5\u9644\u4ef6\u662f\u5426\u6b63\u5e38\u3002", (String)"AISmartPanelPlugin_2", (String)"bos-ext-data", (Object[])new Object[0]));
                }
                this.showAttachment(previewUrl);
            } else if (2 == sourceType) {
                RequestContext ctx = RequestContext.get();
                String billId = this.getPageCache().get("billId");
                ArrayList<String> list = new ArrayList<String>(2);
                list.add(billId);
                Map imageInfoMap = ImageServiceNewHelper.getImageInfoInsideBatch(list, (String)"billid");
                if (imageInfoMap == null || imageInfoMap.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u65e0\u5f71\u50cf\uff0c\u8bf7\u5148\u4e0a\u4f20\u5f71\u50cf\u3002", (String)"AISmartPanelPlugin_3", (String)"bos-ext-data", (Object[])new Object[0]));
                    return;
                }
                Optional<ImageInfo> ImageInfoOp = imageInfoMap.values().stream().filter(info -> info.getBillId().equals(billId)).findAny();
                if (!ImageInfoOp.isPresent()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u65e0\u5f71\u50cf\uff0c\u8bf7\u5148\u4e0a\u4f20\u5f71\u50cf\u3002", (String)"AISmartPanelPlugin_3", (String)"bos-ext-data", (Object[])new Object[0]));
                    return;
                }
                String imagenumber = ImageInfoOp.get().getImageNo();
                if (kd.bos.util.StringUtils.isEmpty((String)imagenumber)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u65e0\u5f71\u50cf\uff0c\u8bf7\u5148\u4e0a\u4f20\u5f71\u50cf\u3002", (String)"AISmartPanelPlugin_3", (String)"bos-ext-data", (Object[])new Object[0]));
                    return;
                }
                String url = ImageServiceHelper.viewPhoto((String)imagenumber, (String)String.valueOf(ctx.getCurrUserId()), (String)ctx.getUserName());
                if (kd.bos.util.StringUtils.isEmpty((String)url)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u65e0\u5f71\u50cf\uff0c\u8bf7\u5148\u4e0a\u4f20\u5f71\u50cf\u3002", (String)"AISmartPanelPlugin_3", (String)"bos-ext-data", (Object[])new Object[0]));
                } else {
                    this.showAttachment(url);
                }
            }
        }
    }

    private void showAttachment(String url) {
        MainEntityType mainEntityType = null;
        try {
            mainEntityType = EntityMetadataCache.getDataEntityType((String)"idi_viewurl");
        }
        catch (Exception e) {
            logger.info("no view page");
            mainEntityType = null;
        }
        if (mainEntityType != null) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("idi_viewurl");
            showParameter.setCustomParam("viewUrl", (Object)url);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    protected void inquiriesAi() {
        StringBuilder sb = new StringBuilder();
        Map<Object, Object> attachmentFileMap = new HashMap(2);
        try {
            attachmentFileMap = this.queryAttachmentFile(false);
        }
        catch (KDBizException e) {
            logger.error((Throwable)e);
        }
        if (!attachmentFileMap.isEmpty()) {
            List<Long> templateIdList = this.collectTemplateId(attachmentFileMap);
            Map<Long, List<AttachmentField>> attachmentFieldMap = this.queryAttachmentField(templateIdList);
            for (AttachmentFile attachmentFile : attachmentFileMap.values()) {
                List<Map<String, Object>> fileContentList = attachmentFile.getContentList();
                if (!CollectionUtils.isNotEmpty(fileContentList)) continue;
                for (Map<String, Object> stringObjectMap : fileContentList) {
                    String auditElementStatus = (String)stringObjectMap.remove("auditElementStatus");
                    if (!"1".equals(auditElementStatus)) continue;
                    Long templateId = (Long)stringObjectMap.remove("templateId");
                    List<AttachmentField> fieldList = attachmentFieldMap.get(templateId);
                    Map<String, AttachmentField> fieldNumberMap = fieldList.stream().filter(field -> field.getParent() == null).collect(Collectors.toMap(field -> field.getFieldNumber(), field -> field));
                    Set<Map.Entry<String, Object>> attachmentDataMap = stringObjectMap.entrySet();
                    if (CollectionUtils.isNotEmpty(fieldList)) {
                        sb.append(fieldList.get(0).getTemplateName()).append("<br>");
                    }
                    for (Map.Entry<String, Object> stringObjectEntry : attachmentDataMap) {
                        String fieldNumber = stringObjectEntry.getKey();
                        Object value = stringObjectEntry.getValue();
                        AttachmentField attachmentField = fieldNumberMap.get(fieldNumber);
                        if (attachmentField == null) {
                            logger.error("not found field\u3002field:" + fieldNumber + "\uff0ctemplate:" + templateId);
                            continue;
                        }
                        if (value instanceof List && attachmentField.isTable()) {
                            List rowList = (List)value;
                            if (!CollectionUtils.isNotEmpty((Collection)rowList)) continue;
                            List tableFieldList = fieldList.stream().filter(field -> attachmentField.equals(field.getParent())).collect(Collectors.toList());
                            for (Object o : rowList) {
                                if (sb.length() > 0) {
                                    sb.append("<br>");
                                }
                                Map rowMap = (Map)o;
                                for (AttachmentField field2 : tableFieldList) {
                                    Object tableValue = rowMap.get(field2.getFieldNumber());
                                    if (this.isNull(field2.getFieldType(), tableValue)) continue;
                                    sb.append(field2.getFieldName()).append("\uff1a").append(tableValue).append("<br>");
                                }
                            }
                            continue;
                        }
                        if (this.isNull(attachmentField.getFieldType(), value)) continue;
                        sb.append(attachmentField.getFieldName()).append("\uff1a").append(value).append("<br>");
                    }
                }
            }
        }
        String pageId = this.getRootPageIdw();
        DynamicObject initConfig = QueryServiceHelper.queryOne((String)"fgptas_audit_init", (String)"process", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        Object process = initConfig == null ? null : initConfig.get("process");
        String string = sb.toString();
        logger.info(string);
        try {
            DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"selectProcessInSideBar", (Object[])new Object[]{process, pageId, string});
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private List<Long> collectTemplateId(Map<String, AttachmentFile> attachmentFileMap) {
        ArrayList<Long> templateIdList = new ArrayList<Long>(5);
        if (attachmentFileMap == null || attachmentFileMap.isEmpty()) {
            return templateIdList;
        }
        for (AttachmentFile af : attachmentFileMap.values()) {
            List<Map<String, Object>> contentList = af.getContentList();
            if (!CollectionUtils.isNotEmpty(contentList)) continue;
            contentList.forEach(content -> {
                if (content.get("templateId") != null) {
                    Long templateId = (Long)content.get("templateId");
                    templateIdList.add(templateId);
                }
            });
        }
        return templateIdList;
    }

    protected String getRootPageIdw() {
        IFormView thisView = this.getView();
        IFormView iFormView = thisView.getMainView();
        if (iFormView == null) {
            IFormView parentView = thisView.getParentView();
            iFormView = parentView == null ? thisView : parentView.getParentView();
        }
        return iFormView.getPageId();
    }

    protected boolean isNull(String fieldType, Object value) {
        if (value instanceof String) {
            return kd.bos.util.StringUtils.isEmpty((String)((String)value));
        }
        if (kd.bos.util.StringUtils.isEmpty((String)fieldType)) {
            return value == null;
        }
        if ("text".equals(fieldType)) {
            if (!(value instanceof String)) {
                logger.info("fieldType is text. value is not\u3002value\uff1a" + value);
            }
            return value == null || kd.bos.util.StringUtils.isEmpty((String)String.valueOf(value));
        }
        return value == null;
    }

    protected void filterResultByAI(String statusType) {
        boolean needExeAiAttachment = this.needExeAiAttachment();
        Map<String, Object> paramMap = this.achieveCustomParamMap();
        if (needExeAiAttachment) {
            paramMap.put("needAiAttachment", needExeAiAttachment);
            paramMap.put(KEY_FILTERTYPE, statusType);
            paramMap.put(KEY_FILTERAI, Boolean.TRUE);
        }
        this.filterResultCore(paramMap);
    }

    protected void filterResult(String statusType) {
        boolean needExeAiAttachment = this.needExeAiAttachment();
        Map<String, Object> paramMap = this.achieveCustomParamMap();
        if (needExeAiAttachment) {
            paramMap.put("needAiAttachment", needExeAiAttachment);
            paramMap.put(KEY_FILTERTYPE, statusType);
        }
        this.filterResultCore(paramMap);
    }

    protected void filterResultCore(Map<String, Object> paramMap) {
        Object[] objectArray;
        String entityNumber = this.getPageCache().get("billType");
        String billId = this.getPageCache().get("billId");
        String billNumber = entityNumber != null && !entityNumber.isEmpty() ? FormMetadataCache.getFormConfig((String)entityNumber).getEntityTypeId() : entityNumber;
        Object pk = this.castId(billNumber, (Object)billId);
        if (this.needExeAiAttachment()) {
            Object[] objectArray2 = new Object[4];
            objectArray2[0] = pk;
            objectArray2[1] = billNumber;
            objectArray2[2] = this.getBillPageId();
            objectArray = objectArray2;
            objectArray2[3] = paramMap;
        } else {
            Object[] objectArray3 = new Object[3];
            objectArray3[0] = pk;
            objectArray3[1] = billNumber;
            objectArray = objectArray3;
            objectArray3[2] = this.getBillPageId();
        }
        Object[] params = objectArray;
        String result = null;
        try {
            result = (String)DispatchServiceHelper.invokeBizService((String)"data", (String)"idi", (String)"IDISchemaParallelService", (String)"querySchemaResult", (Object[])params);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        CustomControl control = (CustomControl)this.getView().getControl(this.getSmartPanelKey());
        if (kd.bos.util.StringUtils.isNotEmpty((String)result)) {
            Map resultMap = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            resultMap.put("version", System.nanoTime());
            resultMap.put("needRefreshBtn", this.needRefreshBtn());
            control.setData((Object)resultMap);
        }
    }

    protected void viewAuditElement() {
        CustomControl control;
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("action", KEY_VIEWAUDITELEMENT);
        ArrayList dataList = new ArrayList(10);
        result.put("data", dataList);
        Map<Object, Object> attachmentFileMap = new HashMap(2);
        try {
            attachmentFileMap = this.queryAttachmentFile(true);
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        if (!attachmentFileMap.isEmpty()) {
            List<Long> templateIdList = this.collectTemplateId(attachmentFileMap);
            Map<Long, List<AttachmentField>> attachmentFieldMap = this.queryAttachmentField(templateIdList);
            for (AttachmentFile attachmentFile : attachmentFileMap.values()) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>(10);
                dataList.add(dataMap);
                dataMap.put("fileName", attachmentFile.getFileName());
                dataMap.put("url", attachmentFile.getPreviewUrl());
                dataMap.put("sourceType", attachmentFile.getSourceType());
                dataMap.put("uniqueId", attachmentFile.getFileId());
                ArrayList contentList = new ArrayList(10);
                dataMap.put("content", contentList);
                boolean hasError = false;
                List<Map<String, Object>> fileDataList = attachmentFile.getContentList();
                if (!CollectionUtils.isNotEmpty(fileDataList)) continue;
                for (Map<String, Object> stringObjectMap : fileDataList) {
                    String auditElementStatus = (String)stringObjectMap.remove("auditElementStatus");
                    HashMap<String, String> fieldValueMap = new HashMap<String, String>(2);
                    StringBuilder sb = new StringBuilder();
                    if ("2".equals(auditElementStatus) || "4".equals(auditElementStatus) || "3".equals(auditElementStatus) || kd.bos.util.StringUtils.isEmpty((String)auditElementStatus)) {
                        if (hasError) continue;
                        String errorMsg = ResManager.loadKDString((String)"AI\u89e3\u6790\u5f02\u5e38\u3002", (String)"AISmartPanelPlugin_6", (String)"bos-ext-data", (Object[])new Object[0]);
                        fieldValueMap.put("error", errorMsg);
                        contentList.add(fieldValueMap);
                        hasError = true;
                        continue;
                    }
                    Long templateId = (Long)stringObjectMap.remove("templateId");
                    List<AttachmentField> fieldList = attachmentFieldMap.get(templateId);
                    if (CollectionUtils.isEmpty(fieldList)) {
                        logger.info(templateId + "not found field");
                        continue;
                    }
                    Map<String, AttachmentField> fieldNumberMap = fieldList.stream().filter(field -> field.getParent() == null).collect(Collectors.toMap(field -> field.getFieldNumber(), field -> field));
                    Set<Map.Entry<String, Object>> attachmentDataMap = stringObjectMap.entrySet();
                    for (Map.Entry<String, Object> stringObjectEntry : attachmentDataMap) {
                        String fieldNumber = stringObjectEntry.getKey();
                        Object value = stringObjectEntry.getValue();
                        AttachmentField attachmentField = fieldNumberMap.get(fieldNumber);
                        if (attachmentField == null) {
                            logger.error("not found field\u3002field:" + fieldNumber + "\uff0ctemplate:" + templateId);
                            continue;
                        }
                        fieldValueMap.put("name", attachmentField.getTemplateName());
                        if (value instanceof List && attachmentField.isTable()) {
                            List rowList = (List)value;
                            if (!CollectionUtils.isNotEmpty((Collection)rowList)) continue;
                            List tableFieldList = fieldList.stream().filter(field -> attachmentField.equals(field.getParent())).collect(Collectors.toList());
                            for (Object o : rowList) {
                                if (sb.length() > 0) {
                                    sb.append("<br>");
                                }
                                Map rowMap = (Map)o;
                                for (AttachmentField field2 : tableFieldList) {
                                    Object tableValue = rowMap.get(field2.getFieldNumber());
                                    if (this.isNull(field2.getFieldType(), tableValue)) continue;
                                    sb.append(field2.getFieldName()).append("\uff1a").append(tableValue).append("<br>");
                                }
                            }
                            continue;
                        }
                        if (this.isNull(attachmentField.getFieldType(), value)) continue;
                        sb.append(attachmentField.getFieldName()).append("\uff1a").append(value).append("<br>");
                    }
                    fieldValueMap.put("desc", sb.toString());
                    if (sb.length() <= 0) continue;
                    contentList.add(fieldValueMap);
                }
            }
        }
        if ((control = (CustomControl)this.getView().getControl(this.getSmartPanelKey())) != null) {
            result.put("version", System.nanoTime());
            String defaultValue = "none";
            result.put("needRefreshBtn", this.needRefreshBtn());
            String ctrlParam = this.queryIDIParam("reprocessDataScope", defaultValue);
            result.put(KEY_VIEWNEEDREFRESHBTN, !defaultValue.equals(ctrlParam));
            control.setData(result);
        }
    }

    private Map<String, AttachmentFile> queryAttachmentFile(boolean needTips) {
        String billType = this.getPageCache().get("billType");
        billType = kd.bos.util.StringUtils.isNotEmpty((String)billType) ? FormMetadataCache.getFormConfig((String)billType).getEntityTypeId() : billType;
        String billId = this.getPageCache().get("billId");
        logger.info("billty : " + billType);
        Object id = this.castId(billType, (Object)billId);
        HashMap<String, AttachmentFile> attachmentFileMap = new HashMap<String, AttachmentFile>();
        Map preProcessResultMap = null;
        try {
            preProcessResultMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fgptas", (String)"IModalPreProcessService", (String)"getPreProcessResult", (Object[])new Object[]{id});
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (preProcessResultMap != null && !preProcessResultMap.isEmpty()) {
            boolean isSuccess = (Boolean)preProcessResultMap.get("success");
            if (isSuccess) {
                List dataArray;
                boolean hasError = (Boolean)preProcessResultMap.get("hasError");
                if (hasError && needTips) {
                    this.getView().showTipNotification((String)preProcessResultMap.get("errorMsg"));
                }
                if (CollectionUtils.isNotEmpty((Collection)(dataArray = (List)preProcessResultMap.get("data")))) {
                    int size = dataArray.size();
                    for (int i = 0; i < size; ++i) {
                        Map recordObj = (Map)dataArray.get(i);
                        Long templateId = (Long)recordObj.get("attachTemplate");
                        String fileName = (String)recordObj.get("attachName");
                        AttachmentFile af = (AttachmentFile)attachmentFileMap.get(fileName);
                        String auditElementStatus = (String)recordObj.get("auditElementStatus");
                        if (af == null) {
                            af = new AttachmentFile();
                            String sourceType = (String)recordObj.get("source");
                            String previewUrl = (String)recordObj.get("previewUrl");
                            String fileId = (String)recordObj.get("uniqueId");
                            af.setFileId(fileId);
                            af.setFileName(fileName);
                            af.setPreviewUrl(previewUrl);
                            af.setSourceType(sourceType);
                            attachmentFileMap.put(fileName, af);
                        }
                        if ("1".equals(auditElementStatus)) {
                            String auditElementResultStr = (String)recordObj.get("auditElementResult");
                            if (!kd.bos.util.StringUtils.isNotEmpty((String)auditElementResultStr)) continue;
                            JSONObject elementResult = JSONObject.parseObject((String)auditElementResultStr);
                            if (elementResult != null && !elementResult.isEmpty()) {
                                elementResult.put("templateId", (Object)templateId);
                                elementResult.put("auditElementStatus", (Object)auditElementStatus);
                                af.addContent((Map<String, Object>)elementResult);
                                continue;
                            }
                            HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
                            dataMap.put("auditElementStatus", auditElementStatus);
                            af.addContent(dataMap);
                            continue;
                        }
                        HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
                        dataMap.put("auditElementStatus", auditElementStatus);
                        af.addContent(dataMap);
                    }
                }
            } else {
                String errorMsg = (String)preProcessResultMap.get("errorMsg");
                throw new KDBizException(errorMsg);
            }
        }
        return attachmentFileMap;
    }

    private Map<Long, List<AttachmentField>> queryAttachmentField(List<Long> templateIdList) {
        HashMap<Long, List<AttachmentField>> attachmentFieldMap = new HashMap<Long, List<AttachmentField>>(10);
        if (CollectionUtils.isNotEmpty(templateIdList)) {
            Map auditElementMap = new HashMap(2);
            try {
                auditElementMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fgptas", (String)"IModalPreProcessService", (String)"queryAuditElement", (Object[])new Object[]{templateIdList});
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            Set entrySet = auditElementMap.entrySet();
            for (Map.Entry longMapEntry : entrySet) {
                Long templateId = (Long)longMapEntry.getKey();
                ArrayList<AttachmentField> list = (ArrayList<AttachmentField>)attachmentFieldMap.get(templateId);
                if (list == null) {
                    list = new ArrayList<AttachmentField>(10);
                    attachmentFieldMap.put(templateId, list);
                }
                Map templateElementMap = (Map)longMapEntry.getValue();
                String templateName = (String)templateElementMap.get("name");
                List detailsList = (List)templateElementMap.get("details");
                if (!CollectionUtils.isNotEmpty((Collection)detailsList)) continue;
                for (Map groupMap : detailsList) {
                    String name = (String)groupMap.get("groupName");
                    String entryNumber = (String)groupMap.get("groupNo");
                    Boolean isEntry = (Boolean)groupMap.get("isEntry");
                    List fieldDetailList = (List)groupMap.get("auditElementList");
                    AttachmentField tableField = null;
                    if (isEntry.booleanValue()) {
                        tableField = new AttachmentField(templateId, templateName, entryNumber, name, "text", true, null);
                        list.add(tableField);
                    }
                    for (Object o : fieldDetailList) {
                        Map fieldInfoMap = (Map)o;
                        String fieldNumber = (String)fieldInfoMap.get("elementNo");
                        String fieldName = (String)fieldInfoMap.get("elementName");
                        String fieldType = (String)fieldInfoMap.get("fieldType");
                        AttachmentField field = new AttachmentField(templateId, templateName, fieldNumber, fieldName, fieldType, false, tableField);
                        list.add(field);
                    }
                }
            }
        }
        return attachmentFieldMap;
    }

    @Override
    protected boolean needExeAiAttachment() {
        return true;
    }

    @Override
    protected boolean processResult(String result) {
        logger.info(result);
        CustomControl control = (CustomControl)this.getView().getControl(this.getSmartPanelKey());
        boolean da = false;
        if (StringUtils.isNotEmpty((CharSequence)result)) {
            this.visibleCustomControl(true);
            try {
                Map map = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                if ("success".equalsIgnoreCase((String)map.get("status"))) {
                    map.put("version", System.nanoTime());
                    da = true;
                }
                map.put("needRefreshBtn", this.needRefreshBtn());
                control.setData((Object)map);
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
        }
        return da;
    }

    @Override
    protected Map<String, Object> achieveCustomParamMap() {
        Map<String, Object> paramMap = super.achieveCustomParamMap();
        paramMap.put(KEY_NEEDAITIPS, Boolean.FALSE);
        String ctrlParam = this.queryIDIParam("reprocessDataScope", "none");
        paramMap.put(KEY_PREPROCESSSCOPE, ctrlParam);
        return paramMap;
    }

    private String queryIDIParam(String paramKey, String defaultValue) {
        String ctrlParam = null;
        try {
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"idi_param_config", (String)"param_val", (QFilter[])new QFilter[]{new QFilter("param_key", "=", (Object)paramKey)});
            ctrlParam = dynamicObject.getString("param_val");
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (kd.bos.util.StringUtils.isEmpty(ctrlParam) || !"all".equals(ctrlParam) && !"partial".equals(ctrlParam)) {
            return defaultValue;
        }
        return ctrlParam;
    }

    private static class AttachmentFile {
        private String fileName;
        private String sourceType;
        private String previewUrl;
        private String fileId;
        private List<Map<String, Object>> contentList;

        private AttachmentFile() {
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public String getPreviewUrl() {
            return this.previewUrl;
        }

        public void setPreviewUrl(String previewUrl) {
            this.previewUrl = previewUrl;
        }

        public String getFileId() {
            return this.fileId;
        }

        public void setFileId(String fileId) {
            this.fileId = fileId;
        }

        public List<Map<String, Object>> getContentList() {
            return this.contentList;
        }

        public void setContentList(List<Map<String, Object>> contentList) {
            this.contentList = contentList;
        }

        public void addContent(Map<String, Object> data) {
            if (CollectionUtils.isEmpty(this.contentList)) {
                this.contentList = new ArrayList<Map<String, Object>>(5);
            }
            this.contentList.add(data);
        }
    }

    private static class AttachmentField {
        private long template;
        private String templateName;
        private String fieldNumber;
        private String fieldName;
        private String fieldType;
        private boolean isTable;
        private AttachmentField parent;

        public AttachmentField(long template, String templateName, String fieldNumber, String fieldName, String fieldType, boolean isTable, AttachmentField parent) {
            this.template = template;
            this.templateName = templateName;
            this.fieldNumber = fieldNumber;
            this.fieldName = fieldName;
            this.fieldType = fieldType;
            this.isTable = isTable;
            this.parent = parent;
        }

        public long getTemplate() {
            return this.template;
        }

        public void setTemplate(long template) {
            this.template = template;
        }

        public String getFieldNumber() {
            return this.fieldNumber;
        }

        public void setFieldNumber(String fieldNumber) {
            this.fieldNumber = fieldNumber;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        public boolean isTable() {
            return this.isTable;
        }

        public void setTable(boolean table) {
            this.isTable = table;
        }

        public AttachmentField getParent() {
            return this.parent;
        }

        public void setParent(AttachmentField parent) {
            this.parent = parent;
        }

        public String getTemplateName() {
            return this.templateName;
        }

        public void setTemplateName(String templateName) {
            this.templateName = templateName;
        }
    }
}

