/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.data.idi.model;

import java.util.List;
import java.util.Map;
import kd.bos.ext.data.idi.model.HighLightHandler;
import kd.bos.form.AbstractFormView;
import kd.bos.util.StringUtils;

public class HighLightCursor {
    private String headField;
    private String entryName;
    private String entryField;
    private int entryIndex;
    private boolean focus;

    public HighLightCursor() {
    }

    public HighLightCursor(String headField) {
        this.headField = headField;
    }

    public HighLightCursor(String entryName, String entryField, int entryIndex) {
        this.entryName = entryName;
        this.entryField = entryField;
        this.entryIndex = entryIndex;
    }

    public String getHeadField() {
        return this.headField;
    }

    public void setHeadField(String headField) {
        this.headField = headField;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    public String getEntryField() {
        return this.entryField;
    }

    public void setEntryField(String entryField) {
        this.entryField = entryField;
    }

    public int getEntryIndex() {
        return this.entryIndex;
    }

    public void setEntryIndex(int entryIndex) {
        this.entryIndex = entryIndex;
    }

    public boolean isHead() {
        return StringUtils.isNotEmpty((String)this.headField);
    }

    public boolean isEntry() {
        return StringUtils.isNotEmpty((String)this.entryName) && StringUtils.isNotEmpty((String)this.entryField) && this.entryIndex >= 0;
    }

    public boolean ignoreHeadField(String headField) {
        return headField.equals(this.headField);
    }

    public boolean ignoreEntryField(String entryName, String entryField, int entryIndex) {
        return entryName.equals(this.entryName) && entryField.equals(this.entryField) && entryIndex == this.entryIndex;
    }

    public void createHighLightCommandRollback(AbstractFormView billView) {
        if (billView == null) {
            return;
        }
        if (this.isHead()) {
            Map<String, Object> ctls = HighLightHandler.createHeadCommand(this.headField, false);
            billView.updateControlMetadata(this.headField, ctls);
        }
        if (this.isEntry()) {
            List<Map<String, Object>> rowStyle = HighLightHandler.createEntryCommand(this.entryField, this.entryIndex, false);
            billView.getClientProxy().invokeControlMethod(this.entryName, "setCellStyle", new Object[]{rowStyle});
        }
    }

    public boolean isFocus() {
        return this.focus;
    }

    public void setFocus(boolean focus) {
        this.focus = focus;
    }
}

