/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.imsc.imic.util;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.imsc.imic.util.CommonUtils;
import kd.bos.form.IFormView;
import kd.bos.form.operate.MutexHelper;
import kd.bos.mutex.impl.DataMutexImpl;

public class LockUtils {
    public static boolean requireLock(String lockId, String groupId, String entityKey, String opKey) {
        if (lockId == null) {
            return false;
        }
        LockUtils.releaseLock(lockId, groupId, entityKey, opKey);
        return MutexHelper.require((String)entityKey, (Object)lockId, (String)opKey, (boolean)true, (StringBuilder)new StringBuilder());
    }

    public static void releaseLock(String lockId, String groupId, String entityKey, String opKey) {
        DataMutexImpl dataMutex;
        Map lockInfo;
        if (StringUtils.isNotEmpty((CharSequence)lockId) && !"null".equalsIgnoreCase(lockId) && (lockInfo = (dataMutex = new DataMutexImpl()).getLockInfo(lockId, groupId, entityKey)) != null && ((String)lockInfo.get("userid")).equals(String.valueOf(RequestContext.get().getCurrUserId()))) {
            MutexHelper.release((String)entityKey, (String)opKey, (String)lockId);
        }
    }

    public static boolean checkLock(String objectId, String groupId, String entityKey, IFormView view, String errMessage) {
        String userId;
        if (StringUtils.isEmpty((CharSequence)objectId)) {
            return false;
        }
        DataMutexImpl dataMutex = new DataMutexImpl();
        Map lockInfo = dataMutex.getLockInfo(objectId, groupId, entityKey);
        if (lockInfo != null && !(userId = (String)lockInfo.get("userid")).equals(String.valueOf(RequestContext.get().getCurrUserId()))) {
            Map<String, Object> userInfo = CommonUtils.getUserInfoById(Long.parseLong(userId));
            view.showErrorNotification(String.format(errMessage, userInfo.getOrDefault("name", "")));
            return true;
        }
        return false;
    }
}

