/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.imsc.ricc.form.f7ext;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.ToolbarAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DataPreviewListPlugin
extends AbstractListPlugin {
    public static final String FIELD_ID = "id";
    public static final String FIELD_NUMBER = "number";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_MAINORG = "mainorg";
    private static final String RICC_TOOLBARAP = "ricc_toolbarap";
    private static final String RICC_TOTALLABEL = "ricc_totallabel";
    private static final String STYLE = "eyJ0eXBlIjowLCJjb250ZW50IjoiJHtcbiAgICBtYXJnaW4tbGVmdDogMjBweDtcbiAgICBtYXJnaW4tYm90dG9tOiAxMHB4O1xuICAgIG1hcmdpbi10b3A6IC04cHg7XG4gICAgbWluLXdpZHRoOiAxMTBweDtcbiAgXHR3aWR0aDo1MHB4O1xuICBcdGNvbG9yOiM4MDgwODA7XG59wqBcbi8qKiBcbiog5qC35L6LXG4qIOaUr+aMgeWOn+eUn2Nzc+agt+W8j+WGmeazlVxuKiDlvZPliY3lhYPntKDnmoRjbGFzc05hbWXkvb/nlKggXCIkXCIg5Luj5pu/77yM5LiN5pSv5oyB6Ieq5a6a5LmJ5YWD57SgY2xhc3NOYW1lXG4qIOebruWJjeaPkOS+m+S4ieS4quagt+adv++8jOaJk+W8gOazqOmHiuWNs+WPr+S9v+eUqFxuKiDms6jph4rlhoXlrrnkvJrooqvov4fmu6TkuI3lsZXnpLpcbiog5aaC6ZyA5L2/55So5bmz5Y+w5Li76aKY6Imy77yM5Y+v5Lul5L2/55SoJ3RoZW1lQ29sb3In5p2l5Luj5oyHXG4gKi9cbi8qKlxuKiDlvZPliY3lhYPntKDog4zmma/popzoibLot5/pmo/kuLvpopjoibJcbiovXG4vKipcbiQge1xuwqDCoGJhY2tncm91bmQ6J3RoZW1lQ29sb3InO1xuwqB9XG4qL1xuwqAvKipcbiog5L+u5pS55b2T5YmN5YWD57Sg6IOM5pmv6aKc6ImyXG4qL1xuLyoqXG4kIHtcbsKgwqBiYWNrZ3JvdW5kOnJlZDtcbsKgfVxuKi9cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oGhvdmVy5pWI5p6cXG7CoCAqL1xuLyoqXG4kOmhvdmVyIHtcbsKgwqBiYWNrZ3JvdW5kOnJlZDtcbsKgfVxuKi9cbi8qKlxuICog5L+u5pS55b2T5YmN5YWD57Sg5Li6ZGl25qCH562+5a2Q5YWD57SgXG4qL1xuLyoqXG4kID4gZGl2IHtcbsKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiAqL1xuIn0=";

    public void afterCreateNewData(EventObject e) {
        ToolbarAp toolBar = this.createToolBar();
        Container rootContainer = (Container)this.getView().getRootControl();
        rootContainer.setView(this.getView());
        toolBar.createControl();
    }

    private ToolbarAp createToolBar() {
        ToolbarAp toolbarAp = new ToolbarAp();
        toolbarAp.setKey(RICC_TOOLBARAP);
        toolbarAp.setId(RICC_TOOLBARAP);
        return toolbarAp;
    }

    public void onGetControl(OnGetControlArgs e) {
        if (RICC_TOOLBARAP.equals(e.getKey())) {
            Toolbar toolbar = new Toolbar();
            toolbar.setKey(RICC_TOOLBARAP);
            toolbar.setView(this.getView());
            toolbar.addItemClickListener((ItemClickListener)this);
            e.setControl((Control)toolbar);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        List dataTemp = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])qFilters.toArray(new QFilter[0]), null, (int)-1);
        this.getView().getPageCache().put("dataCount", String.valueOf(dataTemp.size()));
    }

    private void addLabel() {
        Container container = (Container)this.getView().getRootControl();
        LabelAp labelAp = new LabelAp();
        labelAp.setId(RICC_TOTALLABEL);
        labelAp.setKey(RICC_TOTALLABEL);
        labelAp.setParentId(RICC_TOOLBARAP);
        String dataCount = this.getView().getPageCache().get("dataCount");
        String totalText = String.format(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u5171%s\u6761", (String)"DataPreviewListPlugin_4", (String)"bos-ext-imsc", (Object[])new Object[0]), dataCount);
        labelAp.setName(new LocaleString(totalText));
        labelAp.setCustomeStyles(STYLE);
        Tips tips = new Tips();
        tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u7edf\u8ba1\u4e3a\u9884\u89c8\u603b\u6570\u636e\u91cf\uff0c\u4e0d\u968f\u5217\u8868\u8fc7\u6ee4\u53d8\u5316", (String)"DataPreviewListPlugin_5", (String)"bos-ext-imsc", (Object[])new Object[0])));
        tips.setType("text");
        labelAp.setCtlTips(tips);
        ArrayList<Map> items = new ArrayList<Map>();
        items.add(labelAp.createControl());
        container.insertControls(1, items);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnok"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarap"});
        if (!(e.getSource() instanceof BillList)) {
            this.addLabel();
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entityNumber = (String)customParams.get("entityNumber");
        HashMap<String, String[]> keyFieldsMap = this.getPreviewFields(entityNumber);
        List listColumns = args.getListColumns();
        List values = keyFieldsMap.values().stream().map(o -> o[0]).collect(Collectors.toList());
        List columKeys = listColumns.stream().map(o -> {
            if (values.contains(o.getListFieldKey()) && keyFieldsMap.get(o.getListFieldKey()) != null) {
                o.setVisible(63);
            } else {
                o.setVisible(0);
            }
            return o.getListFieldKey();
        }).collect(Collectors.toList());
        for (Map.Entry<String, String[]> keyFiled : keyFieldsMap.entrySet()) {
            String[] value = keyFiled.getValue();
            if (columKeys.contains(value[0])) continue;
            listColumns.add(Integer.parseInt(value[1]), this.createListColumn(keyFiled.getKey(), value[0]));
        }
    }

    private ListColumn createListColumn(String key, String caption) {
        ListColumn col = new ListColumn();
        col.setCaption(new LocaleString(caption));
        col.setKey(key);
        col.setListFieldKey(key);
        col.setFieldName(key);
        col.setWidth(new LocaleString("8%"));
        return col;
    }

    private HashMap<String, String[]> getPreviewFields(String entityNumber) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String id = entityType.getPrimaryKey().getName();
        String number = null;
        String name = null;
        String mainorg = null;
        if (entityType instanceof BasedataEntityType) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)entityType;
            number = basedataEntityType.getNumberProperty();
            name = basedataEntityType.getNameProperty();
            mainorg = basedataEntityType.getMainOrg();
        } else if (entityType instanceof BillEntityType) {
            BillEntityType billEntityType = (BillEntityType)entityType;
            number = billEntityType.getBillNo();
            name = billEntityType.getBillNo();
            MainOrgProp mainOrgProperty = billEntityType.getMainOrgProperty();
            if (mainOrgProperty != null) {
                mainorg = mainOrgProperty.getName();
            }
        }
        HashMap<String, String[]> keyFieldsMap = new HashMap<String, String[]>(4);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            String idName = StringUtils.isNotBlank((Object)entityType.getProperty(id).getDisplayName()) ? entityType.getProperty(id).getDisplayName().getLocaleValue() : ResManager.loadKDString((String)"\u5185\u7801", (String)"DataPreviewListPlugin_0", (String)"bos-ext-imsc", (Object[])new Object[0]);
            keyFieldsMap.put(id, new String[]{idName, "0"});
        }
        if (StringUtils.isNotBlank((CharSequence)number)) {
            String numberName = StringUtils.isNotBlank((Object)entityType.getProperty(id).getDisplayName()) ? entityType.getProperty(number).getDisplayName().getLocaleValue() : ResManager.loadKDString((String)"\u7f16\u7801", (String)"DataPreviewListPlugin_1", (String)"bos-ext-imsc", (Object[])new Object[0]);
            keyFieldsMap.put(number, new String[]{numberName, "1"});
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            String nameValue = StringUtils.isNotBlank((Object)entityType.getProperty(id).getDisplayName()) ? entityType.getProperty(name).getDisplayName().getLocaleValue() : ResManager.loadKDString((String)"\u540d\u79f0", (String)"DataPreviewListPlugin_2", (String)"bos-ext-imsc", (Object[])new Object[0]);
            keyFieldsMap.put(name, new String[]{nameValue, "2"});
        }
        if (StringUtils.isNotBlank((CharSequence)mainorg)) {
            String mainOrgName = StringUtils.isNotBlank((Object)entityType.getProperty(mainorg).getDisplayName()) ? entityType.getProperty(mainorg).getDisplayName().getLocaleValue() : ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7", (String)"DataPreviewListPlugin_3", (String)"bos-ext-imsc", (Object[])new Object[0]);
            keyFieldsMap.put(mainorg + ".name", new String[]{mainOrgName, "3"});
        }
        return keyFieldsMap;
    }
}

