/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.menu;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.service.IPortalAppMenuExtService;
import kd.bos.servicehelper.DispatchServiceHelper;

public class HTMAppMenuPlugin
implements IPortalAppMenuExtService {
    private static final Log LOG = LogFactory.getLog(HTMAppMenuPlugin.class);
    String APP_HTM_ID = "1WTT6K3V3TD/";
    private static final Set<String> SIHC_PAGE_SET = new HashSet<String>(Arrays.asList("htm_filetransletterhandle", "htm_filetranslettermanage", "htm_admintroletter"));
    private static final Set<String> SIHC_PARENTMENUE_SET = new HashSet<String>(Collections.singletonList("1747248125443061760"));

    public Map<String, Set<String>> getHideMenuIdsByBizAppIds(Long userId, Map<String, Set<String>> appIdAndMenuIdMap) {
        try {
            Set<String> menuIdSet = appIdAndMenuIdMap.get(this.APP_HTM_ID);
            if (CollectionUtils.isEmpty(menuIdSet)) {
                return null;
            }
            HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
            result.put(this.APP_HTM_ID, this.getHideMenu());
            return result;
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            return null;
        }
    }

    private Set<String> getHideMenu() {
        Boolean enableSihc = (Boolean)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"soecs", (String)"SystemConfigMService", (String)"enableSihc", (Object[])new Object[0]);
        if (!enableSihc.booleanValue()) {
            List appMenusInfoByAppId = AppMetadataCache.getAppMenusInfoByAppId((String)this.APP_HTM_ID);
            Set<String> result = appMenusInfoByAppId.stream().filter(appMenusInfo -> SIHC_PAGE_SET.contains(appMenusInfo.getFormId())).map(AppMenuInfo::getId).collect(Collectors.toSet());
            result.addAll(SIHC_PARENTMENUE_SET);
            return result;
        }
        return Sets.newHashSet();
    }
}

