/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.menu;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.service.IPortalAppMenuExtService;
import kd.bos.servicehelper.DispatchServiceHelper;

public class SOECADMMenuPlugin
implements IPortalAppMenuExtService {
    private static final Log LOG = LogFactory.getLog(SOECADMMenuPlugin.class);
    String APP_SOECADM_ID = "3CUZVOXOG9E8";
    private static final Set<String> MOTION_SET = new HashSet<String>(Arrays.asList("soecadm_motion", "soecadm_demrec"));
    private static final Set<String> MOTION_PRE_SET = new HashSet<String>(Arrays.asList("soecadm_motionpre", "soecadm_demrecpre"));

    public Map<String, Set<String>> getHideMenuIdsByBizAppIds(Long userId, Map<String, Set<String>> appIdAndMenuIdMap) {
        try {
            Set<String> menuIdSet = appIdAndMenuIdMap.get(this.APP_SOECADM_ID);
            if (CollectionUtils.isEmpty(menuIdSet)) {
                return null;
            }
            HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
            result.put(this.APP_SOECADM_ID, this.getHideMenu());
            return result;
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            return null;
        }
    }

    private Set<String> getHideMenu() {
        String motionManageType = (String)DispatchServiceHelper.invokeBizService((String)"sihc", (String)"soebs", (String)"IParamConfigService", (String)"getMotionManageConfig", (Object[])new Object[0]);
        boolean movePool = (Boolean)DispatchServiceHelper.invokeBizService((String)"sihc", (String)"soebs", (String)"IParamConfigService", (String)"getMovePoolConfig", (Object[])new Object[0]);
        boolean rembakAppr = (Boolean)DispatchServiceHelper.invokeBizService((String)"sihc", (String)"soebs", (String)"IParamConfigService", (String)"getRembakApprovalConfig", (Object[])new Object[0]);
        String MOTIONMANAGE_POSITION = "1";
        Set<String> needHideSet = MOTIONMANAGE_POSITION.equals(motionManageType) ? MOTION_SET : MOTION_PRE_SET;
        if (!movePool) {
            needHideSet.add("soebs_intopoolperson");
        }
        if (!rembakAppr) {
            needHideSet.add("soebs_removebakapply");
        }
        List appMenusInfoByAppId = AppMetadataCache.getAppMenusInfoByAppId((String)this.APP_SOECADM_ID);
        Set<String> result = appMenusInfoByAppId.stream().filter(appMenusInfo -> needHideSet.contains(appMenusInfo.getFormId())).map(AppMenuInfo::getId).collect(Collectors.toSet());
        needHideSet.remove("soebs_intopoolperson");
        needHideSet.remove("soebs_removebakapply");
        Set parent = appMenusInfoByAppId.stream().filter(appMenusInfo -> needHideSet.contains(appMenusInfo.getFormId())).map(AppMenuInfo::getParentId).collect(Collectors.toSet());
        result.addAll(parent);
        return result;
    }
}

