package kd.bos.ext.taxc.writeback;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.ai.AbstractDapWriteBackImpl;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.ext.fi.ai.VoucherOperation;

import java.util.Map;

/**
 * @ClassName: DapVoucherWriteBackLkdk
 * @Description: 旅客抵扣凭证回调接口
 * @Author: rd_zhiyuan_liu
 * @Date: 2021/1/29 18:01
 */
 //
public class DapVoucherWriteBackLkdk extends AbstractDapWriteBackImpl {
	public DapVoucherWriteBackLkdk() {
	}

	public void writeBack(VoucherOperation operation, String billEntityNumber, Map<Long, Voucher> billToVch) {
		MainEntityType mt = EntityMetadataCache.getDataEntityType(billEntityNumber);
		if (mt.findProperty("billno") != null) {
			if (VoucherOperation.Create==operation) {
				DB.execute(this.getDBRoute(), "update " + mt.getAlias() + " set fisgeneratevoucher = '1'  where fid in (" + StringUtils.join(billToVch.keySet().toArray(), ',') + ")", new Object[0]);
			}

			if (VoucherOperation.Delete==operation) {
				DB.execute(this.getDBRoute(), "update " + mt.getAlias() + " set fisgeneratevoucher = '0'  where fid in (" + StringUtils.join(billToVch.keySet().toArray(), ',') + ")", new Object[0]);
			}
		}
	}

	protected String getVchStatusField() {
		return "fisgeneratevoucher";
	}

	protected Object getVchEnableStatus() {
		return true;
	}

	protected Object getVchDisableStatus() {
		return false;
	}

	protected DBRoute getDBRoute() {
		return DBRoute.of("taxc");
	}
}
