package kd.bos.ext.imc.formplugin.operation;

import com.google.common.collect.Maps;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.engine.extitf.IWorkflowPlugin;
import java.util.Map;

public class AuditImageWorkflowPlugin implements IWorkflowPlugin {
    private static Log logger = LogFactory.getLog(AuditImageWorkflowPlugin.class);

    @Override
    public void notify(AgentExecution execution) {
        logger.info("进入影像归档插件");
        AgentTask currentTask = execution.getCurrentTask();
        if (currentTask != null) {
            String businessKey = execution.getBusinessKey();
            Map<String, Object> variables = currentTask.getCurrentWFPluginParams();
            logger.info("归档参数 {} {}", variables, businessKey);

            DynamicObject billImageMap = QueryServiceHelper.queryOne("task_billimagemap",
                    "billid,imagenumber,imagestate",
                    new QFilter[]{new QFilter("billid", "=", businessKey)});

            String imageNo = billImageMap.getString("imagenumber");
            String imageState = billImageMap.getString("imagestate");
            logger.info("影像编码为{} 影像状态为{}" , imageNo , imageState);

            if (canAudit(imageState)) {
                try {
                    Object imagenumber = variables.get("imagenumber");
                    Map<String, Object> paramMap = Maps.newHashMapWithExpectedSize(1);
                    paramMap.put("scanBillNo", imagenumber);

                    Map<String, Object> rawResult = DispatchServiceHelper
                            .invokeBizService("imc", "bds",
                                    "ImageReceiveService", "auditImage",
                                    new Object[]{paramMap});
                    logger.info("影像归档接口返回 {}" , rawResult);
                } catch (Exception e) {
                    logger.error("退扫发生异常：" + e);
                }
            }
        }
    }

    private boolean canAudit(String imageState){
        return true;
//        return ImageStateEnum.HAS_IMAGE_VALUE.equals(imageState) ||
//                ImageStateEnum.REUPLOAD_IMAGE_VALUE.equals(imageState);
    }


}
