package kd.bos.ext.imc.formplugin.operation;
import kd.bos.dataentity.resource.ResManager;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.imc.common.opration.OpConfigParam;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.entity.operation.CustOpParameterPlugin;
import kd.bos.metadata.entity.operation.CustOperationParameter;

public class CollectConfigParamPlugin extends CustOpParameterPlugin{
	
	private static final List<String> FIELD_KEYS;
	static {
		List<String> list = Lists.newArrayList(OpConfigParam.CONFIG_BILLTYPE,OpConfigParam.CONFIG_BILLNO,OpConfigParam.CONFIG_ORGID,
				OpConfigParam.CONFIG_BILLID,OpConfigParam.CONFIG_CALLBACKPLUGIN,OpConfigParam.CONFIG_CALLBACK,OpConfigParam.CONFIG_ENTITYID,
				OpConfigParam.CONFIG_NEEDAUTOTOBILL,OpConfigParam.CONFIG_HEAD_ENTRY_KEY,OpConfigParam.CONFIG_ITEM_ENTRY_KEY, OpConfigParam.CONFIG_ATTACHPANELKEY);
		FIELD_KEYS = Collections.unmodifiableList(list);
	}
	
	@Override
	public void registerListener(EventObject e) {
		this.addItemClickListeners("toolbarap");
	}
	
	@Override
	public void itemClick(ItemClickEvent evt) {
		String key = evt.getItemKey();
		switch (key) {
		case "unittest":
			//保存数据
			returnParameter(this.createNewOpParameter());
			String info = "{\"invoiceData\":[{\"passengerName\":\"梁某某\",\"stationGetOn\":\"南京\",\"deductionFlag\":\"1\",\"taxPeriod\":\"\",\"uploadSeq\":1657592351951000000,\"destArea\":\"__\",\"downloadUrl\":\"/rim/invoice/312b473e0108c99b80985732b733e10599b0da77a4908d0ee55e1bdd89107f51.ofd\",\"personFlag\":false,\"billCreateTime\":\"2022-05-18 15:51:03\",\"originalTime\":\"2022-05-18 15:51:03\",\"trainNum\":\"G7101\",\"invoice_info\":\"ty_9,ex_1,or_1,td_0,mo_1,\",\"trainTime\":\"2022-03-01\",\"transportDeduction\":\"0\",\"stationGetOff\":\"上海虹桥\",\"imageUrl\":\"/rim/invoice/bb74c90890e025cb2f4e793f4738a1eec07c40242c24172e9f24a61160d78f19.jpg\",\"invoiceType\":\"9\",\"pixel\":\"\",\"area\":\"\",\"amount\":\"181\",\"resource\":\"发票助手\",\"originalState\":\"1\",\"validateMessage\":\"\",\"verifyResult\":[],\"companySeal\":\"0\",\"attachList\":[],\"invoiceDate\":\"2022-03-17\",\"pdfurl\":\"/rim/invoice/fe857bc455a46f0b4de2ced51008616e70433540b44745d003b8ddacdd3646cf.pdf\",\"serialNo\":\"43513be1940647f3b97c44f8318e35c9\",\"errorLevel\":\"3\",\"sourceArea\":\"__\",\"seat\":\"软卧\",\"totalAmount\":\"181\",\"taxRate\":\"0.09\",\"customerIdentityNum\":\"1427241988****1627\",\"travelDate\":\"2022-03-01\",\"rotationAngle\":\"0\",\"snapshotUrl\":\"/rim/invoice/bb74c90890e025cb2f4e793f4738a1eec07c40242c24172e9f24a61160d78f19.jpg\",\"isRevise\":\"1\",\"printingSequenceNo\":\"306712A086012090014302022\",\"region\":\"\",\"totalTaxAmount\":\"14.94\",\"fileType\":\"4\",\"expenseStatus\":\"1\"}],\"attachData\":[]}";
			JSONObject returnData = JSONObject.parseObject(info);
			this.getView().returnDataToParent(returnData);
			this.getView().close();
			break;
		}
	}

	@Override
	protected void showParameter(CustOperationParameter v) {
		Object unittest = this.getView().getFormShowParameter().getCustomParam("unittest");
		if(!(unittest instanceof String) || !unittest.equals("1")) {
			this.getView().setVisible(Boolean.FALSE, "toolbarap");
		}
		//初始化下拉字段可选值
		initEntryKeyComboList();
		//初始化分录字段
		InvoiceOPUtils.initShow(getModel(), FIELD_KEYS, v);
		//初始化映射分录下拉值
		initEntryComboList();
	}
	
	@Override
	protected void returnParameter(CustOperationParameter v) {
		//校验分录字段不能重复
		InvoiceOPUtils.saveConfig(getModel(), FIELD_KEYS, v);
	}
	
	@Override
	public void propertyChanged(PropertyChangedArgs e) {
		String key = e.getProperty().getName();
		switch (key) {
		case OpConfigParam.CONFIG_NEEDAUTOTOBILL:
			Boolean needAutoToBill = (Boolean)e.getChangeSet()[0].getNewValue();
			if(!needAutoToBill) {
				//清空下拉
				this.getModel().setValue(OpConfigParam.CONFIG_HEAD_ENTRY_KEY, " ");
				this.getModel().setValue(OpConfigParam.CONFIG_HEAD_ENTRY_KEY, " ");
			}
			break;
		case OpConfigParam.CONFIG_HEAD_ENTRY_KEY:
			//清空发票头映射分录
			this.getModel().deleteEntryData(OpConfigParam.CONFIG_ENTRY_ENTRYENTITY);
			initHeadEntry();
			break;
		case OpConfigParam.CONFIG_ITEM_ENTRY_KEY:
			//清空发票明细映射分录
			this.getModel().deleteEntryData(OpConfigParam.CONFIG_ENTRY_ITEM_ENTRYENTITY);
			initItemEntry();
			break;
		default:
			break;
		}
	}
	
	private void initEntryKeyComboList() {
		List<ComboItem> entityComboList = InvoiceOPUtils.getComboListOfTypeAll(getView(), OpConfigParam.PARAM_ENTRYENTITY);
		
		ComboEdit headEntryCombo = getControl(OpConfigParam.CONFIG_HEAD_ENTRY_KEY);
		headEntryCombo.setComboItems(entityComboList);
		
		ComboEdit itemEntryCombo = getControl(OpConfigParam.CONFIG_ITEM_ENTRY_KEY);
		itemEntryCombo.setComboItems(entityComboList);
	}
	
	private void initEntryComboList() {
		initHeadEntry();
		initItemEntry();
	}
	
	private void initHeadEntry() {
		initEntryComboList(OpConfigParam.CONFIG_HEAD_ENTRY_KEY,OpConfigParam.CONFIG_ENTRY_ENTRYKEY);
	}
	
	private void initItemEntry() {
		initEntryComboList(OpConfigParam.CONFIG_ITEM_ENTRY_KEY,OpConfigParam.CONFIG_ENTRY_ITEMENTYFIELDKEY);
	}
	
	private void initEntryComboList(String entryKey, String needInitFieldKey) {
		JSONObject fields = InvoiceOPUtils.getBillTypeFields(getView());
		if(fields == null) {
			return;
		}
		JSONObject entry_id = fields.getJSONObject(OpConfigParam.CONFIG_ENTRY_ID);
		JSONObject entryInfo = fields.getJSONObject(OpConfigParam.CONFIG_ENTRY);
		//发票头映射分录
		String entryName= (String)this.getModel().getValue(entryKey);
		if(StringUtils.isBlank(entryName)) {
			return;
		}
		String entryId = entry_id.getString(entryName);
		if(StringUtils.isBlank(entryId)) {
			return;
		}
		JSONArray headEntryFieldKeys = entryInfo.getJSONArray(entryId);
		if(headEntryFieldKeys != null) {
			headEntryFieldKeys.removeIf(v -> StringUtils.equals(OpConfigParam.PARAM_ENTRYENTITY, ((JSONObject)v).getString(OpConfigParam.PARAM__TYPE_)));
			List<ComboItem> headEntryFieldComboList = InvoiceOPUtils.convertComboItemAll(headEntryFieldKeys);
			ComboEdit headEntryCombo = getControl(needInitFieldKey);
			headEntryCombo.setComboItems(headEntryFieldComboList);
		}
	}
}
