package kd.bos.ext.imc.formplugin.operation.bizrule;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.metadata.entity.operation.AbstractOpBizRuleParameterEdit;
import kd.bos.metadata.entity.operation.OpBizRuleElement;

import java.util.EventObject;
import java.util.Map;

/**
 * @ClassName SaveImageConfigParamPlugin
 * @Description 影像保存服务配置页面
 * @Author yuqiu_he
 * @Date 2023/9/21 16:45
 * @Version 1.0
 */
public class DelImageConfigParamPlugin extends AbstractOpBizRuleParameterEdit {
    @Override
    public void afterCreateNewData(EventObject arg0) {
//        Map<String, Object> rawResult = DispatchServiceHelper.invokeBizService("imc", "bds", "YXZSService", "queryImageInvoicePlatform", new Object[]{});
//        JSONObject downFileResult = JSONObject.parseObject(JSONObject.toJSONString(rawResult));
//        JSONObject data = downFileResult.getJSONObject("data");
//        if(!"AWS".equals(data.getString("sys"))){
//            this.getView().setVisible(Boolean.FALSE,"sync_aws");
//        }
        OpBizRuleElement opbiz = this.getOpBizRule();
        if (opbiz != null && StringUtils.isNotBlank(opbiz.getParameter())) {
            JSONObject json = JSONObject.parseObject(opbiz.getParameter());
            this.getModel().getDataEntityType().getProperties();
            for (Map.Entry<String, Object> entry : json.entrySet()) {
                IDataEntityProperty prop = this.getModel().getProperty(entry.getKey());
                if (prop != null && !(prop instanceof EntryProp)) {
                    this.getModel().setValue(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    @Override
    public String getParameter() {
        DynamicObject entity = this.getModel().getDataEntity(true);
        JSONObject param = new JSONObject();


        if(StringUtils.isNotBlank(entity.getString("attachment_flag"))) {
            param.put("attachment_flag", entity.getString("attachment_flag"));
        }

        return param.toJSONString();
    }
}
