package kd.bos.ext.imc.formplugin.operation.bizrule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.EntryProp;
import kd.bos.metadata.entity.operation.AbstractOpBizRuleParameterEdit;
import kd.bos.metadata.entity.operation.OpBizRuleElement;
import kd.bos.servicehelper.DispatchServiceHelper;

import java.util.EventObject;
import java.util.Map;

/**
 * @ClassName SaveImageConfigParamPlugin
 * @Description 影像保存服务配置页面
 * @Author yuqiu_he
 * @Date 2023/9/21 16:45
 * @Version 1.0
 */
public class SaveImageConfigParamPlugin extends AbstractOpBizRuleParameterEdit {
    @Override
    public void afterCreateNewData(EventObject arg0) {
//        Map<String, Object> rawResult = DispatchServiceHelper.invokeBizService("imc", "bds", "YXZSService", "queryImageInvoicePlatform", new Object[]{});
//        JSONObject downFileResult = JSONObject.parseObject(JSONObject.toJSONString(rawResult));
//        JSONObject data = downFileResult.getJSONObject("data");
//        if(!"AWS".equals(data.getString("sys"))){
//            this.getView().setVisible(Boolean.FALSE,"sync_aws");
//        }
        OpBizRuleElement opbiz = this.getOpBizRule();
        if (opbiz != null && StringUtils.isNotBlank(opbiz.getParameter())) {
            JSONObject json = JSONObject.parseObject(opbiz.getParameter());
            this.getModel().getDataEntityType().getProperties();
            for (Map.Entry<String, Object> entry : json.entrySet()) {
                IDataEntityProperty prop = this.getModel().getProperty(entry.getKey());
                if (prop != null && !(prop instanceof EntryProp)) {
                    this.getModel().setValue(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    @Override
    public String getParameter() {
        DynamicObject entity = this.getModel().getDataEntity(true);
        JSONObject param = new JSONObject();
        if(entity.getDynamicObject("bill_type") != null) {
            param.put("bill_type", entity.getDynamicObject("bill_type").getLong("id"));
        }
        if(StringUtils.isNotBlank(entity.getString("bill_no"))) {
            param.put("bill_no", entity.getString("bill_no"));
        }
        if(StringUtils.isNotBlank(entity.getString("bill_id"))) {
            param.put("bill_id", entity.getString("bill_id"));
        }
        if(StringUtils.isNotBlank(entity.getString("bill_user"))) {
            param.put("bill_user", entity.getString("bill_user"));
        }
        if(StringUtils.isNotBlank(entity.getString("bill_company"))) {
            param.put("bill_company", entity.getString("bill_company"));
        }
        if(StringUtils.isNotBlank(entity.getString("bill_image_no"))) {
            param.put("bill_image_no", entity.getString("bill_image_no"));
        }
        if(StringUtils.isNotBlank(entity.getString("print"))) {
            param.put("print", entity.getString("print"));
        }
        if(StringUtils.isNotBlank(entity.getString("attach_panel_key"))) {
            param.put("attach_panel_key", entity.getString("attach_panel_key"));
        }
        if(entity.getBoolean("need_cover")){
            param.put("need_cover", "1");
        }else{
            param.put("need_cover", "0");
        }
        if(entity.getBoolean("need_attach")){
            param.put("need_attach", "1");
        }else{
            param.put("need_attach", "0");
        }
        if(entity.getBoolean("append_attach_only")){
            param.put("append_attach_only", "1");
        }else{
            param.put("append_attach_only", "0");
        }
//        if(entity.getBoolean("sync_aws")){
//            param.put("sync_aws", "1");
//        }else{
//            param.put("sync_aws", "0");
//        }
        if(entity.getDynamicObject("bill_entry_type") != null) {
            param.put("bill_entry_type", entity.getDynamicObject("bill_entry_type").getLong("id"));
        }
        if(StringUtils.isNotBlank(entity.getString("bill_entry_id"))) {
            param.put("bill_entry_id", entity.getString("bill_entry_id"));
        }
        if(StringUtils.isNotBlank(entity.getString("bill_entry_serial_no"))) {
            param.put("bill_entry_serial_no", entity.getString("bill_entry_serial_no"));
        }
        if(StringUtils.isNotBlank(entity.getString("attach_panel_entry_key"))) {
            param.put("attach_panel_entry_key", entity.getString("attach_panel_entry_key"));
        }

        if(StringUtils.isNotBlank(entity.getString("attach_uid_key"))) {
            param.put("attach_uid_key", entity.getString("attach_uid_key"));
        }

        if(StringUtils.isNotBlank(entity.getString("attach_type_key"))) {
            param.put("attach_type_key", entity.getString("attach_type_key"));
        }

        if(StringUtils.isNotBlank(entity.getString("attach_sub_type_key"))) {
            param.put("attach_sub_type_key", entity.getString("attach_sub_type_key"));
        }
        if(StringUtils.isNotBlank(entity.getString("attach_is_paper_key"))) {
            param.put("attach_is_paper_key", entity.getString("attach_is_paper_key"));
        }
        if(StringUtils.isNotBlank(entity.getString("attach_is_paper_rel"))) {
            param.put("attach_is_paper_rel", entity.getString("attach_is_paper_rel"));
        }
        if(StringUtils.isNotBlank(entity.getString("invoice_panel_key"))) {
            param.put("invoice_panel_key", entity.getString("invoice_panel_key"));
        }
        putVal(entity, "attach_panel_tab_key", param);
        return param.toJSONString();
    }

    public static void putVal(DynamicObject entity, String key, JSONObject param){
        if (entity.containsProperty(key)){
            Object obj = entity.get(key);
            if (obj != null && StringUtils.isNotEmpty(obj.toString())){
                param.put(key, obj);
            }
        }
    }
}
