package kd.bos.ext.imc.operation;
import kd.bos.dataentity.resource.ResManager;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;

import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.imc.operation.contant.InvoiceOpParamContant;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IMobileView;
import kd.bos.form.ShowType;

public class DelAtttInvoiceOperate extends AbstractInvoiceFormOperate{
	
	@Override
	protected OperationResult invokeOperation() {
		if(this.getView() instanceof IMobileView) {
			throw new KDBizException(ResManager.loadKDString("移动端无法操作附件", "DelAtttInvoiceOperate_0", "bos-ext-imc"));
		}
		return super.invokeOperation();
	}
	
	@Override
	List<String> getCustomConfigParam() {
		return Lists.newArrayList(InvoiceOpParamContant.BILLID, InvoiceOpParamContant.ENTITYID
				, InvoiceOpParamContant.CALLBACK, InvoiceOpParamContant.CALLBACKPLUGIN, InvoiceOpParamContant.ATTACHPANELKEY);
	}
	
	@Override
	protected void extCustom(Map<String, Object> customParams, Map<String, Object> configParam) {
		customParams.put(InvoiceOpParamContant.QUERYDB, Boolean.TRUE);
		//附件面板
		if(configParam.get(InvoiceOpParamContant.ATTACHPANELKEY) != null) {
			customParams.put(InvoiceOpParamContant.ATTACHPANELKEY, configParam.get(InvoiceOpParamContant.ATTACHPANELKEY));
		}
	}
	
	@Override
	void setPageInfo(FormShowParameter param) {
		param.getOpenStyle().setShowType(ShowType.Modal);
		param.setFormId(InvoiceOpParamContant.RIM_FPZS_ATTACH_DELETE);
	}

}
