package kd.bos.ext.imc.operation;
import kd.bos.dataentity.resource.ResManager;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.imc.operation.exception.ImcRimInvoiceBizException;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;


/**
 * @ClassName DownImageFileOperate
 * @Description TODO
 * @Author yuqiu_he
 * @Date 2023/9/28 14:29
 * @Version 1.0
 */
public class DownImageFileOperate extends FormOperate {
    private static Log logger = LogFactory.getLog(DownImageFileOperate.class);

    protected OperationResult invokeOperation() {
        OperationResult result = super.invokeOperation();
        try {
            Map<String, Object> parameter = this.getParameter();
            Object paramObj = parameter.get("parameter");
            if(paramObj != null) {
                List<String> pkIds = null;
                if(this.getListSelectedData().isEmpty()){
                    pkIds = Lists.newArrayListWithExpectedSize(1);
                    Object billid = this.getView().getModel().getDataEntity(true).getPkValue();
                    if (billid != null && !Objects.equals(billid, 0L)) {
                        pkIds.add(billid+"");
                    }
                }else{
                    pkIds =  Arrays.stream(this.getListSelectedData().getBillListSelectedRowCollection().getPrimaryKeyValues()).map(v -> v+"").collect(Collectors.toList());
                }
                JSONObject param = JSONObject.parseObject(paramObj.toString());
                String billType = param.getString("bill_type");
                DynamicObject billTypeDObj= BusinessDataServiceHelper.loadSingle(billType, "rim_expense_type", "number");
                billType = billTypeDObj.getString("number");

                JSONObject params = new JSONObject();
                params.put("billType",billType);
                params.put("pkIds",pkIds);
                params.put("resource","4");

                logger.info("【发票云操作】影像下载获取zip地址，请求参数：{}", JSON.toJSONString(params));
                Map<String, Object> rawResult = DispatchServiceHelper.invokeBizService("imc", "bds", "YXZSService", "downImage", new Object[]{params});
                logger.info("【发票云操作】影像下载获取zip地址， 返回结果：{}", JSON.toJSONString(rawResult));
                if(!StringUtils.equals((String)rawResult.get("errcode"), "0000")) {
                    throw new ImcRimInvoiceBizException(String.format(ResManager.loadKDString("影像下载获取zip地址失败，%s，请联系管理员", "DownImageFileOperate_0",
                            "bos-ext-imc"), rawResult.get("description")));
                }
                JSONObject downFileResult = JSONObject.parseObject(JSONObject.toJSONString(rawResult));
                JSONObject data = downFileResult.getJSONObject("data");
                String path = data.getString("path");
                if(StringUtils.isBlank(path)){
                    this.getView().showTipNotification(ResManager.loadKDString("当前单据无可下载影像。", "DownImageFileOperate_2", "bos-ext-imc"));
                    result.setShowMessage(true);
                    result.setMessage(ResManager.loadKDString("当前单据无可下载影像。", "DownImageFileOperate_2", "bos-ext-imc"));
                    return result;
                }
                this.getView().openUrl(path);
            }
        } catch (Exception e) {
            logger.error("【发票云操作】，报错信息：",e);
            throw new KDBizException(String.format(ResManager.loadKDString("操作过程中出现错误，请联系管理员处理。%s", "DownImageFileOperate_3", "bos-ext-imc"),
                    e.getMessage()));
        }
        //业务操作
        return result;
    }
}
