package kd.bos.ext.imc.operation.bizrule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.imc.operation.contant.SaveImageConstant;
import kd.bos.ext.imc.operation.exception.ImcRimInvoiceBizException;
import kd.bos.ext.imc.operation.util.CoverUtils;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.util.CollectionUtils;


import java.util.*;
import java.util.stream.Collectors;

/**
 * @ClassName SaveImageAction
 * @Description TODO
 * @Author yuqiu_he
 * @Date 2023/9/21 16:38
 * @Version 1.0
 */
public class SaveImageAction extends AbstractOpBizRuleAction {

    private static Log logger = LogFactory.getLog(SaveImageAction.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        JSONObject config = JSONObject.parseObject(this.getBizRule().getParameter());
        List<String> paramKey = Lists.newArrayList("bill_no" ,"bill_id" ,"bill_user" ,"bill_company" ,"bill_image_no", "bill_entry_type", "bill_entry_id", "bill_entry_serial_no");
        e.getFieldKeys().addAll(paramKey.stream().map(v -> config.getString(v)).filter(v -> v != null).collect(Collectors.toList()));
    }

    @Override
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        List<String> imgNoList = Lists.newArrayList();
        DynamicObject[] dataEntities = e.getDataEntities();
        //先保存影像编码
        JSONObject param = JSONObject.parseObject(this.getBizRule().getParameter());
        logger.info("[保存影像]参数{}", param);
        for (DynamicObject dataEntity : dataEntities) {
            long billid = (long)dataEntity.getPkValue();
            if(billid == 0L) {
                billid = ORM.create().genLongId(dataEntity.getDataEntityType());
                dataEntity.set("id", billid);
            }
            //没有创建的要先创建
            String imageNumber = getImageNumber(dataEntity.getDynamicObjectType().getName(), (Long)dataEntity.getPkValue());
            //如果查询为空，则说明是新创建的
            if(StringUtils.isBlank(imageNumber)) {
                imageNumber = createImageNumber(e.getOperationKey(),dataEntity, param);
                imgNoList.add(imageNumber);
            }
        }
        if(!imgNoList.isEmpty()) {
            param.put("newImgNo", imgNoList);
            this.getBizRule().setParameter(param.toJSONString());
        }
    }

    @Override
    public void rollbackOperation(RollbackOperationArgs e) {
        JSONObject param = JSONObject.parseObject(this.getBizRule().getParameter());
        JSONArray imgNoList = param.getJSONArray("newImgNo");
        if(imgNoList != null) {
            for (int i = 0; i < imgNoList.size(); i++) {
                String imgNo = imgNoList.getString(i);
                delImgNo(imgNo);
            }
            param.remove("newImgNo");
            this.getBizRule().setParameter(param.toJSONString());
        }
    }

    @Override
    public void afterExecuteOperationTransaction(AfterOperationArgs evt) {
        JSONObject param = JSONObject.parseObject(this.getBizRule().getParameter());
        Map<String, String> paraMapKey = param.keySet().stream().collect(Collectors.toMap(v -> exChange(v), v -> v));
        DynamicObject[] dataEntities = evt.getDataEntities();
        List<DynamicObject> successList = Lists.newArrayListWithExpectedSize(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            try {
                excuteService(param, dataEntity, paraMapKey);
                successList.add(dataEntity);
            }catch (Exception e) {
                logger.info("【发票云服务】保存服务，错误：{}", param);
                logger.error(e);
            }
        }
        evt.setDataEntities(successList.toArray(new DynamicObject[successList.size()]));
    }

    /**
     * 	执行保存发票服务
     * @author 何雨秋
     * @date 2022-4-11
     * @param param
     * @param dataEntity
     * @param paraMapKey
     * @throws ImcRimInvoiceBizException
     * @throws Exception
     */
    private void excuteService(JSONObject param, DynamicObject dataEntity, Map<String, String> paraMapKey) throws ImcRimInvoiceBizException,Exception{
        //将页面配置构造成参数
        Map<String, Object> configMap = initConfigParam(param, dataEntity, paraMapKey, true);
        logger.info("【发票云服务】保存影像服务，转换后的参数：{}",configMap);
        //调用发票云的保存服务
        saveInvoiceAndBill(configMap);
    }

    /**
     * 	执行保存发票服务
     * @author 何雨秋
     * @date 2022-4-11
     * @param configMap
     * @throws ImcRimInvoiceBizException
     * @throws Exception
     */
    private void saveInvoiceAndBill(Map<String, Object> configMap) throws ImcRimInvoiceBizException,Exception {
        Map<String, Object> paramMap = Maps.newHashMapWithExpectedSize(11);
        paramMap.put(SaveImageConstant.PARAM_KEY_BILL_TYPE, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_BILL_TYPE,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_BILL_NO, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_BILL_NO,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_BILL_ID, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_BILL_ID,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_BILL_USER, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_BILL_USER,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_BILL_COMPANY, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_BILL_COMPANY,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_BILL_IMAGE_NO, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_BILL_IMAGE_NO,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_RESOURCE, SaveImageConstant.PARAM_KEY_RESOURCE_SERVICE);
        paramMap.put(SaveImageConstant.PARAM_KEY_COVER_BASE64, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_COVER_BASE64,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_COVER_PATH, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_COVER_PATH,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_COVER_TYPE, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_COVER_TYPE,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_ATTACH_LIST, configMap.get(SaveImageConstant.PARAM_KEY_ATTACH_LIST));
        //附件面板
        paramMap.put(SaveImageConstant.PARAM_KEY_ATTACH_PANEL_KEY, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_ATTACH_PANEL_KEY,""));
        //影像模板
        paramMap.put(SaveImageConstant.PARAM_KEY_PRINT, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_PRINT,""));
        //表单
        paramMap.put(SaveImageConstant.PARAM_KEY_FORM_ID, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_FORM_ID,""));

        //同步AWS
        paramMap.put(SaveImageConstant.PARAM_KEY_SYNC_AWS, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_SYNC_AWS,SaveImageConstant.PARAM_KEY_SYNC_AWS_NO));

        // 是否增量更新附件
        paramMap.put(SaveImageConstant.PARAM_KEY_APPEND_ATTACH_ONLY, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_APPEND_ATTACH_ONLY,SaveImageConstant.PARAM_KEY_SYNC_AWS_NO));

        //子单据类型
        paramMap.put(SaveImageConstant.PARAM_KEY_BILL_ENTRY_TYPE, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_BILL_ENTRY_TYPE,""));
        //子单据id
        paramMap.put(SaveImageConstant.PARAM_KEY_BILL_ENTRY_ID, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_BILL_ENTRY_ID,""));
        //子单据发票流水号
        paramMap.put(SaveImageConstant.PARAM_KEY_BILL_ENTRY_SERIAL_NO, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_BILL_ENTRY_SERIAL_NO,""));
        //发票面板标志
        paramMap.put(SaveImageConstant.PARAM_KEY_INVOICE_PANEL_KEY, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_INVOICE_PANEL_KEY,""));
        paramMap.put(SaveImageConstant.PARAM_KEY_INVOICE_SIZE, configMap.getOrDefault(SaveImageConstant.PARAM_KEY_INVOICE_SIZE,""));

        if(configMap.get(SaveImageConstant.PARAM_KEY_INVOICE_SIZE) == null) {
            paramMap.put(SaveImageConstant.PARAM_KEY_INVOICE_SIZE, -1);
        }

        if(configMap.get(SaveImageConstant.PARAM_KEY_ATTACH_LIST) == null) {
            paramMap.put(SaveImageConstant.PARAM_KEY_ATTACH_LIST, new JSONArray());
        }

        if(configMap.get(SaveImageConstant.PARAM_KEY_BILL_ENTRY_ID) == null) {
            paramMap.put(SaveImageConstant.PARAM_KEY_BILL_ENTRY_ID, new JSONArray());
        }
        if(configMap.get(SaveImageConstant.PARAM_KEY_BILL_ENTRY_SERIAL_NO) == null) {
            paramMap.put(SaveImageConstant.PARAM_KEY_BILL_ENTRY_SERIAL_NO, new JSONArray());
        }
        paramMap.put(SaveImageConstant.PARAM_KEY_SAVE_IMAGE_CONFIG, configMap);
        logger.info("【发票云服务】保存服务，推送影像，请求参数：{}", JSON.toJSONString(paramMap));
        Map<String, Object> rawResult = DispatchServiceHelper.invokeBizService("imc", "bds", "YXZSService", "saveImage", new Object[]{paramMap});
        logger.info("【发票云服务】保存服务，推送影像， 返回结果：{}", JSON.toJSONString(rawResult));
        if(!StringUtils.equals((String)rawResult.get("errcode"), "0000")) {
            throw new ImcRimInvoiceBizException(String.format(ResManager.loadKDString("推送影像失败，%s ，请联系管理员", "SaveImageAction_0", "bos-ext-imc"),
                    rawResult.get("description")));
        }
    }

    /**
     * 	操作传递进来的参数或单据页面获取对应的构造保存发票服务的参数
     * 	优先使用调用操作传递进来的参数
     * @author 何雨秋
     * @date 2022-4-11
     * @param param
     * @param dataEntity
     * @param paraMapKey
     * @return
     */
    private Map<String, Object> initConfigParam(JSONObject param, DynamicObject dataEntity, Map<String, String> paraMapKey, boolean createPdf) {
        //获取初始化参数信息
        Map<String, Object> configParam = Maps.newHashMapWithExpectedSize(8);

        //首先检查是否在操作中传递参数
        Map<String, String> opVariables = this.getOption().getVariables();
        logger.info("【发票云服务】保存服务，传入参数：{}",opVariables);
        logger.info("【发票云服务】保存服务，配置参数：{}",param.toJSONString());
        //挑选出参数中未传递的数据
        List<String> noneParam = Lists.newArrayListWithExpectedSize(getCustomConfigParam().size());
        for (String key : getCustomConfigParam()) {
            String value = opVariables.get(key);
            if(value != null) {
                configParam.put(key, value);
            }else {
                noneParam.add(key);
            }
        }

        //根据配置补全参数
        for (String noneKey : noneParam) {
            String configValue = param.getString(paraMapKey.get(noneKey));
            if(StringUtils.equals(noneKey, SaveImageConstant.PARAM_KEY_BILL_ID)) {
                if(StringUtils.equals(configValue, "id")) {
                    //获取单据id
                    configParam.put(noneKey, dataEntity.getPkValue().toString());
                }else {
                    if(dataEntity.getDynamicObjectType().getProperty(configValue) != null) {
                        configParam.put(noneKey, dataEntity.get(configValue));
                    }
                }
            }else if(StringUtils.equals(noneKey, SaveImageConstant.PARAM_KEY_BILL_IMAGE_NO)){
                String imageNumber = getImageNumber(dataEntity.getDynamicObjectType().getName(), (Long)dataEntity.getPkValue());
                if(dataEntity.getDynamicObjectType().getProperty(configValue) != null) {
                    dataEntity.set(configValue,imageNumber);
                }
                configParam.put(noneKey, imageNumber);
            }else if(StringUtils.equals(noneKey, SaveImageConstant.PARAM_KEY_BILL_NO)){
                //判断字段是否存在于当前页面
                if(dataEntity.getDynamicObjectType().getProperty(configValue) != null) {
                    configParam.put(noneKey, dataEntity.get(configValue));
                }
            }else if(StringUtils.equals(noneKey, SaveImageConstant.PARAM_KEY_BILL_TYPE)) {
                if (StringUtils.isNotBlank(configValue)) {
                    DynamicObject billTypeDobj= BusinessDataServiceHelper.loadSingle(configValue, "rim_expense_type", "number");
                    configValue = billTypeDobj.getString("number");
                }
                //单据类型是基础资料
                configParam.put(noneKey, configValue);
            }else if(StringUtils.equals(noneKey, SaveImageConstant.PARAM_KEY_BILL_USER)
                    || StringUtils.equals(noneKey, SaveImageConstant.PARAM_KEY_BILL_COMPANY)){
                if(dataEntity.getDynamicObjectType().getProperty(configValue) != null) {
                    configParam.put(noneKey, getDynamicObjectLongValue(dataEntity.get(configValue)));
                }
            }else if(StringUtils.equals(noneKey, SaveImageConstant.PARAM_KEY_BILL_ENTRY_TYPE)) {
                if (StringUtils.isNotBlank(configValue)) {
                    DynamicObject billTypeDobj= BusinessDataServiceHelper.loadSingle(configValue, "rim_expense_type", "number");
                    configValue = billTypeDobj.getString("number");
                    //单据类型是基础资料
                    configParam.put(noneKey, configValue);
                }
            }else if(StringUtils.equals(noneKey, SaveImageConstant.PARAM_KEY_BILL_ENTRY_ID) || StringUtils.equals(noneKey, SaveImageConstant.PARAM_KEY_BILL_ENTRY_SERIAL_NO)){
                if (StringUtils.isNotBlank(configValue)) {
                    JSONArray resultList = getRealValues(configValue, dataEntity);
                    if(resultList.size() != 0){
                        configParam.put(noneKey, resultList);
                    }
                }
            }
            else if(configValue != null) {
                configParam.put(noneKey, configValue);
            }
        }
        //影像模板不为空，则生成封面
        if(StringUtils.isNotBlank(param.getString(SaveImageConstant.PARAM_KEY_PRINT))) {
            createPdf(param, dataEntity, configParam);
        }
        //附件面板标识不为空，则生成附件
        if(StringUtils.isNotBlank(configParam.get(SaveImageConstant.PARAM_KEY_ATTACH_PANEL_KEY))) {
            getAttachment(param, dataEntity, configParam);
        }
        //附件面板标识不为空，则生成附件
        if(StringUtils.isNotBlank(configParam.get(SaveImageConstant.PARAM_KEY_ATTACH_PANEL_TAB_KEY))) {
            getAttachmentTab(dataEntity, configParam);
        }
        //发票面板标识不为空，则塞入发票数量
        if(StringUtils.isNotBlank(configParam.get(SaveImageConstant.PARAM_KEY_INVOICE_PANEL_KEY))) {
            getInvoiceInfo(dataEntity, configParam);
        }
        //是否自动获取附件信息
        return configParam;
    }



    /**
     * 获取配置字段的实际值列表
     * @param configValue
     * @param dataEntity
     * @return
     */
    private JSONArray getRealValues(String configValue, DynamicObject dataEntity){
        String[] keyArray = configValue.split("\\.");
        if(keyArray.length == 2){
            String parentKey = keyArray[0];
            String entryKey = keyArray[1];
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection(parentKey);
            if(CollectionUtils.isNotEmpty(dynamicObjectCollection)) {
                JSONArray resultList = new JSONArray();
                for(DynamicObject row : dynamicObjectCollection){
                    String value = row.getString(entryKey);
                    if(StringUtils.isNotBlank(value)){
                        resultList.add(value);
                    }
                }
                return resultList;
            }
        }
        return new JSONArray();
    }


    private void getInvoiceInfo(DynamicObject dataEntity, Map<String, Object> configParam) {
        int invoiceSize = -1;
        String invoicePanelKey = (String)configParam.get(SaveImageConstant.PARAM_KEY_INVOICE_PANEL_KEY);
        if (StringUtils.isNotEmpty(invoicePanelKey)){
            Object obj = dataEntity.get(invoicePanelKey);
            if (obj instanceof DynamicObjectCollection){
                DynamicObjectCollection invColl = (DynamicObjectCollection) obj;
                invoiceSize = invColl.size();
            }
        }
        configParam.put(SaveImageConstant.PARAM_KEY_INVOICE_PANEL_KEY, invoicePanelKey);
        configParam.put(SaveImageConstant.PARAM_KEY_INVOICE_SIZE, invoiceSize);
    }

    /**
     * 用来取单据中的附件(东风)
     * @param dataEntity
     * @param configParam
     */
    private void getAttachmentTab(DynamicObject dataEntity, Map<String, Object> configParam) {
        JSONArray attachArr = new JSONArray();
        Object attachArrOfOld = configParam.get(SaveImageConstant.PARAM_KEY_ATTACH_LIST);
        if (attachArrOfOld != null){
            attachArr =(JSONArray) attachArrOfOld;
        }
        Object attach_panel_tab_key = configParam.get(SaveImageConstant.PARAM_KEY_ATTACH_PANEL_TAB_KEY);

        for (String attachTabConfig : attach_panel_tab_key.toString().split("\\|")) {
            findObj(dataEntity, attachTabConfig, attachArr);
        }
        logger.info("[影像保存]取到的附件{}", attachArr.size());
        configParam.put(SaveImageConstant.PARAM_KEY_ATTACH_LIST, attachArr);
    }

    private static void findObj(DynamicObject dataEntity,String attachTabConfig, JSONArray fileList){
        String[] split = attachTabConfig.split(":");
        if (split.length !=2){
            return;
        }

        String objKeys = split[0];
        String[] mappings = split[1].split(",");
        ArrayList<DynamicObject> subFileList = new ArrayList<>();
        findObj0(dataEntity, objKeys, subFileList);

        for (DynamicObject dyObj : subFileList) {
            JSONObject attach = new JSONObject();
            for (String mapping : mappings) {
                String[] mapSplit = mapping.split("=");
                String subKey = mapSplit[1];
                Object o = dyObj.get(subKey);
                if (o instanceof OrmLocaleValue){
                    String localeValue = ((OrmLocaleValue) o).getLocaleValue();
                    attach.put(mapSplit[0], localeValue);
                }else {
                    attach.put(mapSplit[0], o);
                }
            }
            fileList.add(attach);
        }
    }

    private void getAttachment(JSONObject param, DynamicObject dataEntity,Map<String, Object> configParam){
        JSONArray attachArr = new JSONArray();
        HashMap<String, JSONObject> attachTypeMap = new HashMap<>();
        String attachPanelKey =  (String)configParam.get(SaveImageConstant.PARAM_KEY_ATTACH_PANEL_KEY);
        String attachPanelEntryKey =  (String)configParam.get(SaveImageConstant.ATTACH_PANEL_ENTRY_KEY);
        String attachUidKey =  (String)configParam.get(SaveImageConstant.ATTACH_UID_KEY);
        String attachTypeKey =  (String)configParam.get(SaveImageConstant.ATTACH_TYPE_KEY);
        String attachSubTypeKey =  (String)configParam.get(SaveImageConstant.ATTACH_SUB_TYPE_KEY);
        String attachIsPaperKey =  (String)configParam.get(SaveImageConstant.ATTACH_IS_PAPER_KEY);
        String attachIsPaperRel =  (String)configParam.get(SaveImageConstant.ATTACH_IS_PAPER_REL);
        JSONObject attachIsPaperRelJson = getAttachIsPaperRelJson(attachIsPaperRel);
        if (StringUtils.isNotEmpty(attachPanelEntryKey)){
            DynamicObjectCollection attachEntrys = dataEntity.getDynamicObjectCollection(attachPanelEntryKey);
            for (DynamicObject attachEntry : attachEntrys) {
                JSONObject attachTypeJson = new JSONObject();
                String attachUid = attachEntry.getString(attachUidKey);
                attachTypeJson.put("attchType", attachEntry.getString(attachTypeKey));
                attachTypeJson.put("attchSubType", attachEntry.getString(attachSubTypeKey));
                attachTypeJson.put("eleImage", attachIsPaperRelJson.getString(
                        attachEntry.getString(attachIsPaperKey)));
                logger.info("添加附件信息{}", attachTypeJson);
                attachTypeMap.put(attachUid, attachTypeJson);
            }
        }
        String formId = dataEntity.getDynamicObjectType().getName();
        List<Map<String, Object>> attachList = new ArrayList<>();
        if (attachPanelKey != null) {
            String[] attachPanelKeyArr = attachPanelKey.split(";");
            for (int i = 0; i < attachPanelKeyArr.length; i++) {
                attachList.addAll(AttachmentServiceHelper.getAttachments(formId, dataEntity.getPkValue(), attachPanelKeyArr[i]));
            }
        }
        for (Map<String, Object> attach : attachList) {
            JSONObject attachInfo = new JSONObject();
            String url = (String)attach.get("relativeUrl");
            if(StringUtils.isBlank(url)){
                url = (String)attach.get("url");
            }
            attachInfo.put(SaveImageConstant.PARAM_KEY_FILE_PATH, url);//文件服务器path
            attachInfo.put(SaveImageConstant.PARAM_KEY_FILE_NAME,attach.get("name"));//文件名
            attachInfo.put(SaveImageConstant.PARAM_KEY_FILE_EXT,attach.get("type"));//扩展名
            String uid = attach.get("uid").toString();
            JSONObject attachTypeInfo = attachTypeMap.get(uid);//附件扩展信息
            if (attachTypeInfo != null){
                attachInfo.putAll(attachTypeInfo);
            }
            attachArr.add(attachInfo);
        }
        configParam.put(SaveImageConstant.PARAM_KEY_ATTACH_PANEL_KEY, attachPanelKey);
        configParam.put(SaveImageConstant.PARAM_KEY_ATTACH_LIST, attachArr);
        configParam.put(SaveImageConstant.PARAM_KEY_FORM_ID, formId);
    }
    private void createPdf(JSONObject param, DynamicObject dataEntity,Map<String, Object> configParam) {
        //判断是否需要生成封面
        if(!needCreatePdf(param)) {
            logger.info("【发票云服务】保存服务，无需生成封面");
            return;
        }
        //获取影像封面，暂不支持自定义的封面模板
        String templateFormId = param.getString(SaveImageConstant.PARAM_KEY_PRINT);
        if(StringUtils.isNotBlank(templateFormId)) {
            String formId = dataEntity.getDynamicObjectType().getName();
            String imageNumber = getImageNumber(formId, (Long)dataEntity.getPkValue());
            //先判断是否创建影像编号
            if(StringUtils.isNotBlank(imageNumber)){
                byte[] imagePdf = CoverUtils.createSinglePdf("", templateFormId, formId, dataEntity.getPkValue());
                if(imagePdf != null && imagePdf.length > 0) {
                    String base64Str = new String( Base64.getEncoder().encode(imagePdf));
                    configParam.put(SaveImageConstant.PARAM_KEY_COVER_BASE64, base64Str);
                    configParam.put(SaveImageConstant.PARAM_KEY_COVER_TYPE, "pdf");
                    configParam.put(SaveImageConstant.PARAM_KEY_PRINT, templateFormId);
                } else {
                    logger.info("【发票云服务】保存服务，未获取到pdf文件流");
                }
            }else{
                logger.info("【发票云服务】保存服务，未获取到影像编号");
            }
        }
    }

    private boolean needCreatePdf(JSONObject param) {
        return StringUtils.isNotBlank(param.getString("print"));
    }




    /**
     * 获取单据对应的影像编码
     */
    private String getImageNumber(String entityName, Long billId) {
        logger.info("getImageNumber param: " + entityName + ", " + billId);
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.setBillId(String.valueOf(billId));
        imageInfo.setBilltype(entityName);

        ImageInfo result = kd.bos.servicehelper.image.ImageServiceHelper.getImageInfoInside(imageInfo);
        if(result == null) {
            logger.info("【发票云服务】保存服务，影像编码未查询到");
            return "";
        }
        logger.info("【发票云服务】保存服务，影像编码: {}", result.getImageNo());
        return result.getImageNo();
    }

    private String createImageNumber(String opKey, DynamicObject dataEntity, JSONObject param) {
        String imageNum = "";
        try {
            ImageInfo imageInfo = new ImageInfo();
            imageInfo.setBillId(dataEntity.getPkValue().toString());//单据id
            imageInfo.setBillNo(dataEntity.getString(param.getString("bill_no")));//单据编码
            imageInfo.setCreator(""+getDynamicObjectLongValue(dataEntity.get(param.getString("bill_user"))));//提单人id
            imageInfo.setBilltype(dataEntity.getDynamicObjectType().getName());//表单标识
            imageInfo.setOrgId(""+getDynamicObjectLongValue(dataEntity.get(param.getString("bill_company"))));//提单人所在组织
            imageNum = ImageServiceHelper.createImageInfo(imageInfo);
            logger.info("【发票云服务】保存服务，推送发票影像数据前创建影像编码成功：{}", imageNum);
        }catch (Exception e){
            logger.info("【发票云服务】保存服务，推送发票影像数据前创建影像编码失败", e);
            logger.info("【发票云服务】保存服务，推送发票影像数据前创建影像编码失败{} {}", opKey, param);
            showKDBizException(opKey, e);
            logger.info("【发票云服务】保存服务，推送发票影像数据前创建影像编码失败,异常类型：{}", e);
        }
        if(StringUtils.isNotBlank(param.getString("bill_image_no"))
                && dataEntity.getDynamicObjectType().getProperty(param.getString("bill_image_no")) != null) {
            dataEntity.set(param.getString("bill_image_no"), imageNum);
        }
        return imageNum;
    }

    /**
     * 	获取基础资料主键id
     * @author 何雨秋
     * @date 2022-4-11
     * @param value
     * @return
     */
    private long getDynamicObjectLongValue(Object value) {
        try {
            if (value instanceof DynamicObject) {
                return Long.parseLong(((DynamicObject) value).getPkValue().toString());
            } else {
                return Long.parseLong(value.toString());
            }
        } catch (Exception e) {
            logger.info(""+value);
            logger.error(e);
            return 0L;
        }
    }
    /**
     * 	获取接口参数
     * @author rd_yuqiu_he
     * @date 2022-4-8
     * @return
     */
    private List<String> getCustomConfigParam() {
        return Lists.newArrayList(SaveImageConstant.PARAM_KEY_BILL_TYPE, SaveImageConstant.PARAM_KEY_BILL_NO, SaveImageConstant.PARAM_KEY_BILL_ID,
                SaveImageConstant.PARAM_KEY_BILL_USER, SaveImageConstant.PARAM_KEY_BILL_COMPANY, SaveImageConstant.PARAM_KEY_BILL_IMAGE_NO,
                SaveImageConstant.PARAM_KEY_COVER_BASE64, SaveImageConstant.PARAM_KEY_COVER_PATH, SaveImageConstant.PARAM_KEY_COVER_TYPE,
                SaveImageConstant.PARAM_KEY_ATTACH_PANEL_KEY,SaveImageConstant.PARAM_KEY_ATTACH_LIST, SaveImageConstant.PARAM_KEY_NEED_COVER,
                SaveImageConstant.PARAM_KEY_NEED_ATTACH, SaveImageConstant.PARAM_KEY_SYNC_AWS, SaveImageConstant.PARAM_KEY_BILL_ENTRY_TYPE,
                SaveImageConstant.PARAM_KEY_BILL_ENTRY_ID, SaveImageConstant.PARAM_KEY_BILL_ENTRY_SERIAL_NO,
                SaveImageConstant.ATTACH_PANEL_ENTRY_KEY,SaveImageConstant.ATTACH_UID_KEY,SaveImageConstant.ATTACH_TYPE_KEY,
                SaveImageConstant.ATTACH_SUB_TYPE_KEY,SaveImageConstant.ATTACH_IS_PAPER_KEY, SaveImageConstant.ATTACH_IS_PAPER_REL,
                SaveImageConstant.PARAM_KEY_APPEND_ATTACH_ONLY, SaveImageConstant.PARAM_KEY_INVOICE_PANEL_KEY,
                SaveImageConstant.PARAM_KEY_ATTACH_PANEL_TAB_KEY);
    }

    /**
     * 	包装KDEX的错误信息
     * @author 何雨秋
     * @date 2022-4-11
     * @param opKey
     * @param e
     */
    private void showKDBizException(String opKey, Exception e) {
        logger.error("【发票云服务】保存服务，错误日志：", e);
        String errorInfoFormat = ResManager.loadKDString("执行%1$s失败，原因：%2$s", "SaveImageAction_2", "bos-ext-imc");
        String errorInfo = String.format(errorInfoFormat, getServiceName(opKey), e.getMessage());
        throw new KDBizException(e, new ErrorCode("SaveInvoiceAction,afterExecuteOperationTransaction", errorInfo));
    }

    /**
     * 	获取当前操作的多语言文字
     * @author 何雨秋
     * @date 2022-4-11
     * @param opKey
     * @return
     */
    private String getServiceName(String opKey){
        String serviceName = opKey;
        if(this.operateMeta.get("name") != null && this.operateMeta.get("name") instanceof Map) {
            serviceName = LocaleString.fromMap((Map)this.operateMeta.get("name")).getLocaleValue();
        }
        return serviceName;
    }

    /**
     * 	因页面无法写成大写，则在多单词之间增加下划线_，在此进行转换
     * 	例：bill_id = billId
     * @author 何雨秋
     * @date 2022-4-11
     * @param key
     * @return
     */
    private String exChange(String key) {
        String[] strArr = key.split("_");
        StringBuilder sb = new StringBuilder();
        sb.append(strArr[0]);
        for (int i = 1; i < strArr.length; i++) {
            String start = strArr[i].substring(0,1);
            String end = strArr[i].substring(1);
            start = start.toUpperCase();
            strArr[i] = start+end;
            sb.append(strArr[i]);
        }
        return sb.toString();
    }

    private void delImgNo(String imageNo) {
        try (TXHandle h = TX.requiresNew()) {
            try {
                String userName = RequestContext.get().getUserName();
                ImageServiceHelper.deleteImage(imageNo, userName, null);
            } catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private JSONObject getAttachIsPaperRelJson(String attachIsPaperRel){
        JSONObject attachIsPaperRelJson = new JSONObject();
        if (StringUtils.isNotEmpty(attachIsPaperRel)){
            //格式[单据的值]=[发票云的值]; 例如 1=纸质;2=电子;3=待定
            String[] entryStrArr = attachIsPaperRel.split(";");
            for (String entryStr : entryStrArr) {
                String[] split = entryStr.split("=");
                //eleImage : 0纸质 1电子 2待定
                String eleImage = "";
                switch (split[1]){
                    case "纸质":
                        eleImage = "0";
                        break;
                    case "电子":
                        eleImage = "1";
                        break;
                    case "待定":
                        eleImage = "2";
                        break;
                }
                attachIsPaperRelJson.put(split[0], eleImage);
            }
        }
        return attachIsPaperRelJson;
    }


    private static void findObj0(DynamicObject dyObj, String objKeys, ArrayList<DynamicObject> objList) {
        if (StringUtils.isEmpty(objKeys)){
            return;
        }
        if (objKeys.contains(".")){
            String objKey = objKeys.substring(0, objKeys.indexOf("."));
            String lastObjKey = objKeys.substring(objKeys.indexOf(".")+1);
            if (objKey.contains("[]")){
                objKey = objKey.replace("[]", "");
                DynamicObjectCollection arr = dyObj.getDynamicObjectCollection(objKey);
                for (int i = 0; i < arr.size(); i++) {
                    findObj0(arr.get(i), lastObjKey, objList);
                }
            }else {
                findObj0(dyObj.getDynamicObject(objKey), lastObjKey, objList);
            }
        }else {
            if (objKeys.contains("[]")){
                objKeys = objKeys.replace("[]", "");
                DynamicObjectCollection arr = dyObj.getDynamicObjectCollection(objKeys);
                for (int i = 0; i < arr.size(); i++) {
                    objList.add(arr.get(i));
                }
            }else {
                objList.add(dyObj.getDynamicObject(objKeys));
            }
        }
    }
}
