package kd.bos.ext.imc.writeback;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.ai.AbstractDapWriteBackImpl;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.ext.fi.ai.VoucherOperation;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

import java.util.HashMap;
import java.util.Iterator;  
import java.util.Map;

/**
 * @ClassName: InvoiceDapVoucherWriteBack
 * @Description: 发票凭证回调接口
 * @Author: ruiran_liang
 * @Date: 2021/05/17
 */
public class InvoiceDapVoucherWriteBack extends AbstractDapWriteBackImpl {
	private static Log logger = LogFactory.getLog(InvoiceDapVoucherWriteBack.class);

	public InvoiceDapVoucherWriteBack() {
	}

	@Override
	public void writeBack(VoucherOperation operation, String billEntityNumber, Map<Long, Voucher> billToVch) {
		MainEntityType mt = EntityMetadataCache.getDataEntityType(billEntityNumber);
		if (mt.findProperty("billno") != null && operation != null) {
			if (VoucherOperation.Create.getValue().equals(operation.getValue())) {
				DB.execute(this.getDBRoute(), "update " + mt.getAlias() + " set fisvoucher = '1'  where fid in (" + StringUtils.join(billToVch.keySet().toArray(), ',') + ")", new Object[0]);
			}

			if (VoucherOperation.Delete.getValue().equals(operation.getValue())) {
				DB.execute(this.getDBRoute(), "update " + mt.getAlias() + " set fisvoucher = '0'  where fid in (" + StringUtils.join(billToVch.keySet().toArray(), ',') + ")", new Object[0]);
			}
			// 发送MQ消息
			this.sendVoucherMsg(operation.getValue(), billEntityNumber, billToVch);
		}
	}

	private void sendVoucherMsg(String voucherOpValue, String billEntityNumber, Map<Long, Voucher> billToVch) {
		try {
			Map<Long, Long> billPkMap = new HashMap(billToVch.size());
			Iterator var6 = billToVch.entrySet().iterator();

			while(var6.hasNext()) {
				Map.Entry<Long, Voucher> entry = (Map.Entry)var6.next();
				Long billId = entry.getKey();
				Voucher voucher = entry.getValue();
				billPkMap.put(billId, voucher.getId());
			}

			Map<String, Object> params = new HashMap(8);
			params.put("billEntityNumber", billEntityNumber);
			params.put("voucherOpValue", voucherOpValue);
			params.put("billPks", billToVch.keySet());
			params.put("billPkMap", billPkMap);
			Map<String, Object> result = DispatchServiceHelper.invokeBizService("imc", "rim", "FpzsService",
					"dapVoucherWriteBack",params);
		} catch (Exception var13) {
			logger.error("发票云-收票生成凭证,凭证反写全票池推送失败:", var13);
			throw var13;
		}
	}

	@Override
	protected String getVchStatusField() {
		return "fisvoucher";
	}

	@Override
	protected Object getVchEnableStatus() {
		return true;
	}

	@Override
	protected Object getVchDisableStatus() {
		return false;
	}

	@Override
	protected DBRoute getDBRoute() {
		return DBRoute.of("taxc");
	}
}
