/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.api.external.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.api.external.IExternalApiAbutment;
import kd.data.idi.api.external.impl.AbutmentParam;
import kd.data.idi.api.external.impl.AdditionalConfig;
import kd.data.idi.api.external.impl.InvoicePiaoZoneParam;
import kd.data.idi.api.external.impl.UrlParam;
import kd.data.idi.data.CustomInvoiceParamValue;
import kd.data.idi.engine.CacheManager;
import kd.data.idi.engine.ParamFactory;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.exception.BizTipException;
import kd.data.idi.util.IDIEncryptUtils;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.InvoiceParser;

public class InvoicePiaoZoneApiAbutmentImpl
implements IExternalApiAbutment<InvoicePiaoZoneParam, List<DynamicObject>> {
    private static final String TOKEN_KEY = "invoice_cloud_token";
    private static final String SIGN = "sign";
    private static final String TIMESTAMP = "timestamp";
    private static final String EXPENSE_ID = "expenseId";
    private static final int EXPIRE_TIME = 129540;

    @Override
    public UrlParam getUrlParam(String number, AbutmentParam additionalConfig) {
        UrlParam urlParam = new UrlParam();
        String url = ParamFactory.getString(number);
        urlParam.setUrl(url);
        String errorMesg = ResManager.loadKDString((String)"\u7f3a\u5c11API\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4\u3002", (String)"APIConfig_0", (String)"data-idi-core", (Object[])new Object[0]);
        if (additionalConfig == null) {
            SchemaExecutorLogger.error((String)"InvoicePiaoZoneApiAbutmentImpl-param is null");
            throw new KDBizException(errorMesg);
        }
        AdditionalConfig config = (AdditionalConfig)additionalConfig;
        DynamicObject sourceBillObj = config.getDynamicBillObj();
        if (sourceBillObj == null) {
            SchemaExecutorLogger.error((String)"InvoicePiaoZoneApiAbutmentImpl-param.dynamicBillObj is null");
            throw new KDBizException(errorMesg);
        }
        String costCompanyField = config.getCostCompanyField();
        if (StringUtils.isEmpty((String)costCompanyField)) {
            SchemaExecutorLogger.error((String)"InvoicePiaoZoneApiAbutmentImpl-param.costCompanyField is null");
            throw new KDBizException(errorMesg);
        }
        DynamicObject costCompanyObject = (DynamicObject)sourceBillObj.get(costCompanyField);
        if (costCompanyObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4fe1\u606f", (String)"IDIInvoicePiaoZoneHelper_16", (String)"data-idi-core", (Object[])new Object[0]));
        }
        SchemaExecutorLogger.info((String)ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8pkValue:%s", (String)"IDIInvoicePiaoZoneHelper_11", (String)"data-idi-core", (Object[])new Object[0]), (Object[])new Object[]{costCompanyObject.getPkValue()});
        if (config.isUseCustomInvoiceParam()) {
            CustomInvoiceParamValue cipv = config.getCustomInvoiceParamValue();
            if (cipv == null) {
                SchemaExecutorLogger.error((String)"InvoicePiaoZoneApiAbutmentImpl-param.CustomInvoiceParamValue is null");
                throw new KDBizException(errorMesg);
            }
            if (StringUtils.isEmpty((String)cipv.getClientIdValue())) {
                throw new BizTipException(String.format(ResManager.loadKDString((String)"%s\u53c2\u6570\u503c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7968\u636e\u68c0\u67e5\u7684\u53c2\u6570\u914d\u7f6e\u3002", (String)"InvoicePiaoZoneApiAbutmentImpl_0", (String)"data-idi-core", (Object[])new Object[0]), "clientid"));
            }
            if (StringUtils.isEmpty((String)cipv.getSecretValue())) {
                throw new BizTipException(String.format(ResManager.loadKDString((String)"%s\u53c2\u6570\u503c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7968\u636e\u68c0\u67e5\u7684\u53c2\u6570\u914d\u7f6e\u3002", (String)"InvoicePiaoZoneApiAbutmentImpl_0", (String)"data-idi-core", (Object[])new Object[0]), "secret"));
            }
            urlParam.setCustomerKey(cipv.getClientIdValue());
            urlParam.setSecret(cipv.getSecretValue());
        } else {
            DynamicObject resultObj = this.getInvoiceCloudConfig(costCompanyObject.getLong("id"));
            if (resultObj == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u4e0d\u5230\u8d39\u7528\u627f\u62c5\u516c\u53f8\u7684\u7ec4\u7ec7\u4fe1\u606f", (String)"IDIInvoicePiaoZoneHelper_12", (String)"data-idi-core", (Object[])new Object[0]));
            }
            String clientId = resultObj.get("client_id").toString();
            String clientSecret = resultObj.get("client_secret").toString();
            urlParam.setCustomerKey(clientId);
            urlParam.setSecret(clientSecret);
        }
        return urlParam;
    }

    private DynamicObject getInvoiceCloudConfig(Long orgPk) {
        String configParam;
        DynamicObject config = null;
        DynamicObject queryOne = QueryServiceHelper.queryOne((String)"er_stdconfig", (String)"value", (QFilter[])new QFilter[]{new QFilter("key", "=", (Object)"invoicecloud.configpattern")});
        boolean isGroup = false;
        if (queryOne != null && StringUtils.isNotEmpty((String)(configParam = queryOne.getString("value"))) && "2".equals(configParam.trim())) {
            isGroup = true;
        }
        if (isGroup) {
            QFilter enableQFilter;
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_bd_kdinvoicecloudcfgct", (Long)orgPk);
            Map configMap = BusinessDataServiceHelper.loadFromCache((String)"er_bd_kdinvoicecloudcfgct", (String)"client_id,client_secret,createorg,ctrlstrategy,modifytime", (QFilter[])new QFilter[]{baseDataFilter, enableQFilter = new QFilter("enable", "=", (Object)Boolean.TRUE)});
            if (configMap == null || configMap.isEmpty()) {
                return config;
            }
            Collection configs = configMap.values();
            config = configs.stream().sorted((c1, c2) -> {
                Long createOrg1 = c1.getDynamicObject("createorg").getLong("id");
                Long createOrg2 = c2.getDynamicObject("createorg").getLong("id");
                if (Objects.equals(createOrg1, orgPk) && !Objects.equals(createOrg2, orgPk)) {
                    return -1;
                }
                if (Objects.equals(createOrg2, orgPk) && !Objects.equals(createOrg1, orgPk)) {
                    return 1;
                }
                String ctlStrategy1 = c1.getString("ctrlstrategy");
                String ctlStrategy2 = c2.getString("ctrlstrategy");
                if ("7".equals(ctlStrategy1) && "7".equals(ctlStrategy2)) {
                    return -1;
                }
                if ("7".equals(ctlStrategy2) && "7".equals(ctlStrategy1)) {
                    return 1;
                }
                Date modifyDate1 = c1.getDate("modifytime");
                Date modifyDate2 = c2.getDate("modifytime");
                if (modifyDate2 == null && modifyDate1 == null) {
                    return 0;
                }
                if (modifyDate2 == null) {
                    return -1;
                }
                if (modifyDate1 == null) {
                    return 1;
                }
                return modifyDate2.compareTo(modifyDate1);
            }).findFirst().orElse(null);
        } else {
            QFilter filter = new QFilter("org", "=", (Object)orgPk);
            filter = filter.and(new QFilter("enable", "=", (Object)"1"));
            config = QueryServiceHelper.queryOne((String)"er_bd_kdinvoicecloudcfg", (String)"client_id,client_secret,encrypt_key", (QFilter[])new QFilter[]{filter});
        }
        return config;
    }

    @Override
    public boolean validate(UrlParam urlParam, InvoicePiaoZoneParam invoicePiaoZoneParam) {
        String errorMesg = ResManager.loadKDString((String)"\u7f3a\u5c11API\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4\u3002", (String)"APIConfig_0", (String)"data-idi-core", (Object[])new Object[0]);
        if (urlParam == null) {
            SchemaExecutorLogger.error((String)"InvoicePiaoZoneApiAbutmentImpl-UrlParam is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)urlParam.getUrl())) {
            SchemaExecutorLogger.error((String)"InvoicePiaoZoneApiAbutmentImpl-UrlParam.url is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)urlParam.getCustomerKey())) {
            SchemaExecutorLogger.error((String)"InvoicePiaoZoneApiAbutmentImpl-UrlParam.client_id is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)urlParam.getSecret())) {
            SchemaExecutorLogger.error((String)"InvoicePiaoZoneApiAbutmentImpl-UrlParam.client_secret is null");
            throw new KDBizException(errorMesg);
        }
        if (invoicePiaoZoneParam == null) {
            SchemaExecutorLogger.error((String)"InvoicePiaoZoneApiAbutmentImpl-abutmentParam is null");
            throw new KDBizException(errorMesg);
        }
        if (invoicePiaoZoneParam.getSource() == null) {
            SchemaExecutorLogger.error((String)"InvoicePiaoZoneApiAbutmentImpl-abutmentParam.source is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)invoicePiaoZoneParam.getBillType())) {
            SchemaExecutorLogger.error((String)"InvoicePiaoZoneApiAbutmentImpl-abutmentParam.billType is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)invoicePiaoZoneParam.getReimbursementId())) {
            if (invoicePiaoZoneParam.isUseCustomInvoiceParam()) {
                String error = String.format(ResManager.loadKDString((String)"%s\u53c2\u6570\u503c\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7968\u636e\u68c0\u67e5\u7684\u53c2\u6570\u914d\u7f6e\u3002", (String)"InvoicePiaoZoneApiAbutmentImpl_0", (String)"data-idi-core", (Object[])new Object[0]), "bxd_key");
                throw new BizTipException(error);
            }
            SchemaExecutorLogger.error((String)"InvoicePiaoZoneApiAbutmentImpl-abutmentParam.ReimbursementId is null");
            throw new KDBizException(errorMesg);
        }
        return true;
    }

    @Override
    public String tokenService() {
        return "/base/oauth/token";
    }

    @Override
    public String getToken(UrlParam urlParam) {
        String clientId = urlParam.getCustomerKey();
        String clientSecret = urlParam.getSecret();
        String url = urlParam.getUrl();
        String timeStamp = String.valueOf(System.currentTimeMillis());
        String sign = IDIEncryptUtils.getMD5((String)(clientId + clientSecret + timeStamp));
        Map jsonObject = new HashMap<String, String>();
        jsonObject.put("client_id", clientId);
        jsonObject.put(SIGN, sign);
        jsonObject.put(TIMESTAMP, timeStamp);
        String tokenService = this.tokenService();
        String tokenUrl = url + tokenService;
        String paramJson = IDIJSONUtils.toJsonString(jsonObject);
        SchemaExecutorLogger.info((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6token\u524d--loginUrl:%1$s,jsonObject:%2$s", (String)"IDIInvoicePiaoZoneHelper_3", (String)"data-idi-core", (Object[])new Object[0]), tokenUrl, paramJson), (Object[])new Object[0]);
        int timeOut = ParamFactory.getTimeOut();
        String number = "data-idi-invoicetoken";
        this.importAPI(number);
        String result = this.iscInvoke(number, paramJson, tokenUrl, timeOut);
        jsonObject = (Map)IDIJSONUtils.cast((String)result, Map.class);
        String errCode = String.valueOf(jsonObject.get("errcode"));
        if ("0000".equals(errCode)) {
            String token = String.valueOf(jsonObject.get("access_token"));
            String cacheKey = this.buildCacheKey(clientId);
            CacheManager.put("token", cacheKey, token, 129540);
            return token;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25", (String)"IDIInvoicePiaoZoneHelper_0", (String)"data-idi-core", (Object[])new Object[0]));
    }

    @Override
    public String getTokenFromCache(String cacheKey) {
        String cacheToken = CacheManager.get("token", cacheKey);
        return cacheToken;
    }

    @Override
    public String buildCacheKey(String fixKey) {
        return "invoice_cloud_token_" + fixKey;
    }

    @Override
    public String apiService() {
        return "/m4/bill/expense/message/query/expenseId/thirdparty?access_token=";
    }

    @Override
    public String apiAction(UrlParam urlParam, InvoicePiaoZoneParam invoicePiaoZoneParam) {
        String url = urlParam.getUrl();
        String cacheKey = this.buildCacheKey(urlParam.getCustomerKey());
        String token = this.getTokenFromCache(cacheKey);
        boolean hasGetTokenFromInterface = false;
        if (StringUtils.isEmpty((String)token)) {
            token = this.getToken(urlParam);
            hasGetTokenFromInterface = true;
        }
        String reimbursementId = invoicePiaoZoneParam.getReimbursementId();
        String requestUrl = url + this.apiService() + token;
        HashMap<String, String> paramJson = new HashMap<String, String>();
        paramJson.put(EXPENSE_ID, reimbursementId);
        String param = IDIJSONUtils.toJsonString(paramJson);
        SchemaExecutorLogger.info((String)String.format(ResManager.loadKDString((String)"url:%1$s,param:%2$s", (String)"IDIInvoicePiaoZoneHelper_8", (String)"data-idi-core", (Object[])new Object[0]), url, param), (Object[])new Object[0]);
        int timeOut = ParamFactory.getTimeOut();
        String number = "data-idi-invoice";
        this.importAPI(number);
        String result = this.iscInvoke(number, param, requestUrl, timeOut);
        String errorCode = String.valueOf(((Map)IDIJSONUtils.cast((String)result, Map.class)).get("errcode"));
        if (!hasGetTokenFromInterface && !"0000".equals(errorCode)) {
            token = this.getToken(urlParam);
            requestUrl = url + this.apiService() + token;
            result = this.iscInvoke(number, param, requestUrl, timeOut);
        }
        SchemaExecutorLogger.info((String)String.format(ResManager.loadKDString((String)"result:%s", (String)"IDIInvoicePiaoZoneHelper_9", (String)"data-idi-core", (Object[])new Object[0]), result), (Object[])new Object[0]);
        return result;
    }

    @Override
    public List<DynamicObject> parseResult(String content, InvoicePiaoZoneParam invoicePiaoZoneParam) {
        List<DynamicObject> invoiceObjList = InvoiceParser.parseInvoiceResult(content, String.valueOf(invoicePiaoZoneParam.getSource().get("id")));
        if (invoiceObjList == null) {
            invoiceObjList = new ArrayList<DynamicObject>(1);
        }
        return invoiceObjList;
    }

    public static InvoicePiaoZoneApiAbutmentImpl createInstance() {
        return new InvoicePiaoZoneApiAbutmentImpl();
    }
}

