/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.api.external.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.api.external.IExternalApiAbutment;
import kd.data.idi.api.external.impl.AbutmentParam;
import kd.data.idi.api.external.impl.LCAttachmentApiAbutmentImpl;
import kd.data.idi.api.external.impl.LCAttachmentParam;
import kd.data.idi.api.external.impl.UrlParam;
import kd.data.idi.data.attachment.AttachmentFieldTypeEnum;
import kd.data.idi.engine.CacheManager;
import kd.data.idi.engine.ParamFactory;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.attachment.AIRecognizerErrorInfo;
import kd.data.idi.engine.attachment.AIRecognizerResult;
import kd.data.idi.engine.attachment.AIRecognizerSuccessInfo;
import kd.data.idi.engine.attachment.AITemplate;
import kd.data.idi.engine.attachment.Attachment;
import kd.data.idi.util.AttachmentFieldValueHelper;
import kd.data.idi.util.IDIJSONUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class LCAttachmentApiAbutmentImpl
implements IExternalApiAbutment<LCAttachmentParam, AIRecognizerResult> {
    private static final String KEY_PROJECTCODE = "projectCode";
    private static final String KEY_FILESECRET = "fileSecret";
    private static final String OPENAPINUMBER = "callback/attachment";
    private static final String KEY_CALLBACKURL = "callbackurl";

    @Override
    public UrlParam getUrlParam(String number, AbutmentParam additionalConfig) {
        UrlParam urlParam = new UrlParam();
        HashMap<String, String> map = new HashMap<String, String>();
        String url = null;
        String merchanCode = null;
        String merchanSecret = null;
        String method = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"LCAttachmentHelper.getUrlParam", (String)"idi_api_config", (String)"number,url,clientid,clientsecret,httpmethod,paramentryentity.paramname,paramentryentity.paramtype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("enable", "=", (Object)"1")}, null);){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    url = row.getString("url");
                    merchanCode = row.getString("clientid");
                    merchanSecret = row.getString("clientsecret");
                    method = row.getString("httpmethod");
                    String projectCodeName = row.getString("paramentryentity.paramname");
                    String projectCode = row.getString("paramentryentity.paramtype");
                    map.put(projectCodeName, projectCode);
                }
            }
        }
        urlParam.setUrl(url);
        urlParam.setCustomerKey(merchanCode);
        urlParam.setSecret(merchanSecret);
        urlParam.setRequestMethod(method);
        urlParam.setParamMap(map);
        map.put("callbackurl", LCAttachmentApiAbutmentImpl.getCallbackUrl());
        return urlParam;
    }

    public static String getCallbackUrl() {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)"callback/attachment")};
        DynamicObject openApiObj = QueryServiceHelper.queryOne((String)"openapi_customapi", (String)"id,urlformat", (QFilter[])filters);
        if (openApiObj == null) {
            String errorMesg = ResManager.loadKDString((String)"\u7f3a\u5c11API\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4\u3002", (String)"APIConfig_0", (String)"data-idi-core", (Object[])new Object[0]);
            SchemaExecutorLogger.error((String)"not have callback url");
            throw new KDBizException(errorMesg);
        }
        String serviceurl = openApiObj.getString("urlformat");
        String urlCosmic = UrlService.getDomainContextUrl();
        String preUrl = "/kapi" + serviceurl;
        RequestContext rc = RequestContext.get();
        return urlCosmic + preUrl + "?accountId=" + rc.getAccountId();
    }

    @Override
    public boolean validate(UrlParam urlParam, LCAttachmentParam lcAttachmentParam) {
        String errorMesg = ResManager.loadKDString((String)"\u7f3a\u5c11API\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4\u3002", (String)"APIConfig_0", (String)"data-idi-core", (Object[])new Object[0]);
        SchemaExecutorLogger.info((String)("LcAttachmentApiAbutmentImpl-UrlParam\uff1a" + urlParam), (Object[])new Object[0]);
        if (urlParam == null) {
            SchemaExecutorLogger.error((String)"LcAttachmentApiAbutmentImpl-UrlParam is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)urlParam.getUrl())) {
            SchemaExecutorLogger.error((String)"LcAttachmentApiAbutmentImpl-UrlParam.url is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)urlParam.getCustomerKey())) {
            SchemaExecutorLogger.error((String)"LcAttachmentApiAbutmentImpl-UrlParam.client_id is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)urlParam.getSecret())) {
            SchemaExecutorLogger.error((String)"LcAttachmentApiAbutmentImpl-UrlParam.client_secret is null");
            throw new KDBizException(errorMesg);
        }
        Map paramMap = urlParam.getParamMap();
        if (paramMap == null || paramMap.isEmpty()) {
            SchemaExecutorLogger.error((String)"LcAttachmentApiAbutmentImpl-UrlParam.paramMap is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)((String)paramMap.get("projectCode")))) {
            SchemaExecutorLogger.error((String)"LcAttachmentApiAbutmentImpl-UrlParam.paramMap.projectCode is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)((String)paramMap.get("fileSecret")))) {
            SchemaExecutorLogger.error((String)"LcAttachmentApiAbutmentImpl-UrlParam.paramMap.fileSecret is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)((String)paramMap.get("callbackurl")))) {
            SchemaExecutorLogger.error((String)"LcAttachmentApiAbutmentImpl-UrlParam.callbackurl is null");
            throw new KDBizException(errorMesg);
        }
        if (lcAttachmentParam == null) {
            SchemaExecutorLogger.error((String)"LcAttachmentApiAbutmentImpl-lcAttachmentParam is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)lcAttachmentParam.getBillName())) {
            SchemaExecutorLogger.error((String)"LcAttachmentApiAbutmentImpl-lcAttachmentParam.billName is null");
            throw new KDBizException(errorMesg);
        }
        if (StringUtils.isEmpty((String)lcAttachmentParam.getBillNo())) {
            SchemaExecutorLogger.error((String)"LcAttachmentApiAbutmentImpl-lcAttachmentParam.billNo is null");
            throw new KDBizException(errorMesg);
        }
        if (lcAttachmentParam.getTemplate() == null) {
            SchemaExecutorLogger.error((String)"LcAttachmentApiAbutmentImpl-lcAttachmentParam.template is null");
            throw new KDBizException(errorMesg);
        }
        Map zmcFilterConditionMap = lcAttachmentParam.getZmcFilterCondition();
        if (zmcFilterConditionMap == null || zmcFilterConditionMap.isEmpty()) {
            SchemaExecutorLogger.error((String)"LcAttachmentApiAbutmentImpl-lcAttachmentParam.zmcFilterCondition is null");
            throw new KDBizException(errorMesg);
        }
        zmcFilterConditionMap.forEach((key, value) -> {
            if (value == null) {
                SchemaExecutorLogger.error((String)("LcAttachmentApiAbutmentImpl-lcAttachmentParam.zmcFilterCondition." + key + " is null"));
                throw new KDBizException(errorMesg);
            }
        });
        if (CollectionUtils.isEmpty((Collection)lcAttachmentParam.getAttachmentList())) {
            SchemaExecutorLogger.error((String)"LcAttachmentApiAbutmentImpl-lcAttachmentParam.attachmentList is null");
            throw new KDBizException(errorMesg);
        }
        return false;
    }

    @Override
    public String tokenService() {
        return null;
    }

    @Override
    public String getToken(UrlParam urlParam) {
        return null;
    }

    @Override
    public String getTokenFromCache(String cacheKey) {
        return null;
    }

    @Override
    public String buildCacheKey(String fixKey) {
        return "lc";
    }

    @Override
    public String apiService() {
        return "/api-jindie/ifs/audit/notify";
    }

    @Override
    public String apiAction(UrlParam urlParam, LCAttachmentParam lcAttachmentParam) {
        this.validate(urlParam, lcAttachmentParam);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        String requestNo = lcAttachmentParam.getRequestNo();
        SchemaExecutorLogger.info((String)("[DATA-IDI] ApiAction requestNo:" + requestNo), (Object[])new Object[0]);
        if (StringUtils.isEmpty((String)requestNo) || "null".equalsIgnoreCase(requestNo)) {
            requestNo = RequestContext.get().getTraceId();
            SchemaExecutorLogger.info((String)String.format("[DATA-IDI] ApiAction -- reset requestNo to RequestContext.get().getTraceId()\uff1a%s!", requestNo), (Object[])new Object[0]);
        }
        String url = urlParam.getUrl();
        url = url + this.apiService();
        SchemaExecutorLogger.info((String)("[DATA-IDI] ApiAction lc url :" + url), (Object[])new Object[0]);
        Map urlParamMap = urlParam.getParamMap();
        RequestHead rh = new RequestHead(urlParam.getCustomerKey(), (String)urlParamMap.get("projectCode"), urlParam.getSecret(), requestNo);
        RequestHead.access$002((RequestHead)rh, null);
        paramMap.put("requestHead", rh);
        List attachmentList = lcAttachmentParam.getAttachmentList().stream().map(att -> RequestBody.convert((Attachment)att, (String)((String)urlParamMap.get("fileSecret")))).collect(Collectors.toList());
        RequestBody rb = new RequestBody(lcAttachmentParam.getBillNo(), lcAttachmentParam.getBillName(), (String)urlParamMap.get("callbackurl"), lcAttachmentParam.getZmcFilterCondition(), attachmentList);
        paramMap.put("requestBody", rb);
        String paramJson = IDIJSONUtils.toJsonString(paramMap);
        SchemaExecutorLogger.info((String)("[DATA-IDI] ApiAction lc param :" + paramJson), (Object[])new Object[0]);
        int timeOut = ParamFactory.getTimeOut();
        String number = "data-idi-lc";
        this.importAPI(number);
        String result = this.iscInvoke(number, paramJson, url, timeOut);
        SchemaExecutorLogger.info((String)("[DATA-IDI] ApiAction lc result :" + result), (Object[])new Object[0]);
        if (result.contains("success")) {
            Map signValidateResult = (Map)IDIJSONUtils.cast((String)result, Map.class);
            throw new KDBizException(String.valueOf(signValidateResult.get("message")));
        }
        JSONObject resultJson = JSONObject.parseObject((String)result);
        if ("200".equals(resultJson.getString("errorCode"))) {
            String cacheKey = this.buildCacheKey(urlParam.getCustomerKey());
            CacheManager.put(cacheKey, requestNo, requestNo, 600);
            return requestNo;
        }
        throw new KDBizException(resultJson.getString("errorMsg"));
    }

    @Override
    public AIRecognizerResult parseResult(String content, LCAttachmentParam lcAttachmentParam) {
        JSONObject lcResult;
        AIRecognizerResult result = new AIRecognizerResult();
        try {
            lcResult = JSON.parseObject((String)content);
        }
        catch (Exception e) {
            SchemaExecutorLogger.error((String)String.format("[DATA-IDI] LCAttachmentApiAbutmentImpl paresLC error!content:%s, lcAttachmentParam:%s", content, lcAttachmentParam));
            throw new KDBizException((Throwable)e, new ErrorCode("", ""), new Object[]{e.getMessage()});
        }
        if (lcResult == null) {
            SchemaExecutorLogger.info((String)String.format("[DATA-IDI] LCAttachmentApiAbutmentImpl lcResult is null!content:%s, lcAttachmentParam:%s", content, lcAttachmentParam), (Object[])new Object[0]);
            return result;
        }
        String passStatus = lcResult.getString("result");
        result.setRequestId(lcResult.getString("requestNo"));
        result.setErrorCode(passStatus);
        if (!"PASS".equals(passStatus)) {
            result.setDescription(lcResult.getString("failReason"));
        }
        JSONObject successJson = lcResult.getJSONObject("data");
        HashMap<String, String> fieldAndTypeMap = new HashMap<String, String>(16);
        QFilter idFilter = new QFilter("group", "=", (Object)lcAttachmentParam.getTemplate().getId());
        Map fieldAndTypeDynamic = BusinessDataServiceHelper.loadFromCache((String)"idi_attachmentfield", (String)"number,fieldtype", (QFilter[])idFilter.toArray(), null);
        if (fieldAndTypeDynamic != null && !fieldAndTypeDynamic.isEmpty()) {
            for (Map.Entry entry : fieldAndTypeDynamic.entrySet()) {
                DynamicObject dynamicObj = (DynamicObject)entry.getValue();
                fieldAndTypeMap.put(dynamicObj.getString("number"), dynamicObj.getString("fieldtype"));
            }
            SchemaExecutorLogger.info((String)String.format("[DATA-IDI] LCAttachmentApiAbutmentImpl fieldAndTypeMap : %s", JSON.toJSONString(fieldAndTypeMap)), (Object[])new Object[0]);
        }
        JSONArray invoiceArray = successJson.getJSONArray("invoices");
        this.parseSuccessData(invoiceArray, lcAttachmentParam, result, fieldAndTypeMap);
        JSONArray otherArray = successJson.getJSONArray("others");
        this.parseSuccessData(otherArray, lcAttachmentParam, result, fieldAndTypeMap);
        SchemaExecutorLogger.info((String)String.format("[DATA-IDI] LCAttachmentApiAbutmentImpl paresLC success!AIRecognizerResult:%s", JSON.toJSONString((Object)result)), (Object[])new Object[0]);
        return result;
    }

    private void parseSuccessData(JSONArray invoiceArray, LCAttachmentParam lcAttachmentParam, AIRecognizerResult result, Map<String, String> fieldAndTypeMap) {
        int size = invoiceArray.size();
        for (int index = 0; index < size; ++index) {
            AITemplate templateObj;
            JSONObject invoiceData = invoiceArray.getJSONObject(index);
            String fileName = invoiceData.getString("fileSourceKey");
            String templateNumber = invoiceData.getString("voucherCode");
            if (lcAttachmentParam.getTemplate().getNumber().equals(templateNumber)) {
                templateObj = lcAttachmentParam.getTemplate();
                JSONObject dataJSON = invoiceData.getJSONObject("detail");
                Set fieldSet = dataJSON.keySet();
                HashMap<String, Object> dataDetailMap = new HashMap<String, Object>(fieldSet.size());
                HashMap<String, Object> recognitionDataMap = new HashMap<String, Object>(fieldSet.size());
                for (String field : fieldSet) {
                    JSONObject valueJson = dataJSON.getJSONObject(field);
                    Object value = valueJson.get((Object)"value");
                    String valueStr = String.valueOf(value);
                    if (valueStr.startsWith("[{")) {
                        JSONArray tableValueArray = valueJson.getJSONArray("value");
                        int tableSize = tableValueArray.size();
                        ArrayList rowDataList = new ArrayList(tableSize);
                        ArrayList rowConfidenceDataList = new ArrayList(tableSize);
                        for (int i = 0; i < tableSize; ++i) {
                            JSONObject rowJson = tableValueArray.getJSONObject(i);
                            Set subFieldSet = rowJson.keySet();
                            HashMap<String, Object> rowDataMap = new HashMap<String, Object>(subFieldSet.size());
                            HashMap<String, BigDecimal> rowConfidenceDataMap = new HashMap<String, BigDecimal>(subFieldSet.size());
                            for (String subField : subFieldSet) {
                                JSONObject subValueJson = rowJson.getJSONObject(subField);
                                AttachmentFieldTypeEnum fieldTypeEnum = AttachmentFieldValueHelper.getFieldType((String)field, (Object)subValueJson.get((Object)"fieldType"), fieldAndTypeMap);
                                Object formatValue = AttachmentFieldValueHelper.getValueByFieldType((AttachmentFieldTypeEnum)fieldTypeEnum, (Object)subValueJson.get((Object)"value"));
                                rowDataMap.put(subField, formatValue);
                                BigDecimal subConfidence = subValueJson.getBigDecimal("confidence");
                                rowConfidenceDataMap.put(subField, subConfidence);
                            }
                            rowDataList.add(rowDataMap);
                            rowConfidenceDataList.add(rowConfidenceDataMap);
                        }
                        dataDetailMap.put(field, rowDataList);
                        recognitionDataMap.put(field, rowConfidenceDataList);
                        continue;
                    }
                    AttachmentFieldTypeEnum fieldTypeEnum = AttachmentFieldValueHelper.getFieldType((String)field, (Object)valueJson.get((Object)"fieldType"), fieldAndTypeMap);
                    Object formatValue = AttachmentFieldValueHelper.getValueByFieldType((AttachmentFieldTypeEnum)fieldTypeEnum, (Object)value);
                    dataDetailMap.put(field, formatValue);
                    BigDecimal confidence = valueJson.getBigDecimal("confidence");
                    recognitionDataMap.put(field, confidence);
                }
                AIRecognizerSuccessInfo successInfo = new AIRecognizerSuccessInfo(fileName, templateObj, recognitionDataMap, dataDetailMap);
                result.addSuccessInfo(successInfo);
                continue;
            }
            templateObj = new AITemplate();
            templateObj.setCustomTemplate(false);
            templateObj.setNumber(templateNumber);
            AIRecognizerErrorInfo errorInfo = new AIRecognizerErrorInfo();
            errorInfo.setFileName(fileName);
            errorInfo.setTemplate(templateObj);
            errorInfo.setErrorCode("lc404");
            errorInfo.setDescription(ResManager.loadKDString((String)"\u8bc6\u522b\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5339\u914d", (String)"LCAttachmentApiAbutmentImpl_0", (String)"data-idi-core", (Object[])new Object[0]));
            result.addErrorInfo(errorInfo);
        }
    }
}

