/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.lang.Lang;
import kd.bos.util.CollectionUtils;
import kd.data.idi.data.DeductionGradeConfig;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.statistics.AlarmHoverSettingRow;

public class AlarmConfig {
    private FilterCondition filterCondition;
    private String successText;
    private LocaleString localSuccessText;
    private String failText;
    private LocaleString localFailText;
    private boolean checkVote;
    private List<AlarmHoverSettingRow> hoverSetting;
    private IDICondition startCondition;
    private List<DeductionGradeConfig> deductionGradeConfigList;

    public FilterCondition getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(FilterCondition filterCondition) {
        this.filterCondition = filterCondition;
    }

    public String getSuccessText() {
        if (this.localSuccessText == null) {
            return this.successText;
        }
        return this.localSuccessText.toString();
    }

    public void setSuccessText(String successText) {
        this.successText = successText;
    }

    public String getFailText() {
        if (this.localFailText == null) {
            return this.failText;
        }
        return this.localFailText.toString();
    }

    public void setFailText(String failText) {
        this.failText = failText;
    }

    public boolean isCheckVote() {
        return this.checkVote;
    }

    public void setCheckVote(boolean checkVote) {
        this.checkVote = checkVote;
    }

    public void extractProperties(Set<String> varSet, String billType) {
        IDICondition.extractSrcProperties(varSet, (FilterCondition)this.filterCondition);
        if (this.getStartCondition() != null) {
            this.getStartCondition().extractProperties(varSet, billType, new String[]{billType});
        }
    }

    public List<AlarmHoverSettingRow> getHoverSetting() {
        if (this.hoverSetting == null) {
            this.hoverSetting = new ArrayList<AlarmHoverSettingRow>(1);
        }
        return this.hoverSetting;
    }

    public void setHoverSetting(List<AlarmHoverSettingRow> hoverSetting) {
        this.hoverSetting = hoverSetting;
    }

    public IDICondition getStartCondition() {
        return this.startCondition;
    }

    public List<DeductionGradeConfig> getDeductionGradeConfigList() {
        return this.deductionGradeConfigList;
    }

    public void setStartCondition(IDICondition startCondition) {
        this.startCondition = startCondition;
    }

    public void setDeductionGradeConfigList(List<DeductionGradeConfig> deductionGradeConfigList) {
        this.deductionGradeConfigList = deductionGradeConfigList;
    }

    public LocaleString getLocalSuccessText() {
        if (this.localSuccessText == null) {
            return new LocaleString(Lang.zh_CN.toString(), this.successText == null ? "" : this.successText);
        }
        return this.localSuccessText;
    }

    public void setLocalSuccessText(LocaleString localSuccessText) {
        this.localSuccessText = localSuccessText;
    }

    public LocaleString getLocalFailText() {
        if (this.localFailText == null) {
            return new LocaleString(Lang.zh_CN.toString(), this.failText == null ? "" : this.failText);
        }
        return this.localFailText;
    }

    public void setLocalFailText(LocaleString localFailText) {
        this.localFailText = localFailText;
    }

    public boolean validate() {
        FilterCondition fc = this.getFilterCondition();
        if (fc != null) {
            return CollectionUtils.isNotEmpty((Collection)fc.getFilterRow());
        }
        return true;
    }
}

