/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.lang.Lang;
import kd.bos.util.CollectionUtils;
import kd.data.idi.data.Decision;
import kd.data.idi.data.IDICondition;

public class Area {
    private String title;
    private LocaleString localeTitle;
    private List<Decision> decision;
    private String pk;
    private IDICondition startCondition;

    public String getTitle() {
        if (this.localeTitle == null) {
            return this.title;
        }
        return this.localeTitle.toString();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public LocaleString getLocaleTitle() {
        if (this.localeTitle == null) {
            return new LocaleString(Lang.zh_CN.toString(), this.title == null ? "" : this.title);
        }
        return this.localeTitle;
    }

    public void setLocaleTitle(LocaleString localeTitle) {
        this.localeTitle = localeTitle;
    }

    public List<Decision> getDecision() {
        return this.decision;
    }

    public void setDecision(List<Decision> decision) {
        this.decision = decision;
    }

    public boolean hasControl() {
        if (this.decision != null && !this.decision.isEmpty()) {
            for (Decision d : this.decision) {
                if (!d.hasControl()) continue;
                return true;
            }
        }
        return false;
    }

    public String getPk() {
        return this.pk;
    }

    public void setPk(String pk) {
        this.pk = pk;
    }

    public boolean hasLC() {
        if (this.decision != null && !this.decision.isEmpty()) {
            for (Decision d : this.decision) {
                if (!d.isLCAttachment()) continue;
                return true;
            }
        }
        return false;
    }

    public Map<Long, Set<String>> achieveLcTemplateField(String billType) {
        HashMap<Long, Set<String>> lcTemplateFieldMap = new HashMap<Long, Set<String>>(10);
        if (this.decision != null && !this.decision.isEmpty()) {
            for (Decision d : this.decision) {
                if (!d.isLCAttachment()) continue;
                Long templateId = d.achieveLcTemplateId();
                Set<String> lcTemplateFieldSet = (Set<String>)lcTemplateFieldMap.get(templateId);
                if (CollectionUtils.isNotEmpty((Collection)lcTemplateFieldSet)) {
                    lcTemplateFieldSet.addAll(d.achieveLcTemplateField(billType));
                    continue;
                }
                lcTemplateFieldSet = d.achieveLcTemplateField(billType);
                lcTemplateFieldMap.put(templateId, lcTemplateFieldSet);
            }
        }
        return lcTemplateFieldMap;
    }

    public IDICondition getStartCondition() {
        return this.startCondition;
    }

    public void setStartCondition(IDICondition startCondition) {
        this.startCondition = startCondition;
    }

    public void extractProperties(Set<String> varSet, String billType) {
        if (this.startCondition != null) {
            this.startCondition.extractProperties(varSet, billType, new String[]{billType});
        }
        if (CollectionUtils.isNotEmpty(this.decision)) {
            for (Decision subDecision : this.decision) {
                subDecision.extractProperties(varSet, billType);
            }
        }
    }
}

