/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.lang.Lang;
import kd.bos.util.StringUtils;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.KeywordConfigItem;

public class KeywordConfig {
    private List<KeywordConfigItem> items;
    private String detectedText;
    private LocaleString localDetectedText;
    private String notDetectedText;
    private LocaleString localNotDetectedText;
    private IDICondition startCondition;

    public List<KeywordConfigItem> getItems() {
        return this.items;
    }

    public void setItems(List<KeywordConfigItem> items) {
        this.items = items;
    }

    public String getDetectedText() {
        if (this.localDetectedText == null) {
            return this.detectedText;
        }
        return this.localDetectedText.toString();
    }

    public void setDetectedText(String detectedText) {
        this.detectedText = detectedText;
    }

    public String getNotDetectedText() {
        if (this.localNotDetectedText == null) {
            return this.notDetectedText;
        }
        return this.localNotDetectedText.toString();
    }

    public void setNotDetectedText(String notDetectedText) {
        this.notDetectedText = notDetectedText;
    }

    public IDICondition getStartCondition() {
        return this.startCondition;
    }

    public void setStartCondition(IDICondition startCondition) {
        this.startCondition = startCondition;
    }

    public void extractProperties(Set<String> varSet, String billType) {
        if (this.getItems() != null) {
            for (KeywordConfigItem item : this.getItems()) {
                if (!StringUtils.isNotEmpty((String)item.getPropertyName())) continue;
                varSet.add(item.getPropertyName());
            }
        }
        if (this.getStartCondition() != null) {
            this.getStartCondition().extractProperties(varSet, billType, new String[]{billType});
        }
    }

    public LocaleString getLocalDetectedText() {
        if (this.localDetectedText == null) {
            return new LocaleString(Lang.zh_CN.toString(), this.detectedText == null ? "" : this.detectedText);
        }
        return this.localDetectedText;
    }

    public void setLocalDetectedText(LocaleString localDetectedText) {
        this.localDetectedText = localDetectedText;
    }

    public LocaleString getLocalNotDetectedText() {
        if (this.localNotDetectedText == null) {
            return new LocaleString(Lang.zh_CN.toString(), this.notDetectedText == null ? "" : this.notDetectedText);
        }
        return this.localNotDetectedText;
    }

    public void setLocalNotDetectedText(LocaleString localNotDetectedText) {
        this.localNotDetectedText = localNotDetectedText;
    }
}

