/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.data.attachment;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.DecisionFrontEndConfig;
import kd.data.idi.data.DecisionRule;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.attachment.CheckAttachmentTypeEnum;
import kd.data.idi.data.attachment.CheckMethodEnum;
import kd.data.idi.data.attachment.ExceptionTip;
import kd.data.idi.util.IDIStringUtils;

public class AttachmentConfig {
    private IDICondition startCondition;
    private CheckAttachmentTypeEnum checkType;
    private CheckMethodEnum checkMethod;
    private Long validTemplateId;
    private String validTemplateNumber;
    private Long customTemplateId;
    private String customTemplateNumber;
    private Long recognizerId;
    private String recognizerNumber;
    private Long lcTemplateId;
    private String recognizerName;
    private String existWords;
    private String notExistWords;
    private List<DecisionRule> ruleList;
    private List<ExceptionTip> exceptionTipList;
    private DecisionFrontEndConfig frontEndConfig;
    private LocaleString mulExistWords;
    private LocaleString mulNotExistWords;

    public AttachmentConfig() {
    }

    public AttachmentConfig(IDICondition startCondition, CheckAttachmentTypeEnum checkType, CheckMethodEnum checkMethod, Long validTemplateId, Long customTemplateId, Long recognizerId, String recognizerName, String existWords, String notExistWords, List<DecisionRule> ruleList, List<ExceptionTip> exceptionTipList, DecisionFrontEndConfig frontEndConfig) {
        this.startCondition = startCondition;
        this.checkType = checkType;
        this.checkMethod = checkMethod;
        this.validTemplateId = validTemplateId;
        this.customTemplateId = customTemplateId;
        this.recognizerId = recognizerId;
        this.recognizerName = recognizerName;
        this.existWords = existWords;
        this.notExistWords = notExistWords;
        this.ruleList = ruleList;
        this.exceptionTipList = exceptionTipList;
        this.frontEndConfig = frontEndConfig;
    }

    public IDICondition getStartCondition() {
        return this.startCondition;
    }

    public void setStartCondition(IDICondition startCondition) {
        this.startCondition = startCondition;
    }

    public CheckAttachmentTypeEnum getCheckType() {
        return this.checkType;
    }

    public void setCheckType(CheckAttachmentTypeEnum checkType) {
        this.checkType = checkType;
    }

    public CheckMethodEnum getCheckMethod() {
        return this.checkMethod;
    }

    public void setCheckMethod(CheckMethodEnum checkMethod) {
        this.checkMethod = checkMethod;
    }

    public Long getValidTemplateId() {
        return this.validTemplateId;
    }

    public void setValidTemplateId(Long validTemplateId) {
        this.validTemplateId = validTemplateId;
    }

    public Long getCustomTemplateId() {
        return this.customTemplateId;
    }

    public void setCustomTemplateId(Long customTemplateId) {
        this.customTemplateId = customTemplateId;
    }

    public Long getRecognizerId() {
        return this.recognizerId;
    }

    public void setRecognizerId(Long recognizerId) {
        this.recognizerId = recognizerId;
    }

    public String getRecognizerName() {
        return this.recognizerName;
    }

    public void setRecognizerName(String recognizerName) {
        this.recognizerName = recognizerName;
    }

    public String getExistWords() {
        return this.existWords;
    }

    public void setExistWords(String existWords) {
        this.existWords = existWords;
    }

    public String getNotExistWords() {
        return this.notExistWords;
    }

    public void setNotExistWords(String notExistWords) {
        this.notExistWords = notExistWords;
    }

    public List<DecisionRule> getRuleList() {
        return this.ruleList;
    }

    public void setRuleList(List<DecisionRule> ruleList) {
        this.ruleList = ruleList;
    }

    public List<ExceptionTip> getExceptionTipList() {
        return this.exceptionTipList;
    }

    public void setExceptionTipList(List<ExceptionTip> exceptionTipList) {
        this.exceptionTipList = exceptionTipList;
    }

    public DecisionFrontEndConfig getFrontEndConfig() {
        return this.frontEndConfig;
    }

    public void setFrontEndConfig(DecisionFrontEndConfig frontEndConfig) {
        this.frontEndConfig = frontEndConfig;
    }

    public Long getLcTemplateId() {
        return this.lcTemplateId;
    }

    public void setLcTemplateId(Long lcTemplateId) {
        this.lcTemplateId = lcTemplateId;
    }

    public String getValidTemplateNumber() {
        return this.validTemplateNumber;
    }

    public void setValidTemplateNumber(String validTemplateNumber) {
        this.validTemplateNumber = validTemplateNumber;
    }

    public String getCustomTemplateNumber() {
        return this.customTemplateNumber;
    }

    public void setCustomTemplateNumber(String customTemplateNumber) {
        this.customTemplateNumber = customTemplateNumber;
    }

    public String getRecognizerNumber() {
        return this.recognizerNumber;
    }

    public void setRecognizerNumber(String recognizerNumber) {
        this.recognizerNumber = recognizerNumber;
    }

    public LocaleString getMulExistWords() {
        return this.mulExistWords;
    }

    public void setMulExistWords(LocaleString mulExistWords) {
        this.mulExistWords = mulExistWords;
    }

    public LocaleString getMulNotExistWords() {
        return this.mulNotExistWords;
    }

    public void setMulNotExistWords(LocaleString mulNotExistWords) {
        this.mulNotExistWords = mulNotExistWords;
    }

    public void extractProperties(Set<String> varSet, String billType) {
        MainEntityType billMainType;
        List<DecisionRule> ruleList;
        String[] billTypes = new String[]{billType};
        if (this.getStartCondition() != null) {
            this.getStartCondition().extractProperties(varSet, billType, billTypes);
        }
        if ((ruleList = this.getRuleList()) != null) {
            for (DecisionRule decisionRule : ruleList) {
                decisionRule.extractProperties(varSet, billType, billTypes);
            }
        }
        if (this.getFrontEndConfig() != null) {
            this.getFrontEndConfig().extractProperties(varSet, billType, true);
        }
        if ((billMainType = EntityMetadataCache.getDataEntityType((String)billType)).getClass().isAssignableFrom(BillEntityType.class)) {
            varSet.add(((BillEntityType)billMainType).getBillNo());
        }
    }

    public Set<String> achieveLcTemplateFieldFromScript(String billType) {
        String[] billTypes = new String[]{billType};
        HashSet<String> lcTemplateFieldSet = new HashSet<String>(5);
        if (this.checkMethod == CheckMethodEnum.LC) {
            String templateStr = String.valueOf(this.getLcTemplateId());
            List<DecisionRule> ruleList = this.getRuleList();
            if (ruleList != null) {
                for (DecisionRule decisionRule : ruleList) {
                    decisionRule.extractProperties(lcTemplateFieldSet, IDIStringUtils.templatePrefixNoBillObj((String)templateStr), billTypes);
                }
            }
            if (this.getFrontEndConfig() != null) {
                this.getFrontEndConfig().extractProperties(lcTemplateFieldSet, billType, false);
            }
            HashSet<String> templateVarSet = new HashSet<String>(lcTemplateFieldSet.size());
            lcTemplateFieldSet.forEach(field -> {
                if (!"filename".equals(field)) {
                    templateVarSet.add((String)field);
                }
            });
            return templateVarSet;
        }
        return lcTemplateFieldSet;
    }

    public boolean isNeedShowAllEntryCheckTrue() {
        if (CollectionUtils.isEmpty(this.ruleList)) {
            return false;
        }
        for (DecisionRule rule : this.ruleList) {
            if (!rule.isShowAllEntryCheckTrue()) continue;
            return true;
        }
        return false;
    }

    public boolean isNeedShowAllCheckTrue() {
        if (CollectionUtils.isEmpty(this.ruleList)) {
            return false;
        }
        for (DecisionRule rule : this.ruleList) {
            if (!rule.isShowAllCheckTrue()) continue;
            return true;
        }
        return false;
    }

    public String achieveExistWords() {
        return this.mulExistWords != null ? this.mulExistWords.getLocaleValue() : this.existWords;
    }

    public String achieveNotExistWords() {
        return this.mulNotExistWords != null ? this.mulNotExistWords.getLocaleValue() : this.notExistWords;
    }

    public boolean validate() {
        CheckAttachmentTypeEnum checkType = this.getCheckType();
        boolean allEmpty = true;
        boolean pass = true;
        if ((CheckAttachmentTypeEnum.CHECKBILLCONTENT == checkType || CheckAttachmentTypeEnum.CHECKFILENAME == checkType) && CollectionUtils.isNotEmpty(this.getRuleList())) {
            for (DecisionRule decisionRule : this.getRuleList()) {
                if (StringUtils.isEmpty((String)decisionRule.achieveName()) || decisionRule.getRule() == null) {
                    if (StringUtils.isEmpty((String)decisionRule.achieveName()) && decisionRule.getRule() == null) continue;
                    allEmpty = false;
                    pass = false;
                    continue;
                }
                allEmpty = false;
            }
        } else {
            allEmpty = false;
        }
        if (allEmpty) {
            return false;
        }
        return pass;
    }
}

