/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.dataconverter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.AreaResult;
import kd.data.idi.data.BillControlTypeEnum;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.DecisionRule;
import kd.data.idi.data.InvoiceImageRuleResult;
import kd.data.idi.data.LinkUpBillResult;
import kd.data.idi.data.MatchType;
import kd.data.idi.data.Schema;
import kd.data.idi.data.SchemaResult;
import kd.data.idi.data.show.CardRowModel;
import kd.data.idi.data.show.ItemModel;
import kd.data.idi.data.show.TextItemModel;
import kd.data.idi.dataconverter.IDISchemaResultDataConvert;
import kd.data.idi.dataconverter.IDISchemaResultPCDataConvert;
import kd.data.idi.decision.openapi.ApiDecisionResultItem;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.util.IDIJSONUtils;

public class IDISchemaResultSSCDataConverter
extends IDISchemaResultDataConvert {
    private static final String SSC_ISPASS = "isPass";
    private static final String SSC_NOTDETECTEDITEM = "notDetectedItem";
    private static final String SSC_ALARMING = "alarming";
    private static final String SSC_NONE = "none";
    private static final String SSC_STATUS = "status";
    private static final String SSC_SCORE = "score";
    private static final String SSC_RESULT = "result";
    private static final String SSC_SHOWTEXT = "showText";
    private static final String SSC_PASS = "pass";
    private static final String SSC_NOPASS = "nopass";
    private static final String SSC_EXCEPTION = "exception";
    private static final String SSC_HEADDESC = "headDesc";
    private static final String SSC_AREANAME = "areaName";
    private static final String SSC_CONTROLSTATUS = "controlStatus";
    private boolean needAiAttachmentResult = false;

    public IDISchemaResultSSCDataConverter() {
    }

    public IDISchemaResultSSCDataConverter(boolean needAiAttachmentResult) {
        this.needAiAttachmentResult = needAiAttachmentResult;
    }

    public Map<String, Object> convertObject(SchemaResult dataSource, Schema rule) {
        List areaResults;
        String text;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put(SSC_ISPASS, Boolean.TRUE);
        ArrayList<String> notDetectedItems = new ArrayList<String>();
        result.put(SSC_NOTDETECTEDITEM, notDetectedItems);
        if ("success".equalsIgnoreCase(dataSource.getStatus())) {
            List areaResults2 = dataSource.getAreaResults();
            if (areaResults2 != null && !areaResults2.isEmpty()) {
                for (AreaResult areaResult : areaResults2) {
                    List decisionResults = areaResult.getDecisionResults();
                    if (decisionResults == null || decisionResults.isEmpty()) continue;
                    for (DecisionResult decisionResult : decisionResults) {
                        if (decisionResult == null) continue;
                        Decision decision = decisionResult.getDecision();
                        String matchType = decision.getMatchType();
                        if (MatchType.LINKUP_BILL.getType().equalsIgnoreCase(matchType)) {
                            notDetectedItems.addAll(this.handleLinkupBill(decisionResult, decisionResult.getLinkUpBillResults()));
                            continue;
                        }
                        if (MatchType.INVOICE.getType().equalsIgnoreCase(matchType)) {
                            notDetectedItems.addAll(this.handleInvoice(decisionResult));
                            continue;
                        }
                        if (MatchType.ALARM.getType().equalsIgnoreCase(matchType) || MatchType.KEYWORD.getType().equalsIgnoreCase(matchType)) {
                            String txt = this.handleAlarm(decisionResult);
                            if (!StringUtils.isNotEmpty((String)txt)) continue;
                            notDetectedItems.add(txt);
                            continue;
                        }
                        if (MatchType.ATTACHMENT.getType().equalsIgnoreCase(matchType)) {
                            notDetectedItems.addAll(this.handleAttachmentShowText(decisionResult));
                            continue;
                        }
                        if (MatchType.AIATTACHMENT.getType().equalsIgnoreCase(matchType) && this.needAiAttachmentResult) {
                            notDetectedItems.addAll(this.handleAttachmentShowText(decisionResult));
                            continue;
                        }
                        if (MatchType.containsType(matchType)) continue;
                        notDetectedItems.addAll(this.handleCustomDecision(decisionResult));
                    }
                }
            }
            if (!notDetectedItems.isEmpty()) {
                result.put(SSC_ISPASS, Boolean.FALSE);
            }
        } else {
            result.put(SSC_ISPASS, Boolean.FALSE);
            text = this.getErrorSchemaText(ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"IDISchemaResultPCDataConvert_0", (String)"data-idi-core", (Object[])new Object[0]), dataSource.getStatus());
            notDetectedItems.add(text);
        }
        result.put(SSC_STATUS, dataSource.getStatus());
        if (dataSource.getScore() >= 0) {
            result.put(SSC_SCORE, dataSource.getScore());
        }
        if ("success".equalsIgnoreCase(dataSource.getStatus())) {
            IDISchemaResultPCDataConvert pcCovert = new IDISchemaResultPCDataConvert();
            List<CardRowModel> list = pcCovert.createHeader(rule, dataSource);
            List<ItemModel> headItem = list.get(0).getMainDesc();
            if (headItem != null && !headItem.isEmpty()) {
                String headDesc = ((TextItemModel)headItem.get(headItem.size() - 1)).getContent();
                result.put(SSC_HEADDESC, headDesc);
            }
        } else {
            text = this.getErrorSchemaText(ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"IDISchemaResultPCDataConvert_0", (String)"data-idi-core", (Object[])new Object[0]), dataSource.getStatus());
            result.put(SSC_HEADDESC, text);
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
        result.put(SSC_RESULT, resultList);
        if ("success".equalsIgnoreCase(dataSource.getStatus()) && (areaResults = dataSource.getAreaResults()) != null && !areaResults.isEmpty()) {
            for (AreaResult areaResult : areaResults) {
                List decisionResults = areaResult.getDecisionResults();
                String areaName = areaResult.getArea().getTitle();
                if (decisionResults == null || decisionResults.isEmpty()) continue;
                for (DecisionResult decisionResult : decisionResults) {
                    if (decisionResult == null) continue;
                    Decision decision = decisionResult.getDecision();
                    String matchType = decision.getMatchType();
                    if (MatchType.LINKUP_BILL.getType().equalsIgnoreCase(matchType)) {
                        resultList.addAll(this.handleLinkupBillTwo(decisionResult, areaName));
                        continue;
                    }
                    if (MatchType.INVOICE.getType().equalsIgnoreCase(matchType)) {
                        resultList.addAll(this.handleInvoiceTwo(decisionResult, areaName));
                        continue;
                    }
                    if (MatchType.ALARM.getType().equalsIgnoreCase(matchType) || MatchType.KEYWORD.getType().equalsIgnoreCase(matchType)) {
                        resultList.add(this.handleAlarmTwo(decisionResult, areaName));
                        continue;
                    }
                    if (MatchType.ATTACHMENT.getType().equalsIgnoreCase(matchType)) {
                        resultList.addAll(this.handleAttachmentResultList(decisionResult, areaName));
                        continue;
                    }
                    if (MatchType.AIATTACHMENT.getType().equalsIgnoreCase(matchType) && this.needAiAttachmentResult) {
                        resultList.addAll(this.handleAttachmentResultList(decisionResult, areaName));
                        continue;
                    }
                    if (MatchType.containsType(matchType)) continue;
                    resultList.addAll(this.handleCustomDecisionTwo(decisionResult, areaName));
                }
            }
        }
        SchemaExecutorLogger.info((String)("ssc schema result :" + IDIJSONUtils.toJsonString(result)), (Object[])new Object[0]);
        return result;
    }

    private List<Map<String, Object>> handleCustomDecisionTwo(DecisionResult decisionResult, String areaName) {
        List<ApiDecisionResultItem> apiDecisionResultItemList = decisionResult.getApiDecisionResultItems();
        Decision decision = decisionResult.getDecision();
        BillControlTypeEnum billControl = decision == null ? null : decision.getBillControl();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(4);
        if (CollectionUtils.isNotEmpty(apiDecisionResultItemList)) {
            for (ApiDecisionResultItem apiDecisionResultItem : apiDecisionResultItemList) {
                if (apiDecisionResultItem == null) continue;
                HashMap<String, String> resultMap = new HashMap<String, String>(2);
                resultMap.put(SSC_STATUS, this.getStatus(apiDecisionResultItem.getStatus()));
                resultMap.put(SSC_SHOWTEXT, apiDecisionResultItem.getShowText());
                resultMap.put(SSC_AREANAME, areaName);
                resultMap.put(SSC_CONTROLSTATUS, billControl == null ? null : billControl.getType());
                result.add(resultMap);
            }
        }
        return result;
    }

    private List<String> handleCustomDecision(DecisionResult decisionResult) {
        List<ApiDecisionResultItem> apiDecisionResultItemList = decisionResult.getApiDecisionResultItems();
        ArrayList<String> result = new ArrayList<String>(4);
        if (CollectionUtils.isNotEmpty(apiDecisionResultItemList)) {
            for (ApiDecisionResultItem apiDecisionResultItem : apiDecisionResultItemList) {
                if (apiDecisionResultItem == null || !SSC_ALARMING.equals(apiDecisionResultItem.getStatus())) continue;
                result.add(apiDecisionResultItem.getShowText());
            }
        }
        return result;
    }

    private List<String> handleLinkupBill(DecisionResult decisionResult, List<LinkUpBillResult> linkUpBillResults) {
        ArrayList<String> result = new ArrayList<String>(4);
        if (SSC_NONE.equalsIgnoreCase(decisionResult.getStatus())) {
            result.add(decisionResult.getShowText());
        }
        if (CollectionUtils.isNotEmpty(linkUpBillResults)) {
            for (LinkUpBillResult linkUpBillResult : linkUpBillResults) {
                if (linkUpBillResult.isPass()) continue;
                result.add(linkUpBillResult.getShowText());
            }
        } else {
            Decision decision = decisionResult.getDecision();
            int matchRule = decisionResult.getMatchRule();
            if (matchRule > -1) {
                DecisionRule decisionRule = decision.getRules().get(matchRule);
                if (!decisionRule.isPass()) {
                    result.add(decisionRule.achieveName());
                }
            } else if (SSC_ALARMING.equalsIgnoreCase(decisionResult.getStatus())) {
                result.add(decisionResult.getShowText());
            }
        }
        return result;
    }

    private List<String> handleAttachmentShowText(DecisionResult decisionResult) {
        ArrayList<String> result = new ArrayList<String>(4);
        if (SSC_NONE.equalsIgnoreCase(decisionResult.getStatus())) {
            result.add(decisionResult.getShowText());
        }
        Decision decision = decisionResult.getDecision();
        List<LinkUpBillResult> attachmentResultList = decisionResult.getAttachmentResults();
        if (CollectionUtils.isNotEmpty(attachmentResultList)) {
            for (LinkUpBillResult attachmentResult : attachmentResultList) {
                if (attachmentResult.isPass()) continue;
                result.add(attachmentResult.getShowText());
            }
        } else {
            int matchRule = decisionResult.getMatchRule();
            if (matchRule > -1) {
                DecisionRule decisionRule = decision.getRules().get(matchRule);
                if (!decisionRule.isPass()) {
                    result.add(decisionRule.achieveName());
                }
            } else if (SSC_ALARMING.equalsIgnoreCase(decisionResult.getStatus())) {
                result.add(decisionResult.getShowText());
            }
        }
        return result;
    }

    private List<Map<String, Object>> handleAttachmentResultList(DecisionResult decisionResult, String areaName) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(4);
        Decision decision = decisionResult.getDecision();
        BillControlTypeEnum billControl = decision == null ? null : decision.getBillControl();
        List<LinkUpBillResult> attachmentResultList = decisionResult.getAttachmentResults();
        if (CollectionUtils.isNotEmpty(attachmentResultList)) {
            for (LinkUpBillResult attachmentResult : attachmentResultList) {
                HashMap<String, String> resultMap = new HashMap<String, String>(2);
                resultMap.put(SSC_STATUS, attachmentResult.isPass() ? SSC_PASS : SSC_NOPASS);
                resultMap.put(SSC_SHOWTEXT, attachmentResult.getShowText());
                resultMap.put(SSC_AREANAME, areaName);
                resultMap.put(SSC_CONTROLSTATUS, billControl == null ? null : billControl.getType());
                result.add(resultMap);
            }
        } else {
            int matchRule = decisionResult.getMatchRule();
            if (matchRule > -1) {
                DecisionRule decisionRule = decision != null ? decision.getRules().get(decisionResult.getMatchRule()) : null;
                HashMap<String, String> resultMap = new HashMap<String, String>(2);
                resultMap.put(SSC_STATUS, decisionRule != null && decisionRule.isPass() ? SSC_PASS : SSC_NOPASS);
                resultMap.put(SSC_SHOWTEXT, decisionRule != null ? decisionRule.achieveName() : "");
                resultMap.put(SSC_AREANAME, areaName);
                resultMap.put(SSC_CONTROLSTATUS, billControl == null ? null : billControl.getType());
                result.add(resultMap);
            } else {
                HashMap<String, String> resultMap = new HashMap<String, String>(2);
                resultMap.put(SSC_STATUS, this.getStatus(decisionResult.getStatus()));
                resultMap.put(SSC_SHOWTEXT, decisionResult.getShowText());
                resultMap.put(SSC_AREANAME, areaName);
                resultMap.put(SSC_CONTROLSTATUS, billControl == null ? null : billControl.getType());
                result.add(resultMap);
            }
        }
        return result;
    }

    private List<Map<String, Object>> handleLinkupBillTwo(DecisionResult decisionResult, String areaName) {
        BillControlTypeEnum billControl;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        List<LinkUpBillResult> linkUpBillResults = decisionResult.getLinkUpBillResults();
        Decision decision = decisionResult.getDecision();
        BillControlTypeEnum billControlTypeEnum = billControl = decision == null ? null : decision.getBillControl();
        if (CollectionUtils.isNotEmpty(linkUpBillResults)) {
            for (LinkUpBillResult linkUpBillResult : linkUpBillResults) {
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put(SSC_STATUS, linkUpBillResult.isPass() ? SSC_PASS : SSC_NOPASS);
                resultMap.put(SSC_SHOWTEXT, linkUpBillResult.getShowText());
                resultMap.put(SSC_AREANAME, areaName);
                resultMap.put(SSC_CONTROLSTATUS, billControl == null ? null : billControl.getType());
                result.add(resultMap);
            }
        } else {
            int matchRule = decisionResult.getMatchRule();
            if (matchRule > -1) {
                DecisionRule decisionRule = decision != null ? decision.getRules().get(decisionResult.getMatchRule()) : null;
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put(SSC_STATUS, decisionRule != null && decisionRule.isPass() ? SSC_PASS : SSC_NOPASS);
                resultMap.put(SSC_SHOWTEXT, decisionRule != null ? decisionRule.achieveName() : "");
                resultMap.put(SSC_AREANAME, areaName);
                resultMap.put(SSC_CONTROLSTATUS, billControl == null ? null : billControl.getType());
                result.add(resultMap);
            } else {
                result.add(this.handleDecisionTwo(decisionResult, areaName));
            }
        }
        return result;
    }

    String getStatus(String type) {
        switch (type) {
            case "nocontrolbillcontrolalarming": 
            case "alarming": {
                return SSC_NOPASS;
            }
            case "none": {
                return SSC_EXCEPTION;
            }
        }
        return SSC_PASS;
    }

    private List<String> handleInvoice(DecisionResult decisionResult) {
        List<InvoiceImageRuleResult> invoiceImageRuleResults;
        ArrayList<String> result = new ArrayList<String>();
        if (SSC_NONE.equalsIgnoreCase(decisionResult.getStatus()) || SSC_ALARMING.equalsIgnoreCase(decisionResult.getStatus())) {
            result.add(decisionResult.getShowText());
        }
        if ((invoiceImageRuleResults = decisionResult.getInvoiceImageRuleResults()) != null && !invoiceImageRuleResults.isEmpty()) {
            for (InvoiceImageRuleResult invoiceImageRuleResult : invoiceImageRuleResults) {
                if (invoiceImageRuleResult == null || !SSC_ALARMING.equalsIgnoreCase(invoiceImageRuleResult.getStatus())) continue;
                result.add(invoiceImageRuleResult.getText());
            }
        }
        return result;
    }

    private List<Map<String, Object>> handleInvoiceTwo(DecisionResult decisionResult, String areaName) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        Decision decision = decisionResult.getDecision();
        BillControlTypeEnum billControl = decision == null ? null : decision.getBillControl();
        List<InvoiceImageRuleResult> invoiceImageRuleResults = decisionResult.getInvoiceImageRuleResults();
        if (invoiceImageRuleResults != null && !invoiceImageRuleResults.isEmpty()) {
            for (InvoiceImageRuleResult invoiceImageRuleResult : invoiceImageRuleResults) {
                if (invoiceImageRuleResult == null) continue;
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put(SSC_STATUS, this.getStatus(invoiceImageRuleResult.getStatus()));
                resultMap.put(SSC_SHOWTEXT, invoiceImageRuleResult.getText());
                resultMap.put(SSC_AREANAME, areaName);
                resultMap.put(SSC_CONTROLSTATUS, billControl == null ? null : billControl.getType());
                result.add(resultMap);
            }
        } else {
            result.add(this.handleDecisionTwo(decisionResult, areaName));
        }
        return result;
    }

    private String handleAlarm(DecisionResult decisionResult) {
        if (decisionResult.getAlarmResult() != null && decisionResult.getAlarmResult().isOverLimit()) {
            return decisionResult.getShowText();
        }
        return this.handleDecision(decisionResult);
    }

    private Map<String, Object> handleAlarmTwo(DecisionResult decisionResult, String areaName) {
        if (decisionResult.getAlarmResult() != null && decisionResult.getAlarmResult().isOverLimit()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put(SSC_STATUS, SSC_NOPASS);
            resultMap.put(SSC_SHOWTEXT, decisionResult.getShowText());
            resultMap.put(SSC_AREANAME, areaName);
            Decision decision = decisionResult.getDecision();
            BillControlTypeEnum billControl = decision == null ? null : decision.getBillControl();
            resultMap.put(SSC_CONTROLSTATUS, billControl == null ? null : billControl.getType());
            return resultMap;
        }
        return this.handleDecisionTwo(decisionResult, areaName);
    }

    private String handleDecision(DecisionResult decisionResult) {
        String status = decisionResult.getStatus();
        if (SSC_ALARMING.equalsIgnoreCase(status) || SSC_NONE.equalsIgnoreCase(status) || "nocontrolbillcontrolalarming".equals(status)) {
            return decisionResult.getShowText();
        }
        return null;
    }

    private Map<String, Object> handleDecisionTwo(DecisionResult decisionResult, String areaName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(SSC_STATUS, this.getStatus(decisionResult.getStatus()));
        resultMap.put(SSC_SHOWTEXT, decisionResult.getShowText());
        resultMap.put(SSC_AREANAME, areaName);
        Decision decision = decisionResult.getDecision();
        BillControlTypeEnum billControl = decision == null ? null : decision.getBillControl();
        resultMap.put(SSC_CONTROLSTATUS, billControl == null ? null : billControl.getType());
        return resultMap;
    }
}

