/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.dataconverter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.AnalysisMode;
import kd.data.idi.data.Area;
import kd.data.idi.data.AreaResult;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.DecisionRule;
import kd.data.idi.data.GradeItem;
import kd.data.idi.data.InvoiceImageRuleResult;
import kd.data.idi.data.LinkUpBillResult;
import kd.data.idi.data.MatchType;
import kd.data.idi.data.Schema;
import kd.data.idi.data.SchemaResult;
import kd.data.idi.dataconverter.IDISchemaResultDataConvert;
import kd.data.idi.dataconverter.IDISchemaResultPCDataConvert;
import kd.data.idi.dataconverter.IDISchemaResultSSCDataConverter;
import kd.data.idi.decision.openapi.ApiDecisionResultItem;

public class IDISchemaResultStatisticDataConvert
extends IDISchemaResultDataConvert {
    private String statusType = "total";
    private boolean filterAI = false;
    private boolean needHeadPopover = false;

    public IDISchemaResultStatisticDataConvert() {
    }

    public IDISchemaResultStatisticDataConvert(String statusType, Boolean filterAI) {
        if (StringUtils.isNotEmpty((String)statusType)) {
            this.statusType = statusType;
        }
        if (filterAI != null) {
            this.filterAI = filterAI;
        }
    }

    public IDISchemaResultStatisticDataConvert(boolean needHeadPopover) {
        this.needHeadPopover = needHeadPopover;
    }

    public IDISchemaResultStatisticDataConvert(String statusType, Boolean filterAI, boolean needHeadPopover) {
        if (StringUtils.isNotEmpty((String)statusType)) {
            this.statusType = statusType;
        }
        if (filterAI != null) {
            this.filterAI = filterAI;
        }
        this.needHeadPopover = needHeadPopover;
    }

    public Map<String, Object> convertObject(SchemaResult result, Schema schema) {
        IDISchemaResultPCDataConvert pcDataConvert = new IDISchemaResultPCDataConvert(this.createStatusFilter(), this.filterAI);
        Map<String, Object> baseResultMap = pcDataConvert.convertObject(result, schema);
        String schemaResultStatus = result.getStatus();
        baseResultMap.put("statusDesc", result.getScore() < -1 ? ResManager.loadKDString((String)"\u6d1e\u5bdf\u7ed3\u679c\u52a0\u8f7d\u4e2d\u2026\u2026", (String)"IDISchemaResultPCDataConvert_18", (String)"data-idi-core", (Object[])new Object[0]) : this.getErrorSchemaText("", schemaResultStatus));
        Map<String, Object> statisticMap = this.statisticDecision(result, schema);
        baseResultMap.put("aiResult", statisticMap);
        Map<String, Object> aiAuditElementMap = this.aiAuditElement(result, schema);
        baseResultMap.put("aiAuditElement", aiAuditElementMap);
        Map<String, String> favts = this.createFavtsInfo();
        baseResultMap.put("favts", favts);
        return baseResultMap;
    }

    private Map<String, String> createFavtsInfo() {
        HashMap<String, String> favts = new HashMap<String, String>(2);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryFavtsInfo", (String)"idi_aiauditcustom", (String)"name,picture", null, null);){
            if (dataSet != null) {
                int rowCount = 0;
                for (Row row : dataSet) {
                    ++rowCount;
                    String image = row.getString("picture");
                    if (!image.startsWith("http")) {
                        image = UrlService.getImageFullUrl((String)image);
                    }
                    favts.put("image", image);
                    favts.put("name", row.getString("name") + "\uff1a");
                }
                if (rowCount > 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u4fdd\u5b58\u4e00\u6761\u6570\u636e\u3002", (String)"IDIAIAuditCustomSaveOrNewValidator_0", (String)"data-idi-opplugin", (Object[])new Object[0]));
                }
            }
        }
        if (favts.isEmpty()) {
            favts.put("constant", ResManager.loadKDString((String)"\u667a\u5ba1\u5efa\u8bae\uff1a", (String)"AISmartPanelPlugin_0", (String)"bos-ext-data", (Object[])new Object[0]));
        }
        return favts;
    }

    private Function<String, Boolean> createStatusFilter() {
        switch (this.statusType) {
            case "total": {
                return null;
            }
            case "green": {
                return new Function<String, Boolean>(){

                    @Override
                    public Boolean apply(String status) {
                        return "green".equalsIgnoreCase(status) || "normal".equalsIgnoreCase(status);
                    }
                };
            }
            case "alarm": {
                return new Function<String, Boolean>(){

                    @Override
                    public Boolean apply(String status) {
                        return "alarming".equalsIgnoreCase(status);
                    }
                };
            }
            case "warn": {
                return new Function<String, Boolean>(){

                    @Override
                    public Boolean apply(String status) {
                        return "warnning".equalsIgnoreCase(status);
                    }
                };
            }
            case "other": {
                return new Function<String, Boolean>(){

                    @Override
                    public Boolean apply(String status) {
                        return "none".equalsIgnoreCase(status);
                    }
                };
            }
        }
        return null;
    }

    private Map<String, Object> aiAuditElement(SchemaResult result, Schema schema) {
        HashMap<String, Object> aiAuditElementMap = new HashMap<String, Object>(2);
        if (schema == null || result.getScore() < -1) {
            return aiAuditElementMap;
        }
        String code = "0000";
        String msg = "";
        ResManager.loadKDString((String)"AI\u68c0\u67e5\u5f02\u5e38", (String)"SchemaExecutor_4", (String)"data-idi-core", (Object[])new Object[0]);
        if (CollectionUtils.isNotEmpty((Collection)result.getAreaResults())) {
            String aiExeException = ResManager.loadKDString((String)"AI\u68c0\u67e5\u5f02\u5e38", (String)"SchemaExecutor_4", (String)"data-idi-core", (Object[])new Object[0]);
            String fgptLicense = ResManager.loadKDString((String)"\u6ca1\u6709\u201cAI\u8d22\u52a1\u52a9\u624b\u201d\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AIAttachmentExecutor_0", (String)"data-idi-core", (Object[])new Object[0]);
            String aiLicense = ResManager.loadKDString((String)"\u6ca1\u6709\u201cAI\u5f00\u53d1\u5e73\u53f0\u201d\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AIAttachmentExecutor_1", (String)"data-idi-core", (Object[])new Object[0]);
            String aiException = ResManager.loadKDString((String)"AI\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AIAttachmentExecutor_3", (String)"data-idi-core", (Object[])new Object[0]);
            for (AreaResult areaResult : result.getAreaResults()) {
                List decisionResults = areaResult.getDecisionResults();
                if (!CollectionUtils.isNotEmpty((Collection)decisionResults)) continue;
                for (DecisionResult decisionResult : decisionResults) {
                    String status;
                    if (decisionResult == null || decisionResult.getDecision() == null) continue;
                    String matchType = decisionResult.getDecision().getMatchType();
                    String matchTypeMessage = decisionResult.getDecision().getName() + ":";
                    if (!MatchType.AIATTACHMENT.getType().equalsIgnoreCase(matchType) || !"none".equalsIgnoreCase(status = decisionResult.getStatus())) continue;
                    String showText = decisionResult.getShowText();
                    String aiExceptionMsg = matchTypeMessage + aiException;
                    String aiExeExceptionMsg = matchTypeMessage + aiExeException;
                    if (!StringUtils.isNotEmpty((String)showText)) continue;
                    if (fgptLicense.equals(showText)) {
                        code = "1001";
                        msg = showText;
                        continue;
                    }
                    if (aiLicense.equalsIgnoreCase(showText)) {
                        code = "1002";
                        msg = showText;
                        continue;
                    }
                    if (!aiExeExceptionMsg.equalsIgnoreCase(showText)) continue;
                    code = "2001";
                    msg = showText;
                }
            }
        }
        aiAuditElementMap.put("code", code);
        aiAuditElementMap.put("msg", msg);
        return aiAuditElementMap;
    }

    private Map<String, Object> statisticDecision(SchemaResult result, Schema schema) {
        HashMap<String, Object> aiResultMap = new HashMap<String, Object>(10);
        if (schema == null || result.getScore() < -1) {
            return aiResultMap;
        }
        Map<String, Object> smartMap = this.createSmart(result, schema);
        Map<String, Object> aiSmartMap = this.createAISmart(result, schema);
        aiResultMap.put("isPass", (Boolean)aiSmartMap.get("isPass") != false && (Boolean)smartMap.get("isPass") != false);
        String schemaAnalysisMode = schema.getAnalysisMode();
        if (AnalysisMode.SCORE.getType().equals(schemaAnalysisMode)) {
            String scoreMsg = String.format(ResManager.loadKDString((String)"%d\u5206", (String)"IDISchemaResultPCDataConvert_16", (String)"data-idi-core", (Object[])new Object[0]), result.getScore());
            List<GradeItem> gradeList = schema.getGrade();
            Object matchItem = null;
            GradeItem defaultMatchItem = null;
            if (gradeList != null) {
                for (GradeItem gradeItem : gradeList) {
                    if ("morethan".equalsIgnoreCase(gradeItem.getCondition())) {
                        if (!((float)result.getScore() >= gradeItem.getGrade())) continue;
                        matchItem = gradeItem;
                        break;
                    }
                    if (!"other".equalsIgnoreCase(gradeItem.getCondition()) || defaultMatchItem != null) continue;
                    defaultMatchItem = gradeItem;
                }
            }
            if (matchItem == null) {
                matchItem = defaultMatchItem;
            }
            scoreMsg = "<span style=\"color:" + ((GradeItem)matchItem).getShowColor() + ";font-size:14px\">" + scoreMsg + "</span>";
            if (matchItem != null) {
                scoreMsg = scoreMsg + "<span style=\"color:#333333;font-size:14px;margin-left:6px\">" + ((GradeItem)matchItem).getShowScript() + "</span>";
            }
            aiResultMap.put("headdesc", scoreMsg);
        } else {
            aiResultMap.put("headdesc", (Boolean)aiResultMap.get("isPass") != false ? ResManager.loadKDString((String)"\u901a\u8fc7", (String)"IDISchemaResultStatisticDataConvert_0", (String)"data-idi-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7", (String)"IDISchemaResultStatisticDataConvert_1", (String)"data-idi-core", (Object[])new Object[0]));
            if (this.needHeadPopover && this.hasAIAttachment(schema)) {
                HashMap<String, Map<String, Object>> headPopoverMap = new HashMap<String, Map<String, Object>>(3);
                headPopoverMap.put("smart", smartMap);
                headPopoverMap.put("aiSmart", aiSmartMap);
                aiResultMap.put("headPopover", headPopoverMap);
            }
        }
        HashMap<String, Object> statisticMap = new HashMap<String, Object>(10);
        aiResultMap.put("statistic", statisticMap);
        statisticMap.put("total", 0);
        statisticMap.put("totalAi", 0);
        statisticMap.put("totalHaveAi", false);
        statisticMap.put("green", 0);
        statisticMap.put("greenAi", 0);
        statisticMap.put("greenHaveAi", false);
        statisticMap.put("alarm", 0);
        statisticMap.put("alarmAi", 0);
        statisticMap.put("alarmHaveAi", false);
        statisticMap.put("warn", 0);
        statisticMap.put("warnAi", 0);
        statisticMap.put("warnHaveAi", false);
        statisticMap.put("other", 0);
        statisticMap.put("otherAIException", null);
        String aiException = ResManager.loadKDString((String)"AI\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AIAttachmentExecutor_3", (String)"data-idi-core", (Object[])new Object[0]);
        if (CollectionUtils.isNotEmpty((Collection)result.getAreaResults())) {
            for (AreaResult areaResult : result.getAreaResults()) {
                List decisionResults = areaResult.getDecisionResults();
                if (!CollectionUtils.isNotEmpty((Collection)decisionResults)) continue;
                for (DecisionResult decisionResult : decisionResults) {
                    String status;
                    Decision decision;
                    if (decisionResult == null || (decision = decisionResult.getDecision()) == null) continue;
                    String matchType = decision.getMatchType();
                    if (!MatchType.AIATTACHMENT.getType().equalsIgnoreCase(matchType) && !MatchType.ATTACHMENT.getType().equalsIgnoreCase(matchType) && !MatchType.LINKUP_BILL.getType().equalsIgnoreCase(matchType) && !MatchType.INVOICE.getType().equalsIgnoreCase(matchType) && !MatchType.ALARM.getType().equalsIgnoreCase(matchType) && !MatchType.KEYWORD.getType().equalsIgnoreCase(matchType) && MatchType.containsType(matchType)) continue;
                    if (CollectionUtils.isNotEmpty(decisionResult.getLinkUpBillResults())) {
                        List<LinkUpBillResult> linkUpBillResults = decisionResult.getLinkUpBillResults();
                        for (LinkUpBillResult linkUpBillResult : linkUpBillResults) {
                            if (linkUpBillResult == null) continue;
                            status = linkUpBillResult.getStatus();
                            this.statistic(status, false, statisticMap);
                        }
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty(decisionResult.getApiDecisionResultItems())) {
                        List<ApiDecisionResultItem> apiDecisionResultItemList = decisionResult.getApiDecisionResultItems();
                        for (ApiDecisionResultItem apiDecisionResultItem : apiDecisionResultItemList) {
                            if (apiDecisionResultItem == null) continue;
                            status = apiDecisionResultItem.getStatus();
                            this.statistic(status, false, statisticMap);
                        }
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty(decisionResult.getInvoiceImageRuleResults())) {
                        List<InvoiceImageRuleResult> invoiceImageRuleResults = decisionResult.getInvoiceImageRuleResults();
                        for (InvoiceImageRuleResult invoiceImageRuleResult : invoiceImageRuleResults) {
                            if (invoiceImageRuleResult == null) continue;
                            status = invoiceImageRuleResult.getStatus();
                            this.statistic(status, false, statisticMap);
                        }
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty(decisionResult.getAttachmentResults())) {
                        List<LinkUpBillResult> attachmentResults = decisionResult.getAttachmentResults();
                        for (LinkUpBillResult attachmentResult : attachmentResults) {
                            if (attachmentResult == null) continue;
                            status = attachmentResult.getStatus();
                            this.statistic(status, attachmentResult.isAiParticipation(), statisticMap);
                        }
                        continue;
                    }
                    String status2 = decisionResult.getStatus();
                    this.statistic(status2, decisionResult.isAiParticipation(), statisticMap);
                    if (!"none".equals(status2)) continue;
                    String showText = decisionResult.getShowText();
                    String matchTypeMessage = decisionResult.getDecision().getName() + ":";
                    String errorMsg = matchTypeMessage + aiException;
                    if (!errorMsg.equals(showText)) continue;
                    statisticMap.put("otherAIException", ResManager.loadKDString((String)"\u672c\u5355\u9644\u4ef6\u5b58\u5728AI\u89e3\u6790\u5f02\u5e38\uff0c\u53ef\u80fd\u5f71\u54cd\u9644\u4ef6\u5ba1\u6838\u7ed3\u679c\u51c6\u786e\u6027\u3002", (String)"IDISchemaResultStatisticDataConvert_4", (String)"data-idi-core", (Object[])new Object[0]));
                }
            }
        }
        int total = (Integer)statisticMap.get("total");
        boolean totalHaveAi = (Boolean)statisticMap.get("totalHaveAi");
        int totalAi = (Integer)statisticMap.get("totalAi");
        if (total > 0) {
            String string = totalHaveAi ? String.format(ResManager.loadKDString((String)"\u52fe\u9009\u67e5\u770b%1$d\u9879\u4e2d\u7531AI\u53c2\u4e0e\u7684%2$d\u9879\uff0c\u8bf7\u7ed3\u5408\u7ecf\u9a8c\u4f7f\u7528\u3002", (String)"IDISchemaResultStatisticDataConvert_2", (String)"data-idi-core", (Object[])new Object[0]), total, totalAi) : ResManager.loadKDString((String)"\u8be5\u7c7b\u578b\u4e0b\u6682\u65e0\u76f8\u5173AI\u53c2\u4e0e\u68c0\u67e5\u9879\u3002", (String)"IDISchemaResultStatisticDataConvert_3", (String)"data-idi-core", (Object[])new Object[0]);
            statisticMap.put("totalHaveAiDesc", string);
        }
        int n = (Integer)statisticMap.get("green");
        int greenAi = (Integer)statisticMap.get("greenAi");
        boolean greenHaveAi = (Boolean)statisticMap.get("greenHaveAi");
        if (n > 0) {
            String greenHaveAiDesc = greenHaveAi ? String.format(ResManager.loadKDString((String)"\u52fe\u9009\u67e5\u770b%1$d\u9879\u4e2d\u7531AI\u53c2\u4e0e\u7684%2$d\u9879\uff0c\u8bf7\u7ed3\u5408\u7ecf\u9a8c\u4f7f\u7528\u3002", (String)"IDISchemaResultStatisticDataConvert_2", (String)"data-idi-core", (Object[])new Object[0]), n, greenAi) : ResManager.loadKDString((String)"\u8be5\u7c7b\u578b\u4e0b\u6682\u65e0\u76f8\u5173AI\u53c2\u4e0e\u68c0\u67e5\u9879\u3002", (String)"IDISchemaResultStatisticDataConvert_3", (String)"data-idi-core", (Object[])new Object[0]);
            statisticMap.put("greenHaveAiDesc", greenHaveAiDesc);
        }
        int alarm = (Integer)statisticMap.get("alarm");
        int alarmAi = (Integer)statisticMap.get("alarmAi");
        boolean alarmHaveAi = (Boolean)statisticMap.get("alarmHaveAi");
        if (alarm > 0) {
            String alarmHaveAiDesc = alarmHaveAi ? String.format(ResManager.loadKDString((String)"\u52fe\u9009\u67e5\u770b%1$d\u9879\u4e2d\u7531AI\u53c2\u4e0e\u7684%2$d\u9879\uff0c\u8bf7\u7ed3\u5408\u7ecf\u9a8c\u4f7f\u7528\u3002", (String)"IDISchemaResultStatisticDataConvert_2", (String)"data-idi-core", (Object[])new Object[0]), alarm, alarmAi) : ResManager.loadKDString((String)"\u8be5\u7c7b\u578b\u4e0b\u6682\u65e0\u76f8\u5173AI\u53c2\u4e0e\u68c0\u67e5\u9879\u3002", (String)"IDISchemaResultStatisticDataConvert_3", (String)"data-idi-core", (Object[])new Object[0]);
            statisticMap.put("alarmHaveAiDesc", alarmHaveAiDesc);
        }
        int warn = (Integer)statisticMap.get("warn");
        int warnAi = (Integer)statisticMap.get("warnAi");
        boolean warnHaveAi = (Boolean)statisticMap.get("warnHaveAi");
        if (warn > 0) {
            String warnHaveAiDesc = warnHaveAi ? String.format(ResManager.loadKDString((String)"\u52fe\u9009\u67e5\u770b%1$d\u9879\u4e2d\u7531AI\u53c2\u4e0e\u7684%2$d\u9879\uff0c\u8bf7\u7ed3\u5408\u7ecf\u9a8c\u4f7f\u7528\u3002", (String)"IDISchemaResultStatisticDataConvert_2", (String)"data-idi-core", (Object[])new Object[0]), warn, warnAi) : ResManager.loadKDString((String)"\u8be5\u7c7b\u578b\u4e0b\u6682\u65e0\u76f8\u5173AI\u53c2\u4e0e\u68c0\u67e5\u9879\u3002", (String)"IDISchemaResultStatisticDataConvert_3", (String)"data-idi-core", (Object[])new Object[0]);
            statisticMap.put("warnHaveAiDesc", warnHaveAiDesc);
        }
        return aiResultMap;
    }

    private boolean hasAIAttachment(Schema schsema) {
        List<Area> areaList;
        boolean hasAIAttachment = false;
        if (schsema != null && CollectionUtils.isNotEmpty(areaList = schsema.getArea())) {
            block0: for (Area area : areaList) {
                if (area == null || !CollectionUtils.isNotEmpty(area.getDecision())) continue;
                for (Decision decision : area.getDecision()) {
                    if (decision == null || !MatchType.AIATTACHMENT.getType().equalsIgnoreCase(decision.getMatchType()) || !decision.isEnabled()) continue;
                    hasAIAttachment = true;
                    continue block0;
                }
            }
        }
        return hasAIAttachment;
    }

    private Map<String, Object> createAISmart(SchemaResult result, Schema schsema) {
        HashMap<String, Object> aiSmartMap = new HashMap<String, Object>();
        aiSmartMap.put("isPass", Boolean.TRUE);
        if ("success".equalsIgnoreCase(result.getStatus())) {
            ArrayList<String> notDetectedItems = new ArrayList<String>();
            List areaResults = result.getAreaResults();
            if (areaResults != null && !areaResults.isEmpty()) {
                for (AreaResult areaResult : areaResults) {
                    List decisionResults = areaResult.getDecisionResults();
                    if (decisionResults == null || decisionResults.isEmpty()) continue;
                    for (DecisionResult decisionResult : decisionResults) {
                        List<LinkUpBillResult> attachmentResultList;
                        if (decisionResult == null) continue;
                        Decision decision = decisionResult.getDecision();
                        String matchType = decision.getMatchType();
                        if (!MatchType.AIATTACHMENT.getType().equalsIgnoreCase(matchType)) continue;
                        if ("none".equalsIgnoreCase(decisionResult.getStatus())) {
                            notDetectedItems.add(decisionResult.getShowText());
                        }
                        if (CollectionUtils.isNotEmpty(attachmentResultList = decisionResult.getAttachmentResults())) {
                            for (LinkUpBillResult attachmentResult : attachmentResultList) {
                                if (attachmentResult.isPass()) continue;
                                notDetectedItems.add(attachmentResult.getShowText());
                            }
                            continue;
                        }
                        int matchRule = decisionResult.getMatchRule();
                        if (matchRule > -1) {
                            DecisionRule decisionRule = decision.getRules().get(matchRule);
                            if (decisionRule.isPass()) continue;
                            notDetectedItems.add(decisionRule.achieveName());
                            continue;
                        }
                        if (!"alarming".equalsIgnoreCase(decisionResult.getStatus())) continue;
                        notDetectedItems.add(decisionResult.getShowText());
                    }
                }
            }
            if (!notDetectedItems.isEmpty()) {
                aiSmartMap.put("isPass", Boolean.FALSE);
            }
        } else {
            aiSmartMap.put("isPass", Boolean.FALSE);
        }
        String msg = ResManager.loadKDString((String)"AI\u9644\u4ef6\u5ba1\u6838\u7ed3\u679c\uff1a%s\uff08\u8f85\u52a9\u5ba1\u6838\u9644\u4ef6\uff09", (String)"IDISchemaResultStatisticDataConvert_6", (String)"data-idi-core", (Object[])new Object[0]);
        String passMsg = (Boolean)aiSmartMap.get("isPass") != false ? ResManager.loadKDString((String)"\u901a\u8fc7", (String)"IDISchemaResultStatisticDataConvert_0", (String)"data-idi-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7", (String)"IDISchemaResultStatisticDataConvert_1", (String)"data-idi-core", (Object[])new Object[0]);
        aiSmartMap.put("desc", String.format(msg, passMsg));
        return aiSmartMap;
    }

    private Map<String, Object> createSmart(SchemaResult result, Schema schema) {
        IDISchemaResultSSCDataConverter sscDataConverter = new IDISchemaResultSSCDataConverter();
        Map<String, Object> sscResultMap = sscDataConverter.convertObject(result, schema);
        HashMap<String, Object> smartMap = new HashMap<String, Object>();
        smartMap.put("isPass", sscResultMap.get("isPass"));
        String msg = ResManager.loadKDString((String)"\u667a\u80fd\u6570\u636e\u6d1e\u5bdf\u7ed3\u679c\uff1a%s\uff08\u53ef\u7528\u4e8e\u5171\u4eab\u667a\u80fd\u514d\u5ba1\uff09", (String)"IDISchemaResultStatisticDataConvert_5", (String)"data-idi-core", (Object[])new Object[0]);
        String passMsg = (Boolean)sscResultMap.get("isPass") != false ? ResManager.loadKDString((String)"\u901a\u8fc7", (String)"IDISchemaResultStatisticDataConvert_0", (String)"data-idi-core", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7", (String)"IDISchemaResultStatisticDataConvert_1", (String)"data-idi-core", (Object[])new Object[0]);
        smartMap.put("desc", String.format(msg, passMsg));
        return smartMap;
    }

    private void statistic(String status, boolean aiParticipation, Map<String, Object> statisticMap) {
        int total = (Integer)statisticMap.get("total");
        int totalAi = (Integer)statisticMap.get("totalAi");
        boolean totalHaveAi = (Boolean)statisticMap.get("totalHaveAi");
        int green = (Integer)statisticMap.get("green");
        int greenAi = (Integer)statisticMap.get("greenAi");
        boolean greenHaveAi = (Boolean)statisticMap.get("greenHaveAi");
        int alarm = (Integer)statisticMap.get("alarm");
        int alarmAi = (Integer)statisticMap.get("alarmAi");
        boolean alarmHaveAi = (Boolean)statisticMap.get("alarmHaveAi");
        int warn = (Integer)statisticMap.get("warn");
        int warnAi = (Integer)statisticMap.get("warnAi");
        boolean warnHaveAi = (Boolean)statisticMap.get("warnHaveAi");
        int other = (Integer)statisticMap.get("other");
        ++total;
        boolean currentHaveAi = aiParticipation;
        switch (status) {
            case "normal": 
            case "green": {
                ++green;
                if (!aiParticipation) break;
                greenHaveAi = true;
                ++greenAi;
                break;
            }
            case "warnning": {
                ++warn;
                if (!aiParticipation) break;
                warnHaveAi = true;
                ++warnAi;
                break;
            }
            case "alarming": {
                ++alarm;
                if (!aiParticipation) break;
                alarmHaveAi = true;
                ++alarmAi;
                break;
            }
            case "none": {
                ++other;
                currentHaveAi = false;
            }
        }
        if (currentHaveAi) {
            totalHaveAi = true;
            ++totalAi;
        }
        statisticMap.put("total", total);
        statisticMap.put("totalAi", totalAi);
        statisticMap.put("totalHaveAi", totalHaveAi);
        statisticMap.put("green", green);
        statisticMap.put("greenAi", greenAi);
        statisticMap.put("greenHaveAi", greenHaveAi);
        statisticMap.put("alarm", alarm);
        statisticMap.put("alarmAi", alarmAi);
        statisticMap.put("alarmHaveAi", alarmHaveAi);
        statisticMap.put("warn", warn);
        statisticMap.put("warnAi", warnAi);
        statisticMap.put("warnHaveAi", warnHaveAi);
        statisticMap.put("other", other);
    }
}

