/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.decision.executor;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.ext.data.idi.sdk.IExtDecisionPlugin;
import kd.data.idi.data.Decision;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.decision.executor.AbstractExtDecisionExecutor;
import kd.data.idi.decision.model.ExtDecisionInfo;
import kd.data.idi.engine.SchemaExecutorLogger;

public class PluginDecisionExecutor
extends AbstractExtDecisionExecutor {
    public PluginDecisionExecutor(ExtDecisionInfo extDecisionInfo) {
        super(extDecisionInfo);
    }

    protected String executeDecision(SchemaContext context, Decision decision, ExtDecisionInfo extDecisionInfo) {
        String srcEntityNum = context.getEntityType();
        DynamicObject srcBillObj = context.getSelfBill();
        return this.invokePlugin(srcEntityNum, srcBillObj, decision, extDecisionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String invokePlugin(String srcEntityNum, DynamicObject srcBillObj, Decision decision, ExtDecisionInfo extDecisionInfo) {
        IExtDecisionPlugin extDecisionPlugin = null;
        try {
            Class<?> cls = Class.forName(extDecisionInfo.getPluginClass());
            extDecisionPlugin = (IExtDecisionPlugin)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            SchemaExecutorLogger.error((String)"init plugin decision error", (Throwable)e);
            String errorMessage = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u63d2\u4ef6\u68c0\u67e5\u9879\u8c03\u7528\u5f02\u5e38\u3002", (String)"PluginDecisionExecutor_0", (String)"data-idi-core", (Object[])new Object[0]);
            throw new KDBizException(errorMessage);
        }
        String decisionResult = null;
        long start = System.currentTimeMillis();
        try {
            SchemaExecutorLogger.info((String)"invoke plugin decision start. pluginClass:%s", (Object[])new Object[]{extDecisionInfo.getPluginClass()});
            Map paramMap = this.buildServiceParams(extDecisionInfo);
            decisionResult = extDecisionPlugin.execute(srcEntityNum, srcBillObj.getPkValue(), decision.getName(), paramMap);
            SchemaExecutorLogger.info((String)"invoke plugin decision result: %s", (Object[])new Object[]{decisionResult});
        }
        catch (Exception e) {
            try {
                SchemaExecutorLogger.error((String)"invoke plugin decision error.", (Throwable)e);
            }
            catch (Throwable throwable) {
                long end = System.currentTimeMillis();
                SchemaExecutorLogger.info((String)"invoke plugin decision end, cost time %dms.", (Object[])new Object[]{end - start});
                throw throwable;
            }
            long end = System.currentTimeMillis();
            SchemaExecutorLogger.info((String)"invoke plugin decision end, cost time %dms.", (Object[])new Object[]{end - start});
        }
        long end = System.currentTimeMillis();
        SchemaExecutorLogger.info((String)"invoke plugin decision end, cost time %dms.", (Object[])new Object[]{end - start});
        return decisionResult;
    }
}

