/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.data.idi.model.BaseHighLight;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionFrontEndConfig;
import kd.data.idi.data.DecisionFrontEndConfigField;
import kd.data.idi.data.DecisionFrontEndResult;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.DecisionRule;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.LinkUpBillResult;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.data.attachment.AIAttachmentConfig;
import kd.data.idi.data.attachment.CheckAttachmentTypeEnum;
import kd.data.idi.data.attachment.CheckMethodEnum;
import kd.data.idi.data.attachment.ExceptionTip;
import kd.data.idi.data.attachment.ExceptionTipEnum;
import kd.data.idi.data.attachment.GptRiskTip;
import kd.data.idi.data.attachment.RuleRepo;
import kd.data.idi.data.basedata.CreateOrgBaseDataConfig;
import kd.data.idi.data.basedata.StandardBaseDataConfig;
import kd.data.idi.decision.openapi.ApiDecisionResultItem;
import kd.data.idi.engine.DeductionGrade;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.ParamFactory;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.ScriptFormIdHandler;
import kd.data.idi.engine.ScriptLocaleFieldHandler;
import kd.data.idi.engine.ScriptUtils;
import kd.data.idi.engine.SelfBillDecisionExecutor;
import kd.data.idi.engine.attachment.AIParam;
import kd.data.idi.engine.attachment.AIRecognizerParam;
import kd.data.idi.engine.attachment.AIRecognizerResult;
import kd.data.idi.engine.attachment.AIRecognizerSuccessInfo;
import kd.data.idi.engine.attachment.AITemplate;
import kd.data.idi.engine.attachment.Attachment;
import kd.data.idi.engine.attachment.AttachmentField;
import kd.data.idi.engine.attachment.AttachmentServiceFactory;
import kd.data.idi.engine.attachment.IAttachmentService;
import kd.data.idi.engine.front.NumberIdMapping;
import kd.data.idi.exception.AITipException;
import kd.data.idi.util.HighLightBuilder;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.IDIStringUtils;

public class AIAttachmentExecutor
extends SelfBillDecisionExecutor {
    private DeductionGrade deductionGrade = null;
    private static final int MAX_SRC_ENTRY_SIZE = 2000;
    private static final int MAX_EXCEPTION_SIZE = 100;

    @Override
    public DecisionResult execute(SchemaContext context, Decision decision) {
        AIAttachmentConfig aiAttachmentConfig = decision.getAiAttachmentConfig();
        if (aiAttachmentConfig == null) {
            return null;
        }
        if (null == context.getSelfBill()) {
            return null;
        }
        MainEntityType srcEntityType = context.getSrcEntityType();
        this.deductionGrade = new DeductionGrade(context);
        DecisionResult decisionResult = new DecisionResult();
        decisionResult.setDecision(decision);
        DynamicObject billObj = ExecutorHelper.getSelfBill(context);
        HashMap<String, Object> ctx = new HashMap<String, Object>(1);
        ctx.put(context.getEntityType() + "_billObj", billObj);
        String startConditionEntry = null;
        ArrayList<Integer> matchStartConditionEntryIndexList = new ArrayList<Integer>(1);
        IDICondition startCondition = aiAttachmentConfig.getStartCondition();
        if (startCondition != null && StringUtils.isNotEmpty((String)startCondition.getScript())) {
            Set<String> propSet = ScriptUtils.getEntries(srcEntityType, startCondition.getScript(), new String[]{context.getEntityType()});
            if (propSet.size() > 1) {
                throw new AITipException(ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6\u4e0d\u652f\u6301\u8de8\u6e90\u5355\u7684\u591a\u4e2a\u5206\u5f55\u3002", (String)"LinkUpBillDecisionExecutor_12", (String)"data-idi-core", (Object[])new Object[0]));
            }
            DynamicObjectType dynamicObjectType = billObj.getDynamicObjectType();
            if (propSet.size() == 1) {
                startConditionEntry = propSet.iterator().next();
                if (!this.canStart(aiAttachmentConfig, ctx, dynamicObjectType, matchStartConditionEntryIndexList, startConditionEntry)) {
                    return this.notMatchStartCondition(aiAttachmentConfig, decisionResult);
                }
                SchemaExecutorLogger.info((String)"idi startCondition sourceEntry : %s, match entry index : %s", (Object[])new Object[]{startConditionEntry, IDIJSONUtils.toJsonString(matchStartConditionEntryIndexList)});
            } else if (!this.canStart(aiAttachmentConfig, ctx, dynamicObjectType, matchStartConditionEntryIndexList, null)) {
                return this.notMatchStartCondition(aiAttachmentConfig, decisionResult);
            }
        }
        CheckAttachmentTypeEnum checkType = aiAttachmentConfig.getCheckType();
        IAttachmentService attachmentService = AttachmentServiceFactory.getServiceInstance(CheckMethodEnum.FGPTAS);
        List<Attachment> attachmentList = this.queryAttachmentInfo(context, attachmentService);
        NumberIdMapping numberIdMapping = NumberIdMapping.createMapping(aiAttachmentConfig.getFgptasTemplate(), "fgptas_attachtemplate");
        switch (checkType) {
            case CHECKEXISTS: {
                this.checkExists(attachmentList, attachmentService, decisionResult, aiAttachmentConfig, context.getEntityType(), context.getSelfBill(), srcEntityType, context.isNeedHighLight(), numberIdMapping);
                break;
            }
            case CHECKBILLCONTENT: {
                this.checkContent(attachmentList, attachmentService, decisionResult, context.getEntityType(), aiAttachmentConfig, startConditionEntry, matchStartConditionEntryIndexList, srcEntityType, context.getSelfBill(), context.isNeedHighLight(), context.isNeedRefreshAiResult(), numberIdMapping, context.getSchema().getId(), decision.getPk());
                break;
            }
            case CHECKFILENAME: {
                this.checkFileName(attachmentList, decisionResult, aiAttachmentConfig, srcEntityType, context.getSelfBill(), context.isNeedHighLight(), numberIdMapping);
                break;
            }
            default: {
                throw new AITipException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u68c0\u67e5\u7c7b\u578b\u6216\u68c0\u67e5\u7c7b\u578b\u4e3a\u7a7a", (String)"AttachmentExecutor_0", (String)"data-idi-core", (Object[])new Object[0]));
            }
        }
        decisionResult.setDeductPercent(this.deductionGrade.getValue());
        SchemaExecutorLogger.info((String)String.format("AttachmentExecutor decisionResult : %s", IDIJSONUtils.toJsonString((Object)decisionResult)), (Object[])new Object[0]);
        return decisionResult;
    }

    private void checkContent(List<Attachment> attachmentList, IAttachmentService attachmentService, DecisionResult decisionResult, String entityType, AIAttachmentConfig aiAttachmentConfig, String startConditionEntry, List<Integer> matchStartConditionEntryIndexList, MainEntityType srcEntityType, DynamicObject billObj, boolean needHighLight, boolean aiRefresh, NumberIdMapping numberIdMapping, long schemaId, String decisionPK) {
        SchemaExecutorLogger.info((String)String.format("[DATA-IDI] AttachmentExecutor attachmentList:%s", IDIJSONUtils.toJsonString(attachmentList)), (Object[])new Object[0]);
        if (attachmentList == null || attachmentList.isEmpty()) {
            this.noExistsAttachmentException(aiAttachmentConfig, decisionResult);
        } else {
            Map<Object, String> idToNumberMap = numberIdMapping.getNewIdToNumberMap();
            if (idToNumberMap == null || idToNumberMap.isEmpty()) {
                SchemaExecutorLogger.error((String)String.format("[DATA-IDI] AIAttachmentExecutor - start to recognizer attacchment, class is :%s", attachmentService.getClass()));
                throw new AITipException(ResManager.loadKDString((String)"\u9644\u4ef6\u6a21\u677f\u4e3a\u7a7a\u6216\u88ab\u5220\u9664", (String)"AIAttachmentExecutor_4", (String)"data-idi-core", (Object[])new Object[0]));
            }
            StandardBaseDataConfig[] fgptasTemplates = this.createNewTemplates(numberIdMapping.getNewIdToNumberMap());
            AIRecognizerParam param = new AIRecognizerParam(aiAttachmentConfig.getCheckMethod(), null, null, null, null, null, null, null, entityType, null, null, null, null, null);
            param.setFgptasTemplates(fgptasTemplates);
            param.setBillId(billObj.get("id"));
            AIRecognizerResult recognizerResult = (AIRecognizerResult)attachmentService.recognizer(param);
            if ("FAILED".equals(recognizerResult.getErrorCode())) {
                SchemaExecutorLogger.info((String)("[DATA-IDI] AIAttachmentExecutor - recognizer failed. result :" + IDIJSONUtils.toJsonString((Object)recognizerResult)), (Object[])new Object[0]);
                throw new AITipException(recognizerResult.getDescription());
            }
            List successInfoList = recognizerResult.getDetailDatas();
            List errorInfoList = recognizerResult.getErrorInfos();
            SchemaExecutorLogger.info((String)String.format("[DATA-IDI] AttachmentExecutor successInfoList:%s", IDIJSONUtils.toJsonString((Object)successInfoList)), (Object[])new Object[0]);
            SchemaExecutorLogger.info((String)String.format("[DATA-IDI] AttachmentExecutor errorInfoList:%s", IDIJSONUtils.toJsonString((Object)errorInfoList)), (Object[])new Object[0]);
            if (CollectionUtils.isEmpty((Collection)successInfoList) && CollectionUtils.isEmpty((Collection)errorInfoList)) {
                this.noExistsAttachmentException(aiAttachmentConfig, decisionResult);
                return;
            }
            boolean aiParticipation = false;
            if (CollectionUtils.isNotEmpty((Collection)successInfoList)) {
                aiParticipation = successInfoList.stream().filter(sinfo -> sinfo.isAiParticipation()).findAny().isPresent();
            }
            if (CollectionUtils.isNotEmpty((Collection)errorInfoList)) {
                aiParticipation = aiParticipation || errorInfoList.stream().filter(einfo -> einfo.isAiParticipation()).findAny().isPresent();
            }
            AIParam fieldQueryParam = new AIParam(aiAttachmentConfig.getCheckMethod(), null, null, null, null, null, null, null, entityType);
            fieldQueryParam.setFgptasTemplates(fgptasTemplates);
            List fieldList = attachmentService.queryTemplateField(fieldQueryParam);
            if (aiAttachmentConfig.isEnableRuleBase()) {
                this.executeRuleRepo(decisionResult, aiAttachmentConfig, billObj, entityType, srcEntityType, aiRefresh, schemaId, decisionPK, successInfoList, fieldList, numberIdMapping, aiParticipation);
                return;
            }
            String script = this.buildScript(aiAttachmentConfig.getRuleList());
            String entryName = this.validateMoreEntry(script, srcEntityType, ResManager.loadKDString((String)"\u68c0\u67e5\u89c4\u5219\u4e0d\u652f\u6301\u8de8\u6e90\u5355\u7684\u591a\u4e2a\u5206\u5f55\u3002", (String)"AttachmentExecutor_1", (String)"data-idi-core", (Object[])new Object[0]));
            if (entryName == null && CollectionUtils.isEmpty(aiAttachmentConfig.getGptRiskTipList())) {
                throw new AITipException(ResManager.loadKDString((String)"AI\u68c0\u67e5\u9644\u4ef6\u5185\u5bb9\u68c0\u67e5\u672a\u914d\u7f6e\u68c0\u67e5\u89c4\u5219\u3002", (String)"AIAttachmentExecutor_2", (String)"data-idi-core", (Object[])new Object[0]));
            }
            ArrayList<String> templateNumberList = new ArrayList<String>(idToNumberMap.values());
            Map<String, String> templateTableMap = this.validateMoreTable(script, templateNumberList, entityType);
            Set<String> panelKeySet = attachmentList.stream().map(Attachment::getAttachmentPanelName).filter(panelName -> StringUtils.isNotEmpty((String)panelName)).collect(Collectors.toSet());
            String[] panelKeys = panelKeySet.toArray(new String[0]);
            if (entryName != null && CollectionUtils.isEmpty((Collection)errorInfoList) && CollectionUtils.isNotEmpty((Collection)successInfoList) && CollectionUtils.isNotEmpty(aiAttachmentConfig.getRuleList())) {
                ArrayList<LinkUpBillResult> allResultList = new ArrayList<LinkUpBillResult>(10);
                BigDecimal percent = this.calPercent(successInfoList.size(), billObj, entryName, startConditionEntry, matchStartConditionEntryIndexList, 0);
                ArrayList<LinkUpBillResult> relationResultList = new ArrayList<LinkUpBillResult>(successInfoList.size());
                HashMap<LinkUpBillResult, Integer> entryIndexMap = new HashMap<LinkUpBillResult, Integer>(10);
                HashMap<LinkUpBillResult, List<Integer>> reduceEntryIndexMap = new HashMap<LinkUpBillResult, List<Integer>>(5);
                if (this.isHead(entryName)) {
                    for (AIRecognizerSuccessInfo aiRecognizerSuccessInfo : successInfoList) {
                        this.executeRule(script, entryName, percent, aiRecognizerSuccessInfo, billObj, -1, fieldList, srcEntityType, aiAttachmentConfig, relationResultList, templateTableMap, entryIndexMap, numberIdMapping);
                    }
                } else {
                    int entryRowCount = billObj.getDynamicObjectCollection(entryName).size();
                    List<Integer> indexList = entryName.equals(startConditionEntry) ? matchStartConditionEntryIndexList : null;
                    int loopCount = Math.min(entryRowCount, 2000);
                    for (int index = 0; index < loopCount; ++index) {
                        int srcIndex = index;
                        if (CollectionUtils.isNotEmpty(indexList)) {
                            if (index >= indexList.size()) break;
                            srcIndex = indexList.get(index);
                        }
                        ArrayList<LinkUpBillResult> entryGroupResultList = new ArrayList<LinkUpBillResult>(entryRowCount);
                        for (AIRecognizerSuccessInfo aiRecognizerSuccessInfo : successInfoList) {
                            this.executeRule(script, entryName, percent, aiRecognizerSuccessInfo, billObj, srcIndex, fieldList, srcEntityType, aiAttachmentConfig, entryGroupResultList, templateTableMap, entryIndexMap, numberIdMapping);
                            if (!this.isOutOfCount(relationResultList, entryGroupResultList)) continue;
                            break;
                        }
                        relationResultList.addAll(entryGroupResultList);
                    }
                }
                List<LinkUpBillResult> resultList = this.reduceResult(relationResultList, aiAttachmentConfig, entryIndexMap, reduceEntryIndexMap);
                allResultList.addAll(resultList);
                if (allResultList.isEmpty()) {
                    decisionResult.setStatus("empty");
                }
                if (needHighLight) {
                    HighLightBuilder highLightBuilder = new HighLightBuilder();
                    ArrayList<BaseHighLight> allHighLightList = new ArrayList<BaseHighLight>(5);
                    for (LinkUpBillResult result : resultList) {
                        if (result.getMatchRule() == -1) continue;
                        highLightBuilder.buildAttachmentHighLight(result.getMatchRule(), aiAttachmentConfig.getRuleList().get(result.getMatchRule()).getRule().getScript(), srcEntityType.getName(), srcEntityType, (List)reduceEntryIndexMap.get(result), allHighLightList, panelKeys);
                    }
                    if (!allHighLightList.isEmpty()) {
                        decisionResult.setHighLightList(allHighLightList);
                    }
                }
                decisionResult.setAttachmentResults(allResultList);
            } else {
                this.executeGPTRiskTip(decisionResult, aiAttachmentConfig, fgptasTemplates, billObj.get("id"), entityType, aiRefresh, schemaId, decisionPK, aiParticipation, fieldList, numberIdMapping);
            }
        }
    }

    private void executeGPTRiskTip(DecisionResult decisionResult, AIAttachmentConfig aiAttachmentConfig, StandardBaseDataConfig[] fgptasTemplates, Object billId, String billType, boolean aiRefresh, long schemaId, String decisionPK, Boolean aiParticipation, List<AttachmentField> fieldList, NumberIdMapping numberIdMapping) {
        List<GptRiskTip> gptRiskTipList = aiAttachmentConfig.getGptRiskTipList();
        if (CollectionUtils.isNotEmpty(gptRiskTipList)) {
            String data;
            CreateOrgBaseDataConfig gptrisk;
            Object[] prompIds;
            List templateIdList = Arrays.stream(fgptasTemplates).map(config -> config.getId()).collect(Collectors.toList());
            HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
            paramMap.put("templateIds", templateIdList);
            GptRiskTip gptRiskTip = gptRiskTipList.get(0);
            String[] billPositionings = gptRiskTip.getBillPositionings();
            paramMap.put("billFields", billPositionings);
            paramMap.put("billId", billId);
            paramMap.put("entityNumber", billType);
            paramMap.put("schemaId", schemaId);
            paramMap.put("decisionPk", decisionPK);
            paramMap.put("rule", gptRiskTip.getGptRule());
            paramMap.put("descript", gptRiskTip.getGptTip() != null ? gptRiskTip.getGptTip().toString() : "");
            String[] checkAttachmentFields = gptRiskTip.getCheckAttachmentField();
            HashMap<String, List> checkAttachmentFieldMap = new HashMap<String, List>(8);
            paramMap.put("checkTemplateMapFields", checkAttachmentFieldMap);
            if (checkAttachmentFields == null || checkAttachmentFields.length == 0) {
                boolean gptAllAttachmentFieldAtNull = ParamFactory.getGPTAllAttachmentFieldAtNull();
                if (gptAllAttachmentFieldAtNull) {
                    for (AttachmentField attachmentField : fieldList) {
                        if (attachmentField.isTable()) continue;
                        String key = String.valueOf(attachmentField.getTemplate().getId());
                        ArrayList<String> fieldStrList = (ArrayList<String>)checkAttachmentFieldMap.get(key);
                        if (CollectionUtils.isEmpty((Collection)fieldStrList)) {
                            fieldStrList = new ArrayList<String>(10);
                            checkAttachmentFieldMap.put(key, fieldStrList);
                        }
                        fieldStrList.add(attachmentField.getFullName());
                    }
                }
            } else {
                for (String checkAttachmentField : checkAttachmentFields) {
                    if (StringUtils.isEmpty((String)checkAttachmentField)) continue;
                    int index = checkAttachmentField.indexOf(".");
                    String templateNumber = checkAttachmentField.substring(0, index);
                    String field = checkAttachmentField.substring(index + 1);
                    String key = String.valueOf(numberIdMapping.getNewIdByNumber(templateNumber));
                    List newcheckAttachmentFieldList = checkAttachmentFieldMap.computeIfAbsent(key, k -> new ArrayList(10));
                    newcheckAttachmentFieldList.add(field);
                }
            }
            if ((prompIds = CreateOrgBaseDataConfig.loadBaseData("gai_prompt", new CreateOrgBaseDataConfig[]{gptrisk = aiAttachmentConfig.getGptRiskTip()})) == null || prompIds.length <= 0) {
                String errorMsg = ResManager.loadKDString((String)"\u63d0\u793a\u8bcd\u6570\u636e\u5df2\u88ab\u5220\u9664", (String)"AIAttachmentExecutor_6", (String)"data-idi-core", (Object[])new Object[0]);
                throw new AITipException(errorMsg + "\uff1a" + IDIJSONUtils.toJsonString((Object)gptrisk));
            }
            paramMap.put("promptId", prompIds[0]);
            paramMap.put("refresh", aiRefresh);
            try {
                data = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fgptas", (String)"FGPTASDecisionService", (String)"executeLLMDecision", (Object[])new Object[]{IDIJSONUtils.toJsonString(paramMap)});
            }
            catch (Throwable e) {
                SchemaExecutorLogger.error((Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u201cAI\u5ba1\u6838\u98ce\u9669\u63d0\u793a\u201d\u6267\u884c\u5f02\u5e38\u3002", (String)"AIAttachmentExecutor_7", (String)"data-idi-core", (Object[])new Object[0]));
            }
            SchemaExecutorLogger.info((String)("executeGPTRiskTip result:" + data), (Object[])new Object[0]);
            ApiDecisionResultItem apiDecisionResultItem = (ApiDecisionResultItem)IDIJSONUtils.cast((String)data, ApiDecisionResultItem.class);
            if (apiDecisionResultItem != null) {
                String status = apiDecisionResultItem.getStatus();
                String showText = apiDecisionResultItem.getShowText();
                int percent = gptRiskTip.getPercent();
                if ("error".equals(status) || "miss".equals(status)) {
                    status = "none";
                }
                decisionResult.setStatus(status);
                decisionResult.setShowText(showText);
                if ("alarming".equals(status)) {
                    this.deductionGrade.deduct(percent);
                }
                decisionResult.setDeductPercent(this.deductionGrade.getValue());
                List<List<HoverContent>> hoverContentList = apiDecisionResultItem.getHoverContents();
                if (CollectionUtils.isNotEmpty(hoverContentList)) {
                    DecisionFrontEndResult decisionFrontEndResult = new DecisionFrontEndResult();
                    decisionFrontEndResult.setHoverContent(hoverContentList);
                    HashMap<String, Object> customParamMap = new HashMap<String, Object>(2);
                    customParamMap.put("setDetailDisplayType", "1");
                    decisionFrontEndResult.setCustomParamMap(customParamMap);
                    decisionResult.setFrontEndResult(decisionFrontEndResult);
                }
                decisionResult.setLlmParticipateStatus(apiDecisionResultItem.getLlmParticipateStatus());
                decisionResult.setAiParticipation(aiParticipation != false || !"4".equals(apiDecisionResultItem.getLlmParticipateStatus()));
            }
        } else {
            decisionResult.setStatus("empty");
        }
    }

    private boolean isOutOfCount(List<LinkUpBillResult> relationResultList, List<LinkUpBillResult> entryGroupResultList) {
        int count = 0;
        for (LinkUpBillResult billResult : relationResultList) {
            if (billResult.isPass()) continue;
            ++count;
        }
        for (LinkUpBillResult billResult : entryGroupResultList) {
            if (billResult.isPass()) continue;
            ++count;
        }
        return count > 100;
    }

    private void executeRule(String script, String entryName, BigDecimal percent, AIRecognizerSuccessInfo aiRecognizerSuccessInfo, DynamicObject billObj, int entryIndex, List<AttachmentField> attachmentFieldList, MainEntityType srcEntityType, AIAttachmentConfig aiAttachmentConfig, List<LinkUpBillResult> relationResultList, Map<String, String> templateTableMap, Map<LinkUpBillResult, Integer> entryIndexMap, NumberIdMapping numberIdMapping) {
        String sourceEntity = srcEntityType.getName();
        List<Map<String, Object>> attachmentDataList = this.processAttachmentData(aiRecognizerSuccessInfo, attachmentFieldList, templateTableMap);
        if (CollectionUtils.isEmpty(attachmentDataList)) {
            return;
        }
        BigDecimal tablePercent = attachmentDataList.size() <= 1 ? percent : percent.divide(BigDecimal.valueOf(attachmentDataList.size(), 0), 6, RoundingMode.HALF_UP);
        ScriptLocaleFieldHandler localeFieldHandler = new ScriptLocaleFieldHandler();
        String localeScript = localeFieldHandler.processLocaleField(script, new String[]{sourceEntity}, billObj);
        if (!this.isHead(entryName)) {
            localeScript = ScriptUtils.supportEntryProperty((DynamicObjectType)srcEntityType, localeScript, entryIndex);
        }
        for (Map<String, Object> attachmentDataMapNew : attachmentDataList) {
            HashMap<String, Object> ctx = new HashMap<String, Object>(1);
            ctx.put(sourceEntity + "_billObj", billObj);
            ctx.putAll(attachmentDataMapNew);
            SchemaExecutorLogger.info((String)"run script, script %s, param %s", (Object[])new Object[]{localeScript, ctx});
            ScriptFormIdHandler.runScript((String)sourceEntity, (String)sourceEntity, ctx, (String)localeScript);
            Object matchRuleIndexObj = ctx.get("__MatchRuleIndex__");
            LinkUpBillResult result = new LinkUpBillResult();
            result.setAiParticipation(aiRecognizerSuccessInfo.isAiParticipation());
            relationResultList.add(result);
            DecisionFrontEndResult decisionFrontEndResult = this.buildFrontEndResult(attachmentDataMapNew, billObj, aiAttachmentConfig, srcEntityType, entryName, entryIndex, aiRecognizerSuccessInfo.getTemplate().getId(), numberIdMapping);
            if (matchRuleIndexObj == null) {
                ExceptionTip exceptionTip = this.matchExceptionTip(aiAttachmentConfig, ExceptionTipEnum.NO_MATCH_RULE);
                if (exceptionTip.getShowErrorTips().booleanValue()) {
                    relationResultList.remove(result);
                    continue;
                }
                result.setStatus("alarming");
                BigDecimal deductPercent = this.deductionGrade.deductPercent(exceptionTip.getPercent(), tablePercent);
                result.setDeductPercent(deductPercent);
                result.setFrontEndResult(decisionFrontEndResult);
                result.setShowText(exceptionTip.achieveTipWords());
                result.setMatchRule(-1);
                continue;
            }
            int matchRuleIndex = Integer.parseInt(matchRuleIndexObj.toString());
            DecisionRule decisionRule = aiAttachmentConfig.getRuleList().get(matchRuleIndex);
            result.setMatchRule(matchRuleIndex);
            result.setPass(decisionRule.isPass());
            result.setShowText(decisionRule.achieveName());
            result.setStatus(decisionRule.getDecisionStatus());
            if (!decisionRule.isPass()) {
                result.setFrontEndResult(decisionFrontEndResult);
            }
            BigDecimal deductPercent = this.deductionGrade.deductPercent(decisionRule.getDeductionGradePercent(), tablePercent);
            result.setDeductPercent(deductPercent);
            if (entryIndex <= -1) continue;
            entryIndexMap.put(result, entryIndex);
        }
    }

    private void executeRuleRepo(DecisionResult decisionResult, AIAttachmentConfig aiAttachmentConfig, DynamicObject billObj, String billType, MainEntityType srcEntityType, boolean aiRefresh, long schemaId, String decisionPK, List<AIRecognizerSuccessInfo> successInfoList, List<AttachmentField> fieldList, NumberIdMapping numberIdMapping, boolean AiParticipation) {
        ApiDecisionResultItem apiDecisionResultItem;
        List<RuleRepo> ruleRepoList = aiAttachmentConfig.getRuleRepoList();
        if (CollectionUtils.isNotEmpty(ruleRepoList)) {
            String data;
            RuleRepo rr = ruleRepoList.get(0);
            StandardBaseDataConfig ruleRepoObj = rr.getRuleRepo();
            Object[] ruleRepoIds = StandardBaseDataConfig.loadBaseData("fgptas_rule_repo", new StandardBaseDataConfig[]{ruleRepoObj});
            String desc = rr.getRuleRepoTip().getLocaleValue();
            HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
            paramMap.put("ruleRepoId", ruleRepoIds[0]);
            paramMap.put("descript", desc);
            Object billId = billObj.get("id");
            paramMap.put("billId", billId);
            paramMap.put("entityNumber", billType);
            paramMap.put("schemaId", schemaId);
            paramMap.put("decisionPk", decisionPK);
            paramMap.put("refresh", aiRefresh);
            try {
                data = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fgptas", (String)"FGPTASDecisionService", (String)"executeRuleRepoDecision", (Object[])new Object[]{IDIJSONUtils.toJsonString(paramMap)});
            }
            catch (Throwable e) {
                SchemaExecutorLogger.error((Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u89c4\u5219\u5e93\u8c03\u7528\u5f02\u5e38", (String)"AIAttachmentExecutor_8", (String)"data-idi-core", (Object[])new Object[0]));
            }
            SchemaExecutorLogger.info((String)("executeRuleRepoDecision result:" + data), (Object[])new Object[0]);
            apiDecisionResultItem = (ApiDecisionResultItem)IDIJSONUtils.cast((String)data, ApiDecisionResultItem.class);
            if (apiDecisionResultItem != null) {
                String status = apiDecisionResultItem.getStatus();
                String oldStatus = apiDecisionResultItem.getStatus();
                String showText = apiDecisionResultItem.getShowText();
                int percent = rr.getPercent();
                if ("error".equals(oldStatus) || "miss".equals(oldStatus)) {
                    if ("miss".equals(oldStatus)) {
                        ExceptionTip exceptionTip = this.matchExceptionTip(aiAttachmentConfig, ExceptionTipEnum.NO_MATCH_RULE);
                        if (!exceptionTip.getShowErrorTips().booleanValue()) {
                            this.deductionGrade.deduct(exceptionTip.getPercent());
                            status = "alarming";
                        } else {
                            status = "empty";
                        }
                        showText = exceptionTip.achieveTipWords();
                    } else {
                        status = "none";
                    }
                }
                decisionResult.setStatus(status);
                decisionResult.setShowText(showText);
                if ("alarming".equals(oldStatus)) {
                    this.deductionGrade.deduct(percent);
                    if ("5".equals(apiDecisionResultItem.getLlmParticipateStatus())) {
                        decisionResult.setStatus("warnning");
                    }
                    SchemaExecutorLogger.info((String)("executeRuleRepo. success result:" + IDIJSONUtils.toJsonString(successInfoList)), (Object[])new Object[0]);
                    ArrayList<DecisionFrontEndResult> frontEndResultList = new ArrayList<DecisionFrontEndResult>(successInfoList.size());
                    HashSet fileNameSet = apiDecisionResultItem.getFileNames() == null ? new HashSet(2) : new HashSet<String>(Arrays.asList(apiDecisionResultItem.getFileNames()));
                    for (AIRecognizerSuccessInfo aiRecognizerSuccessInfo : successInfoList) {
                        List<Map<String, Object>> dataList;
                        Long newTemplateId;
                        if (!fileNameSet.contains(aiRecognizerSuccessInfo.getFileName()) || (newTemplateId = (Long)numberIdMapping.getNewIdByNumber(aiRecognizerSuccessInfo.getTemplate().getNumber())) == null || CollectionUtils.isEmpty(dataList = this.processAttachmentData(aiRecognizerSuccessInfo, fieldList, new HashMap<String, String>(1)))) continue;
                        for (Map<String, Object> stringObjectMap : dataList) {
                            DecisionFrontEndResult frontEndResult = this.buildFrontEndResult(stringObjectMap, billObj, aiAttachmentConfig, srcEntityType, "", -1, newTemplateId, numberIdMapping);
                            if (frontEndResult == null) continue;
                            frontEndResultList.add(frontEndResult);
                        }
                    }
                    DecisionFrontEndResult frontEndResult = this.reduceFrontEndResult(frontEndResultList);
                    decisionResult.setFrontEndResult(frontEndResult);
                }
                decisionResult.setLlmParticipateStatus(apiDecisionResultItem.getLlmParticipateStatus());
            }
        } else {
            throw new AITipException(ResManager.loadKDString((String)"\u89c4\u5219\u5e93\u4e3a\u7a7a", (String)"AIAttachmentExecutor_5", (String)"data-idi-core", (Object[])new Object[0]));
        }
        decisionResult.setAiParticipation(AiParticipation || !"4".equals(apiDecisionResultItem.getLlmParticipateStatus()));
    }

    private Map<String, String> validateMoreTable(String script, List<String> templateNumberList, String sourceEntityName) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(templateNumberList)) {
            Set vars = ScriptFormIdHandler.extractVariables((String)script, (String[])new String[]{sourceEntityName});
            for (String number : templateNumberList) {
                String prefix = IDIStringUtils.templatePrefix((String)number);
                for (String var : vars) {
                    String[] properties = var.split("\\.");
                    if (properties.length <= 2 || !var.startsWith(prefix)) continue;
                    String previousTable = (String)map.get(number);
                    if (previousTable == null || previousTable.equals(properties[1])) {
                        map.put(number, properties[1]);
                        continue;
                    }
                    throw new AITipException(ResManager.loadKDString((String)"\u68c0\u67e5\u89c4\u5219\u4e0d\u652f\u6301\u8de8\u6a21\u677f\u7684\u591a\u4e2a\u8868\u683c\u3002", (String)"AttachmentExecutor_10", (String)"data-idi-core", (Object[])new Object[0]));
                }
            }
        }
        return map;
    }

    private String validateMoreEntry(String script, MainEntityType entityType, String errorText) {
        if (StringUtils.isNotEmpty((String)script)) {
            Set<String> propSet = ScriptUtils.getEntries(entityType, script, new String[]{entityType.getName()});
            if (propSet.size() > 1) {
                throw new AITipException(errorText);
            }
            if (propSet.isEmpty()) {
                return "";
            }
            return propSet.iterator().next();
        }
        return null;
    }

    private void checkExists(List<Attachment> attachmentList, IAttachmentService attachmentService, DecisionResult decisionResult, AIAttachmentConfig aiAttachmentConfig, String entityNumber, DynamicObject billObj, MainEntityType srcEntityType, boolean needHighLight, NumberIdMapping numberIdMapping) {
        SchemaExecutorLogger.info((String)String.format("[DATA-IDI] AttachmentExecutor attachmentList:%s", IDIJSONUtils.toJsonString(attachmentList)), (Object[])new Object[0]);
        if (attachmentList == null || attachmentList.isEmpty()) {
            decisionResult.setStatus("alarming");
            decisionResult.setShowText(aiAttachmentConfig.achieveNotExistWords());
            this.deductionGrade.deduct(100);
            return;
        }
        AIRecognizerParam param = new AIRecognizerParam(aiAttachmentConfig.getCheckMethod(), null, null, null, null, null, null, null, entityNumber, null, null, null, null, null);
        Map<Object, String> idToNumberMap = numberIdMapping.getNewIdToNumberMap();
        if (idToNumberMap == null || idToNumberMap.isEmpty()) {
            SchemaExecutorLogger.info((String)String.format("[DATA-IDI] AIAttachmentExecutor - start to recognizer attacchment, class is :%s", attachmentService.getClass()), (Object[])new Object[0]);
            throw new AITipException(ResManager.loadKDString((String)"\u9644\u4ef6\u6a21\u677f\u4e3a\u7a7a\u6216\u88ab\u5220\u9664", (String)"AIAttachmentExecutor_4", (String)"data-idi-core", (Object[])new Object[0]));
        }
        StandardBaseDataConfig[] fgptasTemplates = this.createNewTemplates(idToNumberMap);
        param.setFgptasTemplates(fgptasTemplates);
        param.setBillId(billObj.get("id"));
        AIRecognizerResult recognizerResult = (AIRecognizerResult)attachmentService.recognizer(param);
        if ("FAILED".equals(recognizerResult.getErrorCode())) {
            SchemaExecutorLogger.info((String)("[DATA-IDI] AIAttachmentExecutor - recognizer failed. result :" + IDIJSONUtils.toJsonString((Object)recognizerResult)), (Object[])new Object[0]);
            throw new AITipException(recognizerResult.getDescription());
        }
        List successInfoList = recognizerResult.getDetailDatas();
        List errorInfoList = recognizerResult.getErrorInfos();
        SchemaExecutorLogger.info((String)String.format("[DATA-IDI] AttachmentExecutor successInfoList:%s", IDIJSONUtils.toJsonString((Object)successInfoList)), (Object[])new Object[0]);
        SchemaExecutorLogger.info((String)String.format("[DATA-IDI] AttachmentExecutor errorInfoList:%s", IDIJSONUtils.toJsonString((Object)errorInfoList)), (Object[])new Object[0]);
        if (CollectionUtils.isEmpty((Collection)successInfoList) && CollectionUtils.isEmpty((Collection)errorInfoList)) {
            decisionResult.setStatus("alarming");
            decisionResult.setShowText(aiAttachmentConfig.achieveNotExistWords());
            this.deductionGrade.deduct(100);
            return;
        }
        decisionResult.setStatus("green");
        decisionResult.setShowText(aiAttachmentConfig.achieveExistWords());
        AIParam fieldQueryParam = new AIParam(aiAttachmentConfig.getCheckMethod(), null, null, null, null, null, null, null, entityNumber);
        fieldQueryParam.setFgptasTemplates(fgptasTemplates);
        List fieldList = attachmentService.queryTemplateField(fieldQueryParam);
        if (CollectionUtils.isNotEmpty((Collection)successInfoList)) {
            ArrayList<DecisionFrontEndResult> frontEndResultList = new ArrayList<DecisionFrontEndResult>(successInfoList.size());
            for (AIRecognizerSuccessInfo aiRecognizerSuccessInfo : successInfoList) {
                Long newTemplateId = (Long)numberIdMapping.getNewIdByNumber(aiRecognizerSuccessInfo.getTemplate().getNumber());
                if (newTemplateId != null) {
                    List<Map<String, Object>> dataList = this.processAttachmentData(aiRecognizerSuccessInfo, fieldList, new HashMap<String, String>(1));
                    if (CollectionUtils.isEmpty(dataList)) continue;
                    for (Map<String, Object> stringObjectMap : dataList) {
                        DecisionFrontEndResult frontEndResult = this.buildFrontEndResult(stringObjectMap, billObj, aiAttachmentConfig, srcEntityType, "", -1, newTemplateId, numberIdMapping);
                        if (frontEndResult == null) continue;
                        frontEndResultList.add(frontEndResult);
                    }
                }
                DecisionFrontEndResult frontEndResult = this.reduceFrontEndResult(frontEndResultList);
                decisionResult.setFrontEndResult(frontEndResult);
            }
            if (needHighLight) {
                Set<String> panelKeySet = attachmentList.stream().map(Attachment::getAttachmentPanelName).filter(panelName -> StringUtils.isNotEmpty((String)panelName)).collect(Collectors.toSet());
                String[] panelKeys = panelKeySet.toArray(new String[0]);
                HighLightBuilder highLightBuilder = new HighLightBuilder();
                ArrayList<BaseHighLight> allHighLightList = new ArrayList<BaseHighLight>(5);
                highLightBuilder.buildAttachmentHighLight(Integer.MAX_VALUE, "", srcEntityType.getName(), srcEntityType, null, allHighLightList, panelKeys);
                if (!allHighLightList.isEmpty()) {
                    decisionResult.setHighLightList(allHighLightList);
                }
            }
        }
    }

    private StandardBaseDataConfig[] createNewTemplates(Map<Object, String> newIdToNumberMap) {
        StandardBaseDataConfig[] fgptasTemplates = new StandardBaseDataConfig[newIdToNumberMap.size()];
        AtomicInteger index = new AtomicInteger();
        newIdToNumberMap.forEach((id, number) -> {
            fgptasTemplates[index.get()] = new StandardBaseDataConfig(id, (String)number);
            index.getAndIncrement();
        });
        return fgptasTemplates;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Map<String, Object>> processAttachmentData(AIRecognizerSuccessInfo aiRecognizerSuccessInfo, List<AttachmentField> attachmentFieldList, Map<String, String> templateTableMap) {
        AITemplate templateObj = aiRecognizerSuccessInfo.getTemplate();
        String templateNumber = templateObj.getNumber();
        Map<String, String> fieldMap = attachmentFieldList.stream().filter(field -> templateNumber.equals(field.getTemplate().getNumber())).collect(Collectors.toMap(field -> templateObj.isCustomTemplate() ? field.getFullDisplayName() : field.getFullName(), field -> {
            String fieldName = field.getFullName();
            return IDIStringUtils.buildTemplateField((String)templateNumber, (String)fieldName);
        }));
        Map<String, AttachmentField> attachmentFieldMap = attachmentFieldList.stream().filter(field -> templateNumber.equals(field.getTemplate().getNumber())).collect(Collectors.toMap(field -> templateObj.isCustomTemplate() ? field.getFullDisplayName() : field.getFullName(), field -> field));
        Map<String, Object> attachmentDataMap = aiRecognizerSuccessInfo.getDataDetailMap();
        if (attachmentDataMap == null || attachmentDataMap.isEmpty()) {
            return new ArrayList<Map<String, Object>>(1);
        }
        SchemaExecutorLogger.info((String)"attachment data, source data %s", (Object[])new Object[]{attachmentDataMap});
        HashMap<String, String> attachmentDataMapNew = new HashMap<String, String>(attachmentDataMap.size());
        attachmentDataMap.forEach((k, v) -> {
            AttachmentField field = (AttachmentField)attachmentFieldMap.get(k);
            if (null != field && null == field.getParent() && !field.isTable()) {
                String fieldNumber = (String)fieldMap.get(k);
                attachmentDataMapNew.put(fieldNumber, (String)field.convertDataType(v));
            }
        });
        attachmentDataMapNew.put(IDIStringUtils.buildTemplateField((String)templateNumber, (String)"filename"), aiRecognizerSuccessInfo.getFileName());
        SchemaExecutorLogger.info((String)"attachment data %s after user attachemnt field number  ", (Object[])new Object[]{attachmentDataMapNew});
        String tableKey = templateTableMap.get(templateNumber);
        boolean hasTableData = StringUtils.isNotEmpty((String)tableKey);
        ArrayList<Map<String, Object>> attachmentDataList = new ArrayList<Map<String, Object>>(10);
        if (hasTableData) {
            Optional<AttachmentField> tableFieldOptional = attachmentFieldList.stream().filter(field -> tableKey.equals(field.getFullName())).findFirst();
            if (!tableFieldOptional.isPresent()) throw new AITipException(ResManager.loadKDString((String)"\u6a21\u677f\u5b57\u6bb5\u4e0e\u68c0\u67e5\u89c4\u5219\u914d\u7f6e\u5b57\u6bb5\u5b58\u5728\u5dee\u5f02\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u68c0\u67e5\u89c4\u5219", (String)"AttachmentExecutor_11", (String)"data-idi-core", (Object[])new Object[0]));
            AttachmentField tableField = tableFieldOptional.get();
            String tableName = templateObj.isCustomTemplate() ? tableField.getDisplayName() : tableField.getName();
            List tableDataList = (List)attachmentDataMap.get(tableName);
            if (tableDataList != null && !tableDataList.isEmpty()) {
                for (Map tableRowDataMap : tableDataList) {
                    HashMap<String, String> attachmentTableDataMap = new HashMap<String, String>(tableRowDataMap.size() + attachmentDataMapNew.size());
                    attachmentTableDataMap.putAll(attachmentDataMapNew);
                    tableRowDataMap.forEach((k, v) -> {
                        String fullTableFieldKey = tableName + '.' + k;
                        AttachmentField field = (AttachmentField)attachmentFieldMap.get(fullTableFieldKey);
                        if (field != null && field.getParent() != null && !field.isTable()) {
                            String fieldNumber = (String)fieldMap.get(fullTableFieldKey);
                            attachmentTableDataMap.put(fieldNumber, (String)field.convertDataType(v));
                        }
                    });
                    attachmentDataList.add(attachmentTableDataMap);
                }
            } else {
                SchemaExecutorLogger.info((String)("tableData is null, table name:" + tableName), (Object[])new Object[0]);
                attachmentDataList.add(attachmentDataMapNew);
            }
        } else {
            attachmentDataList.add(attachmentDataMapNew);
        }
        SchemaExecutorLogger.info((String)"splite attachemnt data %s ", (Object[])new Object[]{attachmentDataList});
        return attachmentDataList;
    }

    private List<Attachment> queryAttachmentInfo(SchemaContext context, IAttachmentService attachmentService) {
        Long billId = (Long)context.getBillId();
        if (billId == null) {
            DynamicObject billObj = context.getSelfBill();
            billId = billObj.getLong("id");
            if (Long.valueOf(0L).compareTo(billId) == 0) {
                return new ArrayList<Attachment>(0);
            }
        }
        return attachmentService.queryAttachmentInfo(billId, context.getEntityType(), false);
    }

    private void checkFileName(List<Attachment> attachmentList, DecisionResult decisionResult, AIAttachmentConfig aiAttachmentConfig, MainEntityType srcEntityType, DynamicObject billObj, boolean needHighLight, NumberIdMapping numberIdMapping) {
        if (attachmentList == null || attachmentList.isEmpty()) {
            this.noExistsAttachmentException(aiAttachmentConfig, decisionResult);
        } else {
            String script = this.comboRuleScript(aiAttachmentConfig.getRuleList());
            BigDecimal percent = this.calPercent(attachmentList.size(), billObj, "", null, null, 0);
            ArrayList<LinkUpBillResult> relationResultList = new ArrayList<LinkUpBillResult>(attachmentList.size());
            for (Attachment attachment : attachmentList) {
                this.executeCheckFileNameRule(script, percent, attachment.getFileName(), billObj, srcEntityType, aiAttachmentConfig, relationResultList, numberIdMapping);
            }
            List<LinkUpBillResult> resultList = this.reduceResult(relationResultList, aiAttachmentConfig, null, new HashMap<LinkUpBillResult, List<Integer>>(2));
            if (resultList.isEmpty()) {
                decisionResult.setStatus("empty");
            }
            if (needHighLight) {
                Set<String> panelKeySet = attachmentList.stream().map(Attachment::getAttachmentPanelName).filter(pk -> StringUtils.isNotEmpty((String)pk)).collect(Collectors.toSet());
                String[] panelKeys = panelKeySet.toArray(new String[0]);
                HighLightBuilder highLightBuilder = new HighLightBuilder();
                ArrayList<BaseHighLight> allHighLightList = new ArrayList<BaseHighLight>(5);
                for (LinkUpBillResult result : resultList) {
                    if (result.getMatchRule() == -1) continue;
                    highLightBuilder.buildAttachmentHighLight(result.getMatchRule(), aiAttachmentConfig.getRuleList().get(result.getMatchRule()).getRule().getScript(), srcEntityType.getName(), srcEntityType, new ArrayList<Integer>(0), allHighLightList, panelKeys);
                }
                if (!allHighLightList.isEmpty()) {
                    decisionResult.setHighLightList(allHighLightList);
                }
            }
            decisionResult.setAttachmentResults(resultList);
        }
    }

    private String comboRuleScript(List<DecisionRule> ruleList) {
        if (ruleList == null || ruleList.isEmpty()) {
            throw new AITipException(ResManager.loadKDString((String)"\u68c0\u67e5\u9644\u4ef6\u5185\u5bb9\u68c0\u67e5\u672a\u914d\u7f6e\u68c0\u67e5\u89c4\u5219", (String)"AttachmentExecutor_2", (String)"data-idi-core", (Object[])new Object[0]));
        }
        return this.buildScript(ruleList);
    }

    private List<LinkUpBillResult> reduceResult(List<LinkUpBillResult> relationResultList, AIAttachmentConfig aiAttachmentConfig, Map<LinkUpBillResult, Integer> entryIndexMap, Map<LinkUpBillResult, List<Integer>> reduceEntryIndexMap) {
        ArrayList<LinkUpBillResult> ruleResultList = new ArrayList<LinkUpBillResult>(relationResultList.size());
        Map<Integer, List<LinkUpBillResult>> collect = relationResultList.stream().collect(Collectors.groupingBy(LinkUpBillResult::getMatchRule));
        List<DecisionRule> ruleList = aiAttachmentConfig.getRuleList();
        collect.forEach((index, resultList) -> {
            LinkUpBillResult ruleResult = new LinkUpBillResult();
            if (index != -1) {
                DecisionRule rule = (DecisionRule)ruleList.get((int)index);
                ruleResult.setPass(rule.isPass());
                ruleResult.setMatchRule((int)index);
                ruleResult.setStatus(rule.getDecisionStatus());
                ruleResult.setShowText(rule.achieveName());
            } else {
                LinkUpBillResult template = (LinkUpBillResult)resultList.get(0);
                ruleResult.setPass(false);
                ruleResult.setMatchRule((int)index);
                ruleResult.setShowText(template.getShowText());
                ruleResult.setStatus(template.getStatus());
            }
            ArrayList<DecisionFrontEndResult> frontEndResultList = new ArrayList<DecisionFrontEndResult>(resultList.size());
            HashSet<Integer> ruleEntryIndexSet = new HashSet<Integer>(10);
            boolean aiParticipation = false;
            for (Object result : resultList) {
                Integer entryIndex;
                DecisionFrontEndResult ruleFrontEndResult = ((LinkUpBillResult)result).getFrontEndResult();
                if (ruleFrontEndResult != null) {
                    frontEndResultList.add(ruleFrontEndResult);
                }
                if (index != -1 && entryIndexMap != null && !entryIndexMap.isEmpty() && (entryIndex = (Integer)entryIndexMap.get(result)) != null) {
                    ruleEntryIndexSet.add(entryIndex);
                }
                if (!((LinkUpBillResult)result).isAiParticipation()) continue;
                aiParticipation = true;
            }
            ruleResult.setAiParticipation(aiParticipation);
            DecisionFrontEndResult decisionFrontEndResult = this.reduceFrontEndResult(frontEndResultList);
            ruleResult.setFrontEndResult(decisionFrontEndResult);
            for (LinkUpBillResult result : resultList) {
                ruleResult.addDeductPercent(result.getDeductPercent());
            }
            ruleResultList.add(ruleResult);
            if (CollectionUtils.isNotEmpty(ruleEntryIndexSet) && index != -1) {
                ArrayList entryIndexList = new ArrayList(ruleEntryIndexSet);
                entryIndexList.sort(Integer::compare);
                reduceEntryIndexMap.put(ruleResult, entryIndexList);
            }
        });
        if (aiAttachmentConfig.isNeedShowAllCheckTrue()) {
            this.processShowAllCheckTrue(ruleResultList, aiAttachmentConfig.getRuleList(), reduceEntryIndexMap);
        }
        return ruleResultList;
    }

    private void processShowAllCheckTrue(List<LinkUpBillResult> linkUpBillResults, List<DecisionRule> ruleList, Map<LinkUpBillResult, List<Integer>> reduceEntryIndexMap) {
        if (CollectionUtils.isEmpty(linkUpBillResults) || CollectionUtils.isEmpty(ruleList)) {
            return;
        }
        HashMap<DecisionRule, List> map = new HashMap<DecisionRule, List>(linkUpBillResults.size());
        for (LinkUpBillResult linkUpBillResult : linkUpBillResults) {
            int index = linkUpBillResult.getMatchRule();
            if (index <= -1) continue;
            DecisionRule rule2 = ruleList.get(index);
            ArrayList<LinkUpBillResult> list = (ArrayList<LinkUpBillResult>)map.get(rule2);
            if (list == null) {
                list = new ArrayList<LinkUpBillResult>(linkUpBillResults.size());
                map.put(rule2, list);
            }
            list.add(linkUpBillResult);
        }
        if (map.size() > 1) {
            map.forEach((rule, dataList) -> {
                if (rule.isShowAllCheckTrue()) {
                    for (LinkUpBillResult result : dataList) {
                        linkUpBillResults.remove(result);
                        reduceEntryIndexMap.remove(result);
                    }
                }
            });
        }
    }

    private DecisionFrontEndResult reduceFrontEndResult(List<DecisionFrontEndResult> frontEndResultList) {
        List<List<HoverContent>> hoverContentList;
        if (frontEndResultList == null || frontEndResultList.isEmpty()) {
            return null;
        }
        List<List<HoverContent>> list = hoverContentList = frontEndResultList.get(0) != null ? frontEndResultList.get(0).getHoverContent() : null;
        if (hoverContentList == null || hoverContentList.isEmpty()) {
            return null;
        }
        DecisionFrontEndResult decisionFrontEndResult = new DecisionFrontEndResult();
        List<HoverContent> titleList = frontEndResultList.get(0).getHoverContent().get(0);
        if (frontEndResultList.size() > 1) {
            decisionFrontEndResult.setTableStyle(true);
            decisionFrontEndResult.addHoverContent(titleList);
            for (DecisionFrontEndResult result : frontEndResultList) {
                List<HoverContent> valueList = result.getHoverContent().get(1);
                decisionFrontEndResult.addHoverContent(valueList);
            }
        } else {
            int rowCount = titleList.size();
            List<List<HoverContent>> dataList = frontEndResultList.get(0).getHoverContent();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                ArrayList<HoverContent> rowList = new ArrayList<HoverContent>(rowCount);
                for (List<HoverContent> hoverContents : dataList) {
                    HoverContent hc = rowIndex >= hoverContents.size() ? HoverContent.createText((String)" ") : hoverContents.get(rowIndex);
                    rowList.add(hc);
                }
                decisionFrontEndResult.addHoverContent(rowList);
            }
        }
        return decisionFrontEndResult;
    }

    private void executeCheckFileNameRule(String script, BigDecimal percent, String fileName, DynamicObject billObj, MainEntityType srcEntityType, AIAttachmentConfig aiAttachmentConfig, List<LinkUpBillResult> relationResultList, NumberIdMapping numberIdMapping) {
        String sourceEntity = srcEntityType.getName();
        ScriptLocaleFieldHandler localeFieldHandler = new ScriptLocaleFieldHandler();
        String localeScript = localeFieldHandler.processLocaleField(script, new String[]{sourceEntity}, billObj);
        HashMap<String, Object> ctx = new HashMap<String, Object>(1);
        ctx.put(sourceEntity + "_billObj", billObj);
        ctx.put("filename", fileName);
        SchemaExecutorLogger.info((String)"check file name run script, script %s, param %s", (Object[])new Object[]{localeScript, ctx});
        ScriptFormIdHandler.runScript((String)sourceEntity, (String)sourceEntity, ctx, (String)localeScript);
        Object matchRuleIndexObj = ctx.get("__MatchRuleIndex__");
        LinkUpBillResult result = new LinkUpBillResult();
        relationResultList.add(result);
        DecisionFrontEndResult decisionFrontEndResult = this.buildFrontEndResult(ctx, billObj, aiAttachmentConfig, srcEntityType, "", -1, null, numberIdMapping);
        if (matchRuleIndexObj == null) {
            ExceptionTip exceptionTip = this.matchExceptionTip(aiAttachmentConfig, ExceptionTipEnum.NO_MATCH_RULE);
            if (exceptionTip.getShowErrorTips().booleanValue()) {
                relationResultList.remove(result);
            } else {
                result.setStatus("alarming");
                result.setShowText(exceptionTip.achieveTipWords());
                result.setMatchRule(-1);
                BigDecimal deductPercent = this.deductionGrade.deductPercent(exceptionTip.getPercent(), percent);
                result.setDeductPercent(deductPercent);
                result.setFrontEndResult(decisionFrontEndResult);
            }
        } else {
            int matchRuleIndex = Integer.parseInt(matchRuleIndexObj.toString());
            DecisionRule decisionRule = aiAttachmentConfig.getRuleList().get(matchRuleIndex);
            result.setMatchRule(matchRuleIndex);
            result.setPass(decisionRule.isPass());
            result.setShowText(decisionRule.achieveName());
            result.setStatus(decisionRule.getDecisionStatus());
            if (!decisionRule.isPass()) {
                result.setFrontEndResult(decisionFrontEndResult);
            }
            BigDecimal deductPercent = this.deductionGrade.deductPercent(decisionRule.getDeductionGradePercent(), percent);
            result.setDeductPercent(deductPercent);
        }
    }

    private DecisionFrontEndResult buildFrontEndResult(Map<String, Object> attachmentDataMapNew, DynamicObject billObj, AIAttachmentConfig aiAttachmentConfig, MainEntityType srcEntityType, String entryName, int entryIndex, Object templateId, NumberIdMapping numberIdMapping) {
        List showFieldList;
        DecisionFrontEndConfig config = aiAttachmentConfig.getFrontEndConfig();
        List list = showFieldList = config == null ? null : config.getHoverFieldContents();
        if (showFieldList == null || showFieldList.isEmpty()) {
            return null;
        }
        DecisionFrontEndResult decisionFrontEndResult = new DecisionFrontEndResult();
        HoverContent[] titles = new HoverContent[showFieldList.size()];
        int index = 0;
        ArrayList<HoverContent> fieldDataList = new ArrayList<HoverContent>();
        for (DecisionFrontEndConfigField decisionFrontEndConfigField : showFieldList) {
            titles[index++] = HoverContent.createTitle((String)(StringUtils.isEmpty((String)decisionFrontEndConfigField.achieveDisplayName()) ? decisionFrontEndConfigField.getPropDisplayName() : decisionFrontEndConfigField.achieveDisplayName()));
            String billType = decisionFrontEndConfigField.getBillType();
            if ("srcbill".equalsIgnoreCase(billType)) {
                ExecutorHelper.ValueAndName valueAndName = ExecutorHelper.getValueAndNameByName(billObj, decisionFrontEndConfigField.getPropName(), true);
                IDataEntityProperty entityProperty = valueAndName.getEntityProperty();
                Object value = valueAndName.getValue();
                boolean isUser = valueAndName.isUser();
                boolean isBill = !(srcEntityType instanceof BasedataEntityType);
                boolean isBillNo = false;
                if (isBill) {
                    BillEntityType billEntityType = (BillEntityType)srcEntityType;
                    isBillNo = decisionFrontEndConfigField.getPropName().equalsIgnoreCase(billEntityType.getBillNo());
                }
                String fieldEntryName = decisionFrontEndConfigField.getPropName().split("\\.")[0];
                if (value != null) {
                    String content;
                    if (value instanceof List) {
                        List valueList = (List)value;
                        List refValueList = (List)valueAndName.getRefValue();
                        if (entryName.equals(fieldEntryName)) {
                            String content2;
                            Object itemValue = valueList.get(entryIndex);
                            Object formatValue = ExecutorHelper.tryToString(billObj, billObj, itemValue, entityProperty);
                            String string = content2 = formatValue == null ? " " : formatValue.toString();
                            fieldDataList.add(isUser ? HoverContent.createChat((String)content2, refValueList.get(entryIndex)) : (isBillNo ? HoverContent.createHref((String)content2, (DynamicObject)billObj) : HoverContent.createText((String)content2)));
                            continue;
                        }
                        StringBuilder sb = new StringBuilder();
                        valueList.forEach(obj -> {
                            Object formatValue = ExecutorHelper.tryToString(billObj, billObj, obj, entityProperty);
                            String content = formatValue == null ? " " : formatValue.toString();
                            sb.append(content).append(',');
                        });
                        String content3 = sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
                        fieldDataList.add(HoverContent.createText((String)content3));
                        continue;
                    }
                    Object formatValue = ExecutorHelper.tryToString(billObj, billObj, value, entityProperty);
                    String string = content = formatValue == null ? " " : formatValue.toString();
                    fieldDataList.add(isBillNo ? HoverContent.createHref((String)content, (DynamicObject)billObj) : (isUser ? HoverContent.createChat((String)content, (Object)valueAndName.getRefValue()) : HoverContent.createText((String)content)));
                    continue;
                }
                fieldDataList.add(HoverContent.createText((String)" "));
                continue;
            }
            if (!billType.equals("attachmentField")) {
                String templateNumber = numberIdMapping.getNumberByOldId(Long.valueOf(billType));
                Object newTemplateId = numberIdMapping.getNewIdByNumber(templateNumber);
                String string = billType = newTemplateId == null ? "" : newTemplateId.toString();
            }
            if (billType.equalsIgnoreCase(String.valueOf(templateId)) || decisionFrontEndConfigField.getPropName().contains("filename")) {
                String fieldName = templateId == null ? decisionFrontEndConfigField.getPropName() : IDIStringUtils.buildTemplateField((String)numberIdMapping.getNumberByNewId(templateId), (String)decisionFrontEndConfigField.getPropName());
                Object fieldValue = attachmentDataMapNew.get(fieldName);
                String content = fieldValue instanceof Date ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)fieldValue) : String.valueOf(fieldValue);
                fieldDataList.add(HoverContent.createText((String)content));
                continue;
            }
            SchemaExecutorLogger.info((String)("value is null in attachment, field:" + decisionFrontEndConfigField.getPropName() + "billtype:" + billType + "templateId:" + templateId), (Object[])new Object[0]);
            fieldDataList.add(HoverContent.createText((String)" "));
        }
        decisionFrontEndResult.addHoverContent(titles);
        decisionFrontEndResult.addHoverContent(fieldDataList);
        return decisionFrontEndResult;
    }

    private boolean isHead(String entryName) {
        return "".equals(entryName);
    }

    private BigDecimal calPercent(int attachmentSize, DynamicObject billObj, String entryName, String startConditionEntry, List<Integer> matchStartConditionEntryIndexList, int noConfidenceCount) {
        int entryRowCount;
        int successCount = attachmentSize + noConfidenceCount;
        BigDecimal percent = this.isHead(entryName) ? DecisionResult.HUNDRED.divide(BigDecimal.valueOf(successCount, 0), 6, RoundingMode.HALF_UP) : (!entryName.equals(startConditionEntry) ? ((entryRowCount = billObj.getDynamicObjectCollection(entryName).size()) == 0 ? DecisionResult.ZEROED : DecisionResult.HUNDRED.divide(BigDecimal.valueOf((long)successCount * (long)entryRowCount, 0), 6, RoundingMode.HALF_UP)) : DecisionResult.HUNDRED.divide(BigDecimal.valueOf((long)successCount * (long)matchStartConditionEntryIndexList.size(), 0), 6, RoundingMode.HALF_UP));
        return percent;
    }

    private void noExistsAttachmentException(AIAttachmentConfig aiAttachmentConfig, DecisionResult decisionResult) {
        ExceptionTip noExistsTip = this.matchExceptionTip(aiAttachmentConfig, ExceptionTipEnum.NOEXISTS);
        decisionResult.setStatus(noExistsTip.getShowErrorTips() != false ? "empty" : "alarming");
        decisionResult.setShowText(noExistsTip.achieveTipWords());
        this.deductionGrade.deduct(noExistsTip.getShowErrorTips() != false ? 0 : noExistsTip.getPercent());
    }

    private boolean canStart(AIAttachmentConfig aiAttachmentConfig, Map<String, Object> ctx, DynamicObjectType mainType, List<Integer> matchStartConditionEntryIndexList, String entryName) {
        if (aiAttachmentConfig.getStartCondition() != null && StringUtils.isNotEmpty((String)aiAttachmentConfig.getStartCondition().getScript())) {
            boolean matchData;
            String entityType = mainType.getName();
            IDICondition condition = aiAttachmentConfig.getStartCondition();
            String script = condition.getScript();
            DynamicObject bizObj = (DynamicObject)ctx.get(entityType + "_billObj");
            int sourceEntrySize = StringUtils.isEmpty((String)entryName) ? 1 : bizObj.getDynamicObjectCollection(entryName).size();
            ctx.put("rowSize", sourceEntrySize);
            ctx.put("__matchEntryIndexList__", matchStartConditionEntryIndexList);
            ScriptLocaleFieldHandler scriptLocaleFieldHandler = new ScriptLocaleFieldHandler();
            String localeScript = scriptLocaleFieldHandler.processLocaleField(script, new String[]{entityType}, bizObj);
            String entryScript = ScriptUtils.supportEntryPropertyStringIndex(mainType, localeScript, "i");
            String ifStem = "if(%s){\n  __matchEntryIndexList__.add(i);\n}";
            String ifScript = String.format(ifStem, entryScript);
            String forStem = "for(var i=0; i<rowSize; i++){\n%s}";
            String forScript = String.format(forStem, ifScript);
            ScriptFormIdHandler.runScript((String)entityType, null, ctx, (String)forScript);
            boolean bl = matchData = !matchStartConditionEntryIndexList.isEmpty();
            if (StringUtils.isEmpty((String)entryName)) {
                matchStartConditionEntryIndexList.clear();
            }
            return matchData;
        }
        return true;
    }

    private ExceptionTip matchExceptionTip(AIAttachmentConfig attachmentConfig, ExceptionTipEnum tipEnum) {
        List<ExceptionTip> exceptionTipList = attachmentConfig.getExceptionTipList();
        if (exceptionTipList == null || exceptionTipList.isEmpty()) {
            throw new AITipException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5f02\u5e38\u60c5\u51b5\u5904\u7406\u4fe1\u606f", (String)"AttachmentExecutor_7", (String)"data-idi-core", (Object[])new Object[0]));
        }
        Optional<ExceptionTip> matException = exceptionTipList.stream().filter(tip -> tip.getExceptionTipItem() == tipEnum).findAny();
        if (matException.isPresent()) {
            return matException.get();
        }
        String templateStr = ResManager.loadKDString((String)"\u672a\u914d\u7f6e%s\u5f02\u5e38\u60c5\u51b5\u5904\u7406\u4fe1\u606f", (String)"AttachmentExecutor_8", (String)"data-idi-core", (Object[])new Object[0]);
        String error = String.format(templateStr, tipEnum.convertDescription());
        throw new AITipException(error);
    }

    private DecisionResult notMatchStartCondition(AIAttachmentConfig aiAttachmentConfig, DecisionResult decisionResult) {
        ExceptionTip et = this.matchExceptionTip(aiAttachmentConfig, ExceptionTipEnum.NO_MATCH_START);
        if (et.getShowErrorTips().booleanValue()) {
            decisionResult.setStatus("empty");
            this.deductionGrade.deduct(0);
        } else {
            decisionResult.setStatus("alarming");
            this.deductionGrade.deduct(et.getPercent());
            decisionResult.setShowText(et.achieveTipWords());
        }
        decisionResult.setDeductPercent(this.deductionGrade.getValue());
        return decisionResult;
    }
}

