/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.data.AlarmConfig;
import kd.data.idi.data.AlarmResult;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionFrontEndResult;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.DeductionGradeConfig;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.data.statistics.AlarmHoverSettingRow;
import kd.data.idi.engine.AlarmFormula;
import kd.data.idi.engine.DecisionExecutor;
import kd.data.idi.engine.DeductionGrade;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.SelectDecisionExecutor;
import kd.data.idi.engine.ai.service.ISimilarService;
import kd.data.idi.util.DeductionGradeConfigUtil;
import kd.data.idi.util.IDIDateUtils;
import kd.data.idi.util.IDIJSONUtils;

public class AlarmExecutor
extends SelectDecisionExecutor
implements DecisionExecutor {
    private Map<String, String> entryMarkMap;
    private MainEntityType billType;
    private DynamicObject billObj;
    private SchemaContext context;
    private static final Long ZERO = 0L;
    private Map<String, Integer> entryLimitMap = new HashMap<String, Integer>(3);

    public DecisionResult execute(SchemaContext context, Decision decision) {
        AlarmConfig alarmConfig = decision.getAlarm();
        if (alarmConfig == null) {
            return null;
        }
        FilterCondition filterCondition = alarmConfig.getFilterCondition();
        if (filterCondition == null || filterCondition.getFilterRow() == null || filterCondition.getFilterRow().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u80fd\u7b5b\u9009\u51fa\u5386\u53f2\u5bf9\u6bd4\u5355\u636e", (String)"AlarmExecutor_1", (String)"data-idi-core", (Object[])new Object[0]));
        }
        DynamicObject billObj = ExecutorHelper.getSelfBill(context);
        CloneUtils cloneUtils = new CloneUtils(false, false);
        billObj = (DynamicObject)cloneUtils.clone((IDataEntityBase)billObj);
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)context.getEntityType());
        Map allEntities = billType.getAllEntities();
        HashMap<String, String> entryMarkMap = new HashMap<String, String>(50);
        for (Map.Entry typeEntry : allEntities.entrySet()) {
            if (!(typeEntry.getValue() instanceof EntryType)) continue;
            for (IDataEntityProperty property : ((EntityType)typeEntry.getValue()).getProperties()) {
                entryMarkMap.put(property.getName(), (String)typeEntry.getKey());
            }
        }
        List rows = filterCondition.getFilterRow();
        IDICondition startCondition = alarmConfig.getStartCondition();
        MainEntityType srcEntityType = context.getSrcEntityType();
        if (startCondition != null && StringUtils.isNotEmpty((String)startCondition.getScript())) {
            String startConditionEntry = null;
            SelectDecisionExecutor.StartConditionParam param = new SelectDecisionExecutor.StartConditionParam(context.getSelfBill(), context.getSrcEntityType(), startCondition, false);
            if (!this.checkStartCondition(param)) {
                return this.notMatchStartCondition(decision, new DeductionGrade(context));
            }
            startConditionEntry = param.getStartEntry();
            List<Integer> matchStartConditionEntryIndexList = param.getMatchEntryIndexList();
            if (StringUtils.isNotEmpty((String)startConditionEntry) && !CollectionUtils.isEmpty(matchStartConditionEntryIndexList)) {
                DynamicObjectCollection entryCollection = billObj.getDynamicObjectCollection(startConditionEntry);
                ArrayList<Object> retainEntryObj = new ArrayList<Object>(10);
                for (Integer entryIndex : matchStartConditionEntryIndexList) {
                    retainEntryObj.add(entryCollection.get(entryIndex.intValue()));
                }
                entryCollection.clear();
                entryCollection.addAll(retainEntryObj);
            }
        }
        this.entryMarkMap = entryMarkMap;
        this.billType = billType;
        this.billObj = billObj;
        this.context = context;
        AlarmFormula formula = AlarmFormula.createFormula((List)rows, (AlarmExecutor)this);
        Map sameIdMap = formula.calculate();
        SchemaExecutorLogger.info((String)(decision.getName() + "\n sameId match count:" + sameIdMap.size()), (Object[])new Object[0]);
        Map<Object, Map> collect = sameIdMap.entrySet().stream().limit(30L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        SchemaExecutorLogger.info((String)(decision.getName() + "\n sameIdMap structure: " + IDIJSONUtils.toJsonString(collect)), (Object[])new Object[0]);
        DecisionResult result = new DecisionResult();
        result.setDecision(decision);
        DeductionGrade deductionGrade = new DeductionGrade(context);
        String limitMesg = "";
        AlarmResult alarmResult = null;
        if (!this.entryLimitMap.isEmpty()) {
            alarmResult = new AlarmResult();
            alarmResult.setOverLimit(true);
            Optional<Integer> minLimitOp = this.entryLimitMap.values().stream().sorted().findFirst();
            if (minLimitOp.isPresent()) {
                String msg = ResManager.loadKDString((String)"\u3010\u53d6\u524d%d\u884c\u3011", (String)"AlarmExecutor_8", (String)"data-idi-core", (Object[])new Object[0]);
                limitMesg = String.format(msg, minLimitOp.get());
                alarmResult.setMinLimitCount(minLimitOp.get());
            }
        }
        result.setAlarmResult(alarmResult);
        if (!sameIdMap.isEmpty()) {
            DecisionFrontEndResult decisionFrontEndResult = this.getDecisionFrontEndResult(alarmConfig, context, sameIdMap);
            result.setFrontEndResult(decisionFrontEndResult);
            result.setShowText(limitMesg + alarmConfig.getFailText());
            result.setStatus("alarming");
            if (alarmConfig.isCheckVote()) {
                result.setOneVoteVeto(true);
            }
            deductionGrade.deduct(100);
            if (alarmResult != null) {
                alarmResult.setOriginalShowText(alarmConfig.getFailText());
            }
        } else {
            result.setShowText(limitMesg + alarmConfig.getSuccessText());
            result.setStatus("green");
            deductionGrade.deduct(0);
            if (alarmResult != null) {
                alarmResult.setOriginalShowText(alarmConfig.getSuccessText());
            }
        }
        result.setDeductPercent(deductionGrade.getValue());
        return result;
    }

    public Map<Object, Map<String, Set<Object>>> executeFilter(List<SimpleFilterRow> rows) {
        ArrayList allFilters = new ArrayList(10);
        ArrayList<SimpleFilterRow> leftOrFilter = new ArrayList<SimpleFilterRow>(10);
        for (SimpleFilterRow row : rows) {
            leftOrFilter.add(row);
            if (!row.getLogic().equals("1")) continue;
            allFilters.add(leftOrFilter);
            leftOrFilter = new ArrayList(10);
        }
        if (!leftOrFilter.isEmpty()) {
            allFilters.add(leftOrFilter);
        }
        HashMap<Object, Map<String, Set<Object>>> sameIdMap = new HashMap<Object, Map<String, Set<Object>>>(10);
        for (List list : allFilters) {
            Map<Object, Map<String, Set<Object>>> idMap = this.checkRepetition(list, this.entryMarkMap, this.billType, this.billObj, this.context);
            if (idMap.isEmpty()) continue;
            for (Map.Entry<Object, Map<String, Set<Object>>> entry : idMap.entrySet()) {
                if (sameIdMap.get(entry.getKey()) == null || ((Map)sameIdMap.get(entry.getKey())).isEmpty()) {
                    sameIdMap.put(entry.getKey(), entry.getValue());
                    continue;
                }
                Map entryMap = (Map)sameIdMap.get(entry.getKey());
                for (Map.Entry<String, Set<Object>> entityEntry : entry.getValue().entrySet()) {
                    if (entryMap.get(entityEntry.getKey()) == null) {
                        entryMap.put(entityEntry.getKey(), entityEntry.getValue());
                        continue;
                    }
                    ((Set)entryMap.get(entityEntry.getKey())).addAll((Collection)entityEntry.getValue());
                }
            }
        }
        return sameIdMap;
    }

    private DecisionFrontEndResult getDecisionFrontEndResult(AlarmConfig alarmConfig, SchemaContext context, Map<Object, Map<String, Set<Object>>> sameIdMap) {
        List sortPkList;
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)context.getEntityType());
        String noOrNumberField = billType instanceof BasedataEntityType ? "number" : "billno";
        HashSet<String> fieldSet = new HashSet<String>(10);
        fieldSet.add("id");
        fieldSet.add(noOrNumberField);
        if (!CollectionUtils.isEmpty(alarmConfig.getHoverSetting())) {
            alarmConfig.getHoverSetting().forEach(hs -> fieldSet.add(hs.getPropName()));
        }
        Set<Object> billIds = sameIdMap.keySet();
        Object[] sortPks = null;
        Class primaryKeyType = billType.getPrimaryKey().getPropertyType();
        sortPks = Long.TYPE == primaryKeyType || Long.class == primaryKeyType ? Arrays.stream(billIds.toArray()).sorted((id1, id2) -> -1 * Long.compare(Long.parseLong(id1.toString()), Long.parseLong(id2.toString()))).limit(3L).toArray() : (billType.findProperty("createtime") != null ? (!CollectionUtils.isEmpty((Collection)(sortPkList = QueryServiceHelper.queryPrimaryKeys((String)context.getEntityType(), (QFilter[])new QFilter[]{new QFilter(billType.getPrimaryKey().getName(), "in", billIds)}, (String)"createtime desc", (int)3))) ? sortPkList.toArray() : billIds.stream().limit(3L).toArray()) : billIds.stream().limit(3L).toArray());
        List<DynamicObject> firstThreeBillSByCreateTime = Arrays.asList(ExecutorHelper.loadObjects(sortPks, context.getEntityType(), fieldSet, 5));
        DecisionFrontEndResult frontEndResult = new DecisionFrontEndResult();
        ArrayList<String> headTitleList = new ArrayList<String>();
        headTitleList.add(ResManager.loadKDString((String)"\u7591\u4f3c\u91cd\u590d\u5355\u636e\u7f16\u53f7", (String)"AlarmExecutor_4", (String)"data-idi-core", (Object[])new Object[0]));
        headTitleList.addAll(alarmConfig.getHoverSetting().stream().map(row -> {
            row.setEntityNumber(billType.getName());
            return StringUtils.isNotEmpty((String)row.getDisplayName()) ? row.getDisplayName() : row.getPropDisplayName();
        }).collect(Collectors.toList()));
        frontEndResult.setHeadTitleList(headTitleList);
        ArrayList<String> headFieldNumbers = new ArrayList<String>();
        LinkedHashMap<String, List> entryNumbers = new LinkedHashMap<String, List>();
        for (AlarmHoverSettingRow alarmHoverSettingRow : alarmConfig.getHoverSetting()) {
            String propName = alarmHoverSettingRow.getPropName();
            String firstName = propName.split("\\.")[0];
            DynamicProperty firstLevelOfProperty = billType.getProperty(firstName);
            if (firstLevelOfProperty instanceof EntryProp) {
                List values = entryNumbers.computeIfAbsent(firstName, key -> new ArrayList());
                if (values.contains(propName)) continue;
                values.add(propName);
                continue;
            }
            headFieldNumbers.add(propName);
        }
        for (DynamicObject bill : firstThreeBillSByCreateTime) {
            Long billId = bill.getLong("id");
            Map<String, Set<Object>> entryIdsMap = sameIdMap.get(billId);
            if (CollectionUtils.isEmpty(entryNumbers) || CollectionUtils.isEmpty(entryIdsMap)) {
                ArrayList<HoverContent> hoverContentOfRow = new ArrayList<HoverContent>(10);
                hoverContentOfRow.add(HoverContent.createHref((String)bill.getString(noOrNumberField), (Object)bill.get("id"), (String)context.getEntityType()));
                for (AlarmHoverSettingRow alarmHoverSettingRow : alarmConfig.getHoverSetting()) {
                    String propName = alarmHoverSettingRow.getPropName();
                    if (!headFieldNumbers.contains(propName)) continue;
                    ExecutorHelper.ValueAndName valueAndName = ExecutorHelper.alarmGetValueAndNameByName(bill, propName, true);
                    IDataEntityProperty entityProperty = valueAndName.getEntityProperty();
                    Object value = ExecutorHelper.tryToString(bill, bill, valueAndName.getValue(), entityProperty);
                    String headFieldValue = value instanceof OrmLocaleValue ? value.toString() : (String)value;
                    HoverContent headFieldHoverContent = HoverContent.createText((String)(StringUtils.isNotEmpty((String)headFieldValue) ? headFieldValue : ""));
                    hoverContentOfRow.add(headFieldHoverContent);
                }
                frontEndResult.addHoverContent(hoverContentOfRow);
                continue;
            }
            for (Map.Entry currentEntryEntry : entryNumbers.entrySet()) {
                String currentEntryNumber = (String)currentEntryEntry.getKey();
                Set<Object> sameEntryIds = entryIdsMap.get(currentEntryNumber);
                if (CollectionUtils.isEmpty(sameEntryIds)) continue;
                for (Object sameEntryId : sameEntryIds) {
                    ArrayList<HoverContent> hoverContentOfRow = new ArrayList<HoverContent>(10);
                    hoverContentOfRow.add(HoverContent.createHref((String)bill.getString(noOrNumberField), (Object)bill.get("id"), (String)context.getEntityType()));
                    for (AlarmHoverSettingRow alarmHoverSettingRow : alarmConfig.getHoverSetting()) {
                        IDataEntityProperty entityProperty;
                        String propName = alarmHoverSettingRow.getPropName();
                        if (headFieldNumbers.contains(propName)) {
                            ExecutorHelper.ValueAndName valueAndName = ExecutorHelper.alarmGetValueAndNameByName(bill, propName, true);
                            entityProperty = valueAndName.getEntityProperty();
                            Object headFieldValue = ExecutorHelper.tryToString(bill, bill, valueAndName.getValue(), entityProperty);
                            HoverContent headFieldHoverContent = HoverContent.createText((String)(ObjectUtils.isEmpty((Object)headFieldValue) ? "" : headFieldValue.toString()));
                            hoverContentOfRow.add(headFieldHoverContent);
                            continue;
                        }
                        if (currentEntryNumber.equals(propName.split("\\.")[0])) {
                            ExecutorHelper.ValueAndName entryValueAndName = ExecutorHelper.alarmGetValueAndNameByName(bill, propName, true);
                            entityProperty = entryValueAndName.getEntityProperty();
                            List values = (List)entryValueAndName.getValue();
                            List<Object> entryIds = entryValueAndName.getEntryIds();
                            Object value = null;
                            if (!CollectionUtils.isEmpty(entryIds)) {
                                value = values.get(entryIds.indexOf(sameEntryId));
                            }
                            hoverContentOfRow.add(HoverContent.createText((String)((value = ExecutorHelper.tryToString(bill, bill, value, entityProperty)) != null ? value.toString() : "")));
                            continue;
                        }
                        hoverContentOfRow.add(HoverContent.createText((String)""));
                    }
                    frontEndResult.addHoverContent(hoverContentOfRow);
                }
            }
        }
        HashMap<String, Object> customParamMap = new HashMap<String, Object>(2);
        customParamMap.put("entityNumber", context.getEntityType());
        customParamMap.put("sameBillIds", new ArrayList<Object>(billIds));
        frontEndResult.setCustomParamMap(customParamMap);
        return frontEndResult;
    }

    private Map<Object, Map<String, Set<Object>>> checkRepetition(List<SimpleFilterRow> filterRows, Map<String, String> entryMarkMap, MainEntityType billType, DynamicObject billObj, SchemaContext context) {
        String entityName = billType.getName();
        LinkedHashMap entryMap = new LinkedHashMap(10);
        entryMap.put(entityName, new ArrayList(0));
        for (SimpleFilterRow filterRow : filterRows) {
            String fieldName = filterRow.getFieldName();
            String[] prop = fieldName.split("\\.");
            String key = entityName;
            for (String s : prop) {
                if (entryMarkMap.get(s) == null) continue;
                key = entryMarkMap.get(s);
                break;
            }
            if (entryMap.get(key) == null) {
                entryMap.put(key, new ArrayList<SimpleFilterRow>(Collections.singletonList(filterRow)));
                continue;
            }
            ((List)entryMap.get(key)).add(filterRow);
        }
        String billStatusField = billType instanceof BillEntityType ? ((BillEntityType)billType).getBillStatus() : null;
        IDataEntityType currentBillType = billObj.getDataEntityType();
        Map fieldMap = null;
        if (currentBillType instanceof MainEntityType) {
            fieldMap = ((MainEntityType)currentBillType).getAllFields();
        }
        Map<Object, Map<String, Set<Object>>> lastSameIdMap = new HashMap<Object, Map<String, Set<Object>>>(10);
        for (Map.Entry entry : entryMap.entrySet()) {
            if (entry.getValue() == null || ((List)entry.getValue()).isEmpty()) continue;
            boolean mainType = entityName.equals(entry.getKey());
            Map<Object, Map<String, Set<Object>>> tempSameIdMap = this.checkSameEntityIds((List)entry.getValue(), billStatusField, billObj, fieldMap, billType, mainType, context, lastSameIdMap.keySet(), (String)entry.getKey());
            if (tempSameIdMap.isEmpty()) {
                lastSameIdMap = tempSameIdMap;
                break;
            }
            if (!mainType) {
                for (Map.Entry<Object, Map<String, Set<Object>>> mapEntry : tempSameIdMap.entrySet()) {
                    Map<String, Set<Object>> lastMap = lastSameIdMap.get(mapEntry.getKey());
                    if (lastMap == null) continue;
                    mapEntry.getValue().putAll(lastMap);
                }
            }
            lastSameIdMap = tempSameIdMap;
        }
        return lastSameIdMap;
    }

    private Map<Object, Map<String, Set<Object>>> checkSameEntityIds(List<SimpleFilterRow> filterRows, String billStatusField, DynamicObject billObj, Map<String, IDataEntityProperty> fieldMap, MainEntityType billType, boolean mainType, SchemaContext context, Set<Object> lastSameIds, String entityName) {
        HashMap<Object, Map<String, Set<Object>>> sameIdMap = new HashMap<Object, Map<String, Set<Object>>>(10);
        HashMap entryValueMap = new HashMap(10);
        int entryCount = 0;
        HashSet<String> similarProps = new HashSet<String>();
        int index = 0;
        while (index < filterRows.size()) {
            SimpleFilterRow filterRow = filterRows.get(index);
            String fieldName = filterRow.getFieldName();
            if (StringUtils.isNotEmpty((String)billStatusField) && billStatusField.equals(fieldName)) {
                ++index;
                continue;
            }
            String fullFieldName = this.getFullFieldName(fieldName, fieldMap, billType.getName());
            ExecutorHelper.ValueAndName valueAndName = ExecutorHelper.alarmGetValueAndNameByName(billObj, fullFieldName, true);
            Object fieldValue = valueAndName.getValue();
            IDataEntityProperty prop = valueAndName.getEntityProperty();
            boolean isMuliLang = prop instanceof MuliLangTextProp;
            SchemaExecutorLogger.info((String)("field:" + fieldName + ", value:" + fieldValue), (Object[])new Object[0]);
            if (mainType) {
                if ("SIMILAR".equals(filterRow.getCompareType())) {
                    similarProps.add(filterRow.getFieldName());
                    filterRows.remove(index);
                    --index;
                } else {
                    this.constrcutFilterRow(filterRow, fieldValue == null ? fieldValue : (isMuliLang ? String.valueOf(fieldValue) : fieldValue));
                }
            } else if (fieldValue instanceof List) {
                List newFiledValue = ((List)fieldValue).stream().map(obj -> obj == null ? obj : (isMuliLang ? String.valueOf(obj) : obj)).collect(Collectors.toList());
                entryValueMap.put(fieldName, newFiledValue);
                entryCount = ((List)fieldValue).size();
                if (entryCount == 0) {
                    Map allEntities = billType.getAllEntities();
                    if (fullFieldName != null) {
                        EntityType entityType = (EntityType)allEntities.get(fullFieldName.split("\\.")[0]);
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55: %1$s\u4e0d\u5b58\u5728\u5206\u5f55\u884c\uff0c\u65e0\u6cd5\u8fdb\u884c\u4e8b\u4ef6\u91cd\u590d\u68c0\u67e5\u3002", (String)"AlarmExecutor_5", (String)"data-idi-core", (Object[])new Object[0]), entityType.getDisplayName()));
                    }
                }
            }
            ++index;
        }
        QFilter totalFilter = null;
        if (!mainType) {
            SimpleFilterRow firstFilterRow = filterRows.get(0);
            if (filterRows.size() == 1 && entryCount > 1 && this.canInOrNotIn(firstFilterRow, fieldMap)) {
                List fieldValue = (List)entryValueMap.get(firstFilterRow.getFieldName());
                totalFilter = this.processInOrNotIn(firstFilterRow, fieldMap, fieldValue);
            } else {
                int loopCountLimit;
                int loopCount = loopCountLimit = 1600 / filterRows.size();
                if (entryCount > loopCountLimit) {
                    this.entryLimitMap.put(entityName, loopCountLimit);
                } else {
                    loopCount = entryCount;
                }
                ArrayList<String> entryFieldValueList = new ArrayList<String>(Math.max(10, entryCount));
                for (int i = 0; i < loopCount; ++i) {
                    StringBuilder fieldValueSb = new StringBuilder();
                    List collect = filterRows.stream().map(SimpleFilterRow::clone).collect(Collectors.toList());
                    for (SimpleFilterRow filterRow : collect) {
                        Object value = ((List)entryValueMap.get(filterRow.getFieldName())).get(i);
                        fieldValueSb.append(filterRow.getFieldName()).append("-").append((Object)(value == null ? "" : value)).append(",");
                        this.constrcutFilterRow(filterRow, value);
                    }
                    if (entryFieldValueList.contains(fieldValueSb.toString())) continue;
                    entryFieldValueList.add(fieldValueSb.toString());
                    FilterCondition filterCondition = new FilterCondition();
                    filterCondition.setFilterRow(collect);
                    FilterBuilder filterBuilder = new FilterBuilder(billType, filterCondition);
                    try {
                        filterBuilder.buildFilter(false);
                    }
                    catch (Exception ex) {
                        SchemaExecutorLogger.error((String)IDIJSONUtils.toJsonString((Object)filterCondition), (Throwable)ex);
                        filterBuilder.setQFilter(null);
                    }
                    QFilter qFilter = filterBuilder.getQFilter();
                    if (qFilter == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u80fd\u7b5b\u9009\u51fa\u5386\u53f2\u5bf9\u6bd4\u5355\u636e", (String)"AlarmExecutor_1", (String)"data-idi-core", (Object[])new Object[0]));
                    }
                    totalFilter = totalFilter == null ? qFilter : QFilter.or((QFilter)totalFilter, (QFilter)qFilter);
                }
            }
        } else {
            FilterCondition filterCondition = new FilterCondition();
            filterCondition.setFilterRow(filterRows);
            FilterBuilder filterBuilder = new FilterBuilder(billType, filterCondition);
            try {
                filterBuilder.buildFilter(false);
            }
            catch (Exception ex) {
                SchemaExecutorLogger.error((String)IDIJSONUtils.toJsonString((Object)filterCondition), (Throwable)ex);
                filterBuilder.setQFilter(null);
            }
            totalFilter = filterBuilder.getQFilter();
            if (totalFilter == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u80fd\u7b5b\u9009\u51fa\u5386\u53f2\u5bf9\u6bd4\u5355\u636e", (String)"AlarmExecutor_1", (String)"data-idi-core", (Object[])new Object[0]));
            }
        }
        if (context.getBillId() != null) {
            QFilter ignoreSelfBill = new QFilter(billType.getPrimaryKey().getName(), "!=", context.getBillId());
            totalFilter = QFilter.and((QFilter)totalFilter, (QFilter)ignoreSelfBill);
        }
        if (lastSameIds != null && !lastSameIds.isEmpty()) {
            totalFilter = QFilter.and((QFilter)totalFilter, (QFilter)new QFilter(billType.getPrimaryKey().getName(), "in", lastSameIds));
        }
        String noOrNumberField = billType instanceof BasedataEntityType ? "number" : "billno";
        StringBuilder selectProperties = new StringBuilder(noOrNumberField);
        for (String similarProp : similarProps) {
            selectProperties.append(',').append(similarProp);
        }
        String entryName = null;
        if (!mainType) {
            entryName = entityName + ".id";
            selectProperties.append(',').append(entryName);
        }
        selectProperties.append(',').append("id");
        if (totalFilter == null) {
            return Collections.emptyMap();
        }
        DynamicObjectCollection sameBillList = QueryServiceHelper.query((String)context.getEntityType(), (String)selectProperties.toString(), (QFilter[])new QFilter[]{totalFilter}, (String)"id desc", (int)10000);
        SchemaExecutorLogger.info((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u91cd\u590d\u5355\u636e\u8fc7\u6ee4\u6761\u4ef6\uff1a%s", (String)"AlarmExecutor_2", (String)"data-idi-core", (Object[])new Object[0]), totalFilter), (Object[])new Object[0]);
        SchemaExecutorLogger.info((String)("checkSameEntityIds match count:" + (sameBillList == null ? 0 : sameBillList.size())), (Object[])new Object[0]);
        if (sameBillList != null && !sameBillList.isEmpty()) {
            if (!similarProps.isEmpty()) {
                List<Integer> similarTextList = this.similar(similarProps, billObj, sameBillList);
                if (!similarTextList.isEmpty()) {
                    for (Integer integer : similarTextList) {
                        DynamicObject sameBill = (DynamicObject)sameBillList.get(integer.intValue());
                        sameIdMap.put(sameBill.get("id"), new HashMap(0));
                    }
                }
            } else {
                for (DynamicObject sameBill : sameBillList) {
                    Object pkId = sameBill.get("id");
                    if (mainType) {
                        sameIdMap.put(pkId, new HashMap(0));
                        continue;
                    }
                    Object value = sameBill.get(entryName);
                    if (ZERO.equals(value)) continue;
                    HashMap<String, HashSet<Object>> entryMap = (HashMap<String, HashSet<Object>>)sameIdMap.get(pkId);
                    if (entryMap == null) {
                        entryMap = new HashMap<String, HashSet<Object>>(6);
                        entryMap.put(entityName, new HashSet<Object>(Collections.singletonList(value)));
                        sameIdMap.put(pkId, entryMap);
                        continue;
                    }
                    if (entryMap.get(entityName) == null) {
                        entryMap.put(entityName, new HashSet<Object>(Collections.singletonList(value)));
                        continue;
                    }
                    ((Set)entryMap.get(entityName)).add(value);
                }
            }
        }
        SchemaExecutorLogger.info((String)("checkSameEntityIds result match count:" + sameIdMap.size()), (Object[])new Object[0]);
        return sameIdMap;
    }

    private QFilter processInOrNotIn(SimpleFilterRow filterRow, Map<String, IDataEntityProperty> fieldMap, List<Object> dataList) {
        SimpleFilterRow newFilterRow = filterRow.clone();
        IDataEntityProperty property = this.findFieldProp(filterRow, fieldMap);
        String compareType = filterRow.getCompareType();
        DateFormat dateFormat = KDDateFormatUtils.getDateTimeFormat();
        List<Object> newDataList = new ArrayList(dataList.size());
        if (property instanceof DateTimeProp) {
            for (int i = 0; i < dataList.size(); ++i) {
                String dateStr = dateFormat.format((Date)dataList.get(i));
                newDataList.add(dateStr);
            }
        } else {
            newDataList = dataList;
        }
        if (CompareTypeEnum.EQUAL.getId().equals(compareType)) {
            newFilterRow.setCompareType(CompareTypeEnum.IN.getId());
        }
        if (CompareTypeEnum.NOTEQUAL.getId().equals(compareType)) {
            newFilterRow.setCompareType(CompareTypeEnum.NOTIN.getId());
        }
        if (CompareTypeEnum.ORGEQUAL.getId().equals(compareType)) {
            newFilterRow.setCompareType(CompareTypeEnum.ORGIN.getId());
        }
        if (CompareTypeEnum.ORGNOTEQUAL.getId().equals(compareType)) {
            newFilterRow.setCompareType(CompareTypeEnum.ORGNOTIN.getId());
        }
        ArrayList<FilterValue> fvList = new ArrayList<FilterValue>(dataList.size());
        boolean hasNull = false;
        for (Object o : newDataList) {
            if (o == null || o instanceof String && StringUtils.isEmpty((String)((String)o))) {
                hasNull = true;
                continue;
            }
            FilterValue filterValue = new FilterValue();
            filterValue.setValue(o);
            fvList.add(filterValue);
        }
        newFilterRow.setValue(fvList);
        ArrayList<SimpleFilterRow> collect = new ArrayList<SimpleFilterRow>(1);
        collect.add(newFilterRow);
        if (hasNull) {
            newFilterRow.setLogic("1");
            SimpleFilterRow nullFilterRow = filterRow.clone();
            nullFilterRow.setCompareType(CompareTypeEnum.ISNULL.getId());
            ArrayList nullfvList = new ArrayList(1);
            nullFilterRow.setValue(nullfvList);
            collect.add(nullFilterRow);
        }
        FilterCondition filterCondition = new FilterCondition();
        filterCondition.setFilterRow(collect);
        FilterBuilder filterBuilder = new FilterBuilder(this.billType, filterCondition);
        try {
            filterBuilder.buildFilter(false);
        }
        catch (Exception ex) {
            SchemaExecutorLogger.error((String)IDIJSONUtils.toJsonString((Object)filterCondition), (Throwable)ex);
            filterBuilder.setQFilter(null);
        }
        QFilter qFilter = filterBuilder.getQFilter();
        if (qFilter == null) {
            SchemaExecutorLogger.error((String)("[data-idi]-alarm-filterCondition:" + IDIJSONUtils.toJsonString((Object)filterCondition)));
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u80fd\u7b5b\u9009\u51fa\u5386\u53f2\u5bf9\u6bd4\u5355\u636e", (String)"AlarmExecutor_1", (String)"data-idi-core", (Object[])new Object[0]));
        }
        if (property instanceof DateTimeProp) {
            qFilter.__setCP(CompareTypeEnum.EQUAL.getId().equals(compareType) || CompareTypeEnum.ORGEQUAL.getId().equals(compareType) ? "in" : "not in");
            qFilter.__setValue(dataList);
        }
        return qFilter;
    }

    private boolean canInOrNotIn(SimpleFilterRow filterRow, Map<String, IDataEntityProperty> fieldMap) {
        IDataEntityProperty property = this.findFieldProp(filterRow, fieldMap);
        String compareType = filterRow.getCompareType();
        return !(!(property instanceof DateTimeProp) && !(property instanceof TextProp) && !(property instanceof BasedataProp) && !(property instanceof DecimalProp) && !(property instanceof LongProp) || !CompareTypeEnum.EQUAL.getId().equals(compareType) && !CompareTypeEnum.NOTEQUAL.getId().equals(compareType) && !CompareTypeEnum.ORGEQUAL.getId().equals(compareType) && !CompareTypeEnum.ORGNOTEQUAL.getId().equals(compareType));
    }

    private IDataEntityProperty findFieldProp(SimpleFilterRow filterRow, Map<String, IDataEntityProperty> fieldMap) {
        String fieldName = filterRow.getFieldName();
        String onlyField = fieldName.indexOf(46) > 0 ? fieldName.substring(0, fieldName.indexOf(46)) : fieldName;
        return fieldMap.get(onlyField);
    }

    private void constrcutFilterRow(SimpleFilterRow filterRow, Object fieldValue) {
        Pattern pattern = Pattern.compile("^IDI_BETWEEN_([0-9]+)([MWC])$");
        DateFormat dateFormat = KDDateFormatUtils.getDateTimeFormat();
        Matcher matcher = pattern.matcher(filterRow.getCompareType());
        if (matcher.matches()) {
            if (fieldValue instanceof Date) {
                Date beginDate;
                Date endDate = (Date)fieldValue;
                filterRow.setCompareType(CompareTypeEnum.BETWEEN.getId());
                String d = matcher.group(1);
                String t = matcher.group(2);
                int dt = 1;
                if (!StringUtils.isEmpty((String)d)) {
                    try {
                        dt = Integer.parseInt(d);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if ("M".equals(t)) {
                    beginDate = KDDateUtils.addMonths((Date)endDate, (int)(-1 * dt));
                } else if ("W".equals(filterRow.getCompareType())) {
                    beginDate = KDDateUtils.addWeeks((Date)endDate, (int)(-1 * dt));
                } else if ("C".equals(t)) {
                    beginDate = IDIDateUtils.getTheMonthStartTime((Date)endDate);
                    endDate = IDIDateUtils.getTheMonthEndTime((Date)endDate);
                } else {
                    beginDate = KDDateUtils.addDays((Date)endDate, (int)-1);
                }
                ArrayList<FilterValue> fvList = new ArrayList<FilterValue>();
                FilterValue filterValue = new FilterValue();
                filterValue.setValue((Object)dateFormat.format(beginDate));
                fvList.add(filterValue);
                filterValue = new FilterValue();
                filterValue.setValue((Object)dateFormat.format(endDate));
                fvList.add(filterValue);
                filterRow.setValue(fvList);
            } else if (fieldValue == null || fieldValue instanceof OrmLocaleValue && fieldValue.toString() == null) {
                filterRow.setCompareType(CompareTypeEnum.ISNULL.getId());
                filterRow.setValue(Collections.emptyList());
            } else {
                filterRow.setCompareType(CompareTypeEnum.EQUAL.getId());
                FilterValue filterValue = new FilterValue();
                filterValue.setValue((Object)fieldValue.toString());
                filterRow.setValue(Collections.singletonList(filterValue));
            }
        } else if (!(CompareTypeEnum.TODAY.getId().equals(filterRow.getCompareType()) || CompareTypeEnum.YESTERDAY.getId().equals(filterRow.getCompareType()) || CompareTypeEnum.LESS.getId().equals(filterRow.getCompareType()) || CompareTypeEnum.LESSOREQUAL.getId().equals(filterRow.getCompareType()) || CompareTypeEnum.GREATER.getId().equals(filterRow.getCompareType()) || CompareTypeEnum.GREATEROREQUAL.getId().equals(filterRow.getCompareType()))) {
            if (fieldValue == null || fieldValue instanceof String && StringUtils.isEmpty((String)((String)fieldValue)) || fieldValue instanceof OrmLocaleValue && StringUtils.isEmpty((String)fieldValue.toString())) {
                filterRow.setCompareType(CompareTypeEnum.ISNULL.getId());
                filterRow.setValue(Collections.emptyList());
            } else {
                Object value;
                FilterValue filterValue = new FilterValue();
                if (fieldValue instanceof List) {
                    List mulValueList = (List)fieldValue;
                    if (mulValueList.isEmpty()) {
                        String error = ResManager.loadKDString((String)"%s\u4e0d\u5b58\u5728\u503c", (String)"AlarmExecutor_3", (String)"data-idi-core", (Object[])new Object[0]);
                        throw new KDBizException(String.format(error, filterRow.getFieldName()));
                    }
                    value = mulValueList.get(0);
                } else {
                    value = fieldValue instanceof Date ? dateFormat.format(fieldValue) : fieldValue;
                }
                filterValue.setValue((Object)value.toString());
                filterRow.setValue(Collections.singletonList(filterValue));
            }
        }
    }

    private String getFullFieldName(String fieldName, Map<String, IDataEntityProperty> fieldMap, String entityNumber) {
        if (fieldMap == null || fieldMap.isEmpty() || StringUtils.isEmpty((String)fieldName)) {
            return fieldName;
        }
        String onlyField = fieldName.indexOf(46) > 0 ? fieldName.substring(0, fieldName.indexOf(46)) : fieldName;
        String fullFieldName = fieldName;
        IDataEntityProperty property = fieldMap.get(onlyField);
        for (IDataEntityType entityType = property.getParent(); entityType != null && !entityNumber.equals(entityType.getName()); entityType = entityType.getParent()) {
            fullFieldName = entityType.getName() + "." + fullFieldName;
        }
        return fullFieldName;
    }

    private List<Integer> similar(Set<String> similarProps, DynamicObject billObj, DynamicObjectCollection sameBillList) {
        ArrayList<Integer> similarTextSeqList = new ArrayList<Integer>(10);
        for (String similarProp : similarProps) {
            List<String> theBillValues = this.getPropValues(billObj, similarProp);
            ArrayList<String> textList = new ArrayList<String>();
            for (DynamicObject sameBill : sameBillList) {
                String val = sameBill.getString(similarProp);
                textList.add(val);
            }
            for (String text : theBillValues) {
                List similarTextSeqs = ISimilarService.getInstance().textSimilar(text, textList);
                if (similarTextSeqs == null || similarTextSeqs.isEmpty()) continue;
                if (similarTextSeqList.isEmpty()) {
                    similarTextSeqList.addAll(similarTextSeqs);
                    continue;
                }
                similarTextSeqList.retainAll(similarTextSeqs);
            }
        }
        return similarTextSeqList;
    }

    private List<String> getPropValues(DynamicObject billObj, String similarProp) {
        ArrayList<String> theBillValues = new ArrayList<String>();
        Object value = ExecutorHelper.alarmGetValueAndNameByName(billObj, similarProp, false).getValue();
        if (value instanceof List) {
            List objs = (List)value;
            for (Object val : objs) {
                String valStr = val.toString();
                if (!StringUtils.isNotEmpty((String)valStr)) continue;
                theBillValues.add(valStr);
            }
        } else {
            String valueStr;
            String string = valueStr = value == null ? null : value.toString();
            if (StringUtils.isNotEmpty((String)valueStr)) {
                theBillValues.add(valueStr);
            }
        }
        return theBillValues;
    }

    public Map<Object, Map<String, Set<Object>>> logicCalculate(Map<Object, Map<String, Set<Object>>> leftMap, Map<Object, Map<String, Set<Object>>> rightMap, String logic) {
        Map<Object, Map<String, Set<Object>>> result = new HashMap<Object, Map<String, Set<Object>>>(10);
        if (leftMap != null && rightMap != null) {
            SchemaExecutorLogger.info((String)String.format("leftMap count: %1$s , rightMap count: %2$s, Logic : %3$s", leftMap.size(), rightMap.size(), logic), (Object[])new Object[0]);
            if ("1".equals(logic)) {
                for (Map.Entry<Object, Map<String, Set<Object>>> entry : leftMap.entrySet()) {
                    if (rightMap.get(entry.getKey()) == null || rightMap.get(entry.getKey()).isEmpty()) {
                        rightMap.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    Map<String, Set<Object>> entryMap = rightMap.get(entry.getKey());
                    for (Map.Entry<String, Set<Object>> entityEntry : entry.getValue().entrySet()) {
                        if (entryMap.get(entityEntry.getKey()) == null) {
                            entryMap.put(entityEntry.getKey(), entityEntry.getValue());
                            continue;
                        }
                        entryMap.get(entityEntry.getKey()).addAll((Collection<Object>)entityEntry.getValue());
                    }
                }
                result = rightMap;
            } else if ("0".equals(logic)) {
                result = new HashMap(10);
                for (Map.Entry<Object, Map<String, Set<Object>>> entry : leftMap.entrySet()) {
                    if (!rightMap.containsKey(entry.getKey())) continue;
                    Map<String, Set<Object>> rightEntryMap = rightMap.get(entry.getKey());
                    if (rightEntryMap == null || rightEntryMap.isEmpty()) {
                        result.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    Map<String, Set<Object>> leftEntryMap = entry.getValue();
                    if (leftEntryMap != null) {
                        for (Map.Entry<String, Set<Object>> leftEntry : leftEntryMap.entrySet()) {
                            String entityNumber = leftEntry.getKey();
                            if (rightEntryMap.containsKey(entityNumber)) {
                                rightEntryMap.get(entityNumber).retainAll((Collection)leftEntry.getValue());
                                continue;
                            }
                            rightEntryMap.put(entityNumber, leftEntry.getValue());
                        }
                    }
                    result.put(entry.getKey(), rightEntryMap);
                }
            }
        }
        return result;
    }

    public DecisionResult notMatchStartCondition(Decision decision, DeductionGrade deductionGrade) {
        SchemaExecutorLogger.info((String)ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u542f\u52a8\u6761\u4ef6\uff01", (String)"LinkUpBillDecisionExecutor_7", (String)"data-idi-core", (Object[])new Object[0]), (Object[])new Object[0]);
        AlarmConfig alarmConfig = decision.getAlarm();
        boolean isPass = DeductionGradeConfigUtil.findDeductionGradeConfigPass(alarmConfig.getDeductionGradeConfigList(), (DeductionGradeConfig.DeductionGradeItem)DeductionGradeConfig.DeductionGradeItem.STARTCONDITION_NOTMATCH);
        DecisionResult decisionResult = new DecisionResult();
        decisionResult.setStatus(isPass ? "empty" : "alarming");
        decisionResult.setShowText(ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6\u4e0d\u6ee1\u8db3", (String)"ExceptionTipEnum_2", (String)"data-idi-core", (Object[])new Object[0]));
        deductionGrade.deduct(alarmConfig.getDeductionGradeConfigList(), DeductionGradeConfig.DeductionGradeItem.STARTCONDITION_NOTMATCH);
        decisionResult.setDeductPercent(deductionGrade.getValue());
        decisionResult.setDecision(decision);
        return decisionResult;
    }
}

