/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.data.idi.model.BaseHighLight;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionFrontEndConfig;
import kd.data.idi.data.DecisionFrontEndConfigField;
import kd.data.idi.data.DecisionFrontEndResult;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.DecisionRule;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.LinkUpBillResult;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.data.SchemaParallelContext;
import kd.data.idi.data.attachment.AttachmentConfig;
import kd.data.idi.data.attachment.CheckAttachmentTypeEnum;
import kd.data.idi.data.attachment.CheckMethodEnum;
import kd.data.idi.data.attachment.ExceptionTip;
import kd.data.idi.data.attachment.ExceptionTipEnum;
import kd.data.idi.engine.DeductionGrade;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.ParamFactory;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.ScriptFormIdHandler;
import kd.data.idi.engine.ScriptLocaleFieldHandler;
import kd.data.idi.engine.ScriptUtils;
import kd.data.idi.engine.SelfBillDecisionExecutor;
import kd.data.idi.engine.attachment.AIParam;
import kd.data.idi.engine.attachment.AIRecognizerErrorInfo;
import kd.data.idi.engine.attachment.AIRecognizerParam;
import kd.data.idi.engine.attachment.AIRecognizerResult;
import kd.data.idi.engine.attachment.AIRecognizerSuccessInfo;
import kd.data.idi.engine.attachment.AITemplate;
import kd.data.idi.engine.attachment.Attachment;
import kd.data.idi.engine.attachment.AttachmentField;
import kd.data.idi.engine.attachment.AttachmentServiceFactory;
import kd.data.idi.engine.attachment.IAttachmentService;
import kd.data.idi.util.HighLightBuilder;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.IDIStringUtils;
import kd.data.idi.util.Pair;

public class AttachmentExecutor
extends SelfBillDecisionExecutor {
    private DeductionGrade deductionGrade = null;
    private static final String PARAM_ATTACHMENT = "attachment_recognition";
    private static final String PARAM_FIELD_VALUE = "param_val";
    private static final int MAX_SRC_ENTRY_SIZE = 2000;
    private static final int MAX_EXCEPTION_SIZE = 100;

    @Override
    public DecisionResult execute(SchemaContext context, Decision decision) {
        AttachmentConfig attachmentConfig = decision.getAttachmentConfig();
        if (attachmentConfig == null) {
            return null;
        }
        if (null == context.getSelfBill()) {
            return null;
        }
        MainEntityType srcEntityType = EntityMetadataCache.getDataEntityType((String)context.getEntityType());
        this.deductionGrade = new DeductionGrade(context);
        DecisionResult decisionResult = new DecisionResult();
        decisionResult.setDecision(decision);
        CheckAttachmentTypeEnum checkType = attachmentConfig.getCheckType();
        HashMap<String, List<Integer>> canStartRowIndexMap = new HashMap<String, List<Integer>>(2);
        if (!this.canStart(context, attachmentConfig, canStartRowIndexMap, srcEntityType)) {
            ExceptionTip noStart = this.matchExceptionTip(attachmentConfig, ExceptionTipEnum.NO_MATCH_START);
            if (noStart.getShowErrorTips().booleanValue()) {
                decisionResult.setStatus("empty");
                this.deductionGrade.deduct(0);
            } else {
                decisionResult.setStatus("alarming");
                this.deductionGrade.deduct(noStart.getPercent());
                decisionResult.setShowText(noStart.achieveTipWords());
            }
            decisionResult.setDeductPercent(this.deductionGrade.getValue());
            SchemaExecutorLogger.info((String)String.format("starting conditions not met, AttachmentExecutor decisionResult : %s", IDIJSONUtils.toJsonString((Object)decisionResult)), (Object[])new Object[0]);
            return decisionResult;
        }
        Map<Long, Set<String>> lcTemplateFieldMap = context.getLcTemplateFieldMap();
        CheckMethodEnum checkMethod = attachmentConfig.getCheckMethod();
        IAttachmentService attachmentService = AttachmentServiceFactory.getServiceInstance(checkMethod == null ? CheckMethodEnum.PRESET : checkMethod);
        List<Attachment> attachmentList = this.queryAttachmentInfo(context, attachmentConfig, attachmentService);
        Pair<Boolean, Object> lockMessage = new Pair<Boolean, Object>(false, null);
        if (context instanceof SchemaParallelContext) {
            SchemaParallelContext parallelContext = (SchemaParallelContext)context;
            lockMessage = new Pair<Boolean, String>(true, parallelContext.getTraceId());
        }
        SchemaExecutorLogger.info((String)String.format("[DATA-IDI] AttachmentExecutor LockMessage:%s", IDIJSONUtils.toJsonString(lockMessage)), (Object[])new Object[0]);
        switch (checkType) {
            case CHECKEXISTS: {
                this.checkExists(attachmentList, attachmentService, decisionResult, attachmentConfig, context.getEntityType(), context.getSelfBill(), srcEntityType, lcTemplateFieldMap, lockMessage, context.isNeedHighLight());
                break;
            }
            case CHECKBILLCONTENT: {
                this.checkContent(attachmentList, attachmentService, decisionResult, context.getEntityType(), attachmentConfig, canStartRowIndexMap, srcEntityType, lcTemplateFieldMap, context.getSelfBill(), lockMessage, context.isNeedHighLight());
                break;
            }
            case CHECKFILENAME: {
                this.checkFileName(attachmentList, decisionResult, attachmentConfig, canStartRowIndexMap, srcEntityType, context.getSelfBill(), context.isNeedHighLight());
                break;
            }
            default: {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u68c0\u67e5\u7c7b\u578b\u6216\u68c0\u67e5\u7c7b\u578b\u4e3a\u7a7a", (String)"AttachmentExecutor_0", (String)"data-idi-core", (Object[])new Object[0]));
            }
        }
        decisionResult.setDeductPercent(this.deductionGrade.getValue());
        SchemaExecutorLogger.info((String)String.format("AttachmentExecutor decisionResult : %s", IDIJSONUtils.toJsonString((Object)decisionResult)), (Object[])new Object[0]);
        return decisionResult;
    }

    private void checkContent(List<Attachment> attachmentList, IAttachmentService attachmentService, DecisionResult decisionResult, String entityType, AttachmentConfig attachmentConfig, Map<String, List<Integer>> canStartRowIndexMap, MainEntityType srcEntityType, Map<Long, Set<String>> lcTemplateFieldMap, DynamicObject billObj, Pair<Boolean, String> lockMessage, boolean needHighLight) {
        if (attachmentList == null || attachmentList.isEmpty()) {
            this.noExistsAttachmentException(attachmentConfig, decisionResult);
        } else {
            String script = this.comboRuleScript(attachmentConfig.getRuleList());
            String entryName = this.validateMoreEntry(script, srcEntityType, ResManager.loadKDString((String)"\u68c0\u67e5\u89c4\u5219\u4e0d\u652f\u6301\u8de8\u6e90\u5355\u7684\u591a\u4e2a\u5206\u5f55\u3002", (String)"AttachmentExecutor_1", (String)"data-idi-core", (Object[])new Object[0]));
            if (null == entryName) {
                throw new KDBizException(ResManager.loadKDString((String)"\u68c0\u67e5\u9644\u4ef6\u5185\u5bb9\u68c0\u67e5\u672a\u914d\u7f6e\u68c0\u67e5\u89c4\u5219", (String)"AttachmentExecutor_2", (String)"data-idi-core", (Object[])new Object[0]));
            }
            List<Long> templateIdList = this.queryTemplateId(attachmentConfig.getCheckMethod(), attachmentConfig.getCustomTemplateId(), attachmentConfig.getRecognizerId(), attachmentConfig.getLcTemplateId());
            Map<Long, String> templateTableMap = this.validateMoreTable(script, templateIdList, entityType);
            List<AttachmentField> fieldList = this.queryAttachmentField(entityType, attachmentConfig, attachmentService);
            AIRecognizerResult recognizerResult = this.recognizer(attachmentList, attachmentService, attachmentConfig, entityType, lcTemplateFieldMap, billObj, lockMessage);
            List successInfoList = recognizerResult.getDetailDatas();
            List errorInfoList = recognizerResult.getErrorInfos();
            if ((successInfoList == null || successInfoList.isEmpty()) && this.isSameErrorAttachment(errorInfoList)) {
                this.noExistsAttachmentException(attachmentConfig, decisionResult);
                return;
            }
            Set<String> panelKeySet = attachmentList.stream().map(Attachment::getAttachmentPanelName).collect(Collectors.toSet());
            String[] panelKeys = panelKeySet.toArray(new String[0]);
            ArrayList<LinkUpBillResult> allResultList = new ArrayList<LinkUpBillResult>(10);
            if (errorInfoList != null && !errorInfoList.isEmpty() && (successInfoList == null || successInfoList.isEmpty())) {
                ArrayList<LinkUpBillResult> errorResultList = new ArrayList<LinkUpBillResult>(errorInfoList.size());
                this.processErrorAttachment(errorInfoList, errorResultList);
                allResultList.addAll(errorResultList);
            }
            if (successInfoList != null && !successInfoList.isEmpty()) {
                ArrayList<LinkUpBillResult> recogResultList = new ArrayList<LinkUpBillResult>(successInfoList.size());
                int noConfidenceCount = this.processRecognition(successInfoList, recogResultList, script, fieldList, srcEntityType.getName(), attachmentConfig, templateIdList);
                allResultList.addAll(recogResultList);
                BigDecimal percent = this.calPercent(successInfoList.size(), billObj, entryName, canStartRowIndexMap, noConfidenceCount);
                ArrayList<LinkUpBillResult> relationResultList = new ArrayList<LinkUpBillResult>(successInfoList.size());
                HashMap<LinkUpBillResult, Integer> entryIndexMap = new HashMap<LinkUpBillResult, Integer>(10);
                HashMap<LinkUpBillResult, List<Integer>> reduceEntryIndexMap = new HashMap<LinkUpBillResult, List<Integer>>(5);
                if (this.isHead(entryName)) {
                    for (AIRecognizerSuccessInfo aiRecognizerSuccessInfo : successInfoList) {
                        this.executeRule(script, entryName, percent, aiRecognizerSuccessInfo, billObj, -1, fieldList, srcEntityType, attachmentConfig, relationResultList, templateTableMap, entryIndexMap);
                    }
                } else {
                    int entryRowCount = billObj.getDynamicObjectCollection(entryName).size();
                    List<Integer> indexList = canStartRowIndexMap.get(entryName);
                    int loopCount = Math.min(entryRowCount, 2000);
                    for (int index = 0; index < loopCount; ++index) {
                        if (indexList != null && !indexList.isEmpty() && !indexList.contains(index)) continue;
                        ArrayList<LinkUpBillResult> entryGroupResultList = new ArrayList<LinkUpBillResult>(entryRowCount);
                        for (AIRecognizerSuccessInfo aiRecognizerSuccessInfo : successInfoList) {
                            this.executeRule(script, entryName, percent, aiRecognizerSuccessInfo, billObj, index, fieldList, srcEntityType, attachmentConfig, entryGroupResultList, templateTableMap, entryIndexMap);
                            if (!this.isOutOfCount(relationResultList, entryGroupResultList)) continue;
                            break;
                        }
                        if (attachmentConfig.isNeedShowAllEntryCheckTrue()) {
                            List<LinkUpBillResult> entryGroupResultListNew = this.processShowAllEntryCheckTrue(entryGroupResultList, attachmentConfig.getRuleList());
                            relationResultList.addAll(entryGroupResultListNew);
                            continue;
                        }
                        relationResultList.addAll(entryGroupResultList);
                    }
                }
                List<LinkUpBillResult> resultList = this.reduceResult(relationResultList, attachmentConfig, entryIndexMap, reduceEntryIndexMap);
                allResultList.addAll(resultList);
                if (allResultList.isEmpty()) {
                    decisionResult.setStatus("empty");
                }
                if (needHighLight) {
                    HighLightBuilder highLightBuilder = new HighLightBuilder();
                    ArrayList<BaseHighLight> allHighLightList = new ArrayList<BaseHighLight>(5);
                    for (LinkUpBillResult result : resultList) {
                        if (result.getMatchRule() == -1) continue;
                        highLightBuilder.buildAttachmentHighLight(result.getMatchRule(), attachmentConfig.getRuleList().get(result.getMatchRule()).getRule().getScript(), srcEntityType.getName(), srcEntityType, (List)reduceEntryIndexMap.get(result), allHighLightList, panelKeys);
                    }
                    if (!allHighLightList.isEmpty()) {
                        decisionResult.setHighLightList(allHighLightList);
                    }
                }
            }
            decisionResult.setAttachmentResults(allResultList);
        }
    }

    private List<LinkUpBillResult> processShowAllEntryCheckTrue(List<LinkUpBillResult> entryGroupResultList, List<DecisionRule> ruleList) {
        ArrayList<LinkUpBillResult> entryResultList = new ArrayList<LinkUpBillResult>();
        if (entryGroupResultList.isEmpty()) {
            return entryResultList;
        }
        Map<Integer, List<LinkUpBillResult>> classifyMap = entryGroupResultList.stream().collect(Collectors.groupingBy(LinkUpBillResult::getMatchRule));
        Set<Map.Entry<Integer, List<LinkUpBillResult>>> entrySet = classifyMap.entrySet();
        for (Map.Entry<Integer, List<LinkUpBillResult>> integerListEntry : entrySet) {
            DecisionRule rule;
            int mathRule = integerListEntry.getKey();
            if (mathRule < 0) {
                entryResultList.addAll((Collection<LinkUpBillResult>)integerListEntry.getValue());
            }
            if ((rule = ruleList.get(mathRule)).isShowAllEntryCheckTrue()) {
                if (integerListEntry.getValue().size() != entryGroupResultList.size()) continue;
                entryResultList.addAll((Collection<LinkUpBillResult>)integerListEntry.getValue());
                continue;
            }
            entryResultList.addAll((Collection<LinkUpBillResult>)integerListEntry.getValue());
        }
        return entryResultList;
    }

    private boolean isOutOfCount(List<LinkUpBillResult> relationResultList, List<LinkUpBillResult> entryGroupResultList) {
        int count = 0;
        for (LinkUpBillResult billResult : relationResultList) {
            if (billResult.isPass()) continue;
            ++count;
        }
        for (LinkUpBillResult billResult : entryGroupResultList) {
            if (billResult.isPass()) continue;
            ++count;
        }
        return count > 100;
    }

    private void checkFileName(List<Attachment> attachmentList, DecisionResult decisionResult, AttachmentConfig attachmentConfig, Map<String, List<Integer>> canStartRowIndexMap, MainEntityType srcEntityType, DynamicObject billObj, boolean needHighLight) {
        if (attachmentList == null || attachmentList.isEmpty()) {
            this.noExistsAttachmentException(attachmentConfig, decisionResult);
        } else {
            String script = this.comboRuleScript(attachmentConfig.getRuleList());
            BigDecimal percent = this.calPercent(attachmentList.size(), billObj, "", canStartRowIndexMap, 0);
            ArrayList<LinkUpBillResult> relationResultList = new ArrayList<LinkUpBillResult>(attachmentList.size());
            for (Attachment attachment : attachmentList) {
                this.executeCheckFileNameRule(script, percent, attachment.getFileName(), billObj, srcEntityType, attachmentConfig, relationResultList);
            }
            List<LinkUpBillResult> resultList = this.reduceResult(relationResultList, attachmentConfig, null, new HashMap<LinkUpBillResult, List<Integer>>(2));
            if (resultList.isEmpty()) {
                decisionResult.setStatus("empty");
            }
            if (needHighLight) {
                Set<String> panelKeySet = attachmentList.stream().map(Attachment::getAttachmentPanelName).collect(Collectors.toSet());
                String[] panelKeys = panelKeySet.toArray(new String[0]);
                HighLightBuilder highLightBuilder = new HighLightBuilder();
                ArrayList<BaseHighLight> allHighLightList = new ArrayList<BaseHighLight>(5);
                for (LinkUpBillResult result : resultList) {
                    if (result.getMatchRule() == -1) continue;
                    highLightBuilder.buildAttachmentHighLight(result.getMatchRule(), attachmentConfig.getRuleList().get(result.getMatchRule()).getRule().getScript(), srcEntityType.getName(), srcEntityType, new ArrayList<Integer>(0), allHighLightList, panelKeys);
                }
                if (!allHighLightList.isEmpty()) {
                    decisionResult.setHighLightList(allHighLightList);
                }
            }
            decisionResult.setAttachmentResults(resultList);
        }
    }

    private boolean isSameErrorAttachment(List<AIRecognizerErrorInfo> errorInfoList) {
        if (CollectionUtils.isEmpty(errorInfoList)) {
            return true;
        }
        String firstError = errorInfoList.get(0).getErrorCode();
        for (AIRecognizerErrorInfo errorInfo : errorInfoList) {
            if (errorInfo.getErrorCode().equals(firstError)) continue;
            return false;
        }
        return this.isNoRecognizer(firstError);
    }

    private boolean isNoRecognizer(String errorCode) {
        String firstError = errorCode + ',';
        return "20011,30302,20019,30005,60005,10019,lc404,5005,500,".contains(firstError);
    }

    private List<LinkUpBillResult> reduceResult(List<LinkUpBillResult> relationResultList, AttachmentConfig attachmentConfig, Map<LinkUpBillResult, Integer> entryIndexMap, Map<LinkUpBillResult, List<Integer>> reduceEntryIndexMap) {
        ArrayList<LinkUpBillResult> ruleResultList = new ArrayList<LinkUpBillResult>(relationResultList.size());
        Map<Integer, List<LinkUpBillResult>> collect = relationResultList.stream().collect(Collectors.groupingBy(LinkUpBillResult::getMatchRule));
        List<DecisionRule> ruleList = attachmentConfig.getRuleList();
        collect.forEach((index, resultList) -> {
            LinkUpBillResult ruleResult = new LinkUpBillResult();
            if (index != -1) {
                DecisionRule rule = (DecisionRule)ruleList.get((int)index);
                ruleResult.setPass(rule.isPass());
                ruleResult.setMatchRule((int)index);
                ruleResult.setStatus(rule.getDecisionStatus());
                ruleResult.setShowText(rule.achieveName());
            } else {
                LinkUpBillResult template = (LinkUpBillResult)resultList.get(0);
                ruleResult.setPass(false);
                ruleResult.setMatchRule((int)index);
                ruleResult.setShowText(template.getShowText());
                ruleResult.setStatus(template.getStatus());
            }
            ArrayList<DecisionFrontEndResult> frontEndResultList = new ArrayList<DecisionFrontEndResult>(resultList.size());
            HashSet<Integer> ruleEntryIndexSet = new HashSet<Integer>(10);
            for (Object result : resultList) {
                Integer entryIndex;
                DecisionFrontEndResult ruleFrontEndResult = ((LinkUpBillResult)result).getFrontEndResult();
                if (ruleFrontEndResult != null) {
                    frontEndResultList.add(ruleFrontEndResult);
                }
                if (index == -1 || entryIndexMap == null || entryIndexMap.isEmpty() || (entryIndex = (Integer)entryIndexMap.get(result)) == null) continue;
                ruleEntryIndexSet.add(entryIndex);
            }
            DecisionFrontEndResult decisionFrontEndResult = this.reduceFrontEndResult(frontEndResultList);
            ruleResult.setFrontEndResult(decisionFrontEndResult);
            for (LinkUpBillResult result : resultList) {
                ruleResult.addDeductPercent(result.getDeductPercent());
            }
            ruleResultList.add(ruleResult);
            if (CollectionUtils.isNotEmpty(ruleEntryIndexSet) && index != -1) {
                ArrayList entryIndexList = new ArrayList(ruleEntryIndexSet);
                entryIndexList.sort(Integer::compare);
                reduceEntryIndexMap.put(ruleResult, entryIndexList);
            }
        });
        if (attachmentConfig.isNeedShowAllCheckTrue()) {
            this.processShowAllCheckTrue(ruleResultList, attachmentConfig.getRuleList(), reduceEntryIndexMap);
        }
        return ruleResultList;
    }

    private void processShowAllCheckTrue(List<LinkUpBillResult> linkUpBillResults, List<DecisionRule> ruleList, Map<LinkUpBillResult, List<Integer>> reduceEntryIndexMap) {
        if (CollectionUtils.isEmpty(linkUpBillResults) || CollectionUtils.isEmpty(ruleList)) {
            return;
        }
        HashMap<DecisionRule, List> map = new HashMap<DecisionRule, List>(linkUpBillResults.size());
        for (LinkUpBillResult linkUpBillResult : linkUpBillResults) {
            int index = linkUpBillResult.getMatchRule();
            if (index <= -1) continue;
            DecisionRule rule2 = ruleList.get(index);
            ArrayList<LinkUpBillResult> list = (ArrayList<LinkUpBillResult>)map.get(rule2);
            if (list == null) {
                list = new ArrayList<LinkUpBillResult>(linkUpBillResults.size());
                map.put(rule2, list);
            }
            list.add(linkUpBillResult);
        }
        if (map.size() > 1) {
            map.forEach((rule, dataList) -> {
                if (rule.isShowAllCheckTrue()) {
                    for (LinkUpBillResult result : dataList) {
                        linkUpBillResults.remove(result);
                        reduceEntryIndexMap.remove(result);
                    }
                }
            });
        }
    }

    private void executeRule(String script, String entryName, BigDecimal percent, AIRecognizerSuccessInfo aiRecognizerSuccessInfo, DynamicObject billObj, int entryIndex, List<AttachmentField> attachmentFieldList, MainEntityType srcEntityType, AttachmentConfig attachmentConfig, List<LinkUpBillResult> relationResultList, Map<Long, String> templateTableMap, Map<LinkUpBillResult, Integer> entryIndexMap) {
        String sourceEntity = srcEntityType.getName();
        List<Map<String, Object>> attachmentDataList = this.processAttachmentData(aiRecognizerSuccessInfo, attachmentFieldList, templateTableMap);
        BigDecimal tablePercent = attachmentDataList.size() <= 1 ? percent : percent.divide(BigDecimal.valueOf(attachmentDataList.size(), 0), 6, RoundingMode.HALF_UP);
        ScriptLocaleFieldHandler localeFieldHandler = new ScriptLocaleFieldHandler();
        String localeScript = localeFieldHandler.processLocaleField(script, new String[]{sourceEntity}, billObj);
        if (!this.isHead(entryName)) {
            localeScript = ScriptUtils.supportEntryProperty((DynamicObjectType)srcEntityType, localeScript, entryIndex);
        }
        for (Map<String, Object> attachmentDataMapNew : attachmentDataList) {
            HashMap<String, Object> ctx = new HashMap<String, Object>(1);
            ctx.put(sourceEntity + "_billObj", billObj);
            ctx.putAll(attachmentDataMapNew);
            SchemaExecutorLogger.info((String)"run script, script %s, param %s", (Object[])new Object[]{localeScript, ctx});
            ScriptFormIdHandler.runScript((String)sourceEntity, (String)sourceEntity, ctx, (String)localeScript);
            Object matchRuleIndexObj = ctx.get("__MatchRuleIndex__");
            LinkUpBillResult result = new LinkUpBillResult();
            relationResultList.add(result);
            DecisionFrontEndResult decisionFrontEndResult = this.buildFrontEndResult(attachmentDataMapNew, billObj, attachmentConfig, srcEntityType, entryName, entryIndex, aiRecognizerSuccessInfo.getTemplate().getId());
            if (matchRuleIndexObj == null) {
                ExceptionTip exceptionTip = this.matchExceptionTip(attachmentConfig, ExceptionTipEnum.NO_MATCH_RULE);
                if (exceptionTip.getShowErrorTips().booleanValue()) {
                    relationResultList.remove(result);
                    continue;
                }
                result.setStatus("alarming");
                BigDecimal deductPercent = this.deductionGrade.deductPercent(exceptionTip.getPercent(), tablePercent);
                result.setDeductPercent(deductPercent);
                result.setFrontEndResult(decisionFrontEndResult);
                result.setShowText(exceptionTip.achieveTipWords());
                result.setMatchRule(-1);
                continue;
            }
            int matchRuleIndex = Integer.parseInt(matchRuleIndexObj.toString());
            DecisionRule decisionRule = attachmentConfig.getRuleList().get(matchRuleIndex);
            result.setMatchRule(matchRuleIndex);
            result.setPass(decisionRule.isPass());
            result.setShowText(decisionRule.achieveName());
            result.setStatus(decisionRule.getDecisionStatus());
            if (!decisionRule.isPass()) {
                result.setFrontEndResult(decisionFrontEndResult);
            }
            BigDecimal deductPercent = this.deductionGrade.deductPercent(decisionRule.getDeductionGradePercent(), tablePercent);
            result.setDeductPercent(deductPercent);
            if (entryIndex <= -1) continue;
            entryIndexMap.put(result, entryIndex);
        }
    }

    private void executeCheckFileNameRule(String script, BigDecimal percent, String fileName, DynamicObject billObj, MainEntityType srcEntityType, AttachmentConfig attachmentConfig, List<LinkUpBillResult> relationResultList) {
        String sourceEntity = srcEntityType.getName();
        ScriptLocaleFieldHandler localeFieldHandler = new ScriptLocaleFieldHandler();
        String localeScript = localeFieldHandler.processLocaleField(script, new String[]{sourceEntity}, billObj);
        HashMap<String, Object> ctx = new HashMap<String, Object>(1);
        ctx.put(sourceEntity + "_billObj", billObj);
        ctx.put("filename", fileName);
        SchemaExecutorLogger.info((String)"check file name run script, script %s, param %s", (Object[])new Object[]{localeScript, ctx});
        ScriptFormIdHandler.runScript((String)sourceEntity, (String)sourceEntity, ctx, (String)localeScript);
        Object matchRuleIndexObj = ctx.get("__MatchRuleIndex__");
        LinkUpBillResult result = new LinkUpBillResult();
        relationResultList.add(result);
        DecisionFrontEndResult decisionFrontEndResult = this.buildFrontEndResult(ctx, billObj, attachmentConfig, srcEntityType, "", -1, null);
        if (matchRuleIndexObj == null) {
            ExceptionTip exceptionTip = this.matchExceptionTip(attachmentConfig, ExceptionTipEnum.NO_MATCH_RULE);
            if (exceptionTip.getShowErrorTips().booleanValue()) {
                relationResultList.remove(result);
            } else {
                result.setStatus("alarming");
                result.setShowText(exceptionTip.achieveTipWords());
                result.setMatchRule(-1);
                BigDecimal deductPercent = this.deductionGrade.deductPercent(exceptionTip.getPercent(), percent);
                result.setDeductPercent(deductPercent);
                result.setFrontEndResult(decisionFrontEndResult);
            }
        } else {
            int matchRuleIndex = Integer.parseInt(matchRuleIndexObj.toString());
            DecisionRule decisionRule = attachmentConfig.getRuleList().get(matchRuleIndex);
            result.setMatchRule(matchRuleIndex);
            result.setPass(decisionRule.isPass());
            result.setShowText(decisionRule.achieveName());
            result.setStatus(decisionRule.getDecisionStatus());
            if (!decisionRule.isPass()) {
                result.setFrontEndResult(decisionFrontEndResult);
            }
            BigDecimal deductPercent = this.deductionGrade.deductPercent(decisionRule.getDeductionGradePercent(), percent);
            result.setDeductPercent(deductPercent);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Map<String, Object>> processAttachmentData(AIRecognizerSuccessInfo aiRecognizerSuccessInfo, List<AttachmentField> attachmentFieldList, Map<Long, String> templateTableMap) {
        AITemplate templateObj = aiRecognizerSuccessInfo.getTemplate();
        Long templateId = templateObj.getId();
        Map<String, String> fieldMap = attachmentFieldList.stream().filter(field -> templateId.equals(field.getTemplate().getId())).collect(Collectors.toMap(field -> templateObj.isCustomTemplate() ? field.getFullDisplayName() : field.getFullName(), field -> {
            String fieldName = field.getFullName();
            return IDIStringUtils.buildTemplateField((Long)templateId, (String)fieldName);
        }));
        Map<String, AttachmentField> attachmentFieldMap = attachmentFieldList.stream().filter(field -> templateId.equals(field.getTemplate().getId())).collect(Collectors.toMap(field -> templateObj.isCustomTemplate() ? field.getFullDisplayName() : field.getFullName(), field -> field));
        Map<String, Object> attachmentDataMap = aiRecognizerSuccessInfo.getDataDetailMap();
        SchemaExecutorLogger.info((String)"attachment data, source data %s", (Object[])new Object[]{attachmentDataMap});
        HashMap<String, String> attachmentDataMapNew = new HashMap<String, String>(attachmentDataMap.size());
        attachmentDataMap.forEach((k, v) -> {
            AttachmentField field = (AttachmentField)attachmentFieldMap.get(k);
            if (null != field && null == field.getParent() && !field.isTable()) {
                String fieldNumber = (String)fieldMap.get(k);
                attachmentDataMapNew.put(fieldNumber, (String)v);
            }
        });
        attachmentDataMapNew.put(IDIStringUtils.buildTemplateField((Long)templateId, (String)"filename"), aiRecognizerSuccessInfo.getFileName());
        SchemaExecutorLogger.info((String)"attachment data %s after user attachemnt field number  ", (Object[])new Object[]{attachmentDataMapNew});
        String tableKey = templateTableMap.get(templateId);
        boolean hasTableData = StringUtils.isNotEmpty((String)tableKey);
        ArrayList<Map<String, Object>> attachmentDataList = new ArrayList<Map<String, Object>>(10);
        if (hasTableData) {
            Optional<AttachmentField> tableFieldOptional = attachmentFieldList.stream().filter(field -> tableKey.equals(field.getFullName())).findFirst();
            if (!tableFieldOptional.isPresent()) throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u5b57\u6bb5\u4e0e\u68c0\u67e5\u89c4\u5219\u914d\u7f6e\u5b57\u6bb5\u5b58\u5728\u5dee\u5f02\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u68c0\u67e5\u89c4\u5219", (String)"AttachmentExecutor_11", (String)"data-idi-core", (Object[])new Object[0]));
            AttachmentField tableField = tableFieldOptional.get();
            String tableName = templateObj.isCustomTemplate() ? tableField.getDisplayName() : tableField.getName();
            List tableDataList = (List)attachmentDataMap.get(tableName);
            if (tableDataList != null && !tableDataList.isEmpty()) {
                for (Map tableRowDataMap : tableDataList) {
                    HashMap<String, String> attachmentTableDataMap = new HashMap<String, String>(tableRowDataMap.size() + attachmentDataMapNew.size());
                    attachmentTableDataMap.putAll(attachmentDataMapNew);
                    tableRowDataMap.forEach((k, v) -> {
                        String fullTableFieldKey = tableName + '.' + k;
                        AttachmentField field = (AttachmentField)attachmentFieldMap.get(fullTableFieldKey);
                        if (field != null && field.getParent() != null && !field.isTable()) {
                            String fieldNumber = (String)fieldMap.get(fullTableFieldKey);
                            attachmentTableDataMap.put(fieldNumber, (String)v);
                        }
                    });
                    attachmentDataList.add(attachmentTableDataMap);
                }
            } else {
                SchemaExecutorLogger.info((String)("tableData is null, table name:" + tableName), (Object[])new Object[0]);
                attachmentDataList.add(attachmentDataMapNew);
            }
        } else {
            attachmentDataList.add(attachmentDataMapNew);
        }
        SchemaExecutorLogger.info((String)"splite attachemnt data %s ", (Object[])new Object[]{attachmentDataList});
        return attachmentDataList;
    }

    private DecisionFrontEndResult buildFrontEndResult(Map<String, Object> attachmentDataMapNew, DynamicObject billObj, AttachmentConfig attachmentConfig, MainEntityType srcEntityType, String entryName, int entryIndex, Long templateId) {
        List showFieldList;
        DecisionFrontEndConfig config = attachmentConfig.getFrontEndConfig();
        List list = showFieldList = config == null ? null : config.getHoverFieldContents();
        if (showFieldList == null || showFieldList.isEmpty()) {
            return null;
        }
        DecisionFrontEndResult decisionFrontEndResult = new DecisionFrontEndResult();
        HoverContent[] titles = new HoverContent[showFieldList.size()];
        int index = 0;
        ArrayList<HoverContent> fieldDataList = new ArrayList<HoverContent>();
        for (DecisionFrontEndConfigField decisionFrontEndConfigField : showFieldList) {
            titles[index++] = HoverContent.createTitle((String)(StringUtils.isEmpty((String)decisionFrontEndConfigField.achieveDisplayName()) ? decisionFrontEndConfigField.getPropDisplayName() : decisionFrontEndConfigField.achieveDisplayName()));
            String billType = decisionFrontEndConfigField.getBillType();
            if ("srcbill".equalsIgnoreCase(billType)) {
                ExecutorHelper.ValueAndName valueAndName = ExecutorHelper.getValueAndNameByName(billObj, decisionFrontEndConfigField.getPropName(), true);
                IDataEntityProperty entityProperty = valueAndName.getEntityProperty();
                Object value = valueAndName.getValue();
                boolean isUser = valueAndName.isUser();
                boolean isBill = !(srcEntityType instanceof BasedataEntityType);
                boolean isBillNo = false;
                if (isBill) {
                    BillEntityType billEntityType = (BillEntityType)srcEntityType;
                    isBillNo = decisionFrontEndConfigField.getPropName().equalsIgnoreCase(billEntityType.getBillNo());
                }
                String fieldEntryName = decisionFrontEndConfigField.getPropName().split("\\.")[0];
                if (value != null) {
                    String content;
                    if (value instanceof List) {
                        List valueList = (List)value;
                        List refValueList = (List)valueAndName.getRefValue();
                        if (entryName.equals(fieldEntryName)) {
                            String content2;
                            Object itemValue = valueList.get(entryIndex);
                            Object formatValue = ExecutorHelper.tryToString(billObj, billObj, itemValue, entityProperty);
                            String string = content2 = formatValue == null ? " " : formatValue.toString();
                            fieldDataList.add(isUser ? HoverContent.createChat((String)content2, refValueList.get(entryIndex)) : (isBillNo ? HoverContent.createHref((String)content2, (DynamicObject)billObj) : HoverContent.createText((String)content2)));
                            continue;
                        }
                        StringBuilder sb = new StringBuilder();
                        valueList.forEach(obj -> {
                            Object formatValue = ExecutorHelper.tryToString(billObj, billObj, obj, entityProperty);
                            String content = formatValue == null ? " " : formatValue.toString();
                            sb.append(content).append(',');
                        });
                        String content3 = sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
                        fieldDataList.add(HoverContent.createText((String)content3));
                        continue;
                    }
                    Object formatValue = ExecutorHelper.tryToString(billObj, billObj, value, entityProperty);
                    String string = content = formatValue == null ? " " : formatValue.toString();
                    fieldDataList.add(isBillNo ? HoverContent.createHref((String)content, (DynamicObject)billObj) : (isUser ? HoverContent.createChat((String)content, (Object)valueAndName.getRefValue()) : HoverContent.createText((String)content)));
                    continue;
                }
                fieldDataList.add(HoverContent.createText((String)" "));
                continue;
            }
            if (billType.equalsIgnoreCase(String.valueOf(templateId)) || decisionFrontEndConfigField.getPropName().contains("filename")) {
                String fieldName = templateId == null ? decisionFrontEndConfigField.getPropName() : IDIStringUtils.buildTemplateField((Long)templateId, (String)decisionFrontEndConfigField.getPropName());
                Object fieldValue = attachmentDataMapNew.get(fieldName);
                String content = fieldValue instanceof Date ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format((Date)fieldValue) : String.valueOf(fieldValue);
                fieldDataList.add(HoverContent.createText((String)content));
                continue;
            }
            SchemaExecutorLogger.info((String)("value is null in attachment, field:" + decisionFrontEndConfigField.getPropName() + "billtype:" + billType + "templateId:" + templateId), (Object[])new Object[0]);
            fieldDataList.add(HoverContent.createText((String)" "));
        }
        decisionFrontEndResult.addHoverContent(titles);
        decisionFrontEndResult.addHoverContent(fieldDataList);
        return decisionFrontEndResult;
    }

    private void processErrorAttachment(List<AIRecognizerErrorInfo> errorInfoList, List<LinkUpBillResult> relationResultList) {
        if (errorInfoList == null || errorInfoList.isEmpty()) {
            return;
        }
        LinkUpBillResult result = new LinkUpBillResult();
        result.setStatus("alarming");
        result.setShowText(ResManager.loadKDString((String)"\u5b58\u5728\u8bc6\u522b\u5931\u8d25\u7684\u9644\u4ef6", (String)"AttachmentExecutor_4", (String)"data-idi-core", (Object[])new Object[0]));
        DecisionFrontEndResult decisionFrontEndResult = new DecisionFrontEndResult();
        result.addDeductPercent(BigDecimal.ZERO);
        result.setFrontEndResult(decisionFrontEndResult);
        for (AIRecognizerErrorInfo aiRecognizerErrorInfo : errorInfoList) {
            if (this.isNoRecognizer(aiRecognizerErrorInfo.getErrorCode())) continue;
            ArrayList<HoverContent> hcList = new ArrayList<HoverContent>(errorInfoList.size());
            decisionFrontEndResult.addHoverContent(hcList);
            String font = aiRecognizerErrorInfo.getFileName() + " , " + aiRecognizerErrorInfo.getDescription();
            hcList.add(HoverContent.createText((String)font));
        }
        if (decisionFrontEndResult.getHoverContent() != null) {
            relationResultList.add(result);
        }
    }

    private int processRecognition(List<AIRecognizerSuccessInfo> successInfoList, List<LinkUpBillResult> relationResultList, String script, List<AttachmentField> fieldList, String sourceEntityName, AttachmentConfig attachmentConfig, List<Long> templateIdList) {
        if (successInfoList == null || successInfoList.isEmpty()) {
            return 0;
        }
        DynamicObject recognition = ParamFactory.getParam(PARAM_ATTACHMENT);
        if (recognition != null && StringUtils.isNotEmpty((String)recognition.getString(PARAM_FIELD_VALUE))) {
            BigDecimal paramValue;
            try {
                paramValue = new BigDecimal(recognition.getString(PARAM_FIELD_VALUE));
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7f6e\u4fe1\u5ea6\u53c2\u6570\u503c\u56e0\u4e3a0\u52301\u4e4b\u95f4\u7684\u6570\u503c", (String)"AttachmentExecutor_5", (String)"data-idi-core", (Object[])new Object[0]));
            }
            if (attachmentConfig.getCheckMethod() == CheckMethodEnum.PRESET) {
                templateIdList.add(attachmentConfig.getValidTemplateId());
            }
            HashMap<String, Long> templateFieldPrefixMap = new HashMap<String, Long>(templateIdList.size());
            for (Long templateId : templateIdList) {
                templateFieldPrefixMap.put(IDIStringUtils.templatePrefix((Long)templateId), templateId);
            }
            Set vars = ScriptFormIdHandler.extractVariables((String)script, (String[])new String[]{sourceEntityName});
            Set templateFieldPrefixSet = templateFieldPrefixMap.keySet();
            HashSet<String> templateFieldSet = new HashSet<String>(10);
            block3: for (String prop : vars) {
                for (String templateFieldPrefix : templateFieldPrefixSet) {
                    if (!prop.startsWith(templateFieldPrefix)) continue;
                    templateFieldSet.add(prop);
                    continue block3;
                }
            }
            if (templateFieldSet.isEmpty()) {
                return 0;
            }
            Map<Long, List<AttachmentField>> templateFieldMap = fieldList.stream().filter(fieldObj -> {
                String fieldStr = IDIStringUtils.buildTemplateField((Long)fieldObj.getTemplate().getId(), (String)fieldObj.getFullName());
                return templateFieldSet.contains(fieldStr);
            }).collect(Collectors.groupingBy(fieldObj -> fieldObj.getTemplate().getId()));
            ArrayList<AIRecognizerSuccessInfo> noExecutorList = new ArrayList<AIRecognizerSuccessInfo>(successInfoList.size());
            LinkUpBillResult result = new LinkUpBillResult();
            result.setStatus("warnning");
            result.setShowText(ResManager.loadKDString((String)"\u9644\u4ef6\u8bc6\u522b\u7ed3\u679c\u53ef\u4fe1\u5ea6\u4f4e\uff0c\u5efa\u8bae\u4eba\u5de5\u68c0\u67e5\u3002", (String)"AttachmentExecutor_3", (String)"data-idi-core", (Object[])new Object[0]));
            DecisionFrontEndResult decisionFrontEndResult = new DecisionFrontEndResult();
            ArrayList<HoverContent> hcList = new ArrayList<HoverContent>(1);
            hcList.add(HoverContent.createText((String)ResManager.loadKDString((String)"\u4ee5\u4e0b\u9644\u4ef6\u5b57\u6bb5\u503c\u7684\u7f6e\u4fe1\u5ea6\u5c0f\u4e8e\u6807\u51c6\u503c\uff1a", (String)"AttachmentExecutor_12", (String)"data-idi-core", (Object[])new Object[0])));
            decisionFrontEndResult.addHoverContent(hcList);
            result.setFrontEndResult(decisionFrontEndResult);
            for (AIRecognizerSuccessInfo aiRecognizerSuccessInfo : successInfoList) {
                Long templateId;
                List<AttachmentField> templateFieldList;
                Map<String, Object> dataMap;
                Map<String, Object> recognitionDataMap = aiRecognizerSuccessInfo.getRecognitionDataMap();
                if (recognitionDataMap == null) {
                    recognitionDataMap = new HashMap<String, Object>(1);
                }
                if ((dataMap = aiRecognizerSuccessInfo.getDataDetailMap()) == null || dataMap.isEmpty() || CollectionUtils.isEmpty(templateFieldList = templateFieldMap.get(templateId = aiRecognizerSuccessInfo.getTemplate().getId()))) continue;
                boolean noConfidence = false;
                String fieldName = "";
                int rowIndex = -1;
                block6: for (AttachmentField attachmentField : templateFieldList) {
                    if (noConfidence) break;
                    String key = attachmentField.getTemplate().isCustomTemplate() ? attachmentField.getDisplayName() : attachmentField.getName();
                    fieldName = attachmentField.getFullDisplayName();
                    if (attachmentField.getParent() == null && !attachmentField.isTable()) {
                        Object confidence = recognitionDataMap.get(key);
                        Object value = dataMap.get(key);
                        if ((confidence == null || paramValue.compareTo(new BigDecimal(String.valueOf(confidence))) <= 0) && !this.isNullValue(attachmentConfig.getCheckMethod(), value)) continue;
                        noConfidence = true;
                        break;
                    }
                    if (attachmentField.getParent() == null) continue;
                    String tableName = attachmentField.getTemplate().isCustomTemplate() ? attachmentField.getParent().getDisplayName() : attachmentField.getParent().getName();
                    List confidenceTableDataList = (List)recognitionDataMap.get(tableName);
                    List tableDataList = (List)dataMap.get(tableName);
                    if (tableDataList == null || tableDataList.isEmpty()) continue;
                    int index = 0;
                    for (Map rowDataMap : tableDataList) {
                        Map confidenceRowDataMap;
                        if (CollectionUtils.isEmpty((Collection)confidenceTableDataList) || index >= confidenceTableDataList.size() || (confidenceRowDataMap = (Map)confidenceTableDataList.get(index)) == null) {
                            rowIndex = index;
                            noConfidence = true;
                            continue block6;
                        }
                        Object confidence = confidenceRowDataMap.get(key);
                        Object value = rowDataMap.get(key);
                        if (confidence != null && paramValue.compareTo(new BigDecimal(String.valueOf(confidence))) > 0 || this.isNullValue(attachmentConfig.getCheckMethod(), value)) {
                            rowIndex = index;
                            noConfidence = true;
                            continue block6;
                        }
                        ++index;
                    }
                }
                if (!noConfidence) continue;
                noExecutorList.add(aiRecognizerSuccessInfo);
                StringBuilder sb = new StringBuilder(aiRecognizerSuccessInfo.getFileName()).append(" , ");
                sb.append(fieldName);
                if (rowIndex > -1) {
                    String rowDesc = ResManager.loadKDString((String)"\u7b2c%d\u884c", (String)"KeywordDecisionExecutor_0", (String)"data-idi-core", (Object[])new Object[0]);
                    rowDesc = String.format(rowDesc, rowIndex + 1);
                    sb.append(rowDesc);
                }
                ArrayList<HoverContent> cList = new ArrayList<HoverContent>(1);
                cList.add(HoverContent.createText((String)sb.toString()));
                decisionFrontEndResult.addHoverContent(cList);
            }
            if (!noExecutorList.isEmpty()) {
                BigDecimal grad = DecisionResult.HUNDRED.divide(new BigDecimal(successInfoList.size()), DecisionResult.DECIMAL4).multiply(new BigDecimal(noExecutorList.size()), DecisionResult.DECIMAL4);
                result.setDeductPercent(grad);
                this.deductionGrade.deduct(grad);
                relationResultList.add(result);
            }
            successInfoList.removeAll(noExecutorList);
            return noExecutorList.size();
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u7f6e\u4fe1\u5ea6\u53c2\u6570\u7f3a\u5931", (String)"AttachmentExecutor_6", (String)"data-idi-core", (Object[])new Object[0]));
    }

    private boolean isNullValue(CheckMethodEnum method, Object value) {
        return method == CheckMethodEnum.PRESET && value == null || StringUtils.isEmpty((String)String.valueOf(value));
    }

    private boolean isHead(String entryName) {
        return "".equals(entryName);
    }

    private BigDecimal calPercent(int attachmentSize, DynamicObject billObj, String entryName, Map<String, List<Integer>> canStartRowIndexMap, int noConfidenceCount) {
        BigDecimal percent;
        int successCount = attachmentSize + noConfidenceCount;
        if (this.isHead(entryName)) {
            percent = DecisionResult.HUNDRED.divide(BigDecimal.valueOf(successCount, 0), 6, RoundingMode.HALF_UP);
        } else {
            int entryRowCount = billObj.getDynamicObjectCollection(entryName).size();
            List<Integer> indexList = canStartRowIndexMap.get(entryName);
            percent = indexList == null || indexList.isEmpty() ? (entryRowCount == 0 ? DecisionResult.ZEROED : DecisionResult.HUNDRED.divide(BigDecimal.valueOf((long)successCount * (long)entryRowCount, 0), 6, RoundingMode.HALF_UP)) : DecisionResult.HUNDRED.divide(BigDecimal.valueOf((long)successCount * (long)indexList.size(), 0), 6, RoundingMode.HALF_UP);
        }
        return percent;
    }

    private AIRecognizerResult recognizer(List<Attachment> attachmentList, IAttachmentService attachmentService, AttachmentConfig attachmentConfig, String entityNumber, Map<Long, Set<String>> lcTemplateFieldMap, DynamicObject billObj, Pair<Boolean, String> lockMessage) {
        IDataEntityProperty entityProperty;
        String billNo;
        IDataEntityType billMainType = billObj.getDataEntityType();
        String billName = billMainType.getAlias();
        String billNoData = null;
        if (billMainType.getClass().isAssignableFrom(BillEntityType.class) && StringUtils.isNotEmpty((String)(billNo = ((BillEntityType)billMainType).getBillNo())) && (entityProperty = (IDataEntityProperty)billObj.getDynamicObjectType().getProperties().get((Object)billNo)) != null) {
            billNoData = billObj.getString(billNo);
        }
        AIRecognizerParam param = new AIRecognizerParam(attachmentConfig.getCheckMethod(), attachmentConfig.getValidTemplateId(), attachmentConfig.getValidTemplateNumber(), attachmentConfig.getCustomTemplateId(), attachmentConfig.getCustomTemplateNumber(), attachmentConfig.getRecognizerId(), attachmentConfig.getRecognizerNumber(), attachmentConfig.getLcTemplateId(), entityNumber, attachmentList, billName, billNoData, lcTemplateFieldMap, lockMessage);
        SchemaExecutorLogger.info((String)String.format("[DATA-IDI] AttachmentExecutor - start to recognizer attacchment, class is :%s", attachmentService.getClass()), (Object[])new Object[0]);
        return (AIRecognizerResult)attachmentService.recognizer(param);
    }

    private String comboRuleScript(List<DecisionRule> ruleList) {
        if (ruleList == null || ruleList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u68c0\u67e5\u9644\u4ef6\u5185\u5bb9\u68c0\u67e5\u672a\u914d\u7f6e\u68c0\u67e5\u89c4\u5219", (String)"AttachmentExecutor_2", (String)"data-idi-core", (Object[])new Object[0]));
        }
        return this.buildScript(ruleList);
    }

    private void noExistsAttachmentException(AttachmentConfig attachmentConfig, DecisionResult decisionResult) {
        ExceptionTip noExistsTip = this.matchExceptionTip(attachmentConfig, ExceptionTipEnum.NOEXISTS);
        decisionResult.setStatus(noExistsTip.getShowErrorTips() != false ? "empty" : "alarming");
        decisionResult.setShowText(noExistsTip.achieveTipWords());
        this.deductionGrade.deduct(noExistsTip.getShowErrorTips() != false ? 0 : noExistsTip.getPercent());
    }

    private ExceptionTip matchExceptionTip(AttachmentConfig attachmentConfig, ExceptionTipEnum tipEnum) {
        List<ExceptionTip> exceptionTipList = attachmentConfig.getExceptionTipList();
        if (exceptionTipList == null || exceptionTipList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5f02\u5e38\u60c5\u51b5\u5904\u7406\u4fe1\u606f", (String)"AttachmentExecutor_7", (String)"data-idi-core", (Object[])new Object[0]));
        }
        Optional<ExceptionTip> matException = exceptionTipList.stream().filter(tip -> tip.getExceptionTipItem() == tipEnum).findAny();
        if (matException.isPresent()) {
            return matException.get();
        }
        String templateStr = ResManager.loadKDString((String)"\u672a\u914d\u7f6e%s\u5f02\u5e38\u60c5\u51b5\u5904\u7406\u4fe1\u606f", (String)"AttachmentExecutor_8", (String)"data-idi-core", (Object[])new Object[0]);
        String error = String.format(templateStr, tipEnum.convertDescription());
        throw new KDBizException(error);
    }

    private void checkExists(List<Attachment> attachmentList, IAttachmentService attachmentService, DecisionResult decisionResult, AttachmentConfig attachmentConfig, String entityNumber, DynamicObject billObj, MainEntityType srcEntityType, Map<Long, Set<String>> lcTemplateFieldMap, Pair<Boolean, String> lockMessage, boolean needHighLight) {
        SchemaExecutorLogger.info((String)String.format("[DATA-IDI] AttachmentExecutor attachmentList:%s", IDIJSONUtils.toJsonString(attachmentList)), (Object[])new Object[0]);
        if (attachmentList == null || attachmentList.isEmpty()) {
            decisionResult.setStatus("alarming");
            decisionResult.setShowText(attachmentConfig.achieveNotExistWords());
            this.deductionGrade.deduct(100);
            return;
        }
        AIRecognizerResult recognizerResult = this.recognizer(attachmentList, attachmentService, attachmentConfig, entityNumber, lcTemplateFieldMap, billObj, lockMessage);
        List successInfoList = recognizerResult.getDetailDatas();
        List errorInfoList = recognizerResult.getErrorInfos();
        SchemaExecutorLogger.info((String)String.format("[DATA-IDI] AttachmentExecutor successInfoList:%s", IDIJSONUtils.toJsonString((Object)successInfoList)), (Object[])new Object[0]);
        SchemaExecutorLogger.info((String)String.format("[DATA-IDI] AttachmentExecutor errorInfoList:%s", IDIJSONUtils.toJsonString((Object)errorInfoList)), (Object[])new Object[0]);
        if (CollectionUtils.isEmpty((Collection)successInfoList) && CollectionUtils.isEmpty((Collection)errorInfoList)) {
            decisionResult.setStatus("alarming");
            decisionResult.setShowText(attachmentConfig.achieveNotExistWords());
            this.deductionGrade.deduct(100);
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)successInfoList)) {
            decisionResult.setStatus("green");
            decisionResult.setShowText(attachmentConfig.achieveExistWords());
            AIParam fieldQueryParam = new AIParam(attachmentConfig.getCheckMethod(), attachmentConfig.getValidTemplateId(), attachmentConfig.getValidTemplateNumber(), attachmentConfig.getCustomTemplateId(), attachmentConfig.getCustomTemplateNumber(), attachmentConfig.getRecognizerId(), attachmentConfig.getRecognizerNumber(), attachmentConfig.getLcTemplateId(), entityNumber);
            List fieldList = attachmentService.queryTemplateField(fieldQueryParam);
            ArrayList<DecisionFrontEndResult> frontEndResultList = new ArrayList<DecisionFrontEndResult>(successInfoList.size());
            for (AIRecognizerSuccessInfo aiRecognizerSuccessInfo : successInfoList) {
                List<Map<String, Object>> dataList = this.processAttachmentData(aiRecognizerSuccessInfo, fieldList, new HashMap<Long, String>(1));
                for (Map<String, Object> stringObjectMap : dataList) {
                    DecisionFrontEndResult frontEndResult = this.buildFrontEndResult(stringObjectMap, billObj, attachmentConfig, srcEntityType, "", -1, aiRecognizerSuccessInfo.getTemplate().getId());
                    if (frontEndResult == null) continue;
                    frontEndResultList.add(frontEndResult);
                }
            }
            DecisionFrontEndResult frontEndResult = this.reduceFrontEndResult(frontEndResultList);
            decisionResult.setFrontEndResult(frontEndResult);
            if (needHighLight) {
                Set<String> panelKeySet = attachmentList.stream().map(Attachment::getAttachmentPanelName).collect(Collectors.toSet());
                String[] panelKeys = panelKeySet.toArray(new String[0]);
                HighLightBuilder highLightBuilder = new HighLightBuilder();
                ArrayList<BaseHighLight> allHighLightList = new ArrayList<BaseHighLight>(5);
                highLightBuilder.buildAttachmentHighLight(Integer.MAX_VALUE, "", srcEntityType.getName(), srcEntityType, null, allHighLightList, panelKeys);
                if (!allHighLightList.isEmpty()) {
                    decisionResult.setHighLightList(allHighLightList);
                }
            }
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)errorInfoList)) {
            if (errorInfoList.size() < attachmentList.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9644\u4ef6\u6570\u91cf\u4e0e\u9644\u4ef6\u8bc6\u522b\u7ed3\u679c\u6570\u91cf\u4e0d\u4e00\u81f4", (String)"AttachmentExecutor_9", (String)"data-idi-core", (Object[])new Object[0]));
            }
            SchemaExecutorLogger.info((String)("AttachmentExecutor: errorInfoList.size():" + errorInfoList.size() + ", attachmentList.size() : " + attachmentList.size()), (Object[])new Object[0]);
            decisionResult.setStatus("alarming");
            this.deductionGrade.deduct(100);
            if (this.isSameErrorAttachment(errorInfoList)) {
                decisionResult.setShowText(attachmentConfig.achieveNotExistWords());
            } else {
                DecisionFrontEndResult decisionFrontEndResult = new DecisionFrontEndResult();
                decisionResult.setFrontEndResult(decisionFrontEndResult);
                for (AIRecognizerErrorInfo aiRecognizerErrorInfo : errorInfoList) {
                    if (this.isNoRecognizer(aiRecognizerErrorInfo.getErrorCode())) continue;
                    ArrayList<HoverContent> hcList = new ArrayList<HoverContent>(errorInfoList.size());
                    decisionFrontEndResult.addHoverContent(hcList);
                    String font = aiRecognizerErrorInfo.getFileName() + " , " + aiRecognizerErrorInfo.getDescription();
                    hcList.add(HoverContent.createText((String)font));
                }
                if (decisionFrontEndResult.getHoverContent() != null) {
                    decisionResult.setShowText(ResManager.loadKDString((String)"\u5b58\u5728\u8bc6\u522b\u5931\u8d25\u7684\u9644\u4ef6", (String)"AttachmentExecutor_4", (String)"data-idi-core", (Object[])new Object[0]));
                }
            }
        }
    }

    private DecisionFrontEndResult reduceFrontEndResult(List<DecisionFrontEndResult> frontEndResultList) {
        List<List<HoverContent>> hoverContentList;
        if (frontEndResultList == null || frontEndResultList.isEmpty()) {
            return null;
        }
        List<List<HoverContent>> list = hoverContentList = frontEndResultList.get(0) != null ? frontEndResultList.get(0).getHoverContent() : null;
        if (hoverContentList == null || hoverContentList.isEmpty()) {
            return null;
        }
        DecisionFrontEndResult decisionFrontEndResult = new DecisionFrontEndResult();
        List<HoverContent> titleList = frontEndResultList.get(0).getHoverContent().get(0);
        if (frontEndResultList.size() > 1) {
            decisionFrontEndResult.setTableStyle(true);
            decisionFrontEndResult.addHoverContent(titleList);
            for (DecisionFrontEndResult result : frontEndResultList) {
                List<HoverContent> valueList = result.getHoverContent().get(1);
                decisionFrontEndResult.addHoverContent(valueList);
            }
        } else {
            int rowCount = titleList.size();
            List<List<HoverContent>> dataList = frontEndResultList.get(0).getHoverContent();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                ArrayList<HoverContent> rowList = new ArrayList<HoverContent>(rowCount);
                for (List<HoverContent> hoverContents : dataList) {
                    HoverContent hc = rowIndex >= hoverContents.size() ? HoverContent.createText((String)" ") : hoverContents.get(rowIndex);
                    rowList.add(hc);
                }
                decisionFrontEndResult.addHoverContent(rowList);
            }
        }
        return decisionFrontEndResult;
    }

    private List<AttachmentField> queryAttachmentField(String entityType, AttachmentConfig attachmentConfig, IAttachmentService attachmentService) {
        AIParam fieldQueryParam = new AIParam(attachmentConfig.getCheckMethod(), attachmentConfig.getValidTemplateId(), attachmentConfig.getValidTemplateNumber(), attachmentConfig.getCustomTemplateId(), attachmentConfig.getCustomTemplateNumber(), attachmentConfig.getRecognizerId(), attachmentConfig.getRecognizerNumber(), attachmentConfig.getLcTemplateId(), entityType);
        return attachmentService.queryTemplateField(fieldQueryParam);
    }

    private List<Attachment> queryAttachmentInfo(SchemaContext context, AttachmentConfig attachmentConfig, IAttachmentService attachmentService) {
        Long billId = (Long)context.getBillId();
        if (billId == null) {
            DynamicObject billObj = context.getSelfBill();
            billId = billObj.getLong("id");
            if (Long.valueOf(0L).compareTo(billId) == 0) {
                return new ArrayList<Attachment>(0);
            }
        }
        boolean decrypt = CheckMethodEnum.RECOGNIZER != attachmentConfig.getCheckMethod();
        return attachmentService.queryAttachmentInfo(billId, context.getEntityType(), decrypt);
    }

    private boolean canStart(SchemaContext context, AttachmentConfig attachmentConfig, Map<String, List<Integer>> canStartRowIndexMap, MainEntityType srcEntityType) {
        DynamicObject billObj = context.getSelfBill();
        IDICondition startCondition = attachmentConfig.getStartCondition();
        String entryName = this.validateMoreEntry(startCondition, srcEntityType, ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6\u4e0d\u652f\u6301\u8de8\u6e90\u5355\u7684\u591a\u4e2a\u5206\u5f55\u3002", (String)"LinkUpBillDecisionExecutor_12", (String)"data-idi-core", (Object[])new Object[0]));
        if (startCondition != null && StringUtils.isNotEmpty((String)startCondition.getScript())) {
            ArrayList canStartRowIndexList = new ArrayList(10);
            ScriptLocaleFieldHandler localeFieldHandler = new ScriptLocaleFieldHandler();
            String script = localeFieldHandler.processLocaleField(startCondition.getScript(), new String[]{srcEntityType.getName()}, billObj);
            HashMap<String, Object> ctx = new HashMap<String, Object>(1);
            ctx.put(context.getEntityType() + "_billObj", billObj);
            ArrayList matchList = new ArrayList();
            ctx.put("matchList", matchList);
            String templateScript = "if (%s) {\n  matchList.add(%d);\n}\n";
            if (StringUtils.isNotEmpty((String)entryName)) {
                DynamicObjectCollection entryCols = billObj.getDynamicObjectCollection(entryName);
                int size = entryCols.size();
                StringBuilder scriptBuilder = new StringBuilder();
                int loopSize = Math.min(size, 2000);
                int entryIndex = 0;
                while (entryIndex < loopSize) {
                    for (int batch = 0; batch < 10 && entryIndex < loopSize; ++entryIndex, ++batch) {
                        String entryScript = ScriptUtils.supportEntryProperty((DynamicObjectType)srcEntityType, script, entryIndex);
                        scriptBuilder.append(String.format(templateScript, entryScript, entryIndex));
                    }
                    String batchScript = scriptBuilder.toString();
                    SchemaExecutorLogger.info((String)"start contion script run,  script: %s , param : %s", (Object[])new Object[]{batchScript, ctx});
                    ScriptFormIdHandler.runScript((String)context.getEntityType(), (String)context.getEntityType(), ctx, (String)batchScript);
                    scriptBuilder.setLength(0);
                }
            } else {
                script = String.format(templateScript, script, -1);
                SchemaExecutorLogger.info((String)"start contion script run,  script: %s , param : %s", (Object[])new Object[]{script, ctx});
                ScriptFormIdHandler.runScript((String)context.getEntityType(), (String)context.getEntityType(), ctx, (String)script);
            }
            boolean result = !matchList.isEmpty();
            matchList.remove((Object)-1);
            canStartRowIndexList.addAll(matchList);
            canStartRowIndexMap.put(entryName, canStartRowIndexList);
            return result;
        }
        return true;
    }

    private String validateMoreEntry(IDICondition condition, MainEntityType entityType, String errorText) {
        if (condition != null) {
            return this.validateMoreEntry(condition.getScript(), entityType, errorText);
        }
        return null;
    }

    private String validateMoreEntry(String script, MainEntityType entityType, String errorText) {
        if (StringUtils.isNotEmpty((String)script)) {
            Set<String> propSet = ScriptUtils.getEntries(entityType, script, new String[]{entityType.getName()});
            if (propSet.size() > 1) {
                throw new KDBizException(errorText);
            }
            if (propSet.isEmpty()) {
                return "";
            }
            return propSet.iterator().next();
        }
        return null;
    }

    private Map<Long, String> validateMoreTable(String script, List<Long> templateIdList, String sourceEntityName) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        if (!templateIdList.isEmpty()) {
            Set vars = ScriptFormIdHandler.extractVariables((String)script, (String[])new String[]{sourceEntityName});
            for (Long aLong : templateIdList) {
                String prefix = IDIStringUtils.templatePrefix((Long)aLong);
                for (String var : vars) {
                    String[] properties = var.split("\\.");
                    if (properties.length <= 2 || !var.startsWith(prefix)) continue;
                    String previousTable = (String)map.get(aLong);
                    if (previousTable == null || previousTable.equals(properties[1])) {
                        map.put(aLong, properties[1]);
                        continue;
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u68c0\u67e5\u89c4\u5219\u4e0d\u652f\u6301\u8de8\u6a21\u677f\u7684\u591a\u4e2a\u8868\u683c\u3002", (String)"AttachmentExecutor_10", (String)"data-idi-core", (Object[])new Object[0]));
                }
            }
        }
        return map;
    }

    /*
     * Unable to fully structure code
     */
    private List<Long> queryTemplateId(CheckMethodEnum checkMethod, Long customTemplateId, Long recognizerId, Long lcTemplateId) {
        templateIdList = new ArrayList<Long>(2);
        switch (1.$SwitchMap$kd$data$idi$data$attachment$CheckMethodEnum[checkMethod.ordinal()]) {
            case 1: {
                templateIdList.add(customTemplateId);
                break;
            }
            case 2: {
                templateIdList.add(lcTemplateId);
                break;
            }
            case 3: {
                dataSet = QueryServiceHelper.queryDataSet((String)"AttachmentExecutor.queryTemplateId", (String)"cvp_cls_info", (String)"template_infos.included_template.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)recognizerId)}, null);
                var7_7 = null;
                for (Row row : dataSet) {
                    templateIdList.add(row.getLong("template_infos.included_template.id"));
                }
                if (dataSet == null) break;
                if (var7_7 == null) ** GOTO lbl27
                try {
                    dataSet.close();
                }
                catch (Throwable var8_9) {
                    var7_7.addSuppressed(var8_9);
                }
                break;
lbl27:
                // 1 sources

                dataSet.close();
                break;
                catch (Throwable var8_10) {
                    try {
                        var7_7 = var8_10;
                        throw var8_10;
                    }
                    catch (Throwable var10_12) {
                        if (dataSet != null) {
                            if (var7_7 != null) {
                                try {
                                    dataSet.close();
                                }
                                catch (Throwable var11_13) {
                                    var7_7.addSuppressed(var11_13);
                                }
                            } else {
                                dataSet.close();
                            }
                        }
                        throw var10_12;
                    }
                }
            }
        }
        return templateIdList;
    }
}

