/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.data.BillFlowConfig;
import kd.data.idi.data.BillFlowConfigDetail;
import kd.data.idi.data.BillFlowResult;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.LineCard;
import kd.data.idi.data.NodeLineStatusEnum;
import kd.data.idi.data.NodeStatusEnum;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.data.TableLineNode;
import kd.data.idi.engine.DecisionExecutor;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.SelectDecisionExecutor;

public class BillFlowExecutor
extends SelectDecisionExecutor
implements DecisionExecutor {
    private static final long ONE_DAY = 86400000L;

    public DecisionResult execute(SchemaContext context, Decision decision) {
        SelectDecisionExecutor.StartConditionParam param;
        if (decision.getBillFlowConfig() == null || decision.getBillFlowConfig().getDetailList() == null || decision.getBillFlowConfig().getDetailList().isEmpty()) {
            SchemaExecutorLogger.info((String)ResManager.loadKDString((String)"\u4e0a\u4e0b\u6e38\u5355\u636e\u4fe1\u606f\u914d\u7f6e\u4e3a\u7a7a", (String)"BillFlowExecutor_2", (String)"data-idi-core", (Object[])new Object[0]), (Object[])new Object[0]);
            return null;
        }
        IDICondition startCondition = decision.getStartCondition();
        if (startCondition != null && StringUtils.isNotEmpty((String)startCondition.getScript()) && !this.checkStartCondition(param = new SelectDecisionExecutor.StartConditionParam(context.getSelfBill(), context.getSrcEntityType(), startCondition, false))) {
            DecisionResult result = new DecisionResult();
            result.setStatus("empty");
            result.setDecision(decision);
            result.setShowText(String.format(ResManager.loadKDString((String)"%s : \u542f\u52a8\u6761\u4ef6\u4e0d\u6ee1\u8db3", (String)"GeneralLedgerExecutor_7", (String)"data-idi-core", (Object[])new Object[0]), decision.getName()));
            return result;
        }
        BillFlowConfig billFlowConfig = decision.getBillFlowConfig();
        LinkedHashMap<String, HashSet<Long>> allBillId = this.getAllBillIds(context.getEntityType(), (Long)context.getBillId());
        BillFlowResult billFlowResult = this.buildResult(context, billFlowConfig, allBillId);
        DecisionResult result = new DecisionResult();
        result.setDecision(decision);
        result.setBillFlowResult(billFlowResult);
        result.setStatus("green");
        return result;
    }

    private BillFlowResult buildResult(SchemaContext context, BillFlowConfig billFlowConfig, Map<String, HashSet<Long>> allBillId) {
        List<List<DynamicObject>> nodeBillList = this.queryAllBills(context, billFlowConfig, allBillId);
        for (BillFlowConfigDetail detail : billFlowConfig.getDetailList()) {
            detail.setCalculateDistanceDays(true);
        }
        Date dateOfDeadline = this.getDateOfDeadline(billFlowConfig, nodeBillList);
        boolean isBillAfterDeadLine = false;
        ArrayList<TableLineNode> nodeList = new ArrayList<TableLineNode>(nodeBillList.size());
        Date lastDateOfBillType = null;
        for (List<DynamicObject> objectList : nodeBillList) {
            String billType = objectList.get(0).getDataEntityType().getName();
            BillFlowConfigDetail detail = null;
            for (BillFlowConfigDetail detail1 : billFlowConfig.getDetailList()) {
                if (!detail1.getBillTypeNumber().equals(billType)) continue;
                detail = detail1;
                break;
            }
            if (detail == null) {
                detail = new BillFlowConfigDetail();
                detail.setBillTypeNumber(billType);
                ArrayList<String> displayFieldList = new ArrayList<String>();
                displayFieldList.add("billno");
                detail.setDisplayFieldList(displayFieldList);
                detail.setCalculateDistanceDays(false);
            }
            nodeList.add(this.buildOneBillNode(detail, objectList, lastDateOfBillType, context.getEntityType().equals(billType)));
            lastDateOfBillType = objectList.size() == 1 && detail.getDateFieldName() != null ? objectList.get(0).getDate(detail.getDateFieldName()) : null;
            if (isBillAfterDeadLine) continue;
            isBillAfterDeadLine = this.isBillAfterDeadLineDate(detail, objectList, dateOfDeadline);
        }
        if (StringUtils.isNotEmpty((String)billFlowConfig.getBillTypeNumberOfDeadline())) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)billFlowConfig.getBillTypeNumberOfDeadline());
            DynamicProperty dateProp = type.getProperty(billFlowConfig.getDateFieldOfDeadline());
            String fieldName = dateProp != null ? dateProp.getDisplayName().toString() : "";
            TableLineNode tableLineNode = new TableLineNode();
            tableLineNode.setStatus(NodeStatusEnum.FUTURE);
            tableLineNode.setTitle(type.getDisplayName().getLocaleValue() + fieldName);
            tableLineNode.setLineStatus(NodeLineStatusEnum.PLAN);
            if (dateOfDeadline != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                HoverContent hoverContent = HoverContent.createText((String)simpleDateFormat.format(dateOfDeadline));
                if (isBillAfterDeadLine) {
                    hoverContent.addData("color", (Object)"#FB2323");
                } else {
                    hoverContent.addData("color", (Object)"#98A1A8");
                }
                tableLineNode.addTitleDescrpt(hoverContent);
            }
            nodeList.add(tableLineNode);
        }
        if (!nodeList.isEmpty()) {
            TableLineNode lastTableLineNode = (TableLineNode)nodeList.get(nodeList.size() - 1);
            lastTableLineNode.setLineStatus(null);
        }
        BillFlowResult billFlowResult = new BillFlowResult();
        billFlowResult.setNodeList(nodeList);
        return billFlowResult;
    }

    private List<List<DynamicObject>> queryAllBills(SchemaContext context, BillFlowConfig billFlowConfig, Map<String, HashSet<Long>> allBillIdMap) {
        ArrayList<List<DynamicObject>> billList = new ArrayList<List<DynamicObject>>(billFlowConfig.getDetailList().size());
        for (Map.Entry<String, HashSet<Long>> entry : allBillIdMap.entrySet()) {
            boolean found = false;
            for (int index = 0; index < billFlowConfig.getDetailList().size(); ++index) {
                BillFlowConfigDetail detail = (BillFlowConfigDetail)billFlowConfig.getDetailList().get(index);
                if (!detail.getBillTypeNumber().equals(entry.getKey())) continue;
                billList.add(this.queryBillObjects(billFlowConfig, detail, entry.getKey(), (Set<Long>)entry.getValue()));
                found = true;
            }
            if (found) continue;
            billList.add(this.queryBillObjects(billFlowConfig, null, entry.getKey(), (Set<Long>)entry.getValue()));
        }
        return billList;
    }

    private boolean isBillAfterDeadLineDate(BillFlowConfigDetail detail, List<DynamicObject> objectList, Date dateOfDeadline) {
        if (detail.getDateFieldName() != null) {
            for (DynamicObject billObj : objectList) {
                ExecutorHelper.ValueAndName valueAndName = ExecutorHelper.getValueAndNameByName(billObj, detail.getDateFieldName(), false);
                Date billDate = this.getDate(valueAndName);
                if (billDate == null || dateOfDeadline == null || !billDate.after(dateOfDeadline)) continue;
                return true;
            }
        }
        return false;
    }

    private Date getDateOfDeadline(BillFlowConfig billFlowConfig, List<List<DynamicObject>> billList) {
        ExecutorHelper.ValueAndName valueAndName = null;
        for (List<DynamicObject> objectList : billList) {
            DynamicObject billObj = objectList.get(0);
            String billType = billObj.getDataEntityType().getName();
            if (!billType.equals(billFlowConfig.getBillTypeNumberOfDeadline())) continue;
            valueAndName = ExecutorHelper.getValueAndNameByName(billObj, billFlowConfig.getDateFieldOfDeadline(), false);
            break;
        }
        return this.getDate(valueAndName);
    }

    private Date getDate(ExecutorHelper.ValueAndName valueAndName) {
        if (valueAndName != null && valueAndName.getValue() instanceof Date) {
            return (Date)valueAndName.getValue();
        }
        return null;
    }

    private TableLineNode buildOneBillNode(BillFlowConfigDetail detail, List<DynamicObject> objectList, Date lastDateOfBillType, boolean isCurrentBill) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)detail.getBillTypeNumber());
        TableLineNode tableLineNode = new TableLineNode();
        tableLineNode.setStatus(isCurrentBill ? NodeStatusEnum.NOW : NodeStatusEnum.PAST);
        tableLineNode.setTitle(type.getDisplayName().getLocaleValue());
        tableLineNode.setLineStatus(NodeLineStatusEnum.COMPLETE);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (detail.getDateFieldName() != null) {
            Date billDate = objectList.get(0).getDate(detail.getDateFieldName());
            if (objectList.size() == 1 && billDate != null) {
                List<HoverContent> hoverContents = this.calculateDistanceDays(detail, billDate, lastDateOfBillType);
                if (hoverContents != null) {
                    for (HoverContent hoverContent : hoverContents) {
                        tableLineNode.addTitleDescrpt(hoverContent);
                    }
                }
                tableLineNode.addTitleDescrpt(HoverContent.createText((String)simpleDateFormat.format(billDate)));
            }
        }
        for (DynamicObject billObj : objectList) {
            ArrayList<HoverContent> rightTextList;
            LineCard lineCard = new LineCard();
            ExecutorHelper.ValueAndName valueAndName = ExecutorHelper.getValueAndNameByName(billObj, detail.getDateFieldName(), false);
            if (objectList.size() > 1 && detail.getDateFieldName() != null) {
                HoverContent textContent;
                lineCard.addLeftText(HoverContent.createText((String)valueAndName.getName()));
                rightTextList = new ArrayList<HoverContent>(4);
                Date billDate = (Date)valueAndName.getValue();
                List<HoverContent> hoverContents = this.calculateDistanceDays(detail, billDate, lastDateOfBillType);
                if (hoverContents != null) {
                    rightTextList.addAll(hoverContents);
                }
                if ((textContent = HoverContent.createText((String)simpleDateFormat.format(billDate))) != null) {
                    rightTextList.add(textContent);
                }
                if (!rightTextList.isEmpty()) {
                    lineCard.addRightText(rightTextList);
                }
            }
            int i = 0;
            for (String displayField : detail.getDisplayFieldList()) {
                HoverContent rightContent;
                if (detail.getDateFieldName() != null && displayField.equals(detail.getDateFieldName())) continue;
                valueAndName = ExecutorHelper.getValueAndNameByName(billObj, displayField, true);
                IDataEntityProperty entityProperty = valueAndName.getEntityProperty();
                String fieldDisplayName = detail.getDisplayFieldNameList() != null && detail.getDisplayFieldNameList().get(i) != null ? detail.getDisplayFieldNameList().get(i) : valueAndName.getName();
                lineCard.addLeftText(HoverContent.createText((String)fieldDisplayName));
                if ("billno".equals(displayField)) {
                    rightContent = HoverContent.createHref((String)((String)valueAndName.getValue()), (DynamicObject)billObj);
                } else {
                    Object itemValue = valueAndName.getValue();
                    Object formatValue = ExecutorHelper.tryToString(billObj, billObj, itemValue, entityProperty);
                    String valStr = formatValue == null ? " " : formatValue.toString();
                    rightContent = valueAndName.isUser() ? HoverContent.createChat((String)valStr, (Object)valueAndName.getRefValue()) : HoverContent.createText((String)valStr);
                }
                rightTextList = new ArrayList(1);
                rightTextList.add(rightContent);
                lineCard.addRightText(rightTextList);
                ++i;
            }
            tableLineNode.addCard(lineCard);
        }
        return tableLineNode;
    }

    private List<HoverContent> calculateDistanceDays(BillFlowConfigDetail detail, Date billDate, Date lastDateOfBillType) {
        if (detail.isCalculateDistanceDays() && lastDateOfBillType != null) {
            long diff_ms = Math.abs(billDate.getTime() - lastDateOfBillType.getTime());
            long days = diff_ms % 86400000L == 0L ? diff_ms / 86400000L : diff_ms / 86400000L + 1L;
            ArrayList<HoverContent> hoverContents = new ArrayList<HoverContent>(3);
            hoverContents.add(HoverContent.createText((String)ResManager.loadKDString((String)"\u76f8\u8ddd", (String)"BillFlowExecutor_0", (String)"data-idi-core", (Object[])new Object[0])));
            HoverContent hoverContent = HoverContent.createText((String)(days > 99L ? "99+" : String.valueOf(days)));
            hoverContent.addData("color", (Object)"#ED812B");
            hoverContents.add(hoverContent);
            hoverContents.add(HoverContent.createText((String)ResManager.loadKDString((String)"\u5929", (String)"BillFlowExecutor_1", (String)"data-idi-core", (Object[])new Object[0])));
            return hoverContents;
        }
        return null;
    }

    private List<DynamicObject> queryBillObjects(BillFlowConfig billFlowConfig, BillFlowConfigDetail detail, String billType, Set<Long> idSet) {
        String orderBy;
        HashSet<String> propSet = new HashSet<String>();
        propSet.add("id");
        propSet.add("billno");
        if (detail != null) {
            propSet.add(detail.getDateFieldName());
            if (detail.getDisplayFieldList() != null && !detail.getDisplayFieldList().isEmpty()) {
                propSet.addAll(detail.getDisplayFieldList());
            }
        }
        if (billType.equals(billFlowConfig.getBillTypeNumberOfDeadline())) {
            propSet.add(billFlowConfig.getDateFieldOfDeadline());
        }
        QFilter qfilter = new QFilter("id", "in", idSet);
        String selectField = "id";
        if (detail != null) {
            orderBy = detail.getDateFieldName() + " desc";
            selectField = selectField + "," + detail.getDateFieldName();
        } else {
            orderBy = "billno desc";
        }
        Object[] pks = new Object[idSet.size()];
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.data.idi.engine.BillFlowExecutor", (String)billType, (String)selectField, (QFilter[])new QFilter[]{qfilter}, (String)orderBy);){
            int i = 0;
            for (Row row : ds) {
                pks[i++] = row.get("id");
            }
        }
        DynamicObject[] billObjs = ExecutorHelper.loadObjects(pks, billType, propSet);
        ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>();
        Collections.addAll(objList, billObjs);
        return objList;
    }

    public LinkedHashMap<String, HashSet<Long>> getAllBillIds(String theBillType, Long theBillId) {
        LinkedHashMap<String, HashSet<Long>> allBills = new LinkedHashMap<String, HashSet<Long>>();
        Map<String, HashSet<Long>> linkUpBills = ExecutorHelper.getLinkUpBills(theBillId, theBillType);
        if (!linkUpBills.isEmpty()) {
            ArrayList<String> billTypeList = new ArrayList<String>(linkUpBills.size());
            for (Map.Entry<String, HashSet<Long>> entry : linkUpBills.entrySet()) {
                billTypeList.add(entry.getKey());
            }
            for (int i = billTypeList.size() - 1; i >= 0; --i) {
                allBills.put((String)billTypeList.get(i), linkUpBills.get(billTypeList.get(i)));
            }
        }
        HashSet<Long> theBillList = new HashSet<Long>();
        theBillList.add(theBillId);
        allBills.put(theBillType, theBillList);
        Map<String, HashSet<Long>> linkDownBillIds = ExecutorHelper.loadLinkDownBillIds(theBillId, theBillType);
        for (Map.Entry<String, HashSet<Long>> entry : linkDownBillIds.entrySet()) {
            allBills.put(entry.getKey(), entry.getValue());
        }
        return allBills;
    }
}

