/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.util.IDIJSONUtils;
import kd.data.idi.util.InvoiceParser;

public class IDIInvoiceCloudHelper {
    private static final String SUCCESS_CODE = "0000";
    public static final String INVOICE = "invoiceData";
    public static final String REPEAT = "repeatData";

    public static Map<String, String> checkContinuous(DynamicObject sourceBillObj, String costCompanyField, String serialNoField) {
        if (sourceBillObj == null || StringUtils.isEmpty((String)costCompanyField) || StringUtils.isEmpty((String)serialNoField)) {
            SchemaExecutorLogger.info((String)" sourceBillObj is null or costCompanyField is null or serialNoField is null", (Object[])new Object[0]);
            return null;
        }
        DynamicObjectType dt = sourceBillObj.getDynamicObjectType();
        String entityNumber = dt.getName();
        Object billId = sourceBillObj.getPkValue();
        DynamicObject costCompanyObject = (DynamicObject)sourceBillObj.get(costCompanyField);
        if (costCompanyObject == null) {
            SchemaExecutorLogger.info((String)ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4fe1\u606f", (String)"IDIInvoicePiaoZoneHelper_16", (String)"data-idi-core", (Object[])new Object[0]), (Object[])new Object[0]);
            return null;
        }
        ExecutorHelper.ValueAndName serialNoValueAndName = ExecutorHelper.getValueAndNameByName(sourceBillObj, serialNoField, true);
        Object serialNoValue = serialNoValueAndName.getValue();
        if (null == serialNoValue || serialNoValue instanceof String && StringUtils.isEmpty((String)((String)serialNoValue)) || serialNoValue instanceof List && CollectionUtils.isEmpty((Collection)((List)serialNoValue)) || serialNoValue instanceof LinkedHashMap && ((LinkedHashMap)serialNoValue).isEmpty()) {
            SchemaExecutorLogger.info((String)"serialNoValue is null", (Object[])new Object[0]);
            return null;
        }
        Long orgId = costCompanyObject.getLong("id");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(10);
        paramMap.put("billType", entityNumber);
        paramMap.put("billId", String.valueOf(billId));
        paramMap.put("resource", "4");
        paramMap.put("orgId", orgId);
        ArrayList<Object> serialNoList = new ArrayList<Object>(3);
        if (serialNoValue instanceof List) {
            serialNoList.addAll((List)serialNoValue);
        } else if (serialNoValue instanceof LinkedHashMap) {
            Map subDataMap = (Map)serialNoValue;
            subDataMap.forEach((index, valueList) -> {
                if (CollectionUtils.isNotEmpty((Collection)valueList)) {
                    serialNoList.addAll((Collection<Object>)valueList);
                }
            });
        } else {
            serialNoList.add(serialNoValue);
        }
        paramMap.put("serialNos", serialNoList);
        Map result = null;
        try {
            result = (Map)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"queryVerify", (Object[])new Object[]{paramMap});
        }
        catch (Exception ex) {
            SchemaExecutorLogger.error((Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u661f\u701a\u53d1\u7968\u4e91\u7684\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"IDIInvoiceCloudHelper_1", (String)"data-idi-core", (Object[])new Object[0]));
        }
        SchemaExecutorLogger.info((String)("queryVerify result:" + result), (Object[])new Object[0]);
        if (result != null && !result.isEmpty() && SUCCESS_CODE.equals(result.get("errcode"))) {
            HashMap<String, String> sequenceNoMap = new HashMap<String, String>(10);
            JSONArray dataList = (JSONArray)result.get("data");
            if (CollectionUtils.isNotEmpty((Collection)dataList)) {
                block2: for (int index2 = 0; index2 < dataList.size(); ++index2) {
                    String errorLevel;
                    JSONObject item = dataList.getJSONObject(index2);
                    if (item == null || Integer.parseInt(errorLevel = item.getString("errorLevel")) >= 3) continue;
                    String serialNo = item.getString("serialNo");
                    JSONArray verifyResult = item.getJSONArray("verifyResult");
                    if (!CollectionUtils.isNotEmpty((Collection)verifyResult)) continue;
                    for (int verifyIndex = 0; verifyIndex < verifyResult.size(); ++verifyIndex) {
                        JSONObject verifyResultDto = verifyResult.getJSONObject(verifyIndex);
                        if (verifyResultDto == null || verifyResultDto == null || !"sequence_no".equals(verifyResultDto.getString("configType"))) continue;
                        sequenceNoMap.put(serialNo, verifyResultDto.getString("msg"));
                        continue block2;
                    }
                }
            }
            return sequenceNoMap;
        }
        return null;
    }

    public static Map<String, Object> queryInvoice(DynamicObject billObj) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (billObj == null) {
            return dataMap;
        }
        List<String> expenseIdList = IDIInvoiceCloudHelper.achieveExpense(billObj);
        long startTime = System.currentTimeMillis();
        for (String reimbursementId : expenseIdList) {
            IDIInvoiceCloudHelper.queryInvoiceCore(billObj, reimbursementId, dataMap);
        }
        SchemaExecutorLogger.info((String)"use invoiceCloud,  query :%d, cost: %d (ms)", (Object[])new Object[]{expenseIdList.size(), System.currentTimeMillis() - startTime});
        return dataMap;
    }

    public static void queryInvoiceCore(DynamicObject billObj, String reimbursementId, Map<String, Object> dataMap) {
        JSONObject resultJson = null;
        try {
            resultJson = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"InputService", (String)"queryInvoiceByExpenseId", (Object[])new Object[]{reimbursementId});
        }
        catch (Exception ex) {
            SchemaExecutorLogger.error((Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u661f\u701a\u53d1\u7968\u4e91\u7684\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"IDIInvoiceCloudHelper_1", (String)"data-idi-core", (Object[])new Object[0]));
        }
        SchemaExecutorLogger.info((String)"use invoiceCloud, billid %s, result %s", (Object[])new Object[]{reimbursementId, resultJson});
        if (resultJson == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u63a5\u661f\u701a\u53d1\u7968\u4e91\u5f02\u5e38", (String)"IDIInvoiceCloudHelper_0", (String)"data-idi-core", (Object[])new Object[0]));
        }
        String errcode = resultJson.getString("errcode");
        if (!SUCCESS_CODE.equals(errcode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u63a5\u661f\u701a\u53d1\u7968\u4e91\u5f02\u5e38", (String)"IDIInvoiceCloudHelper_0", (String)"data-idi-core", (Object[])new Object[0]));
        }
        String imageNumber = InvoiceParser.getImageNumber(billObj.getPkValue().toString());
        JSONArray invoiceJsonArray = resultJson.getJSONArray("data");
        if (invoiceJsonArray != null && !invoiceJsonArray.isEmpty()) {
            HashMap<String, List<RepeatInvoiceInfo>> repeatMap;
            ArrayList<DynamicObject> successInvoiceList = (ArrayList<DynamicObject>)dataMap.get(INVOICE);
            if (successInvoiceList == null) {
                successInvoiceList = new ArrayList<DynamicObject>(invoiceJsonArray.size());
                dataMap.put(INVOICE, successInvoiceList);
            }
            if ((repeatMap = (HashMap<String, List<RepeatInvoiceInfo>>)dataMap.get(REPEAT)) == null) {
                repeatMap = new HashMap<String, List<RepeatInvoiceInfo>>(invoiceJsonArray.size());
                dataMap.put(REPEAT, repeatMap);
            }
            for (int i = 0; i < invoiceJsonArray.size(); ++i) {
                IDIInvoiceCloudHelper.recognizeSuccessInvoice(invoiceJsonArray.getJSONObject(i), billObj, imageNumber, successInvoiceList, repeatMap, reimbursementId);
            }
        }
    }

    public static List<String> achieveExpense(DynamicObject dynamicBillObj) {
        ArrayList<String> list = new ArrayList<String>(2);
        String entityNumber = dynamicBillObj.getDynamicObjectType().getName();
        if ("ap_finapbill".equals(entityNumber)) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"IDIInvoiceCloudHelper.achieveExpense", (String)"ap_finapbill", (String)"inventry.invid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dynamicBillObj.getLong("id"))}, null);){
                for (Row row : dataSet) {
                    long invoiceId = row.getLong("inventry.invid");
                    if (invoiceId <= 0L) continue;
                    list.add(String.valueOf(invoiceId));
                }
            }
        } else {
            list.add(String.valueOf(dynamicBillObj.getPkValue()));
        }
        return list;
    }

    public static void recognizeSuccessInvoice(JSONObject data, DynamicObject dynamicBillObj, String imageNumber, List<DynamicObject> invoiceList, Map<String, List<RepeatInvoiceInfo>> repeatMap, String reimbursementId) {
        String repeatInfoStr = IDIJSONUtils.toJsonString((Object)data.getJSONArray("expenseInfo"));
        if (StringUtils.isNotEmpty((String)repeatInfoStr)) {
            SchemaExecutorLogger.info((String)("repeatInfoStr :" + repeatInfoStr), (Object[])new Object[0]);
            List repeatList = IDIJSONUtils.jsonCastToList((String)repeatInfoStr, RepeatInvoiceInfo.class);
            data.remove((Object)"expenseInfo");
            if (repeatList != null && !repeatList.isEmpty()) {
                Iterator iterator = repeatList.iterator();
                while (iterator.hasNext()) {
                    RepeatInvoiceInfo info = (RepeatInvoiceInfo)iterator.next();
                    if (!"1".equals(info.getStatus()) && !reimbursementId.equals(info.getExpenseId())) continue;
                    iterator.remove();
                }
                String invoiceKey = data.getString("serialNo");
                repeatMap.put(invoiceKey, repeatList);
            }
        }
        DynamicObject invoiceData = InvoiceParser.recognizeSuccessInvoice(data, dynamicBillObj.getPkValue().toString(), imageNumber);
        invoiceData.set("id", (Object)System.nanoTime());
        invoiceList.add(invoiceData);
    }

    protected static class RepeatInvoiceInfo {
        private String expenseNum;
        private String expenseId;
        private String status;

        public void setExpenseId(String expenseId) {
            this.expenseId = expenseId;
        }

        public void setExpenseNum(String expenseNum) {
            this.expenseNum = expenseNum;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getExpenseId() {
            return this.expenseId;
        }

        public String getStatus() {
            return this.status;
        }

        public String getExpenseNum() {
            return this.expenseNum;
        }
    }
}

