/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.data.idi.model.BaseHighLight;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionFrontEndResult;
import kd.data.idi.data.DecisionResult;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.KeywordConfig;
import kd.data.idi.data.KeywordConfigItem;
import kd.data.idi.data.SchemaContext;
import kd.data.idi.data.sysparam.KeyWordProviderEnum;
import kd.data.idi.engine.DecisionExecutor;
import kd.data.idi.engine.DeductionGrade;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.ScriptFormIdHandler;
import kd.data.idi.engine.ScriptLocaleFieldHandler;
import kd.data.idi.engine.ScriptUtils;
import kd.data.idi.engine.ai.service.IKeywordDetect;
import kd.data.idi.util.HighLightBuilder;
import kd.data.idi.util.Pair;
import kd.data.idi.util.SystemParamHelper;

public class KeywordDecisionExecutor
implements DecisionExecutor {
    public DecisionResult execute(SchemaContext context, Decision decision) {
        if (decision.getKeywordConfig() == null) {
            return null;
        }
        KeywordConfig keywordConfig = decision.getKeywordConfig();
        DynamicObject billObj = ExecutorHelper.getSelfBill(context);
        DeductionGrade deductionGrade = new DeductionGrade(context);
        IDICondition startCondition = keywordConfig.getStartCondition();
        HashSet<Integer> matchStartConditionEntryIndexSet = new HashSet<Integer>(10);
        String entryName = "";
        if (startCondition != null && StringUtils.isNotEmpty((String)startCondition.getScript())) {
            Pair<Boolean, String> startConditionPair = this.canStart(startCondition, billObj, matchStartConditionEntryIndexSet);
            if (!startConditionPair.getKey().booleanValue()) {
                DecisionResult result = new DecisionResult();
                result.setStatus("empty");
                deductionGrade.deduct(0);
                result.setDeductPercent(deductionGrade.getValue());
                result.setDecision(decision);
                result.setShowText(String.format(ResManager.loadKDString((String)"%s : \u542f\u52a8\u6761\u4ef6\u4e0d\u6ee1\u8db3", (String)"GeneralLedgerExecutor_7", (String)"data-idi-core", (Object[])new Object[0]), decision.getName()));
                return result;
            }
            entryName = startConditionPair.getValue();
        }
        if (!this.checkLimit(keywordConfig, billObj, entryName, matchStartConditionEntryIndexSet)) {
            return this.createOutOfLimitResult(decision, deductionGrade);
        }
        DecisionFrontEndResult frontEndResult = new DecisionFrontEndResult();
        int detectCount = 0;
        ArrayList<String> headFieldList = new ArrayList<String>(5);
        ArrayList<String> hasKeyHeadFieldList = new ArrayList<String>(5);
        HashMap<String, List<String>> entryFieldMap = new HashMap<String, List<String>>(5);
        HashMap<String, List<String>> hasKeyEntryFieldMap = new HashMap<String, List<String>>(5);
        HashMap<String, Map<String, List<String>>> subEntryFieldMap = new HashMap<String, Map<String, List<String>>>(5);
        HashMap<String, List<Integer>> hasKeyEntryIndexMap = new HashMap<String, List<Integer>>(5);
        HashMap<String, List<Integer>> entryIndexMap = new HashMap<String, List<Integer>>(5);
        LinkedHashMap<String, Map<Integer, List<Integer>>> subEntryIndexMap = new LinkedHashMap<String, Map<Integer, List<Integer>>>(5);
        int jcTotal = 0;
        for (KeywordConfigItem item : keywordConfig.getItems()) {
            String fieldEntryName;
            String fieldName = item.getPropertyName();
            ExecutorHelper.ValueAndName valueAndName = ExecutorHelper.getValueAndNameByName(billObj, fieldName, true, true);
            Object value = valueAndName.getValue();
            String name = valueAndName.getName();
            if (value instanceof LinkedHashMap) {
                Map subDataMap = (Map)value;
                if (subDataMap == null || subDataMap.isEmpty()) continue;
                String[] fields = fieldName.split("\\.");
                fieldEntryName = fields[0];
                String fieldSubEntryName = fields[1];
                Map subFieldMap = subEntryFieldMap.computeIfAbsent(fieldEntryName, k -> new HashMap(3));
                List subFieldList = subFieldMap.computeIfAbsent(fieldSubEntryName, k -> new ArrayList(5));
                subFieldList.add(fieldName);
                Map subIndexMap = subEntryIndexMap.computeIfAbsent(fieldName, k -> new HashMap(3));
                Pair<List<String>, List<String>> keywordPair = this.getKeywords(item.getKeywordLibraryIds());
                List<String> keywordList = keywordPair.getKey();
                List<String> whitelistList = keywordPair.getValue();
                Set subDataSet = subDataMap.entrySet();
                for (Map.Entry integerListEntry : subDataSet) {
                    List valueList;
                    int entryIndex = (Integer)integerListEntry.getKey();
                    if (fieldEntryName.equals(entryName) && !matchStartConditionEntryIndexSet.contains(entryIndex) || !CollectionUtils.isNotEmpty((Collection)(valueList = (List)integerListEntry.getValue()))) continue;
                    int index = 0;
                    for (Object valueObj : valueList) {
                        if (valueObj != null) {
                            List<String> result = IKeywordDetect.getInstance().detect(valueObj.toString(), item.getItemId(), keywordList, whitelistList);
                            ++jcTotal;
                            if (!result.isEmpty()) {
                                ++detectCount;
                                StringBuilder keywords = new StringBuilder();
                                for (String keyword : result) {
                                    keywords.append(keyword).append(';');
                                }
                                String s1 = name;
                                s1 = s1 + " " + String.format(ResManager.loadKDString((String)"\u7b2c%1$d\u884c\u5206\u5f55\u4e0b\u7b2c%2$d\u884c\u5b50\u5206\u5f55", (String)"KeywordDecisionExecutor_1", (String)"data-idi-core", (Object[])new Object[0]), entryIndex + 1, index + 1);
                                frontEndResult.addHoverContent(HoverContent.createText((String)s1), HoverContent.createText((String)keywords.toString()));
                                List subIndexList = subIndexMap.computeIfAbsent(entryIndex, k -> new ArrayList(2));
                                subIndexList.add(index);
                            }
                        }
                        ++index;
                    }
                }
                continue;
            }
            ArrayList<String> values = new ArrayList<String>();
            boolean isSameEntry = false;
            fieldEntryName = null;
            boolean isEntry = false;
            if (value instanceof List) {
                List objs = (List)value;
                for (Object val : objs) {
                    values.add(val == null ? "" : val.toString());
                }
                fieldEntryName = fieldName.split("\\.")[0];
                isSameEntry = fieldEntryName.equals(entryName);
                List entryFieldList = entryFieldMap.computeIfAbsent(fieldEntryName, k -> new ArrayList(5));
                entryFieldList.add(fieldName);
                isEntry = true;
            } else {
                String valueStr = value != null ? value.toString() : (String)value;
                values.add(valueStr);
                headFieldList.add(fieldName);
            }
            int index = -1;
            Pair<List<String>, List<String>> keywordPair = this.getKeywords(item.getKeywordLibraryIds());
            List<String> keywordList = keywordPair.getKey();
            List<String> whitelistList = keywordPair.getValue();
            boolean hasKeyWord = false;
            for (String valueStr : values) {
                ++index;
                if (isEntry) {
                    List entryFieldList = entryIndexMap.computeIfAbsent(fieldName, k -> new ArrayList(5));
                    entryFieldList.add(index);
                }
                if (isSameEntry && !matchStartConditionEntryIndexSet.contains(index) || StringUtils.isEmpty((String)valueStr)) continue;
                List<String> result = IKeywordDetect.getInstance().detect(valueStr, item.getItemId(), keywordList, whitelistList);
                ++jcTotal;
                if (result.isEmpty()) continue;
                ++detectCount;
                StringBuilder keywords = new StringBuilder();
                hasKeyWord = true;
                for (String keyword : result) {
                    keywords.append(keyword).append(';');
                }
                String s1 = name;
                if (isEntry) {
                    s1 = s1 + " " + String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c", (String)"KeywordDecisionExecutor_0", (String)"data-idi-core", (Object[])new Object[0]), index + 1);
                    List entryFieldList = hasKeyEntryIndexMap.computeIfAbsent(fieldName, k -> new ArrayList(5));
                    entryFieldList.add(index);
                } else {
                    hasKeyHeadFieldList.add(fieldName);
                }
                frontEndResult.addHoverContent(HoverContent.createText((String)s1), HoverContent.createText((String)keywords.toString()));
            }
            if (!isEntry || !hasKeyWord) continue;
            fieldEntryName = fieldName.split("\\.")[0];
            List entryFieldList = hasKeyEntryFieldMap.computeIfAbsent(fieldEntryName, k -> new ArrayList(5));
            entryFieldList.add(fieldName);
        }
        SchemaExecutorLogger.info((String)("Keyword Decision execute count:" + jcTotal), (Object[])new Object[0]);
        DecisionResult result = new DecisionResult();
        result.setDecision(decision);
        if (detectCount > 0) {
            result.setShowText(keywordConfig.getDetectedText());
            result.setStatus("alarming");
            result.setFrontEndResult(frontEndResult);
            deductionGrade.deduct(100);
        } else {
            result.setShowText(keywordConfig.getNotDetectedText());
            result.setStatus("green");
            deductionGrade.deduct(0);
        }
        result.setDeductPercent(deductionGrade.getValue());
        if (context.isNeedHighLight()) {
            HighLightBuilder highLightBuilder = new HighLightBuilder();
            ArrayList<BaseHighLight> allHighLightList = new ArrayList<BaseHighLight>(2);
            if (detectCount > 0) {
                highLightBuilder.buildKeywordHighLight(hasKeyHeadFieldList, hasKeyEntryFieldMap, subEntryFieldMap, hasKeyEntryIndexMap, subEntryIndexMap, allHighLightList, context.getSrcEntityType());
            } else {
                highLightBuilder.buildKeywordHighLight(headFieldList, entryFieldMap, subEntryFieldMap, entryIndexMap, subEntryIndexMap, allHighLightList, context.getSrcEntityType());
            }
            result.setHighLightList(allHighLightList);
        }
        return result;
    }

    public Pair<List<String>, List<String>> getKeywords(List<Long> keywordLibraryIds) {
        HashSet<String> keywordSet = new HashSet<String>();
        HashSet<String> whitelistSet = new HashSet<String>();
        HashSet<Long> idSet = new HashSet<Long>(keywordLibraryIds);
        QFilter filter = new QFilter("id", "in", idSet);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.data.idi.engine.KeywordDecisionExecutor", (String)"idi_keyword_library", (String)"keyword,whitelist", (QFilter[])new QFilter[]{filter}, (String)"id");){
            for (Row row : dataSet) {
                String keywordStr = row.getString("keyword");
                this.stringToSet(keywordStr, keywordSet);
                String whitelistStr = row.getString("whitelist");
                this.stringToSet(whitelistStr, whitelistSet);
            }
        }
        return new Pair<List<String>, List<String>>(new ArrayList(keywordSet), new ArrayList(whitelistSet));
    }

    private void stringToSet(String keywordStr, Set<String> keywordSet) {
        if (StringUtils.isNotEmpty((String)keywordStr)) {
            String[] keywordArr;
            for (String kw : keywordArr = keywordStr.split("\\-")) {
                if (!StringUtils.isNotEmpty((String)kw)) continue;
                keywordSet.add(kw);
            }
        }
    }

    private DecisionResult createOutOfLimitResult(Decision decision, DeductionGrade deductionGrade) {
        DecisionResult dr = new DecisionResult();
        dr.setStatus("nocontrolbillcontrolalarming");
        String message = ResManager.loadKDString((String)"%s\uff1a\u68c0\u6d4b\u5931\u8d25\u3002\u6267\u884c\u654f\u611f\u8bcd\u68c0\u6d4b\u7684\u5206\u5f55\u884c\u6570\u5df2\u8d85\u51fa\u53c2\u6570\u9650\u5236\u7684\u6700\u5927\u8303\u56f4\uff0c\u8bf7\u4eba\u5de5\u68c0\u67e5\u3002", (String)"KeywordDecisionExecutor_2", (String)"data-idi-core", (Object[])new Object[0]);
        dr.setShowText(String.format(message, decision.getName()));
        dr.setDecision(decision);
        deductionGrade.deduct(0);
        dr.setDeductPercent(deductionGrade.getValue());
        return dr;
    }

    private boolean checkLimit(KeywordConfig keywordConfig, DynamicObject billObj, String entryName, Set<Integer> matchStartConditionEntryIndexSet) {
        int checkLineNum = 0;
        for (KeywordConfigItem item : keywordConfig.getItems()) {
            int count;
            String fieldEntryName;
            String[] fields;
            String fieldName = item.getPropertyName();
            ExecutorHelper.ValueAndName valueAndName = ExecutorHelper.getValueAndNameByName(billObj, fieldName, true, true);
            Object value = valueAndName.getValue();
            if (value instanceof LinkedHashMap) {
                Map subDataMap = (Map)value;
                if (subDataMap == null || subDataMap.isEmpty()) continue;
                fields = fieldName.split("\\.");
                fieldEntryName = fields[0];
                count = 0;
                if (fieldEntryName.equals(entryName)) {
                    for (Map.Entry entryObj : subDataMap.entrySet()) {
                        Integer index = (Integer)entryObj.getKey();
                        List valueList = (List)entryObj.getValue();
                        if (!matchStartConditionEntryIndexSet.contains(index)) continue;
                        count += valueList.size();
                    }
                } else {
                    Collection values = subDataMap.values();
                    for (List objects : values) {
                        count += objects.size();
                    }
                }
                checkLineNum += count;
                continue;
            }
            if (value instanceof List) {
                List objects = (List)value;
                fields = fieldName.split("\\.");
                fieldEntryName = fields[0];
                count = fieldEntryName.equals(entryName) ? objects.size() - matchStartConditionEntryIndexSet.size() : objects.size();
                checkLineNum += count;
                continue;
            }
            ++checkLineNum;
        }
        int limit = this.getLimit();
        return checkLineNum <= limit;
    }

    private int getLimit() {
        int limit;
        String keyWordProvider = (String)SystemParamHelper.getParam("keywordprovider");
        KeyWordProviderEnum keyWordProviderEnum = KeyWordProviderEnum.convert(keyWordProvider);
        if (keyWordProviderEnum == KeyWordProviderEnum.IDI) {
            limit = 100000;
            SchemaExecutorLogger.info((String)("use idi, limit:" + limit), (Object[])new Object[0]);
        } else {
            Object param = SystemParamHelper.getParam("nlplimitlinenum");
            limit = param instanceof Integer ? (Integer)param : 1000;
            SchemaExecutorLogger.info((String)("use NLP, limit:" + limit), (Object[])new Object[0]);
        }
        return limit;
    }

    private Pair<Boolean, String> canStart(IDICondition startCondition, DynamicObject billObj, Set<Integer> matchStartConditionEntryIndexSet) {
        String billType = billObj.getDynamicObjectType().getName();
        String script = startCondition.getScript();
        MainEntityType srcEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        Set<String> propSet = ScriptUtils.getEntries(srcEntityType, script, new String[]{billType});
        if (propSet.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6\u4e0d\u652f\u6301\u8de8\u6e90\u5355\u7684\u591a\u4e2a\u5206\u5f55\u3002", (String)"LinkUpBillDecisionExecutor_12", (String)"data-idi-core", (Object[])new Object[0]));
        }
        HashMap<String, Object> ctx = new HashMap<String, Object>(1);
        ctx.put(billType + "_billObj", billObj);
        ScriptLocaleFieldHandler scriptLocaleFieldHandler = new ScriptLocaleFieldHandler();
        String localeScript = scriptLocaleFieldHandler.processLocaleField(script, new String[]{billType}, billObj);
        if (propSet.size() == 1) {
            String startConditionEntry = propSet.iterator().next();
            int sourceEntrySize = billObj.getDynamicObjectCollection(startConditionEntry).size();
            ctx.put("rowSize", sourceEntrySize);
            ctx.put("__matchEntryIndexSet__", matchStartConditionEntryIndexSet);
            String entryScript = ScriptUtils.supportEntryPropertyStringIndex((DynamicObjectType)srcEntityType, localeScript, "i");
            String ifStem = "if(%s){\n  __matchEntryIndexSet__.add(i);\n}";
            String ifScript = String.format(ifStem, entryScript);
            String forStem = "for(var i=0; i<rowSize; i++){\n%s}";
            String forScript = String.format(forStem, ifScript);
            ScriptFormIdHandler.runScript((String)billType, null, ctx, (String)forScript);
            boolean matchData = !matchStartConditionEntryIndexSet.isEmpty();
            return new Pair<Boolean, String>(matchData, startConditionEntry);
        }
        Boolean matchData = (Boolean)ScriptFormIdHandler.runScript((String)billType, null, ctx, (String)localeScript);
        return new Pair<Boolean, String>(matchData, "");
    }
}

