/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Schema;
import kd.data.idi.data.SchemaResult;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.ScriptFormIdHandler;
import kd.data.idi.engine.ScriptLocaleFieldHandler;
import kd.data.idi.engine.ScriptUtils;
import kd.data.idi.util.IDIJSONUtils;

public class SchemaSearcher {
    private static final String orderByFields = "order,ispreset,createtime";

    public List<Schema> matchAll(DynamicObject bizObj) {
        List<Schema> schemaList = this.findByBillAll(bizObj);
        if (schemaList != null && !schemaList.isEmpty()) {
            String billType = bizObj.getDataEntityType().getName();
            HashSet<String> propSet = new HashSet<String>();
            for (Schema schema : schemaList) {
                if (schema.getStartCondition() == null) continue;
                schema.getStartCondition().extractProperties(propSet, billType, new String[]{billType});
            }
            bizObj = ExecutorHelper.loadObject(bizObj.getPkValue(), billType, propSet);
            return this.matchCore(bizObj, schemaList, propSet);
        }
        return Collections.emptyList();
    }

    public Object[] match(DynamicObject bizObj, boolean loadBill) {
        Object[] result = new Object[]{null, null};
        SchemaResult schemaResult = new SchemaResult();
        result[0] = schemaResult;
        LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)"PRO_IDI");
        boolean hasLicense = checkResult.getHasLicense();
        if (hasLicense) {
            String billType = bizObj.getDataEntityType().getName();
            QFilter[] filters = new QFilter[]{new QFilter("sourceentitynumber", "=", (Object)billType)};
            DynamicObjectCollection schemaObjList = QueryServiceHelper.query((String)"idi_schema", (String)"id,number,name,rule_tag,enable", (QFilter[])filters, (String)orderByFields);
            result[1] = this.matchCore(bizObj, schemaObjList, schemaResult, loadBill);
        } else {
            schemaResult.setStatus("nolicense");
        }
        return result;
    }

    public Object[] match(DynamicObject bizObj) {
        return this.match(bizObj, true);
    }

    public Object[] billControlMatch(DynamicObject bizObj) {
        return this.match(bizObj, false);
    }

    private Schema matchCore(DynamicObject bizObj, DynamicObjectCollection schemaObjList, SchemaResult schemaResult, boolean loadBill) {
        String billType = bizObj.getDataEntityType().getName();
        if (schemaObjList == null || schemaObjList.size() == 0) {
            schemaResult.setStatus("empty");
        } else {
            HashSet<String> propSet = new HashSet<String>();
            List<Schema> schemaList = new ArrayList<Schema>(schemaObjList.size());
            for (DynamicObject schemaObj : schemaObjList) {
                if (!"1".equals(schemaObj.getString("enable"))) continue;
                Schema schema = (Schema)IDIJSONUtils.cast((String)schemaObj.getString("rule_tag"), Schema.class);
                schema.setNumber(schemaObj.getString("number"));
                schema.setName(schemaObj.getString("name"));
                schema.setId(schemaObj.getLong("id"));
                schemaList.add(schema);
                if (schema.getStartCondition() == null) continue;
                schema.getStartCondition().extractProperties(propSet, billType, new String[]{billType});
            }
            if (schemaList.size() > 0) {
                if (loadBill) {
                    bizObj = ExecutorHelper.loadObject(bizObj.getPkValue(), billType, propSet);
                }
                if ((schemaList = this.matchCore(bizObj, schemaList, propSet)).size() > 0) {
                    return schemaList.get(0);
                }
                schemaResult.setStatus("nostart");
            } else {
                schemaResult.setStatus("disable");
            }
        }
        return null;
    }

    public List<Schema> matchCore(DynamicObject bizObj, List<Schema> schemaList, Set<String> popSet) {
        DynamicObjectType dt = bizObj.getDynamicObjectType();
        String billType = dt.getName();
        ScriptLocaleFieldHandler scriptLocaleFieldHandler = new ScriptLocaleFieldHandler();
        String[] billTypes = new String[]{billType};
        ArrayList<Schema> resultList = new ArrayList<Schema>();
        int len = schemaList.size();
        if (len <= 0) {
            return resultList;
        }
        ArrayList<Integer> matchSchemaIndex = new ArrayList<Integer>();
        StringBuilder scriptBuilder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            Schema schema = schemaList.get(i);
            String sourceExpr = schema.getStartCondition() == null ? "" : schema.getStartCondition().getScript();
            String localeScript = scriptLocaleFieldHandler.processLocaleField(sourceExpr, billTypes, bizObj);
            Set<String> propSet = ScriptUtils.getEntries((MainEntityType)bizObj.getDataEntityType(), sourceExpr, new String[]{billType});
            String expr = localeScript;
            if (CollectionUtils.isNotEmpty(propSet)) {
                boolean isEmptyEntry = false;
                for (String entryName : propSet) {
                    DynamicObjectCollection entryCols = bizObj.getDynamicObjectCollection(entryName);
                    if (!CollectionUtils.isEmpty((Collection)entryCols)) continue;
                    isEmptyEntry = true;
                    break;
                }
                if (!isEmptyEntry) {
                    expr = ScriptUtils.supportEntryProperty(dt, localeScript, 0);
                }
            }
            if (StringUtils.isEmpty((String)expr)) {
                matchSchemaIndex.add(i);
                continue;
            }
            String ifStm = String.format("if (%s) {\n  matchList.add(%d);\n}\n", expr, i);
            scriptBuilder.append(ifStm);
        }
        if (scriptBuilder.length() > 0) {
            String script = scriptBuilder.toString();
            SchemaExecutorLogger.info((String)script, (Object[])new Object[0]);
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            ctx.put(billType + "_billObj", bizObj);
            ArrayList matchList = new ArrayList();
            ctx.put("matchList", matchList);
            ScriptFormIdHandler.runScript((String)billType, null, ctx, (String)script);
            if (!matchList.isEmpty()) {
                matchSchemaIndex.addAll(0, matchList);
            }
        }
        if (!matchSchemaIndex.isEmpty()) {
            ArrayList<Schema> newSchemaList = new ArrayList<Schema>(matchSchemaIndex.size());
            for (Integer i : matchSchemaIndex) {
                newSchemaList.add(schemaList.get(i));
            }
            resultList = newSchemaList;
        }
        return resultList;
    }

    public Object[] match(DynamicObject bizObj, List<String> schemaNumbers) {
        Object[] result = new Object[]{null, null};
        SchemaResult schemaResult = new SchemaResult();
        result[0] = schemaResult;
        LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)"PRO_IDI");
        boolean hasLicense = checkResult.getHasLicense();
        if (hasLicense) {
            if (schemaNumbers == null || schemaNumbers.isEmpty()) {
                schemaResult.setStatus("empty");
            } else {
                DynamicObjectCollection schemaObjList = QueryServiceHelper.query((String)"idi_schema", (String)"id,number,name,rule_tag,enable", (QFilter[])new QFilter[]{new QFilter("number", "in", schemaNumbers)}, (String)orderByFields);
                result[1] = this.matchCore(bizObj, schemaObjList, schemaResult, true);
            }
        } else {
            schemaResult.setStatus("nolicense");
        }
        return result;
    }

    public Object[] match(DynamicObject bizObj, String schemaNumber) {
        Object[] result = new Object[]{null, null};
        SchemaResult schemaResult = new SchemaResult();
        result[0] = schemaResult;
        LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)"PRO_IDI");
        boolean hasLicense = checkResult.getHasLicense();
        if (hasLicense) {
            if (StringUtils.isEmpty((String)schemaNumber)) {
                schemaResult.setStatus("empty");
            } else {
                DynamicObjectCollection schemaObjList = QueryServiceHelper.query((String)"idi_schema", (String)"id,number,name,rule_tag,enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)schemaNumber)}, (String)orderByFields);
                result[1] = this.matchCore(bizObj, schemaObjList, schemaResult, true);
            }
        } else {
            schemaResult.setStatus("nolicense");
        }
        return result;
    }

    public List<Schema> findSchema(List<QFilter> filters) {
        if (filters == null || filters.isEmpty()) {
            return Collections.emptyList();
        }
        filters.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        DynamicObject[] schemaObjList = BusinessDataServiceHelper.load((String)"idi_schema", (String)"id,number,name,rule_tag", (QFilter[])filters.toArray(new QFilter[0]), (String)orderByFields);
        ArrayList<Schema> schemaList = new ArrayList<Schema>(schemaObjList.length);
        for (DynamicObject schemaObj : schemaObjList) {
            Schema schema = (Schema)IDIJSONUtils.cast((String)schemaObj.getString("rule_tag"), Schema.class);
            schema.setNumber(schemaObj.getString("number"));
            schema.setName(schemaObj.getString("name"));
            schemaList.add(schema);
        }
        return schemaList;
    }

    public List<Schema> findByBillAll(DynamicObject bizObj) {
        if (bizObj == null) {
            return Collections.emptyList();
        }
        String billType = bizObj.getDataEntityType().getName();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("sourceentitynumber", "=", (Object)billType));
        return this.findSchema(filters);
    }
}

