/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.ScriptFormIdHandler;
import kd.data.idi.engine.functions.CustomFuncEnum;
import kd.data.idi.engine.functions.CustomFuncSpecialDeal;
import kd.data.idi.engine.linkupbill.MulEntryValidator;

public class ScriptUtils {
    public static String supportEntryProperty(DynamicObjectType mainType, String script, int entryIndex) {
        return ScriptUtils.supportEntryPropertyStringIndex(mainType, script, String.valueOf(entryIndex));
    }

    public static String supportEntryPropertyStringIndex(DynamicObjectType mainType, String script, String entryIndex) {
        if (mainType == null || StringUtils.isEmpty((String)script)) {
            return script;
        }
        String mainVarName = mainType.getName() + "_billObj.";
        Set vars = ScriptFormIdHandler.extractVariables((String)script, (String[])new String[]{mainType.getName()});
        HashSet<String> entryVars = new HashSet<String>();
        block0: for (String var : vars) {
            DynamicObjectType parentType;
            String[] properties = var.split("\\.");
            if (var.startsWith(mainVarName)) {
                if (properties.length <= 2) continue;
                parentType = mainType;
                for (int i = 1; i < properties.length; ++i) {
                    DynamicProperty property = parentType.getProperty(properties[i]);
                    if (property instanceof DynamicCollectionProperty) {
                        entryVars.add(properties[i]);
                        parentType = ((DynamicCollectionProperty)property).getDynamicCollectionItemPropertyType();
                        continue;
                    }
                    if (!(property instanceof DynamicComplexProperty)) continue block0;
                    parentType = ((DynamicComplexProperty)property).getDynamicComplexPropertyType();
                }
                continue;
            }
            parentType = mainType;
            for (String prop : properties) {
                DynamicProperty property = parentType.getProperty(prop);
                if (property == null) continue;
                if (property instanceof DynamicCollectionProperty) {
                    script = script.replaceAll(var, var + "\\[" + entryIndex + "\\]");
                    continue block0;
                }
                if (!(property instanceof DynamicComplexProperty)) continue block0;
                parentType = ((DynamicComplexProperty)property).getDynamicComplexPropertyType();
            }
        }
        for (String entryVar : entryVars) {
            script = script.replaceAll("\\." + entryVar + "\\.", "\\." + entryVar + "\\[" + entryIndex + "\\]\\.");
        }
        return script;
    }

    public static Set<String> getEntries(MainEntityType mainType, String script, String[] billTypes) {
        String mainVarName = mainType.getName() + "_billObj.";
        Set vars = ScriptFormIdHandler.extractVariables((String)script, (String[])billTypes);
        HashSet<String> entryVars = new HashSet<String>();
        block0: for (String var : vars) {
            String[] properties;
            if (!var.startsWith(mainVarName) || (properties = var.split("\\.")).length <= 2) continue;
            MainEntityType parentType = mainType;
            for (int i = 1; i < properties.length; ++i) {
                DynamicProperty property = parentType.getProperty(properties[i]);
                if (property instanceof DynamicCollectionProperty) {
                    entryVars.add(properties[i]);
                    parentType = ((DynamicCollectionProperty)property).getDynamicCollectionItemPropertyType();
                    continue;
                }
                if (!(property instanceof DynamicComplexProperty)) continue block0;
                parentType = ((DynamicComplexProperty)property).getDynamicComplexPropertyType();
            }
        }
        return entryVars;
    }

    public static Set<String> getLeastLevelEntries(MainEntityType mainType, String script, String[] billTypes) {
        String mainVarName = mainType.getName() + "_billObj.";
        Set entryKeySet = mainType.getAllEntities().keySet();
        Set vars = ScriptFormIdHandler.extractVariables((String)script, (String[])billTypes);
        HashSet<String> entryVars = new HashSet<String>();
        for (String var : vars) {
            String[] properties;
            if (!var.startsWith(mainVarName) || (properties = var.split("\\.")).length <= 2) continue;
            MainEntityType parentType = mainType;
            String entryNumber = null;
            for (int i = 1; i < properties.length; ++i) {
                DynamicProperty property = parentType.getProperty(properties[i]);
                if (property instanceof EntryProp) {
                    entryNumber = properties[i];
                    parentType = ((DynamicCollectionProperty)property).getDynamicCollectionItemPropertyType();
                    continue;
                }
                if (!(property instanceof DynamicComplexProperty)) break;
                parentType = ((DynamicComplexProperty)property).getDynamicComplexPropertyType();
            }
            if (!StringUtils.isNotEmpty(entryNumber) || !entryKeySet.contains(entryNumber)) continue;
            entryVars.add(entryNumber);
        }
        return entryVars;
    }

    public static String setEntryIndex(String script, String billType, Set<String> entryVars, int index) {
        String mainVarName = billType + "_billObj.";
        for (String entryVar : entryVars) {
            script = script.replaceAll(mainVarName + entryVar + "\\.", mainVarName + entryVar + "\\[" + index + "\\]\\.");
        }
        return script;
    }

    public static String setEntryIndexSingle(String script, String billType, String entryName, String index, boolean needProcessSelf) {
        String mainVarName = billType + "_billObj.";
        if (needProcessSelf) {
            String selfVarName = "targetisself_" + billType + "_billObj.";
            String replaceSelfVarName = "targetisself_" + billType + "_billObj#.";
            String replaceScript = script.replaceAll(selfVarName, replaceSelfVarName);
            String srcReplaceScript = replaceScript.replaceAll(mainVarName + entryName + "\\.", mainVarName + entryName + "\\[" + index + "\\]\\.");
            return srcReplaceScript.replaceAll(replaceSelfVarName, selfVarName);
        }
        return script.replaceAll(mainVarName + entryName + "\\.", mainVarName + entryName + "\\[" + index + "\\]\\.");
    }

    public static String setSubEntryIndexSingle(String script, String billType, String entryName, String index, String subEntryName, String subEntryIndex, boolean needProcessSelf) {
        String mainVarName = billType + "_billObj.";
        if (needProcessSelf) {
            String selfVarName = "targetisself_" + billType + "_billObj.";
            String replaceSelfVarName = "targetisself_" + billType + "_billObj#.";
            String replaceScript = script.replaceAll(selfVarName, replaceSelfVarName);
            String srcReplaceScript = replaceScript.replaceAll(mainVarName + entryName + "\\[" + index + "\\]\\." + subEntryName + "\\.", mainVarName + entryName + "\\[" + index + "\\]\\." + subEntryName + "\\[" + subEntryIndex + "\\]\\.");
            return srcReplaceScript.replaceAll(replaceSelfVarName, selfVarName);
        }
        return script.replaceAll(mainVarName + entryName + "\\[" + index + "\\]\\." + subEntryName + "\\.", mainVarName + entryName + "\\[" + index + "\\]\\." + subEntryName + "\\[" + subEntryIndex + "\\]\\.");
    }

    public static String replaceEntryIndex(String script, String firstEntry, int firstIndex, String secondEntry, int secondIndex) {
        script = script.replaceAll(firstEntry + "\\.", firstEntry + "\\[" + firstIndex + "\\]\\.");
        script = script.replaceAll(secondEntry + "\\.", secondEntry + "\\[" + secondIndex + "\\]\\.");
        return script;
    }

    public static MulEntryValidator getEntriesForValidate(MainEntityType mainType, String script, String[] billTypes, String billPrefix) {
        String scriptBillType = billPrefix + mainType.getName();
        String mainVarName = scriptBillType + "_billObj.";
        MulEntryValidator mulEntryValidator = new MulEntryValidator(mainType);
        Set vars = ScriptFormIdHandler.extractVariables((String)script, (String[])billTypes);
        HashSet<String> billTypeSet = new HashSet<String>(2);
        billTypeSet.add(scriptBillType);
        Map<String, Set<String>> exactFieldSet = ScriptUtils.extractCustomFuncFieldAll(script, CustomFuncEnum.EXACT.getFuncName(), billTypeSet, true, true);
        Set<String> excludeFieldSet = exactFieldSet.get(scriptBillType);
        block0: for (String var : vars) {
            String[] properties;
            if (!var.startsWith(mainVarName) || !CollectionUtils.isEmpty(excludeFieldSet) && !excludeFieldSet.contains(var) || (properties = var.split("\\.")).length <= 2) continue;
            MainEntityType parentType = mainType;
            for (int i = 1; i < properties.length; ++i) {
                DynamicProperty property = parentType.getProperty(properties[i]);
                if (property instanceof EntryProp) {
                    parentType = ((DynamicCollectionProperty)property).getDynamicCollectionItemPropertyType();
                    mulEntryValidator.addEntry(property);
                    continue;
                }
                if (!(property instanceof DynamicComplexProperty)) continue block0;
                parentType = ((DynamicComplexProperty)property).getDynamicComplexPropertyType();
            }
        }
        return mulEntryValidator;
    }

    public static boolean checkEntryCountByRule(String sourceNumber, String targetNumber, String originRuleScript) {
        return ScriptUtils.checkEntryCountByRule(sourceNumber, EntityMetadataCache.getDataEntityType((String)targetNumber), originRuleScript);
    }

    public static boolean checkEntryCountByRule(String sourceNumber, MainEntityType targetEntity, String originRuleScript) {
        String ruleScript = ScriptUtils.replaceCustomFuncOfScript(originRuleScript);
        MainEntityType sourceEntity = EntityMetadataCache.getDataEntityType((String)sourceNumber);
        String targetNumber = targetEntity.getName();
        if (targetNumber != null && !targetNumber.equals(sourceNumber)) {
            String[] billTypes = new String[]{sourceNumber, targetNumber};
            Set<String> sourceEntrySet = ScriptUtils.getLeastLevelEntries(sourceEntity, ruleScript, billTypes);
            Set<String> targetEntrySet = ScriptUtils.getLeastLevelEntries(targetEntity, ruleScript, billTypes);
            return sourceEntrySet.size() + targetEntrySet.size() <= 2;
        }
        String[] billTypes = new String[]{sourceNumber};
        Set<String> sourceEntrySet = ScriptUtils.getLeastLevelEntries(sourceEntity, ruleScript, billTypes);
        return sourceEntrySet.size() <= 2;
    }

    public static List<String> getCustomFuncOfScript(String originRuleScript) {
        String ruleScript = originRuleScript;
        ArrayList<String> result = new ArrayList<String>(1);
        for (CustomFuncEnum funcEnum : CustomFuncEnum.values()) {
            if (funcEnum == CustomFuncEnum.DATE_DIFF_UNIT) continue;
            String regex = funcEnum.getFuncName();
            String[] extractCustomAns = new String[4];
            extractCustomAns[3] = "0";
            while (extractCustomAns[3] != null && (extractCustomAns = ScriptUtils.extractCustomFunc(ruleScript, regex, Integer.parseInt(extractCustomAns[3])))[1] != null) {
                String content = extractCustomAns[1];
                result.add(content);
                String innerContent = content.substring(regex.length(), content.length() - 1).trim().substring(1);
                ScriptUtils.replaceStartIndexAndNewValue(innerContent, extractCustomAns);
                ruleScript = ScriptUtils.assembleArray(extractCustomAns);
            }
        }
        return result;
    }

    public static String replaceCustomFuncOfScript(String originRuleScript) {
        return ScriptUtils.replaceCustomFuncOfScript(ScriptUtils.getCustomFuncOfScript(originRuleScript), originRuleScript);
    }

    public static String replaceCustomFuncOfScript(List<String> customFuncOfScriptList, String originRuleScript) {
        String replaceScript = originRuleScript;
        if (!customFuncOfScriptList.isEmpty()) {
            for (String customFuncScript : customFuncOfScriptList) {
                replaceScript = replaceScript.replace(customFuncScript, "");
            }
        }
        return replaceScript;
    }

    public static String getFirstEntryNumber(String script, MainEntityType srcEntityType) {
        String[] scripts = script.split("\\.");
        Set entityNumbers = srcEntityType.getAllEntities().keySet();
        entityNumbers.remove(srcEntityType.getName());
        for (int i = 0; i < scripts.length - 1; ++i) {
            if (!entityNumbers.contains(scripts[i]) || entityNumbers.contains(scripts[i + 1])) continue;
            return scripts[i];
        }
        return "";
    }

    public static String[] extractCustomFunc(String script, String regex, int startIndex) {
        String[] ans = new String[4];
        String ansScript = null;
        int firstIndex = 0;
        int endIndex = 0;
        while (script.indexOf(regex, startIndex) != -1 && ansScript == null) {
            int i = script.indexOf(regex, startIndex);
            char[] charArray = script.toCharArray();
            int leftcount = 0;
            int preStartIndex = startIndex;
            for (int j = i + regex.length(); j < charArray.length; ++j) {
                if (leftcount == 0 && charArray[j] != ' ' && charArray[j] != '(') {
                    startIndex = j;
                    break;
                }
                if (charArray[j] == '(') {
                    ++leftcount;
                } else if (charArray[j] == ')' && --leftcount == 0) {
                    ansScript = script.substring(i, j + 1);
                    firstIndex = i;
                    endIndex = j + 1;
                    startIndex = j + 1;
                    break;
                }
                if (j != charArray.length - 1) continue;
                startIndex = j;
            }
            if (startIndex != preStartIndex) continue;
            break;
        }
        if (ansScript != null) {
            ans[0] = script.substring(0, firstIndex);
            ans[1] = ansScript;
            ans[2] = script.substring(endIndex, script.length());
            ans[3] = String.valueOf(startIndex);
        }
        return ans;
    }

    public static String assembleArray(String[] extractCustomAns) {
        StringBuilder ans = new StringBuilder();
        int i = 0;
        for (String extractCustomAn : extractCustomAns) {
            if (extractCustomAn != null && i < 3) {
                ans.append(extractCustomAn);
            }
            ++i;
        }
        return ans.toString();
    }

    public static void replaceStartIndexAndNewValue(String newValue, String[] extractCustomAns) {
        String oldValue = extractCustomAns[1];
        int startIndex = Integer.parseInt(extractCustomAns[3]);
        int newStartIndex = startIndex + newValue.length() - oldValue.length();
        newStartIndex = Math.max(newStartIndex, 0);
        extractCustomAns[3] = String.valueOf(newStartIndex);
        extractCustomAns[1] = newValue;
    }

    public static Map<String, Set<String>> extractCustomFuncFieldAll(String script, String regex, Set<String> billTypeSet, boolean needTargetSelf, boolean needPrefix) {
        String[] extractCustomAns = new String[4];
        extractCustomAns[3] = "0";
        HashMap<String, Set<String>> fieldMap = new HashMap<String, Set<String>>(3);
        while (extractCustomAns[3] != null && (extractCustomAns = ScriptUtils.extractCustomFunc(script, regex, Integer.parseInt(extractCustomAns[3])))[1] != null) {
            String beforeSpecialDealScript = extractCustomAns[1];
            String funcStr = CustomFuncSpecialDeal.specialDeal((String)beforeSpecialDealScript.replace(" ", ""));
            String funcInnerStr = funcStr.substring(0, funcStr.length() - 1).replace(regex + "(", "");
            if (funcInnerStr.indexOf("_billObj") > -1) {
                String[] split;
                String field;
                String realBillEntry;
                String billEntity = funcInnerStr.substring(0, funcInnerStr.indexOf("_billObj"));
                String string = realBillEntry = needTargetSelf ? billEntity : billEntity.replaceAll("targetisself_", "");
                if (!CollectionUtils.isEmpty(billTypeSet) && !billTypeSet.contains(realBillEntry) || !StringUtils.isNotEmpty((String)(field = (split = funcInnerStr.split(","))[0].trim()))) continue;
                String fullField = needPrefix ? field : field.substring(field.indexOf(".") + 1);
                Set fieldSet = fieldMap.computeIfAbsent(realBillEntry, k -> new HashSet(3));
                fieldSet.add(fullField);
                continue;
            }
            Set fieldSet = fieldMap.computeIfAbsent(null, k -> new HashSet(3));
            String[] split = funcInnerStr.split(",");
            String field = split[0].trim();
            fieldSet.add(field);
        }
        return fieldMap;
    }
}

