/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.ai.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.ai.service.IKeywordDetect;
import kd.data.idi.engine.ai.service.ServerInfo;
import kd.data.idi.util.IDIJSONUtils;

public class KeywordDetectImpl
implements IKeywordDetect {
    @Override
    public List<String> detect(String text, String modelId, List<String> keywords, List<String> whitelists) {
        String secondText = this.handleWhiteList(text, whitelists);
        if (this.notNecessaryDetect(secondText)) {
            return new ArrayList<String>(1);
        }
        String url = this.getServiceUrl();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("modelId", modelId);
        params.put("rebuildModel", "false");
        params.put("text", secondText);
        params.put("keywords", keywords);
        ServerInfo.addAILogParam(params);
        try {
            String paramJson = IDIJSONUtils.toJsonString(params);
            SchemaExecutorLogger.info((String)("keyword detect params: " + paramJson), (Object[])new Object[0]);
            long start = System.currentTimeMillis();
            String resp = HttpClientUtils.postAppJson((String)url, new HashMap(), params);
            long end = System.currentTimeMillis();
            SchemaExecutorLogger.info((String)String.format("keyword detect cost time: %sms", end - start), (Object[])new Object[0]);
            SchemaExecutorLogger.info((String)("keyword detect resp: " + resp), (Object[])new Object[0]);
            if (StringUtils.isEmpty((String)resp)) {
                return new ArrayList<String>(1);
            }
            Result result = (Result)IDIJSONUtils.cast((String)resp, Result.class);
            if (result == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u654f\u611f\u8bcd\u68c0\u6d4b\u5931\u8d25,%s", (String)"KeywordDetectImpl_0", (String)"data-idi-core", (Object[])new Object[0]), resp));
            }
            if (result.getCode() != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u654f\u611f\u8bcd\u68c0\u6d4b\u5931\u8d25,%s", (String)"KeywordDetectImpl_0", (String)"data-idi-core", (Object[])new Object[0]), result.err));
            }
            return result.result;
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u654f\u611f\u8bcd\u68c0\u6d4b\u9047\u5230\u95ee\u9898", (String)"KeywordDetectImpl_1", (String)"data-idi-core", (Object[])new Object[0])), new Object[0]);
        }
    }

    private String getServiceUrl() {
        return ServerInfo.getAIHost() + "/intelligent_finance/sensitiveword";
    }

    protected static class Result {
        private int code;
        private String err;
        private List<String> result;

        protected Result() {
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getErr() {
            return this.err;
        }

        public void setErr(String err) {
            this.err = err;
        }

        public List<String> getResult() {
            return this.result;
        }

        public void setResult(List<String> result) {
            this.result = result;
        }
    }
}

