/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.attachment;

import java.io.Serializable;
import java.math.BigDecimal;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.attachment.AITemplate;

public class AttachmentField
implements Serializable {
    private static final long serialVersionUID = -7503309279553379287L;
    private String name;
    private String displayName;
    private boolean isTable;
    private AITemplate template;
    private AttachmentField parent;
    private String fieldType = "text";

    public AttachmentField() {
    }

    public AttachmentField(String name, String displayName, boolean isTable) {
        this.name = name;
        this.displayName = displayName;
        this.isTable = isTable;
    }

    public AttachmentField(String name, String displayName, boolean isTable, AITemplate template) {
        this.name = name;
        this.displayName = displayName;
        this.isTable = isTable;
        this.template = template;
    }

    public AttachmentField(String name, String displayName, boolean isTable, AITemplate template, AttachmentField parent) {
        this.name = name;
        this.displayName = displayName;
        this.isTable = isTable;
        this.template = template;
        this.parent = parent;
    }

    public AttachmentField(String name, String displayName, boolean isTable, AITemplate template, AttachmentField parent, String fieldType) {
        this.name = name;
        this.displayName = displayName;
        this.isTable = isTable;
        this.template = template;
        this.parent = parent;
        this.fieldType = fieldType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isTable() {
        return this.isTable;
    }

    public void setTable(boolean table) {
        this.isTable = table;
    }

    public AITemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(AITemplate template) {
        this.template = template;
    }

    public AttachmentField getParent() {
        return this.parent;
    }

    public void setParent(AttachmentField parent) {
        this.parent = parent;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public String getFullName() {
        if (this.parent != null) {
            return this.getParent().getFullName() + "." + this.name;
        }
        return this.name;
    }

    public String getFullNameAndTemplate() {
        if (this.getTemplate() != null) {
            return this.getTemplate().getNumber() + "." + this.getFullName();
        }
        return this.getFullName();
    }

    public String getFullDisplayName() {
        if (this.parent != null) {
            return this.getParent().getFullDisplayName() + "." + this.displayName;
        }
        return this.displayName;
    }

    public String getFullDisplayNameAndTemplate() {
        if (this.getTemplate() != null) {
            return this.getTemplate().getName() + "." + this.getFullDisplayName();
        }
        return this.getFullDisplayName();
    }

    public Object convertDataType(Object fieldValue) {
        if (fieldValue == null) {
            return fieldValue;
        }
        Object result = null;
        if (fieldValue instanceof String && StringUtils.isEmpty((String)((String)fieldValue))) {
            result = "text".equals(this.getFieldType()) ? String.valueOf(fieldValue) : null;
            return result;
        }
        switch (this.getFieldType()) {
            case "text": {
                result = String.valueOf(fieldValue);
                break;
            }
            case "num": 
            case "amount": {
                String amountStr = String.valueOf(fieldValue);
                result = new BigDecimal(amountStr);
                break;
            }
            case "time": {
                result = String.valueOf(fieldValue);
                break;
            }
            case "short_date": {
                try {
                    return KDDateFormatUtils.getDateFormat().parse((String)fieldValue);
                }
                catch (Throwable ignore) {
                    SchemaExecutorLogger.error((Throwable)ignore);
                    break;
                }
            }
            case "long_date": {
                try {
                    result = KDDateFormatUtils.getDateTimeFormat().parse((String)fieldValue);
                    break;
                }
                catch (Throwable ignore) {
                    SchemaExecutorLogger.error((Throwable)ignore);
                }
            }
        }
        return result;
    }
}

