/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.attachment;

import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.data.idi.data.basedata.StandardBaseDataConfig;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.attachment.AIParam;
import kd.data.idi.engine.attachment.AIRecognizerErrorInfo;
import kd.data.idi.engine.attachment.AIRecognizerParam;
import kd.data.idi.engine.attachment.AIRecognizerResult;
import kd.data.idi.engine.attachment.AIRecognizerSuccessInfo;
import kd.data.idi.engine.attachment.AITemplate;
import kd.data.idi.engine.attachment.Attachment;
import kd.data.idi.engine.attachment.AttachmentField;
import kd.data.idi.engine.attachment.IAttachmentService;
import kd.data.idi.util.IDIJSONUtils;

public class GPTAttachmentServiceImpl
implements IAttachmentService<AIRecognizerResult> {
    public List<AttachmentField> queryTemplateField(AIParam fieldQueryParam) {
        StandardBaseDataConfig[] templateConfig = fieldQueryParam.getFgptasTemplates();
        if (templateConfig == null || templateConfig.length <= 0) {
            return null;
        }
        Object[] templateIds = StandardBaseDataConfig.loadBaseData("fgptas_attachtemplate", templateConfig);
        List<Object> idList = Arrays.asList(templateIds);
        Map auditElementMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fgptas", (String)"IModalPreProcessService", (String)"queryAuditElement", (Object[])new Object[]{idList});
        SchemaExecutorLogger.info((String)("gpt auditElement result:" + IDIJSONUtils.toJsonString((Object)auditElementMap)), (Object[])new Object[0]);
        ArrayList<AttachmentField> list = new ArrayList<AttachmentField>(10);
        Set entrySet = auditElementMap.entrySet();
        for (Map.Entry longMapEntry : entrySet) {
            Long templateId = (Long)longMapEntry.getKey();
            Map templateElementMap = (Map)longMapEntry.getValue();
            String templateNumber = (String)templateElementMap.get("number");
            String templateName = (String)templateElementMap.get("name");
            List detailsList = (List)templateElementMap.get("details");
            AITemplate templateObj = new AITemplate(templateId, templateNumber, templateName);
            templateObj.setCustomTemplate(false);
            if (!CollectionUtils.isNotEmpty((Collection)detailsList)) continue;
            for (Map groupMap : detailsList) {
                String name = (String)groupMap.get("groupName");
                String entryNumber = (String)groupMap.get("groupNo");
                Boolean isEntry = (Boolean)groupMap.get("isEntry");
                List fieldDetailList = (List)groupMap.get("auditElementList");
                AttachmentField tableField = null;
                if (isEntry.booleanValue()) {
                    tableField = new AttachmentField(entryNumber, name, true, templateObj);
                    list.add(tableField);
                }
                for (Object o : fieldDetailList) {
                    Map fieldInfoMap = (Map)o;
                    String fieldNumber = (String)fieldInfoMap.get("elementNo");
                    String fieldName = (String)fieldInfoMap.get("elementName");
                    String fieldType = (String)fieldInfoMap.get("fieldType");
                    AttachmentField field = new AttachmentField(fieldNumber, fieldName, false, templateObj, tableField, fieldType);
                    list.add(field);
                }
            }
        }
        return list;
    }

    public List<Attachment> queryAttachmentInfo(Long billId, String billType, boolean decrypt) {
        ArrayList<Attachment> attachmentList = new ArrayList<Attachment>(10);
        Map panelAttachmentMap = AttachmentServiceHelper.getAttachmentsForApi((String)billType, (Object)String.valueOf(billId));
        if (panelAttachmentMap != null && !panelAttachmentMap.isEmpty()) {
            Set panelAttachmentSet = panelAttachmentMap.entrySet();
            Map.Entry entry = panelAttachmentSet.iterator().next();
            String panelKey = (String)entry.getKey();
            List attachments = AttachmentServiceHelper.getAttachments((String)billType, (Object)String.valueOf(billId), (String)panelKey, (boolean)decrypt);
            for (Map attachment : attachments) {
                String filePath = null;
                if (!decrypt) {
                    String url = (String)attachment.get("url");
                    String path = url.substring(url.indexOf("path=") + 6);
                    try {
                        filePath = URLDecoder.decode(path, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
                    }
                }
                Attachment attachmentInfo = new Attachment((String)attachment.get("uid"), (String)attachment.get("url"), (String)attachment.get("type"), (String)attachment.get("name"), ((Long)attachment.get("size")).longValue(), filePath, panelKey);
                attachmentList.add(attachmentInfo);
            }
        }
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fgptas", (String)"IBillImageService", (String)"getBillImageDetail", (Object[])new Object[]{billId});
        SchemaExecutorLogger.info((String)("gpt billimage result:" + IDIJSONUtils.toJsonString((Object)resultMap)), (Object[])new Object[0]);
        Boolean status = (Boolean)resultMap.get("success");
        if (status.booleanValue()) {
            List imageDetails;
            Map bidMap = (Map)resultMap.get("billImageDetail");
            if (bidMap != null && CollectionUtils.isNotEmpty((Collection)(imageDetails = (List)bidMap.get("imageDetailList")))) {
                for (Map imageDetailMap : imageDetails) {
                    if (imageDetailMap == null) continue;
                    Attachment attachmentInfo = new Attachment((String)imageDetailMap.get("fileId"), (String)imageDetailMap.get("downloadUrl"), "", (String)imageDetailMap.get("fileName"), -1L, "", "");
                    attachmentList.add(attachmentInfo);
                }
            }
        } else {
            String msg = (String)resultMap.get("msg");
            SchemaExecutorLogger.info((String)msg, (Object[])new Object[0]);
        }
        return attachmentList;
    }

    public AIRecognizerResult recognizer(AIRecognizerParam param) {
        StandardBaseDataConfig[] templateObjs = param.getFgptasTemplates();
        HashMap<Object, String> newIdToNumberMap = new HashMap<Object, String>(10);
        for (StandardBaseDataConfig templateObj : templateObjs) {
            newIdToNumberMap.put(templateObj.getId(), templateObj.getNumber());
        }
        AIRecognizerResult aiRecognizerResult = new AIRecognizerResult();
        Map preProcessResultMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"fgptas", (String)"IModalPreProcessService", (String)"getPreProcessResult", (Object[])new Object[]{param.getBillId()});
        SchemaExecutorLogger.info((String)("gpt recognizer result:" + IDIJSONUtils.toJsonString((Object)preProcessResultMap)), (Object[])new Object[0]);
        if (preProcessResultMap != null) {
            boolean isSuccess = (Boolean)preProcessResultMap.get("success");
            if (isSuccess) {
                boolean needExecuteDecision = (Boolean)preProcessResultMap.get("needExecuteDecision");
                if (needExecuteDecision) {
                    aiRecognizerResult.setErrorCode("SUCCESS");
                    List dataArray = (List)preProcessResultMap.get("data");
                    if (CollectionUtils.isNotEmpty((Collection)dataArray)) {
                        int size = dataArray.size();
                        for (int i = 0; i < size; ++i) {
                            boolean aiParticipation;
                            Map recordObj = (Map)dataArray.get(i);
                            Long templateId = (Long)recordObj.get("attachTemplate");
                            if (newIdToNumberMap.get(templateId) == null) continue;
                            AITemplate aiTemplate = new AITemplate(templateId, (String)newIdToNumberMap.get(templateId), null);
                            aiTemplate.setCustomTemplate(false);
                            String auditElementStatus = (String)recordObj.get("auditElementStatus");
                            String fileName = (String)recordObj.get("attachName");
                            String llmParticipateStatus = (String)recordObj.get("llmParticipateStatus");
                            boolean bl = aiParticipation = !"4".equals(llmParticipateStatus);
                            if ("1".equals(auditElementStatus)) {
                                AIRecognizerSuccessInfo successInfo = new AIRecognizerSuccessInfo();
                                successInfo.setTemplate(aiTemplate);
                                successInfo.setFileName(fileName);
                                String auditElementResultStr = (String)recordObj.get("auditElementResult");
                                JSONObject elementResult = JSONObject.parseObject((String)auditElementResultStr);
                                successInfo.setDataDetailMap((Map<String, Object>)elementResult);
                                successInfo.setAiParticipation(aiParticipation);
                                aiRecognizerResult.addSuccessInfo(successInfo);
                                continue;
                            }
                            AIRecognizerErrorInfo errorInfo = new AIRecognizerErrorInfo();
                            errorInfo.setTemplate(aiTemplate);
                            errorInfo.setFileName(fileName);
                            errorInfo.setAiParticipation(aiParticipation);
                            String code = auditElementStatus;
                            code = "2".equals(auditElementStatus) ? "notResolved" : ("3".equals(auditElementStatus) ? "requestFaill" : "nullresult");
                            errorInfo.setErrorCode(code);
                            errorInfo.setDescription((String)recordObj.get("auditElementResult"));
                            aiRecognizerResult.addErrorInfo(errorInfo);
                        }
                    }
                } else {
                    String errorMsg = (String)preProcessResultMap.get("decisionTips");
                    aiRecognizerResult.setDescription(errorMsg);
                    aiRecognizerResult.setErrorCode("FAILED");
                }
            } else {
                String errorMsg = (String)preProcessResultMap.get("decisionTips");
                aiRecognizerResult.setDescription(errorMsg);
                aiRecognizerResult.setErrorCode("FAILED");
            }
        }
        return aiRecognizerResult;
    }
}

