/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.customrule;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionRule;
import kd.data.idi.data.IDICompareType;
import kd.data.idi.data.IDICondition;
import kd.data.idi.data.LinkUpBillResult;
import kd.data.idi.engine.ScriptFormIdHandler;
import kd.data.idi.engine.customrule.DecisionRuleAnalysisDTO;
import kd.data.idi.engine.customrule.EntryRowRelationDTO;
import kd.data.idi.engine.front.LinkUpBillFront;
import kd.data.idi.engine.functions.CustomFuncEnum;
import kd.data.idi.util.MetadataUtil;

public class EntryRowRelation {
    public static EntryRowRelationDTO getEntryRowIndexRelation(IDICondition crossEntryRule, DynamicObject srcBillObj, String entityType, String startConditionEntry, List<Integer> matchStartConditionEntryIndexList, List<LinkUpBillResult> linkUpBillResults, Decision decision, boolean billControl) {
        Object value;
        if (!billControl) {
            srcBillObj = BusinessDataServiceHelper.loadSingleFromCache((Object)srcBillObj.get("id"), (String)srcBillObj.getDynamicObjectType().getName());
        }
        EntryRowRelationDTO relationDTO = new EntryRowRelationDTO();
        HashSet<Object> existRelationValues = new HashSet<Object>(10);
        List filterRowList = crossEntryRule.getFilterCondition().getFilterRow();
        SimpleFilterRow firstFilterRow = (SimpleFilterRow)filterRowList.get(0);
        String firstFieldName = firstFilterRow.getFieldName();
        String fieldEntryName = firstFieldName.substring(0, firstFieldName.indexOf(46));
        String firstValueName = ((FilterValue)firstFilterRow.getValue().get(0)).getValue().toString();
        String valueEntryName = firstValueName.substring(0, firstValueName.indexOf(46));
        String fieldPropertyName = firstFieldName.substring(fieldEntryName.length() + 1);
        String valuePropertyName = firstValueName.substring(valueEntryName.length() + 1);
        MainEntityType srcMainType = EntityMetadataCache.getDataEntityType((String)entityType);
        Map allEntities = srcMainType.getAllEntities();
        boolean trueSubEntry = false;
        String parentEntryNumber = null;
        String subEntryNumber = null;
        String prefix = entityType + "_billObj.";
        HashSet<String> subEntryEntity = new HashSet<String>(2);
        HashSet<Object> notMatchData = new HashSet<Object>(10);
        String fullName = allEntities.get(fieldEntryName) instanceof SubEntryType ? ((EntityType)allEntities.get(fieldEntryName)).getParent().getName() + "." + firstFieldName : firstFieldName;
        String notMatchTitle = MetadataUtil.getDisplayNameByScriptStr(prefix + fullName, srcMainType, null);
        if (valueEntryName.equals(((EntityType)allEntities.get(fieldEntryName)).getParent().getName()) || fieldEntryName.equals(((EntityType)allEntities.get(valueEntryName)).getParent().getName())) {
            trueSubEntry = true;
            parentEntryNumber = allEntities.get(fieldEntryName) instanceof SubEntryType ? valueEntryName : fieldEntryName;
            subEntryNumber = allEntities.get(fieldEntryName) instanceof SubEntryType ? fieldEntryName : valueEntryName;
            subEntryEntity.add(subEntryNumber);
        }
        if (trueSubEntry) {
            DynamicObjectCollection parentEntry = srcBillObj.getDynamicObjectCollection(parentEntryNumber);
            relationDTO.setEntryFlag(parentEntryNumber);
            relationDTO.setTargetEntryFlag(subEntryNumber);
            relationDTO.addSubParentEntryMap(subEntryNumber, parentEntryNumber);
            relationDTO.setTrueSubEntry(true);
            relationDTO.addEntryCollectionMap(parentEntryNumber, parentEntry);
            block0: for (int parentIndex = 0; parentIndex < parentEntry.size(); ++parentIndex) {
                DynamicObject dynamicObject = (DynamicObject)parentEntry.get(parentIndex);
                DynamicObjectCollection subEntry = dynamicObject.getDynamicObjectCollection(subEntryNumber);
                relationDTO.addTrueSubEntryCollection(Integer.valueOf(parentIndex), subEntry);
                for (int subIndex = 0; subIndex < subEntry.size(); ++subIndex) {
                    if (startConditionEntry != null && !matchStartConditionEntryIndexList.isEmpty()) {
                        if (startConditionEntry.equals(parentEntryNumber) && !matchStartConditionEntryIndexList.contains(parentIndex)) continue block0;
                        if (startConditionEntry.equals(subEntryNumber) && !matchStartConditionEntryIndexList.contains(subIndex)) continue;
                    }
                    StringBuilder indexScriptBuilder = new StringBuilder();
                    for (int filterRowIndex = 0; filterRowIndex < filterRowList.size(); ++filterRowIndex) {
                        SimpleFilterRow simpleFilterRow = (SimpleFilterRow)filterRowList.get(filterRowIndex);
                        String fieldName = simpleFilterRow.getFieldName();
                        String valueName = ((FilterValue)simpleFilterRow.getValue().get(0)).getValue().toString();
                        indexScriptBuilder.append(simpleFilterRow.getLeftBracket()).append(prefix);
                        Set fieldNameSet = Arrays.stream(fieldName.split("\\.")).collect(Collectors.toSet());
                        Set valueNameSet = Arrays.stream(valueName.split("\\.")).collect(Collectors.toSet());
                        if (fieldNameSet.contains(parentEntryNumber)) {
                            fieldName = EntryRowRelation.replaceParentEntryName(allEntities, fieldName, parentEntryNumber, parentIndex, subEntryEntity, parentIndex);
                        } else if (fieldNameSet.contains(subEntryNumber)) {
                            fieldName = EntryRowRelation.replaceParentEntryName(allEntities, fieldName, subEntryNumber, subIndex, subEntryEntity, parentIndex);
                        }
                        indexScriptBuilder.append(fieldName).append(" == ");
                        if (valueNameSet.contains(parentEntryNumber)) {
                            valueName = EntryRowRelation.replaceParentEntryName(allEntities, valueName, parentEntryNumber, parentIndex, subEntryEntity, parentIndex);
                        } else if (valueNameSet.contains(subEntryNumber)) {
                            valueName = EntryRowRelation.replaceParentEntryName(allEntities, valueName, subEntryNumber, subIndex, subEntryEntity, parentIndex);
                        }
                        indexScriptBuilder.append(prefix).append(valueName).append(simpleFilterRow.getRightBracket());
                        if (filterRowIndex >= filterRowList.size() - 1) continue;
                        indexScriptBuilder.append("0".equals(simpleFilterRow.getLogic()) ? " && " : " || ");
                    }
                    String indexScript = "if(%s) {\nreturn %s\n}";
                    String resultIndexRelation = "\"true\";";
                    String runIndexScript = String.format(indexScript, indexScriptBuilder.toString(), resultIndexRelation);
                    HashMap<String, DynamicObject> ctx = new HashMap<String, DynamicObject>(1);
                    ctx.put(entityType + "_billObj", srcBillObj);
                    Object runScriptResult = ScriptFormIdHandler.runScript((String)entityType, null, ctx, (String)runIndexScript);
                    if (runScriptResult != null && Boolean.parseBoolean(String.valueOf(runScriptResult))) {
                        relationDTO.addEntryIdMap(Integer.valueOf(parentIndex), Integer.valueOf(subIndex));
                        existRelationValues.add(fieldEntryName.equals(parentEntryNumber) ? dynamicObject.get(fieldPropertyName) : ((DynamicObject)subEntry.get(subIndex)).get(fieldPropertyName));
                        continue;
                    }
                    if (fieldEntryName.equals(parentEntryNumber)) {
                        DynamicObject subObj;
                        Object value2 = dynamicObject.get(fieldPropertyName);
                        if (EntryRowRelation.validateNull(value2, (subObj = (DynamicObject)subEntry.get(subIndex)).get(valuePropertyName))) {
                            relationDTO.addEntryIdMap(Integer.valueOf(parentIndex), Integer.valueOf(subIndex));
                            existRelationValues.add(value2);
                            continue;
                        }
                        notMatchData.add(value2);
                        continue;
                    }
                    if (!fieldEntryName.equals(subEntryNumber)) continue;
                    DynamicObject subObj = (DynamicObject)subEntry.get(subIndex);
                    value = subObj.get(fieldPropertyName);
                    if (EntryRowRelation.validateNull(value, dynamicObject.get(valuePropertyName))) {
                        relationDTO.addEntryIdMap(Integer.valueOf(parentIndex), Integer.valueOf(subIndex));
                        existRelationValues.add(value);
                        continue;
                    }
                    notMatchData.add(value);
                }
            }
        } else {
            relationDTO.setEntryFlag(fieldEntryName);
            relationDTO.setTargetEntryFlag(valueEntryName);
            DynamicObjectCollection fieldEntry = null;
            DynamicObjectCollection valueEntry = null;
            if (allEntities.get(fieldEntryName) instanceof SubEntryType) {
                subEntryEntity.add(fieldEntryName);
                String string = ((EntityType)allEntities.get(fieldEntryName)).getParent().getName();
                fieldEntry = relationDTO.gatherSubEntryData(srcBillObj, string, fieldEntryName, fieldEntry);
            } else {
                fieldEntry = srcBillObj.getDynamicObjectCollection(fieldEntryName);
            }
            if (allEntities.get(valueEntryName) instanceof SubEntryType) {
                subEntryEntity.add(valueEntryName);
                String string = ((EntityType)allEntities.get(valueEntryName)).getParent().getName();
                valueEntry = relationDTO.gatherSubEntryData(srcBillObj, string, valueEntryName, valueEntry);
            } else {
                valueEntry = srcBillObj.getDynamicObjectCollection(valueEntryName);
            }
            relationDTO.addEntryCollectionMap(fieldEntryName, fieldEntry);
            relationDTO.addEntryCollectionMap(valueEntryName, valueEntry);
            Map map = relationDTO.getSubParentEntryMap();
            Map parentEntryIndexMap = relationDTO.getParentEntryIndexMap();
            if (fieldEntry != null && valueEntry != null) {
                block3: for (int fieldIndex = 0; fieldIndex < fieldEntry.size(); ++fieldIndex) {
                    for (int valueIndex = 0; valueIndex < valueEntry.size(); ++valueIndex) {
                        if (startConditionEntry != null && !matchStartConditionEntryIndexList.isEmpty()) {
                            if (startConditionEntry.equals(fieldEntryName) && !matchStartConditionEntryIndexList.contains(fieldIndex) || startConditionEntry.equals(map.get(fieldEntryName)) && parentEntryIndexMap.get(startConditionEntry) != null && !matchStartConditionEntryIndexList.contains(((Map)parentEntryIndexMap.get(startConditionEntry)).get(fieldIndex))) continue block3;
                            if (startConditionEntry.equals(valueEntryName) && !matchStartConditionEntryIndexList.contains(valueIndex) || startConditionEntry.equals(map.get(valueEntryName)) && parentEntryIndexMap.get(startConditionEntry) != null && !matchStartConditionEntryIndexList.contains(((Map)parentEntryIndexMap.get(startConditionEntry)).get(valueIndex))) continue;
                        }
                        StringBuilder indexScriptBuilder = new StringBuilder();
                        for (int filterRowIndex = 0; filterRowIndex < filterRowList.size(); ++filterRowIndex) {
                            SimpleFilterRow simpleFilterRow = (SimpleFilterRow)filterRowList.get(filterRowIndex);
                            String fieldName = simpleFilterRow.getFieldName();
                            String valueName = ((FilterValue)simpleFilterRow.getValue().get(0)).getValue().toString();
                            indexScriptBuilder.append(simpleFilterRow.getLeftBracket()).append(prefix);
                            if (fieldName.contains(fieldEntryName)) {
                                fieldName = EntryRowRelation.replaceEntryName(allEntities, fieldName, fieldEntryName, fieldIndex, subEntryEntity);
                            } else if (fieldName.contains(valueEntryName)) {
                                fieldName = EntryRowRelation.replaceEntryName(allEntities, fieldName, valueEntryName, valueIndex, subEntryEntity);
                            }
                            indexScriptBuilder.append(fieldName).append(" == ");
                            if (valueName.contains(fieldEntryName)) {
                                valueName = EntryRowRelation.replaceEntryName(allEntities, valueName, fieldEntryName, fieldIndex, subEntryEntity);
                            } else if (valueName.contains(valueEntryName)) {
                                valueName = EntryRowRelation.replaceEntryName(allEntities, valueName, valueEntryName, valueIndex, subEntryEntity);
                            }
                            indexScriptBuilder.append(prefix).append(valueName).append(simpleFilterRow.getRightBracket());
                            if (filterRowIndex >= filterRowList.size() - 1) continue;
                            indexScriptBuilder.append("0".equals(simpleFilterRow.getLogic()) ? " && " : " || ");
                        }
                        String indexScript = "if(%s) {\nreturn %s\n}";
                        String resultIndexRelation = "\"true\";";
                        String runIndexScript = String.format(indexScript, indexScriptBuilder.toString(), resultIndexRelation);
                        HashMap<String, DynamicObject> ctx = new HashMap<String, DynamicObject>(1);
                        ctx.put(entityType + "_billObj", srcBillObj);
                        Object runScriptResult = ScriptFormIdHandler.runScript((String)entityType, null, ctx, (String)runIndexScript);
                        if (runScriptResult != null && Boolean.parseBoolean(String.valueOf(runScriptResult))) {
                            relationDTO.addEntryIdMap(Integer.valueOf(fieldIndex), Integer.valueOf(valueIndex));
                            existRelationValues.add(((DynamicObject)fieldEntry.get(fieldIndex)).get(fieldPropertyName));
                            continue;
                        }
                        value = ((DynamicObject)fieldEntry.get(fieldIndex)).get(fieldPropertyName);
                        if (EntryRowRelation.validateNull(value, ((DynamicObject)valueEntry.get(valueIndex)).get(valuePropertyName))) {
                            relationDTO.addEntryIdMap(Integer.valueOf(fieldIndex), Integer.valueOf(valueIndex));
                            existRelationValues.add(value);
                            continue;
                        }
                        notMatchData.add(value);
                    }
                }
            }
        }
        notMatchData.removeAll(existRelationValues);
        HashSet<String> noMatchDataString = new HashSet<String>(notMatchData.size());
        for (Object e : notMatchData) {
            if (e == null) {
                noMatchDataString.add("");
                continue;
            }
            if (e instanceof Number) {
                noMatchDataString.add(new BigDecimal(e.toString()).setScale(2, RoundingMode.HALF_UP).toPlainString());
                continue;
            }
            noMatchDataString.add(e.toString());
        }
        if (!noMatchDataString.isEmpty() && linkUpBillResults != null) {
            LinkUpBillResult billResult = new LinkUpBillResult();
            billResult.setMatchRule(-1);
            billResult.setPass(true);
            billResult.setShowText(String.format(ResManager.loadKDString((String)"%s: \u5b58\u5728\u672a\u5173\u8054\u7684\u503c", (String)"EntryRowRelation_0", (String)"data-idi-core", (Object[])new Object[0]), decision.getName()));
            billResult.setStatus("warnning");
            billResult.setFrontEndResult(LinkUpBillFront.buildNoMatch(noMatchDataString, notMatchTitle));
            linkUpBillResults.add(billResult);
        }
        return relationDTO;
    }

    private static boolean validateNull(Object value1, Object value2) {
        return (value1 == null || StringUtils.isEmpty((String)value1.toString()) || value1 instanceof Long && 0L == (Long)value1) && (value2 == null || StringUtils.isEmpty((String)value2.toString()) || value2 instanceof Long && 0L == (Long)value2);
    }

    private static String replaceParentEntryName(Map<String, EntityType> allEntities, String sourceRule, String targetName, int targetIndex, Set<String> subEntryEntity, int parentIndex) {
        sourceRule = subEntryEntity.contains(targetName) ? sourceRule.replace(targetName + ".", allEntities.get(targetName).getParent().getName() + "[" + parentIndex + "]." + targetName + "[" + targetIndex + "].") : sourceRule.replace(targetName + ".", targetName + "[" + targetIndex + "].");
        return sourceRule;
    }

    private static String replaceEntryName(Map<String, EntityType> allEntities, String sourceRule, String targetName, int targetIndex, Set<String> subEntryEntity) {
        sourceRule = subEntryEntity.contains(targetName) ? sourceRule.replace(targetName + ".", allEntities.get(targetName).getParent().getName() + "." + targetName + "[" + targetIndex + "].") : sourceRule.replace(targetName + ".", targetName + "[" + targetIndex + "].");
        return sourceRule;
    }

    public static List<DecisionRuleAnalysisDTO> matchEntryNumber(List<DecisionRule> decisionRuleList, IDICondition crossEntryRule, String entity, MainEntityType mainType, Map<String, Object> funcValueMap) {
        ArrayList<DecisionRuleAnalysisDTO> matchRules = new ArrayList<DecisionRuleAnalysisDTO>(decisionRuleList.size());
        List filterRowList = crossEntryRule.getFilterCondition().getFilterRow();
        SimpleFilterRow firstFilterRow = (SimpleFilterRow)filterRowList.get(0);
        String firstFieldName = firstFilterRow.getFieldName();
        String fieldEntryName = firstFieldName.substring(0, firstFieldName.indexOf(46));
        String firstValueName = ((FilterValue)firstFilterRow.getValue().get(0)).getValue().toString();
        String valueEntryName = firstValueName.substring(0, firstValueName.indexOf(46));
        Map allEntities = mainType.getAllEntities();
        for (int j = 0; j < decisionRuleList.size(); ++j) {
            String[] valueProperties;
            Set fieldSet;
            DecisionRule decisionRule = decisionRuleList.get(j);
            String ruleScript = decisionRule.getRule().getScript();
            if (ruleScript == null || ruleScript.isEmpty()) continue;
            ruleScript = ruleScript.replaceAll(" ", "");
            if (!funcValueMap.isEmpty()) {
                for (Map.Entry<String, Object> replaceEntry : funcValueMap.entrySet()) {
                    ruleScript = ruleScript.replace(replaceEntry.getKey(), replaceEntry.getValue().toString());
                }
            }
            if (2 != (fieldSet = ScriptFormIdHandler.extractVariables((String)ruleScript, (String[])new String[]{entity})).size()) continue;
            String fieldExpression = null;
            String fieldBelongEntry = null;
            String fieldProp = null;
            String valueExpression = null;
            CustomFuncEnum[] valueBelongEntry = null;
            String valueProp = null;
            int index = 0;
            for (String expression : fieldSet) {
                if (index == 0) {
                    fieldExpression = expression;
                }
                if (index == 1) {
                    valueExpression = expression;
                }
                ++index;
            }
            if (fieldExpression == null || valueExpression == null) continue;
            String[] fieldProperties = fieldExpression.split("\\.");
            if (fieldProperties.length > 2) {
                for (int i = 1; i < fieldProperties.length; ++i) {
                    String field = fieldProperties[i];
                    if (!(allEntities.get(field) instanceof EntryType)) continue;
                    fieldBelongEntry = field;
                    fieldProp = fieldExpression.substring(fieldExpression.indexOf(field) + field.length() + 1);
                }
            }
            if ((valueProperties = valueExpression.split("\\.")).length > 2) {
                for (int i = 1; i < valueProperties.length; ++i) {
                    CustomFuncEnum[] field = valueProperties[i];
                    if (!(allEntities.get(field) instanceof EntryType)) continue;
                    valueBelongEntry = field;
                    valueProp = valueExpression.substring(valueExpression.indexOf((String)field) + field.length() + 1);
                }
            }
            if (fieldBelongEntry == null || valueBelongEntry == null) continue;
            String comparisonSymbol = ruleScript.replace(fieldExpression, "").replace(valueExpression, "");
            for (CustomFuncEnum value : CustomFuncEnum.values()) {
                comparisonSymbol = comparisonSymbol.replace(value.getFuncName() + "()", "");
                if (!value.getFuncName().equals(CustomFuncEnum.SUM_ENTRY.getFuncName()) || !comparisonSymbol.contains(value.getFuncName())) continue;
                comparisonSymbol = comparisonSymbol.replace(value.getFuncName() + "(", "");
                comparisonSymbol = comparisonSymbol.replaceAll(",\\d+\\)", "");
            }
            IDICompareType idiCompareType = IDICompareType.typeToCompareType((String)comparisonSymbol);
            if (idiCompareType == null) continue;
            if (fieldBelongEntry.equals(fieldEntryName) && valueBelongEntry.equals(valueEntryName)) {
                DecisionRuleAnalysisDTO ruleAnalysisDTO = new DecisionRuleAnalysisDTO(ruleScript, idiCompareType, fieldBelongEntry, fieldProp, (String)valueBelongEntry, valueProp, j);
                matchRules.add(ruleAnalysisDTO);
                continue;
            }
            if (!fieldBelongEntry.equals(valueEntryName) || !valueBelongEntry.equals(fieldEntryName)) continue;
            DecisionRuleAnalysisDTO ruleAnalysisDTO = new DecisionRuleAnalysisDTO(ruleScript, idiCompareType, (String)valueBelongEntry, valueProp, fieldBelongEntry, fieldProp, j);
            matchRules.add(ruleAnalysisDTO);
        }
        return matchRules;
    }
}

