/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.front;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.Pair;
import kd.bos.util.StringUtils;
import kd.data.idi.data.Decision;
import kd.data.idi.data.DecisionFrontEndConfig;
import kd.data.idi.data.DecisionFrontEndConfigField;
import kd.data.idi.data.DecisionFrontEndResult;
import kd.data.idi.data.HoverContent;
import kd.data.idi.data.LinkUpBillConfig;
import kd.data.idi.engine.BillCheckResult;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.customrule.EntryRowRelationDTO;
import kd.data.idi.engine.front.IFront;
import kd.data.idi.engine.functions.CustomFuncEnum;
import kd.data.idi.engine.functions.CustomFuncInfoChain;
import kd.data.idi.engine.linkupbill.SubRelation;
import kd.data.idi.util.MetadataUtil;

public class LinkUpBillFront
implements IFront {
    private static final Log logger = LogFactory.getLog(LinkUpBillFront.class);
    private final Decision decision;
    private final List<BillCheckResult> billCheckResultList;
    private final CustomFuncInfoChain customFuncInfoChain;
    private EntryRowRelationDTO relationDTO;
    private boolean onlyFunc;
    private MainEntityType srcEntityType;
    private MainEntityType targetEntityType;

    public LinkUpBillFront(Decision decision, List<BillCheckResult> billCheckResultList, CustomFuncInfoChain customFuncInfoChain, MainEntityType srcEntityType, MainEntityType targetEntityType) {
        this.decision = decision;
        this.billCheckResultList = billCheckResultList;
        this.customFuncInfoChain = customFuncInfoChain;
        this.srcEntityType = srcEntityType;
        this.targetEntityType = targetEntityType;
    }

    public void setRelationDTO(EntryRowRelationDTO relationDTO) {
        this.relationDTO = relationDTO;
    }

    public DecisionFrontEndResult build() {
        if (!this.check()) {
            return null;
        }
        try {
            return this.exec();
        }
        catch (Exception e) {
            logger.error("[DATA-IDI] LinkUpBillFront exec error!", (Throwable)e);
            throw e;
        }
    }

    private boolean check() {
        return this.billCheckResultList != null && !this.billCheckResultList.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private DecisionFrontEndResult exec() {
        HoverContent titleHoverContent;
        Map<String, Object> sumEntryFuncMap;
        Map<String, Object> funcValueMap;
        DecisionFrontEndResult frontEndResult = new DecisionFrontEndResult();
        HashMap<Integer, Tuple<HoverContent, List<HoverContent>>> tableMap = new HashMap<Integer, Tuple<HoverContent, List<HoverContent>>>();
        int curColIndex = 0;
        int maxLine = 0;
        boolean isIncludeFunc = false;
        int targetFunValueColIndex = -1;
        ArrayList<Integer> srcSumColIndexList = new ArrayList<Integer>(2);
        ArrayList<Integer> targetSumColIndexList = new ArrayList<Integer>(2);
        if (this.customFuncInfoChain != null && (funcValueMap = this.customFuncInfoChain.getFuncValueMap()) != null && !funcValueMap.isEmpty() && !(sumEntryFuncMap = funcValueMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(CustomFuncEnum.SUM_ENTRY.getFuncName())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty()) {
            for (Map.Entry<String, Object> entry2 : sumEntryFuncMap.entrySet()) {
                String funcScript = entry2.getKey();
                int startIndex = funcScript.indexOf("(");
                int endIndex = funcScript.indexOf(")");
                String scriptStr = funcScript.substring(startIndex + 1, endIndex);
                String funcName = String.format(ResManager.loadKDString((String)"%s\u5408\u8ba1", (String)"LinkUpBillFront_0", (String)"data-idi-core", (Object[])new Object[0]), MetadataUtil.getDisplayNameByScriptStr(scriptStr, this.srcEntityType, this.targetEntityType));
                Object funcValue = entry2.getValue();
                titleHoverContent = HoverContent.createTitle((String)funcName);
                ArrayList<HoverContent> valueHoverContentList = new ArrayList<HoverContent>(10);
                if (funcValue instanceof Map) {
                    Map targetFuncValueMap = (Map)funcValue;
                    targetFuncValueMap.forEach((linkObj, mseg) -> {
                        HoverContent hc = HoverContent.createHref((String)String.valueOf(mseg), (DynamicObject)((DynamicObject)linkObj));
                        valueHoverContentList.add(hc);
                    });
                    if (targetFunValueColIndex < 0) {
                        targetFunValueColIndex = curColIndex;
                    }
                    targetSumColIndexList.add(curColIndex);
                    maxLine = Math.max(targetFuncValueMap.size(), 1);
                } else {
                    HoverContent valueHoverContent = HoverContent.createText((String)String.valueOf(funcValue));
                    valueHoverContentList.add(valueHoverContent);
                    srcSumColIndexList.add(curColIndex);
                }
                Tuple colTuple = new Tuple((Object)titleHoverContent, valueHoverContentList);
                tableMap.put(curColIndex, (Tuple<HoverContent, List<HoverContent>>)colTuple);
                ++curColIndex;
            }
            isIncludeFunc = true;
            maxLine = Math.max(maxLine, 1);
        }
        if (targetFunValueColIndex >= 0) {
            this.billCheckResultList.sort((o1, o2) -> {
                DynamicObject linkObj1 = o1.getLinkObj();
                DynamicObject linkObj2 = o2.getLinkObj();
                return linkObj1.hashCode() - linkObj2.hashCode();
            });
        }
        LinkedHashMap<String, List<Integer>> linkStartIndexMap = new LinkedHashMap<String, List<Integer>>(10);
        DecisionFrontEndConfig frontEndConfig = this.decision.getFrontEndConfig();
        if (frontEndConfig != null && frontEndConfig.getHoverFieldContents() != null && !frontEndConfig.getHoverFieldContents().isEmpty()) {
            List hoverFieldContentList = frontEndConfig.getHoverFieldContents();
            for (DecisionFrontEndConfigField frontEndConfigField : hoverFieldContentList) {
                Pair<Boolean, List<HoverContent>> dataPair;
                String billType = frontEndConfigField.getBillType();
                String propName = frontEndConfigField.getPropName();
                String displayName = frontEndConfigField.achieveDisplayName();
                String propDisplayName = frontEndConfigField.getPropDisplayName();
                String titleName = StringUtils.isNotEmpty((String)displayName) ? displayName : propDisplayName;
                titleHoverContent = HoverContent.createTitle((String)titleName);
                String entryName = propName.split("\\.")[0];
                ArrayList<HoverContent> valueHoverContentList = new ArrayList<HoverContent>(4);
                if (this.relationDTO != null && this.onlyFunc && !((Boolean)(dataPair = this.getHoverContentFromCrossEntryRule(this.relationDTO, propName)).getKey()).booleanValue()) {
                    valueHoverContentList.addAll((Collection)dataPair.getValue());
                    maxLine = Math.max(maxLine, valueHoverContentList.size());
                    Tuple colTuple = new Tuple((Object)titleHoverContent, valueHoverContentList);
                    tableMap.put(curColIndex, (Tuple<HoverContent, List<HoverContent>>)colTuple);
                    ++curColIndex;
                    continue;
                }
                boolean isSourceBill = "srcbill".equals(billType);
                DynamicObject preLink = null;
                for (BillCheckResult billCheckResult : this.billCheckResultList) {
                    String content;
                    String srcEntryName = billCheckResult.getSrcEntryName();
                    int srcEntryIndex = billCheckResult.getSrcEntryIndex();
                    String linkEntryName = billCheckResult.getLinkEntryName();
                    int linkEntryIndex = billCheckResult.getLinkEntryIndex();
                    DynamicObject billObj = ExecutorHelper.getBillCheckResultBillObj(billType, billCheckResult);
                    IDataEntityType entityType = billObj.getDataEntityType();
                    if (!isSourceBill && billCheckResult.getLinkObj() != null && !billCheckResult.getLinkObj().equals(preLink)) {
                        String targetBillId = String.valueOf(billCheckResult.getLinkObj().get("id"));
                        ArrayList<Integer> oldLinkStartIndex = (ArrayList<Integer>)linkStartIndexMap.get(targetBillId);
                        if (oldLinkStartIndex != null) {
                            oldLinkStartIndex.add(valueHoverContentList.size());
                        } else {
                            oldLinkStartIndex = new ArrayList<Integer>(10);
                            oldLinkStartIndex.add(valueHoverContentList.size());
                            linkStartIndexMap.put(targetBillId, oldLinkStartIndex);
                        }
                        preLink = billCheckResult.getLinkObj();
                    }
                    if (this.relationDTO != null) {
                        Map subParentEntryMap = this.relationDTO.getSubParentEntryMap();
                        String[] propNameSplit = propName.split("\\.");
                        int subEntryIndex = 0;
                        boolean ifSubEntry = false;
                        for (int i = 0; i < propNameSplit.length; ++i) {
                            if (subParentEntryMap.get(propNameSplit[i]) == null) continue;
                            subEntryIndex = i;
                            ifSubEntry = true;
                            break;
                        }
                        if (ifSubEntry) {
                            valueHoverContentList.add(ExecutorHelper.getHoverContent(this.relationDTO, propNameSplit, billCheckResult, billObj, subEntryIndex, false, this.srcEntityType));
                            continue;
                        }
                        if (!subParentEntryMap.isEmpty() && subParentEntryMap.containsValue(propNameSplit[0]) && !this.relationDTO.isTrueSubEntry()) {
                            valueHoverContentList.add(ExecutorHelper.getHoverContent(this.relationDTO, propNameSplit, billCheckResult, billObj, subEntryIndex, true, this.srcEntityType));
                            continue;
                        }
                    }
                    ExecutorHelper.ValueAndName valueAndNameByName = ExecutorHelper.getValueAndNameByName(billObj, (DynamicObjectType)(isSourceBill ? this.srcEntityType : this.targetEntityType), propName, true, true);
                    Object value = valueAndNameByName.getValue();
                    IDataEntityProperty entityProperty = valueAndNameByName.getEntityProperty();
                    Object refValue = valueAndNameByName.getRefValue();
                    boolean isUser = valueAndNameByName.isUser();
                    boolean isBill = !(entityType instanceof BasedataEntityType);
                    boolean isBillNo = false;
                    if (isBill) {
                        BillEntityType billEntityType = (BillEntityType)entityType;
                        isBillNo = propName.equalsIgnoreCase(billEntityType.getBillNo());
                    }
                    if (value == null) {
                        valueHoverContentList.add(HoverContent.createText((String)" "));
                        continue;
                    }
                    if (value instanceof List) {
                        int entryIndex;
                        List valueList = (List)value;
                        List refValueList = (List)refValue;
                        int n = entryIndex = isSourceBill && entryName != null && entryName.equals(srcEntryName) ? srcEntryIndex : linkEntryIndex;
                        if (entryName != null && (entryName.equals(srcEntryName) || entryName.equals(linkEntryName))) {
                            if (entryIndex >= 0 && entryIndex < valueList.size()) {
                                Object itemValue = valueList.get(entryIndex);
                                Object formatValue = ExecutorHelper.tryToString(billObj, billObj, itemValue, entityProperty);
                                String content2 = formatValue == null ? " " : formatValue.toString();
                                HoverContent valueHoverContent = isUser ? HoverContent.createChat((String)content2, refValueList.get(entryIndex)) : HoverContent.createText((String)content2);
                                valueHoverContentList.add(valueHoverContent);
                                continue;
                            }
                            valueHoverContentList.add(HoverContent.createText((String)" "));
                            continue;
                        }
                        if (this.customFuncInfoChain != null && this.customFuncInfoChain.getEntrySet().contains(entryName) || this.decision.getLinkUpBillConfig().getCheckType() == LinkUpBillConfig.CheckType.CheckBillExists) {
                            for (int i = 0; i < valueList.size(); ++i) {
                                String val;
                                Object itemValue = valueList.get(i);
                                Object formatValue = ExecutorHelper.tryToString(billObj, billObj, itemValue, entityProperty);
                                String string = val = formatValue == null ? "" : formatValue.toString();
                                valueHoverContentList.add(isUser ? HoverContent.createChat((String)val, CollectionUtils.isNotEmpty((Collection)refValueList) && i < refValueList.size() ? refValueList.get(i) : null) : HoverContent.createText((String)val));
                            }
                            if (this.customFuncInfoChain == null || !this.customFuncInfoChain.getEntrySet().contains(entryName)) continue;
                            preLink = null;
                            continue;
                        }
                        throw new KDBizException(ResManager.loadKDString((String)"\u60ac\u505c\u4fe1\u606f\u914d\u7f6e\u7684\u5206\u5f55\u5b57\u6bb5\u8d85\u8fc7\u89c4\u5219\u5141\u8bb8\u8303\u56f4\u3002", (String)"LinkUpBillDecisionExecutor_16", (String)"data-idi-core", (Object[])new Object[0]));
                    }
                    if (value instanceof LinkedHashMap) {
                        int entryIndex;
                        String subEntryName = propName.split("\\.")[1];
                        boolean isCustomFuncSubEntry = this.customFuncInfoChain != null && this.customFuncInfoChain.getEntrySet().contains(subEntryName) || this.decision.getLinkUpBillConfig().getCheckType() == LinkUpBillConfig.CheckType.CheckBillExists;
                        SubRelation sr = billCheckResult.getSubRelation();
                        if (!isCustomFuncSubEntry && sr == null) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u60ac\u505c\u5b50\u5206\u5f55\u5b57\u6bb5\u8d85\u8fc7\u89c4\u5219\u5141\u8bb8\u8303\u56f4\u3002", (String)"LinkUpBillDecisionExecutor_17", (String)"data-idi-core", (Object[])new Object[0]));
                        }
                        Map subDataMap = (Map)value;
                        if (subDataMap.isEmpty()) {
                            valueHoverContentList.add(HoverContent.createText((String)" "));
                            continue;
                        }
                        Map subRefValueMap = (Map)refValue;
                        boolean isSpecialSubEntryIndex = false;
                        int n = entryIndex = isSourceBill && entryName != null && entryName.equals(srcEntryName) ? srcEntryIndex : linkEntryIndex;
                        if (StringUtils.isNotEmpty((String)entryName) && StringUtils.isNotEmpty((String)subEntryName) && sr != null) {
                            String dataSubEntryName;
                            int subEntryIndex = isSourceBill && entryName != null && entryName.equals(srcEntryName) ? sr.getSrcSubEntryIndex() : sr.getLinkSubEntryIndex();
                            String string = dataSubEntryName = isSourceBill && entryName != null && entryName.equals(srcEntryName) ? sr.getSrcSubEntryName() : sr.getLinkSubEntryName();
                            if (subEntryName.equals(dataSubEntryName)) {
                                List refValueList;
                                List valueList = (List)subDataMap.get(entryIndex);
                                List list = refValueList = isUser ? (List)subRefValueMap.get(entryIndex) : null;
                                if (CollectionUtils.isNotEmpty((Collection)valueList) && subEntryIndex > -1 && subEntryIndex < valueList.size()) {
                                    String content3;
                                    Object itemValue = valueList.get(subEntryIndex);
                                    Object formatValue = ExecutorHelper.tryToString(billObj, billObj, itemValue, entityProperty);
                                    String string2 = content3 = formatValue == null ? " " : formatValue.toString();
                                    if (isUser) {
                                        Object userId = null;
                                        if (CollectionUtils.isNotEmpty((Collection)refValueList) && subEntryIndex > -1 && subEntryIndex < refValueList.size()) {
                                            userId = refValueList.get(subEntryIndex);
                                        }
                                        valueHoverContentList.add(HoverContent.createChat((String)content3, userId));
                                    } else {
                                        valueHoverContentList.add(HoverContent.createText((String)content3));
                                    }
                                } else {
                                    valueHoverContentList.add(HoverContent.createText((String)" "));
                                }
                                isSpecialSubEntryIndex = true;
                            }
                        }
                        if (isSpecialSubEntryIndex) continue;
                        if (isCustomFuncSubEntry) {
                            for (Map.Entry subDataEntry : subDataMap.entrySet()) {
                                List refValueList;
                                Integer parentEntryRowIndex = (Integer)subDataEntry.getKey();
                                List valueList = (List)subDataMap.get(parentEntryRowIndex);
                                List list = refValueList = isUser ? (List)subRefValueMap.get(parentEntryRowIndex) : null;
                                if (CollectionUtils.isNotEmpty((Collection)valueList)) {
                                    for (int j = 0; j < valueList.size(); ++j) {
                                        String content4;
                                        Object itemValue = valueList.get(j);
                                        Object formatValue = ExecutorHelper.tryToString(billObj, billObj, itemValue, entityProperty);
                                        String string = content4 = formatValue == null ? " " : formatValue.toString();
                                        if (isUser) {
                                            Object userId = null;
                                            if (CollectionUtils.isNotEmpty((Collection)refValueList) && j < refValueList.size()) {
                                                userId = refValueList.get(j);
                                            }
                                            valueHoverContentList.add(HoverContent.createChat((String)content4, userId));
                                            continue;
                                        }
                                        valueHoverContentList.add(HoverContent.createText((String)content4));
                                    }
                                    continue;
                                }
                                valueHoverContentList.add(HoverContent.createText((String)" "));
                            }
                            continue;
                        }
                        throw new KDBizException(ResManager.loadKDString((String)"\u60ac\u505c\u5b50\u5206\u5f55\u5b57\u6bb5\u8d85\u8fc7\u89c4\u5219\u5141\u8bb8\u8303\u56f4\u3002", (String)"LinkUpBillDecisionExecutor_17", (String)"data-idi-core", (Object[])new Object[0]));
                    }
                    Object formatValue = ExecutorHelper.tryToString(billObj, billObj, value, entityProperty);
                    String string = content = formatValue == null ? " " : formatValue.toString();
                    HoverContent valueHoverContent = isBillNo ? HoverContent.createHref((String)content, (DynamicObject)billObj) : (isUser ? HoverContent.createChat((String)content, (Object)refValue) : HoverContent.createText((String)content));
                    valueHoverContentList.add(valueHoverContent);
                }
                for (HoverContent hc : valueHoverContentList) {
                    if (HoverContent.ContentType.HREF != hc.getType() || !this.decision.isCrossTenant()) continue;
                    hc.setType(HoverContent.ContentType.TEXT);
                }
                maxLine = Math.max(maxLine, valueHoverContentList.size());
                Tuple colTuple = new Tuple((Object)titleHoverContent, valueHoverContentList);
                tableMap.put(curColIndex, (Tuple<HoverContent, List<HoverContent>>)colTuple);
                ++curColIndex;
            }
        } else if (!isIncludeFunc) {
            return null;
        }
        maxLine = Math.min(maxLine, 25);
        int colSize = tableMap.size();
        if (isIncludeFunc || maxLine > 1) {
            HoverContent[] hoverContentArray = (HoverContent[])tableMap.values().stream().map(tuple -> (HoverContent)tuple.item1).toArray(HoverContent[]::new);
            frontEndResult.addHoverContent(hoverContentArray);
            this.processFuncValueAlignLinkObj(targetFunValueColIndex, tableMap, targetSumColIndexList, maxLine, linkStartIndexMap, srcSumColIndexList);
            for (int rowIndex = 0; rowIndex < maxLine; ++rowIndex) {
                HoverContent[] valueHoverContents = new HoverContent[colSize];
                for (int columnIndex = 0; columnIndex < colSize; ++columnIndex) {
                    Tuple tupleContent = (Tuple)tableMap.get(columnIndex);
                    List valueHoverContent = (List)tupleContent.item2;
                    valueHoverContents[columnIndex] = rowIndex < valueHoverContent.size() ? (HoverContent)valueHoverContent.get(rowIndex) : HoverContent.createText((String)" ");
                }
                frontEndResult.addHoverContent(valueHoverContents);
            }
            frontEndResult.setTableStyle(true);
        } else {
            void var12_18;
            boolean bl = false;
            while (var12_18 < colSize) {
                Tuple tupleContent = (Tuple)tableMap.get((int)var12_18);
                frontEndResult.addHoverContent((HoverContent)tupleContent.item1, ((List)tupleContent.item2).isEmpty() ? HoverContent.createTitle((String)" ") : (HoverContent)((List)tupleContent.item2).get(0));
                ++var12_18;
            }
        }
        return frontEndResult;
    }

    public static DecisionFrontEndResult buildNoMatch(Set<String> notMatchData, String noMatchName) {
        DecisionFrontEndResult frontEndResult = new DecisionFrontEndResult();
        ArrayList<HoverContent> hoverContents = new ArrayList<HoverContent>(10);
        for (String notMatchDatum : notMatchData) {
            hoverContents.add(HoverContent.createText((String)notMatchDatum));
        }
        frontEndResult.setTableStyle(true);
        HashMap<Integer, Tuple> tableMap = new HashMap<Integer, Tuple>();
        tableMap.put(0, new Tuple((Object)HoverContent.createTitle((String)noMatchName), hoverContents));
        int maxLine = Math.min(hoverContents.size(), 25);
        int colSize = tableMap.size();
        HoverContent[] titleHoverContents = (HoverContent[])tableMap.values().stream().map(tuple -> (HoverContent)tuple.item1).toArray(HoverContent[]::new);
        frontEndResult.addHoverContent(titleHoverContents);
        for (int rowIndex = 0; rowIndex < maxLine; ++rowIndex) {
            HoverContent[] valueHoverContents = new HoverContent[colSize];
            for (int columnIndex = 0; columnIndex < colSize; ++columnIndex) {
                Tuple tupleContent = (Tuple)tableMap.get(columnIndex);
                List valueHoverContent = (List)tupleContent.item2;
                valueHoverContents[columnIndex] = rowIndex < valueHoverContent.size() ? (HoverContent)valueHoverContent.get(rowIndex) : HoverContent.createText((String)" ");
            }
            frontEndResult.addHoverContent(valueHoverContents);
        }
        return frontEndResult;
    }

    private Pair<Boolean, List<HoverContent>> getHoverContentFromCrossEntryRule(EntryRowRelationDTO relationDTO, String fullFieldName) {
        String entry;
        Map subParentEntryMap = relationDTO.getSubParentEntryMap();
        Map entryCollectionMap = relationDTO.getEntryCollectionMap();
        LinkedHashMap entryIdMap = relationDTO.getEntryIdMap();
        String[] split = fullFieldName.split("\\.");
        String subEntryName = null;
        String entryName = null;
        for (int i = 0; i < split.length; ++i) {
            if (subParentEntryMap.get(split[i]) != null) {
                subEntryName = split[i];
                entryName = null;
                break;
            }
            if (!entryCollectionMap.containsKey(split[i])) continue;
            entryName = split[i];
        }
        String string = entry = StringUtils.isNotEmpty(subEntryName) ? subEntryName : entryName;
        if (entry != null && StringUtils.isNotEmpty(entry)) {
            ArrayList dataList = new ArrayList();
            String detailFieldName = fullFieldName.substring(fullFieldName.indexOf(entry) + entry.length() + 1);
            if (relationDTO.isTrueSubEntry()) {
                if (StringUtils.isNotEmpty((String)subEntryName)) {
                    Map subEntryDataMap = relationDTO.getTrueSubEntryCollectionMap();
                    entryIdMap.forEach((entryIndex, subIndexSet) -> {
                        DynamicObjectCollection subEntryData = (DynamicObjectCollection)subEntryDataMap.get(entryIndex);
                        if (CollectionUtils.isNotEmpty((Collection)subIndexSet)) {
                            for (Integer subEntryIndex : subIndexSet) {
                                DynamicObjectType subEntityType;
                                DynamicObject subEntryRow = (DynamicObject)subEntryData.get(subEntryIndex.intValue());
                                ExecutorHelper.ValueAndName fieldValue = ExecutorHelper.getValueAndNameByName(subEntryRow, subEntityType = subEntryRow.getDynamicObjectType(), detailFieldName, true, true);
                                String itemValue = (String)fieldValue.getValue();
                                String value = itemValue == null ? " " : itemValue;
                                Object refValue = fieldValue.getRefValue();
                                HoverContent valueHoverContent = fieldValue.isUser() ? HoverContent.createChat((String)value, (Object)refValue) : HoverContent.createText((String)value);
                                dataList.add(valueHoverContent);
                            }
                        }
                    });
                } else {
                    DynamicObjectCollection entryData = (DynamicObjectCollection)entryCollectionMap.get(entry);
                    entryIdMap.forEach((entryIndex, subIndexSet) -> {
                        DynamicObjectType entityType;
                        DynamicObject entryRow = (DynamicObject)entryData.get(entryIndex.intValue());
                        ExecutorHelper.ValueAndName fieldValue = ExecutorHelper.getValueAndNameByName(entryRow, entityType = entryRow.getDynamicObjectType(), detailFieldName, true, true);
                        String itemValue = (String)fieldValue.getValue();
                        String value = itemValue == null ? " " : itemValue;
                        Object refValue = fieldValue.getRefValue();
                        HoverContent valueHoverContent = fieldValue.isUser() ? HoverContent.createChat((String)value, (Object)refValue) : HoverContent.createText((String)value);
                        dataList.add(valueHoverContent);
                    });
                }
            } else {
                DynamicObjectCollection entryData = (DynamicObjectCollection)entryCollectionMap.get(entry);
                if (entry.equals(relationDTO.getEntryFlag())) {
                    entryIdMap.forEach((entryIndex, targetIndexSet) -> {
                        DynamicObject entryRow = (DynamicObject)entryData.get(entryIndex.intValue());
                        DynamicObjectType entityType = entryRow.getDynamicObjectType();
                        ExecutorHelper.ValueAndName fieldValue = ExecutorHelper.getValueAndNameByName(entryRow, entityType, detailFieldName, true, true);
                        Object refValue = fieldValue.getRefValue();
                        Object valueType = fieldValue.getValue();
                        if (valueType instanceof List) {
                            List valueList = (List)valueType;
                            List refValueList = (List)refValue;
                            int i = 0;
                            for (String itemValue : valueList) {
                                String value = itemValue == null ? " " : itemValue;
                                HoverContent valueHoverContent = fieldValue.isUser() ? HoverContent.createChat((String)value, refValueList.get(i)) : HoverContent.createText((String)value);
                                dataList.add(valueHoverContent);
                                ++i;
                            }
                        } else {
                            String itemValue = (String)valueType;
                            String value = itemValue == null ? " " : itemValue;
                            HoverContent valueHoverContent = fieldValue.isUser() ? HoverContent.createChat((String)value, (Object)refValue) : HoverContent.createText((String)value);
                            dataList.add(valueHoverContent);
                        }
                    });
                } else {
                    entryIdMap.forEach((entryIndex, targetIndexSet) -> {
                        if (CollectionUtils.isNotEmpty((Collection)targetIndexSet)) {
                            for (Integer targetEntryIndex : targetIndexSet) {
                                DynamicObject targetEntryRow = (DynamicObject)entryData.get(targetEntryIndex.intValue());
                                DynamicObjectType targetEntityType = targetEntryRow.getDynamicObjectType();
                                ExecutorHelper.ValueAndName fieldValue = ExecutorHelper.getValueAndNameByName(targetEntryRow, targetEntityType, detailFieldName, true, true);
                                Object refValue = fieldValue.getRefValue();
                                Object valueType = fieldValue.getValue();
                                if (valueType instanceof List) {
                                    List valueList = (List)valueType;
                                    List refValueList = (List)refValue;
                                    int i = 0;
                                    for (String itemValue : valueList) {
                                        String value = itemValue == null ? " " : itemValue;
                                        HoverContent valueHoverContent = fieldValue.isUser() ? HoverContent.createChat((String)value, refValueList.get(i)) : HoverContent.createText((String)value);
                                        dataList.add(valueHoverContent);
                                        ++i;
                                    }
                                    continue;
                                }
                                String itemValue = (String)valueType;
                                String value = itemValue == null ? " " : itemValue;
                                HoverContent valueHoverContent = fieldValue.isUser() ? HoverContent.createChat((String)value, (Object)refValue) : HoverContent.createText((String)value);
                                dataList.add(valueHoverContent);
                            }
                        }
                    });
                }
            }
            return new Pair((Object)false, dataList);
        }
        return new Pair((Object)true, null);
    }

    private void processFuncValueAlignLinkObj(int targetFunValueColIndex, Map<Integer, Tuple<HoverContent, List<HoverContent>>> tableMap, List<Integer> targetSumColIndexList, int maxLine, Map<String, List<Integer>> linkStartIndexMap, List<Integer> srcSumColIndexList) {
        Tuple<HoverContent, List<HoverContent>> funcTupleContent;
        if (targetFunValueColIndex >= 0 && (funcTupleContent = tableMap.get(targetFunValueColIndex)) != null) {
            if (CollectionUtils.isNotEmpty(targetSumColIndexList)) {
                for (Integer targetColIndex : targetSumColIndexList) {
                    Tuple<HoverContent, List<HoverContent>> targetFuncTupleContent = tableMap.get(targetColIndex);
                    List oldTargetFuncValueList = (List)targetFuncTupleContent.item2;
                    ArrayList<HoverContent> newTargetFuncValueList = new ArrayList<HoverContent>(maxLine);
                    if (linkStartIndexMap.isEmpty()) {
                        for (HoverContent hoverContent : oldTargetFuncValueList) {
                            newTargetFuncValueList.add(HoverContent.createText((String)hoverContent.getContent()));
                            tableMap.put(targetColIndex, (Tuple<HoverContent, List<HoverContent>>)new Tuple(targetFuncTupleContent.item1, newTargetFuncValueList));
                        }
                        continue;
                    }
                    for (int i = 0; i < maxLine; ++i) {
                        newTargetFuncValueList.add(HoverContent.createText((String)" "));
                    }
                    for (HoverContent hoverContent : oldTargetFuncValueList) {
                        String targetBillId;
                        List<Integer> linkIndexList;
                        if (hoverContent.getType() != HoverContent.ContentType.HREF || hoverContent.getData() == null || hoverContent.getData().isEmpty() || CollectionUtils.isEmpty(linkIndexList = linkStartIndexMap.get(targetBillId = (String)hoverContent.getData().get("billId")))) continue;
                        for (Integer linkIndex : linkIndexList) {
                            if (linkIndex == null || linkIndex >= maxLine) continue;
                            newTargetFuncValueList.set(linkIndex, HoverContent.createText((String)hoverContent.getContent()));
                        }
                    }
                    tableMap.put(targetColIndex, (Tuple<HoverContent, List<HoverContent>>)new Tuple(targetFuncTupleContent.item1, newTargetFuncValueList));
                }
            }
            if (CollectionUtils.isNotEmpty(srcSumColIndexList) && !linkStartIndexMap.isEmpty()) {
                for (Integer sumColIndex : srcSumColIndexList) {
                    Tuple<HoverContent, List<HoverContent>> srcFuncTupleContent = tableMap.get(sumColIndex);
                    List oldSrcFuncValueList = (List)srcFuncTupleContent.item2;
                    HoverContent template = (HoverContent)oldSrcFuncValueList.get(0);
                    ArrayList<HoverContent> newSrcFuncValueList = new ArrayList<HoverContent>(maxLine);
                    HashSet<Integer> formatIndexSet = new HashSet<Integer>(10);
                    for (List<Integer> valueIndexList : linkStartIndexMap.values()) {
                        formatIndexSet.addAll(valueIndexList);
                    }
                    for (int i = 0; i < maxLine; ++i) {
                        if (formatIndexSet.contains(i)) {
                            newSrcFuncValueList.add(template);
                            continue;
                        }
                        newSrcFuncValueList.add(HoverContent.createText((String)" "));
                    }
                    tableMap.put(sumColIndex, (Tuple<HoverContent, List<HoverContent>>)new Tuple(srcFuncTupleContent.item1, newSrcFuncValueList));
                }
            }
        }
    }

    public boolean isOnlyFunc() {
        return this.onlyFunc;
    }

    public void setOnlyFunc(boolean onlyFunc) {
        this.onlyFunc = onlyFunc;
    }

    public MainEntityType getSrcEntityType() {
        return this.srcEntityType;
    }

    public void setSrcEntityType(MainEntityType srcEntityType) {
        this.srcEntityType = srcEntityType;
    }

    public MainEntityType getTargetEntityType() {
        return this.targetEntityType;
    }

    public void setTargetEntityType(MainEntityType targetEntityType) {
        this.targetEntityType = targetEntityType;
    }
}

