/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.front;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.data.idi.data.basedata.StandardBaseDataConfig;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.util.IDIJSONUtils;

public class NumberIdMapping {
    private Map<Object, String> oldIdToNumberMap;
    private Map<Object, String> newIdToNumberMap;
    private Map<String, Object> numberToOldIdMap;
    private Map<String, Object> numberToNewIdMap;

    public static NumberIdMapping createMapping(StandardBaseDataConfig[] standardBaseDataConfigs, String entityType) {
        NumberIdMapping numberIdMapping = new NumberIdMapping();
        if (standardBaseDataConfigs != null && standardBaseDataConfigs.length > 0) {
            HashMap<Object, String> oldIdToNumberMap = new HashMap<Object, String>(standardBaseDataConfigs.length * 2);
            HashMap<String, Object> numberToOldIdMap = new HashMap<String, Object>(standardBaseDataConfigs.length * 2);
            for (StandardBaseDataConfig standardBaseDataConfig : standardBaseDataConfigs) {
                numberToOldIdMap.put(standardBaseDataConfig.getNumber(), standardBaseDataConfig.getId());
                oldIdToNumberMap.put(standardBaseDataConfig.getId(), standardBaseDataConfig.getNumber());
            }
            Map<String, Object> numberToNewIdMap = StandardBaseDataConfig.loadBaseDataMap(entityType, standardBaseDataConfigs);
            HashMap<Object, String> newIdToNumberMap = new HashMap<Object, String>(standardBaseDataConfigs.length * 2);
            numberToNewIdMap.forEach((number, newId) -> newIdToNumberMap.put(newId, (String)number));
            numberIdMapping.setNewIdToNumberMap(newIdToNumberMap);
            numberIdMapping.setNumberToNewIdMap(numberToNewIdMap);
            numberIdMapping.setOldIdToNumberMap(oldIdToNumberMap);
            numberIdMapping.setNumberToOldIdMap(numberToOldIdMap);
            if (numberToOldIdMap.size() != numberToNewIdMap.size()) {
                SchemaExecutorLogger.info((String)("numberToOldIdMap:" + IDIJSONUtils.toJsonString(numberToOldIdMap)), (Object[])new Object[0]);
                SchemaExecutorLogger.info((String)("numberToNewIdMap:" + IDIJSONUtils.toJsonString(numberToNewIdMap)), (Object[])new Object[0]);
                throw new KDBizException(ResManager.loadKDString((String)"\u9644\u4ef6\u6a21\u677f\u4e3a\u7a7a\u6216\u88ab\u5220\u9664", (String)"AIAttachmentExecutor_4", (String)"data-idi-core", (Object[])new Object[0]));
            }
        }
        return numberIdMapping;
    }

    public Object getOldIdByNumber(String number) {
        return this.numberToOldIdMap.get(number);
    }

    public Object getNewIdByNumber(String number) {
        return this.numberToNewIdMap.get(number);
    }

    public String getNumberByOldId(Object oldId) {
        return this.oldIdToNumberMap.get(oldId);
    }

    public String getNumberByNewId(Object newId) {
        return this.newIdToNumberMap.get(newId);
    }

    protected Map<Object, String> getOldIdToNumberMap() {
        return this.oldIdToNumberMap;
    }

    protected void setOldIdToNumberMap(Map<Object, String> oldIdToNumberMap) {
        this.oldIdToNumberMap = oldIdToNumberMap;
    }

    public Map<Object, String> getNewIdToNumberMap() {
        return this.newIdToNumberMap;
    }

    protected void setNewIdToNumberMap(Map<Object, String> newIdToNumberMap) {
        this.newIdToNumberMap = newIdToNumberMap;
    }

    protected Map<String, Object> getNumberToOldIdMap() {
        return this.numberToOldIdMap;
    }

    protected void setNumberToOldIdMap(Map<String, Object> numberToOldIdMap) {
        this.numberToOldIdMap = numberToOldIdMap;
    }

    protected Map<String, Object> getNumberToNewIdMap() {
        return this.numberToNewIdMap;
    }

    protected void setNumberToNewIdMap(Map<String, Object> numberToNewIdMap) {
        this.numberToNewIdMap = numberToNewIdMap;
    }
}

