/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.engine.functions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.ScriptUtils;
import kd.data.idi.engine.customrule.EntryRowRelationDTO;
import kd.data.idi.engine.functions.CustomFuncEnum;
import kd.data.idi.engine.functions.CustomFuncInfoChain;
import kd.data.idi.engine.functions.CustomFuncSpecialDeal;
import kd.data.idi.util.MetadataUtil;

public class ExactFunc {
    public static void dealFunc(CustomFuncInfoChain customFuncChain, DynamicObject srcObj, List<DynamicObject> targetObjList, String startConditionEntry, List<Integer> matchStartConditionEntryIndexList, EntryRowRelationDTO entryRowIndexRelationDto, MainEntityType targetMainType) {
        String regex = CustomFuncEnum.EXACT.getFuncName();
        String script = customFuncChain.getDealScript();
        Map<String, Object> funcValueMap = customFuncChain.getFuncValueMap();
        Map<String, Object> intactFuncValueMap = customFuncChain.getIntactFuncValueMap();
        Set<String> entrySet = customFuncChain.getEntrySet();
        String srcEntity = srcObj.getDataEntityType().getName();
        MainEntityType srcMainType = null;
        String targetEntity = CollectionUtils.isEmpty(targetObjList) ? null : targetObjList.get(0).getDataEntityType().getName();
        String[] extractCustomAns = new String[4];
        extractCustomAns[3] = "0";
        while (extractCustomAns[3] != null && (extractCustomAns = ScriptUtils.extractCustomFunc(script, regex, Integer.parseInt(extractCustomAns[3])))[1] != null) {
            srcMainType = srcMainType == null ? EntityMetadataCache.getDataEntityType((String)srcEntity) : srcMainType;
            String beforeSpecialDealScript = extractCustomAns[1];
            String funcStr = CustomFuncSpecialDeal.specialDeal((String)beforeSpecialDealScript.replace(" ", ""));
            String funcInnerStr = funcStr.substring(0, funcStr.length() - 1).replace(regex + "(", "");
            String[] split = funcInnerStr.split(",");
            if (split.length != 2) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5728exact\u51fd\u6570\u4e2d\u914d\u7f6e\u4e24\u4e2a\u53c2\u6570\u3002", (String)"ExactFunc_0", (String)"data-idi-core", (Object[])new Object[0]));
            }
            String modelType = split[1].trim();
            String field = split[0].trim();
            String billEntity = funcInnerStr.substring(0, funcInnerStr.indexOf("_billObj"));
            boolean isSourceBill = billEntity.equals(srcEntity);
            ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(10);
            if (isSourceBill) {
                entrySet.addAll(ScriptUtils.getEntries(srcMainType, funcStr, new String[]{srcEntity}));
                billList.add(srcObj);
            } else {
                if (targetMainType == null) continue;
                entrySet.addAll(ScriptUtils.getEntries(targetMainType, funcInnerStr.startsWith("targetisself_") ? funcInnerStr.replace("targetisself_", "") : funcInnerStr, new String[]{targetEntity}));
                billList.addAll(targetObjList);
            }
            MainEntityType billMainType = isSourceBill ? srcMainType : targetMainType;
            Map<String, String> entryInfoMap = MetadataUtil.getEntryMapByScriptStr(billMainType, field);
            String tempStartConditionEntry = isSourceBill ? startConditionEntry : null;
            List<Integer> tempMatchStartConditionEntryIndexList = isSourceBill ? matchStartConditionEntryIndexList : null;
            boolean same = false;
            switch (modelType) {
                case "0": {
                    same = ExactFunc.allBillCal(entryInfoMap, billList, tempStartConditionEntry, tempMatchStartConditionEntryIndexList, entryRowIndexRelationDto);
                    break;
                }
                case "1": {
                    same = ExactFunc.groupByBillCal(entryInfoMap, billList, tempStartConditionEntry, tempMatchStartConditionEntryIndexList, entryRowIndexRelationDto);
                    break;
                }
                case "2": {
                    same = ExactFunc.groupByBillEntryCal(entryInfoMap, billList, tempStartConditionEntry, tempMatchStartConditionEntryIndexList, entryRowIndexRelationDto);
                    break;
                }
                default: {
                    throw new KDBizException(ResManager.loadKDString((String)"\u811a\u672c\u6267\u884c\u51fa\u9519\uff0c\u65e0\u6cd5\u6267\u884c\u68c0\u67e5", (String)"ScriptEngine_1", (String)"data-idi-core", (Object[])new Object[0]));
                }
            }
            funcValueMap.put(funcStr, same);
            intactFuncValueMap.put(funcStr, same);
            ScriptUtils.replaceStartIndexAndNewValue(String.valueOf(same), extractCustomAns);
            script = ScriptUtils.assembleArray(extractCustomAns);
        }
        customFuncChain.setDealScript(script);
    }

    private static boolean groupByBillEntryCal(Map<String, String> entryInfoMap, List<DynamicObject> billList, String startConditionEntry, List<Integer> matchStartConditionEntryIndexList, EntryRowRelationDTO entryRowIndexRelationDto) {
        boolean same = true;
        String subEntryKey = entryInfoMap.get("subEntryKey");
        if (StringUtils.isNotEmpty((String)subEntryKey)) {
            if (CollectionUtils.isNotEmpty(billList)) {
                for (DynamicObject billObj : billList) {
                    Map<Integer, List<Object>> valueMap = MetadataUtil.getFieldValueMap(billObj, entryInfoMap, startConditionEntry, matchStartConditionEntryIndexList, entryRowIndexRelationDto);
                    if (valueMap.isEmpty()) {
                        same = same;
                        continue;
                    }
                    Set<Map.Entry<Integer, List<Object>>> entrySet = valueMap.entrySet();
                    for (Map.Entry<Integer, List<Object>> integerListEntry : entrySet) {
                        List<Object> subValueList = integerListEntry.getValue();
                        HashSet<Object> subValueSet = new HashSet<Object>(subValueList.size());
                        subValueSet.addAll(subValueList);
                        boolean subSame = subValueSet.isEmpty() || subValueSet.size() == 1;
                        same = same && subSame;
                    }
                }
            }
        } else {
            same = ExactFunc.groupByBillCal(entryInfoMap, billList, startConditionEntry, matchStartConditionEntryIndexList, entryRowIndexRelationDto);
        }
        return same;
    }

    private static boolean groupByBillCal(Map<String, String> entryInfoMap, List<DynamicObject> billList, String startConditionEntry, List<Integer> matchStartConditionEntryIndexList, EntryRowRelationDTO entryRowIndexRelationDto) {
        boolean same = true;
        if (CollectionUtils.isNotEmpty(billList)) {
            for (DynamicObject billObj : billList) {
                HashSet<Object> valueSet = new HashSet<Object>(2);
                List<Object> valueList = MetadataUtil.getFieldValueList(billObj, entryInfoMap, startConditionEntry, matchStartConditionEntryIndexList, entryRowIndexRelationDto);
                valueSet.addAll(valueList);
                boolean subSame = valueSet.isEmpty() || valueSet.size() == 1;
                same = same && subSame;
            }
        }
        return same;
    }

    private static boolean allBillCal(Map<String, String> entryInfoMap, List<DynamicObject> billList, String startConditionEntry, List<Integer> matchStartConditionEntryIndexList, EntryRowRelationDTO entryRowIndexRelationDto) {
        HashSet<Object> valueSet = new HashSet<Object>(2);
        if (CollectionUtils.isNotEmpty(billList)) {
            for (DynamicObject billObj : billList) {
                List<Object> valueList = MetadataUtil.getFieldValueList(billObj, entryInfoMap, startConditionEntry, matchStartConditionEntryIndexList, entryRowIndexRelationDto);
                valueSet.addAll(valueList);
            }
        }
        return valueSet.isEmpty() || valueSet.size() == 1;
    }
}

