/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.basedata.StandardBaseDataConfig;
import kd.data.idi.engine.SchemaExecutorLogger;
import kd.data.idi.engine.attachment.AITemplate;
import kd.data.idi.engine.attachment.AttachmentField;
import kd.data.idi.util.IDIStringUtils;

public class AttachmentFieldHelper {
    public static String genFieldNumber(String displayName, Long templateId) {
        String pre = Integer.toHexString(displayName.hashCode());
        String fix = Long.toHexString(templateId);
        return 'f' + pre + fix;
    }

    public static String genTableNumber(String displayName, Long templateId) {
        String pre = Integer.toHexString(displayName.hashCode());
        String fix = Long.toHexString(templateId);
        return 't' + pre + fix;
    }

    public static boolean processField(List<AttachmentField> fieldList, AITemplate template) {
        Map<String, AttachmentField> fieldSet = fieldList.stream().collect(Collectors.toMap(field -> field.getFullDisplayName(), field -> field));
        QFilter templateFilter = new QFilter("aitemplate", "=", (Object)template.getId());
        HashSet<Long> deleteFieldIdSet = new HashSet<Long>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AIAttachmentServiceImpl.queryPresetField", (String)"idi_attachmentfield", (String)"id,number,name,aitemplate", (QFilter[])new QFilter[]{templateFilter}, null);){
            if (dataSet != null) {
                for (Row row : dataSet) {
                    String storageField = row.getString("name");
                    if (fieldSet.containsKey(storageField)) {
                        AttachmentField attachmentField = fieldSet.get(storageField);
                        attachmentField.setName(row.getString("number"));
                        continue;
                    }
                    deleteFieldIdSet.add(row.getLong("id"));
                }
            }
        }
        List<AttachmentField> newFieldList = fieldList.stream().filter(field -> field.getName().equals(field.getDisplayName())).collect(Collectors.toList());
        Set<String> repeatSet = fieldList.stream().filter(field -> !field.getName().equals(field.getDisplayName())).map(AttachmentField::getName).collect(Collectors.toSet());
        AttachmentFieldHelper.insertFieldAI(newFieldList, template, repeatSet);
        if (!deleteFieldIdSet.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"idi_attachmentfield"), (Object[])deleteFieldIdSet.toArray());
            return true;
        }
        return false;
    }

    public static void insertFieldAI(List<AttachmentField> fieldList, AITemplate template, Set<String> repeatSet) {
        if (fieldList == null || fieldList.isEmpty()) {
            return;
        }
        DynamicObject fieldDyn = QueryServiceHelper.queryOne((String)"idi_attachmentfield", (String)"group", (QFilter[])new QFilter[]{new QFilter("aitemplate", "=", (Object)template.getId())});
        try (TXHandle txHandle = TX.required((String)String.valueOf(template.getId()));){
            try {
                Object groupId;
                if (fieldDyn == null) {
                    DynamicObject root = QueryServiceHelper.queryOne((String)"idi_fieldgroup", (String)"id,number,name,isleaf,level", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"ai")});
                    if (root == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11\u89c6\u89c9\u8bc6\u522b\u670d\u52a1\u5206\u7ec4", (String)"AttachmentFieldHelper_0", (String)"data-idi-core", (Object[])new Object[0]));
                    }
                    DynamicObject group = BusinessDataServiceHelper.newDynamicObject((String)"idi_fieldgroup");
                    group.set("number", (Object)template.getNumber());
                    group.set("name", (Object)template.getName());
                    group.set("enable", (Object)"1");
                    group.set("status", (Object)"C");
                    group.set("creator", (Object)RequestContext.get().getCurrUserId());
                    group.set("createtime", (Object)new Date());
                    group.set("parent_id", (Object)root.getLong("id"));
                    group.set("longnumber", (Object)(root.getString("number") + '.' + template.getNumber()));
                    group.set("fullname", (Object)(root.getString("name") + '.' + template.getName()));
                    group.set("level", (Object)(root.getInt("level") + 1));
                    group.set("isleaf", (Object)true);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{group});
                    groupId = group.getPkValue();
                } else {
                    groupId = fieldDyn.getLong("group");
                }
                DynamicObject[] fields = new DynamicObject[fieldList.size()];
                int index = 0;
                for (AttachmentField attachmentField : fieldList) {
                    String fieldName;
                    DynamicObject fieldObj = BusinessDataServiceHelper.newDynamicObject((String)"idi_attachmentfield");
                    String string = fieldName = attachmentField.isTable() ? AttachmentFieldHelper.genTableNumber(attachmentField.getFullDisplayName(), template.getId()) : AttachmentFieldHelper.genFieldNumber(attachmentField.getFullDisplayName(), template.getId());
                    if (repeatSet.contains(fieldName)) {
                        fieldName = fieldName + index + repeatSet.size();
                    }
                    repeatSet.add(fieldName);
                    attachmentField.setName(fieldName);
                    fieldObj.set("number", (Object)fieldName);
                    fieldObj.set("name", (Object)attachmentField.getFullDisplayName());
                    fieldObj.set("enable", (Object)"1");
                    fieldObj.set("status", (Object)"C");
                    fieldObj.set("creator", (Object)RequestContext.get().getCurrUserId());
                    fieldObj.set("createtime", (Object)new Date());
                    fieldObj.set("group_id", groupId);
                    fieldObj.set("source", (Object)"0");
                    fieldObj.set("aitemplate_id", (Object)template.getId());
                    fields[index++] = fieldObj;
                }
                SaveServiceHelper.save((DynamicObject[])fields);
            }
            catch (Throwable e) {
                txHandle.markRollback();
                SchemaExecutorLogger.error((Throwable)e);
                throw new KDBizException(e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
        }
    }

    public static List<AttachmentField> queryLcTemplateAndField(Long lcTemplateId) {
        ArrayList<AttachmentField> fieldList = new ArrayList<AttachmentField>(10);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AttachmentFieldHelper.queryLcTemplateAndField", (String)"idi_attachmentfield", (String)"group.id,group.number,group.name,name,number,tablenumber", (QFilter[])new QFilter[]{new QFilter("group.id", "=", (Object)lcTemplateId)}, null);){
            AITemplate template = new AITemplate();
            template.setCustomTemplate(false);
            LinkedHashMap<String, AttachmentField> fieldMap = new LinkedHashMap<String, AttachmentField>(10);
            for (Row row : dataSet) {
                template.setId(row.getLong("group.id"));
                template.setName(row.getString("group.name"));
                template.setNumber(row.getString("group.number"));
                AttachmentField fieldObj = new AttachmentField();
                fieldObj.setTemplate(template);
                fieldObj.setDisplayName(row.getString("name"));
                fieldObj.setName(row.getString("number"));
                String tableNumber = row.getString("tablenumber");
                if (StringUtils.isNotEmpty((String)tableNumber)) {
                    AttachmentField tableField = new AttachmentField();
                    tableField.setTable(true);
                    tableField.setName(tableNumber);
                    fieldObj.setParent(tableField);
                }
                fieldMap.put(fieldObj.getName(), fieldObj);
            }
            for (AttachmentField value : fieldMap.values()) {
                fieldList.add(value);
                AttachmentField tableField = value.getParent();
                if (tableField == null) continue;
                AttachmentField realTableField = (AttachmentField)fieldMap.get(tableField.getName());
                if (realTableField == null) {
                    throw new KDBizException("table field has been delete :" + tableField.getName());
                }
                realTableField.setTable(tableField.isTable());
                value.setParent(realTableField);
            }
        }
        return fieldList;
    }

    public static Map<Long, AITemplate> queryLcTemplateById(Collection<Long> templateIds) {
        if (CollectionUtils.isEmpty(templateIds)) {
            throw new KDBizException("templateId is null");
        }
        DynamicObjectCollection templateObjs = QueryServiceHelper.query((String)"idi_fieldgroup", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", templateIds)});
        HashMap<Long, AITemplate> aiTemplateMap = new HashMap<Long, AITemplate>(templateObjs.size());
        for (DynamicObject templateObj : templateObjs) {
            AITemplate template = new AITemplate();
            Long templateId = templateObj.getLong("id");
            template.setId(templateId);
            template.setNumber(templateObj.getString("number"));
            template.setName(templateObj.getString("name"));
            aiTemplateMap.put(templateId, template);
        }
        return aiTemplateMap;
    }

    public static Map<String, AITemplate> queryGPTTemplateById(StandardBaseDataConfig[] standardBaseDataConfigs) {
        if (standardBaseDataConfigs == null || standardBaseDataConfigs.length <= 0) {
            return null;
        }
        ArrayList<String> numberList = new ArrayList<String>(standardBaseDataConfigs.length);
        for (StandardBaseDataConfig standardBaseDataConfig : standardBaseDataConfigs) {
            numberList.add(standardBaseDataConfig.getNumber());
        }
        HashMap<String, AITemplate> templateMap = new HashMap<String, AITemplate>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)"fgptas_attachtemplate", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "in", numberList)}, null, (int)-1);){
            for (Row row : dataSet) {
                AITemplate aiTemplate = new AITemplate(row.getLong("id"), row.getString("number"), row.getString("name"));
                templateMap.put(aiTemplate.getNumber(), aiTemplate);
            }
        }
        return templateMap;
    }

    public static MainEntityType createAttachmentEntityType(Map<AITemplate, List<AttachmentField>> attachmentFieldClassMap) {
        if (attachmentFieldClassMap == null || attachmentFieldClassMap.isEmpty()) {
            return null;
        }
        boolean mulTemplate = attachmentFieldClassMap.size() > 1;
        QueryEntityType mainEntityType = new QueryEntityType();
        mainEntityType.setName("attachment_virtualentity");
        boolean hasProp = false;
        Set<Map.Entry<AITemplate, List<AttachmentField>>> attachmentFieldClassMapEntry = attachmentFieldClassMap.entrySet();
        for (Map.Entry<AITemplate, List<AttachmentField>> entry : attachmentFieldClassMapEntry) {
            AITemplate aiTemplate = entry.getKey();
            List<AttachmentField> attachmentFieldList = entry.getValue();
            if (CollectionUtils.isEmpty(attachmentFieldList)) continue;
            for (AttachmentField attachmentField : attachmentFieldList) {
                String fieldType = attachmentField.getFieldType();
                String templatePrefix = IDIStringUtils.templatePrefix((String)aiTemplate.getNumber());
                String fieldDisplayName = mulTemplate ? aiTemplate.getName() + "." + attachmentField.getFullDisplayName() : attachmentField.getFullDisplayName();
                String name = templatePrefix + attachmentField.getFullName();
                name = name.replaceAll("\\.", "|");
                String alias = 'f' + attachmentField.getName();
                TextProp prop = null;
                switch (fieldType) {
                    case "text": {
                        prop = new TextProp();
                        break;
                    }
                    case "num": 
                    case "amount": {
                        prop = new DecimalProp();
                        break;
                    }
                    case "time": {
                        prop = new TimeProp();
                        break;
                    }
                    case "short_date": {
                        prop = new DateProp();
                        break;
                    }
                    case "long_date": {
                        prop = new DateTimeProp();
                    }
                }
                if (prop == null) continue;
                hasProp = true;
                prop.setDisplayName(new LocaleString(fieldDisplayName));
                prop.setAlias(alias);
                prop.setName(name);
                mainEntityType.registerSimpleProperty((DynamicSimpleProperty)prop);
            }
        }
        return hasProp ? mainEntityType : null;
    }
}

