/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.data.idi.data.Area;
import kd.data.idi.data.Decision;
import kd.data.idi.data.MatchType;
import kd.data.idi.data.Schema;
import kd.data.idi.data.attachment.AIAttachmentConfig;
import kd.data.idi.data.attachment.RuleRepo;
import kd.data.idi.data.basedata.StandardBaseDataConfig;

public class FGPTASRefrenceHelper {
    public static List<DynamicObject> createRefrence(Long schemaId, Schema schemaData) {
        if (schemaData == null) {
            return null;
        }
        List<Area> areaList = schemaData.getArea();
        if (CollectionUtils.isEmpty(areaList)) {
            return null;
        }
        HashMap<String, StandardBaseDataConfig[]> itemToTemplateMap = new HashMap<String, StandardBaseDataConfig[]>(10);
        ArrayList<StandardBaseDataConfig> templateList = new ArrayList<StandardBaseDataConfig>(10);
        HashMap<String, StandardBaseDataConfig> itemToRuleRepoMap = new HashMap<String, StandardBaseDataConfig>(10);
        for (Area area : areaList) {
            List<Decision> decisionList = area.getDecision();
            if (CollectionUtils.isEmpty(decisionList)) continue;
            for (Decision decision : decisionList) {
                String matchType = decision.getMatchType();
                if (!MatchType.AIATTACHMENT.getType().equalsIgnoreCase(matchType)) continue;
                AIAttachmentConfig aiAttachmentConfig = decision.getAiAttachmentConfig();
                if (aiAttachmentConfig.isEnableRuleBase()) {
                    List<RuleRepo> ruleRepoList1 = aiAttachmentConfig.getRuleRepoList();
                    if (!CollectionUtils.isNotEmpty(ruleRepoList1)) continue;
                    for (RuleRepo ruleRepo2 : ruleRepoList1) {
                        StandardBaseDataConfig ruleRepo1 = ruleRepo2.getRuleRepo();
                        itemToRuleRepoMap.put(decision.getPk(), ruleRepo1);
                    }
                    continue;
                }
                StandardBaseDataConfig[] templates = aiAttachmentConfig.getFgptasTemplate();
                if (templates == null || templates.length <= 0) continue;
                itemToTemplateMap.put(decision.getPk(), templates);
                templateList.addAll(Arrays.asList(templates));
            }
        }
        ArrayList<DynamicObject> refList = new ArrayList<DynamicObject>(10);
        if (CollectionUtils.isNotEmpty(templateList)) {
            StandardBaseDataConfig[] templates = templateList.toArray(new StandardBaseDataConfig[0]);
            Map<String, Object> templateNumberMap = StandardBaseDataConfig.loadBaseDataMap("fgptas_attachtemplate", templates);
            itemToTemplateMap.forEach((itemId, templateDatas) -> {
                for (StandardBaseDataConfig templateData : templateDatas) {
                    Object templateId = templateNumberMap.get(templateData.getNumber());
                    if (templateId == null) continue;
                    DynamicObject refIbj = BusinessDataServiceHelper.newDynamicObject((String)"idi_fgptastemplatrefrence");
                    refIbj.set("schemaid", (Object)schemaId);
                    refIbj.set("itemid", itemId);
                    refIbj.set("fgptasattachtemplateid", templateId);
                    refIbj.set("createdate", (Object)new Date());
                    refIbj.set("handletype", (Object)"fgptas_attachtemplate");
                    refList.add(refIbj);
                }
            });
        }
        if (!itemToRuleRepoMap.isEmpty()) {
            StandardBaseDataConfig[] ruleRepos = itemToRuleRepoMap.values().toArray(new StandardBaseDataConfig[0]);
            Map<String, Object> ruleRepoNumberMap = StandardBaseDataConfig.loadBaseDataMap("fgptas_rule_repo", ruleRepos);
            itemToRuleRepoMap.forEach((itemId, ruleRepo) -> {
                Object ruleRepoId = ruleRepoNumberMap.get(ruleRepo.getNumber());
                if (ruleRepoId != null) {
                    DynamicObject refIbj = BusinessDataServiceHelper.newDynamicObject((String)"idi_fgptastemplatrefrence");
                    refIbj.set("schemaid", (Object)schemaId);
                    refIbj.set("itemid", itemId);
                    refIbj.set("fgptasattachtemplateid", ruleRepoId);
                    refIbj.set("createdate", (Object)new Date());
                    refIbj.set("handletype", (Object)"fgptas_rule_repo");
                    refList.add(refIbj);
                }
            });
        }
        return refList;
    }

    public static int deleteRefrence(Collection<Long> schemaIds) {
        if (CollectionUtils.isEmpty(schemaIds)) {
            return 0;
        }
        return DeleteServiceHelper.delete((String)"idi_fgptastemplatrefrence", (QFilter[])new QFilter[]{new QFilter("schemaid", "in", schemaIds)});
    }

    public static Map<Long, Boolean> existsRefrence(Collection<Long> templateId) {
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(10);
        if (CollectionUtils.isNotEmpty(templateId)) {
            for (Long aLong : templateId) {
                map.put(aLong, Boolean.FALSE);
            }
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"existsRefrence", (String)"idi_fgptastemplatrefrence", (String)"fgptasattachtemplateid", (QFilter[])new QFilter[]{new QFilter("fgptasattachtemplateid", "in", templateId), new QFilter("handletype", "=", (Object)"fgptas_attachtemplate")}, null).distinct();){
                for (Row row : dataSet) {
                    map.put(row.getLong("fgptasattachtemplateid"), Boolean.TRUE);
                }
            }
        }
        return map;
    }

    public static Map<Long, Boolean> existsRuleRepoRefrence(Collection<Long> ruleRepoId) {
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(10);
        if (CollectionUtils.isNotEmpty(ruleRepoId)) {
            for (Long aLong : ruleRepoId) {
                map.put(aLong, Boolean.FALSE);
            }
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"existsRuleRepoRefrence", (String)"idi_fgptastemplatrefrence", (String)"fgptasattachtemplateid", (QFilter[])new QFilter[]{new QFilter("fgptasattachtemplateid", "in", ruleRepoId), new QFilter("handletype", "=", (Object)"fgptas_rule_repo")}, null).distinct();){
                for (Row row : dataSet) {
                    map.put(row.getLong("fgptasattachtemplateid"), Boolean.TRUE);
                }
            }
        }
        return map;
    }
}

