/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.data.idi.engine.ExecutorHelper;
import kd.data.idi.engine.attachment.AITemplate;
import kd.data.idi.engine.attachment.AttachmentField;
import kd.data.idi.util.IDIStringUtils;

public class FieldTreeBuilder {
    public static TreeNode buildBillFieldNode(MainEntityType billEntityType, TreeNode parentNode) {
        TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)billEntityType, (PropTreeBuildOption)new PropTreeBuildOption());
        FieldTreeBuilder.updateTreeNode(parentNode, billTreeNode, billEntityType, "", "");
        return billTreeNode;
    }

    public static TreeNode buildBillFieldNode(MainEntityType billEntityType, TreeNode parentNode, String prefix, String namePrefix) {
        TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)billEntityType, (PropTreeBuildOption)new PropTreeBuildOption());
        FieldTreeBuilder.updateTreeNode(parentNode, billTreeNode, billEntityType, prefix, namePrefix);
        return billTreeNode;
    }

    private static void updateTreeNode(TreeNode parentNode, TreeNode treeNode, MainEntityType billEntityType, String prefix, String namePrefix) {
        if (parentNode != null) {
            parentNode.addChild(treeNode);
        }
        String billNumber = billEntityType.getName();
        String newRootId = prefix + billNumber + "_billObj";
        treeNode.setId(newRootId);
        treeNode.setParentid(parentNode == null ? "" : parentNode.getId());
        String newName = namePrefix + treeNode.getText();
        treeNode.setText(newName);
        if (treeNode.getChildren() == null) {
            return;
        }
        Set<String> mulBaseDataEntitySet = ExecutorHelper.getMulBaseDataEntity(billNumber);
        Map entityTypeMap = billEntityType.getAllEntities();
        for (TreeNode node : treeNode.getChildren()) {
            node.setParentid(treeNode.getId());
            EntityType entityType = (EntityType)entityTypeMap.get(node.getId());
            String newNodeId = entityType instanceof SubEntryType ? treeNode.getId() + "." + entityType.getParent().getName() + "." + node.getId() : treeNode.getId() + "." + node.getId();
            node.setId(newNodeId);
            if (node.getChildren() == null) continue;
            FieldTreeBuilder.updateTreeNodeChild(node, mulBaseDataEntitySet);
        }
    }

    private static void updateTreeNodeChild(TreeNode parentNode, Set<String> mulBaseDataEntitySet) {
        boolean isHeadField = parentNode.getId().endsWith("billhead");
        for (TreeNode node : parentNode.getChildren()) {
            node.setParentid(parentNode.getId());
            String newNodeId = isHeadField ? parentNode.getId().replace("billhead", node.getId()) : (node.getId().indexOf(46) > -1 ? parentNode.getId() + node.getId().substring(node.getId().lastIndexOf(46)) : parentNode.getId() + "." + node.getId());
            if (!mulBaseDataEntitySet.isEmpty()) {
                for (String mulEntityNumber : mulBaseDataEntitySet) {
                    if (!node.getId().equals(mulEntityNumber) || newNodeId.contains(mulEntityNumber + ".fbasedataid")) continue;
                    newNodeId = newNodeId.replace(mulEntityNumber, mulEntityNumber + ".fbasedataid");
                }
            }
            node.setId(newNodeId);
            if (node.getChildren() == null) continue;
            FieldTreeBuilder.updateTreeNodeChild(node, mulBaseDataEntitySet);
        }
    }

    public static List<TreeNode> buildAttachFieldNode(Map<AITemplate, List<AttachmentField>> fieldClassifyMap, TreeNode parentNode, boolean userTemplateNumber) {
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(fieldClassifyMap.size());
        fieldClassifyMap.forEach((templateData, fields) -> {
            String templatePrefix = userTemplateNumber ? IDIStringUtils.templatePrefix((String)templateData.getNumber()) : IDIStringUtils.templatePrefix((Long)templateData.getId());
            TreeNode templateNode = new TreeNode(parentNode == null ? "" : parentNode.getId(), templatePrefix.substring(0, templatePrefix.length() - 1), templateData.getName());
            if (parentNode != null) {
                parentNode.addChild(templateNode);
            }
            treeNodeList.add(templateNode);
            HashMap<AttachmentField, TreeNode> tableNodeMap = new HashMap<AttachmentField, TreeNode>(fields.size());
            for (AttachmentField attachmentField : fields) {
                AttachmentField attachmentFieldParent;
                TreeNode currentNode = (TreeNode)tableNodeMap.get(attachmentField);
                if (currentNode == null) {
                    currentNode = new TreeNode(templateNode.getId(), templatePrefix + attachmentField.getFullName(), attachmentField.getFullDisplayName());
                    if (attachmentField.isTable()) {
                        tableNodeMap.put(attachmentField, currentNode);
                    }
                }
                if ((attachmentFieldParent = attachmentField.getParent()) != null) {
                    TreeNode tableNode = (TreeNode)tableNodeMap.get(attachmentFieldParent);
                    if (tableNode == null) {
                        tableNode = new TreeNode(templateNode.getId(), templatePrefix + attachmentFieldParent.getFullName(), attachmentFieldParent.getFullDisplayName());
                        tableNodeMap.put(attachmentFieldParent, tableNode);
                    }
                    currentNode.setParentid(tableNode.getId());
                    tableNode.addChild(currentNode);
                    continue;
                }
                templateNode.addChild(currentNode);
            }
        });
        return treeNodeList;
    }
}

