/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.engine.customrule.EntryRowRelationDTO;

public class MetadataUtil {
    private MetadataUtil() {
    }

    public static String getDisplayNameByScriptStr(String scriptStr, MainEntityType srcEntityType, MainEntityType targetEntityType) {
        DynamicProperty mulBaseDataProperty;
        Map allEntities;
        EntityType subEntryEntityType;
        DynamicProperty enTryProperty;
        int markIndex;
        String entityStr;
        if (scriptStr == null) {
            return null;
        }
        if (scriptStr.startsWith("targetisself_")) {
            scriptStr = scriptStr.replace("targetisself_", "");
        }
        MainEntityType mainEntityType = (entityStr = scriptStr.substring(0, markIndex = scriptStr.indexOf(46)).replace("_billObj", "")).equals(srcEntityType.getName()) ? srcEntityType : targetEntityType;
        Map<String, String> entryMap = MetadataUtil.getEntryMapByScriptStr(mainEntityType, scriptStr);
        String entryStr = entryMap.get("entryKey");
        String subEntryStr = entryMap.get("subEntryKey");
        String fieldStr = entryMap.get("fieldKey");
        String mulBaseDataStr = entryMap.get("mulBaseDataKey");
        String displayEntryName = null;
        String displaySubEntryName = null;
        String displayMulBaseDataName = null;
        String displayFieldEntryName = null;
        if (StringUtils.isNotEmpty((String)entityStr) && (enTryProperty = mainEntityType.getProperty(entryStr)) != null) {
            displayEntryName = enTryProperty.getDisplayName().toString();
        }
        if (StringUtils.isNotEmpty((String)subEntryStr) && (subEntryEntityType = (EntityType)(allEntities = mainEntityType.getAllEntities()).get(subEntryStr)) != null) {
            displaySubEntryName = subEntryEntityType.getDisplayName().toString();
        }
        if (StringUtils.isNotEmpty((String)mulBaseDataStr) && (mulBaseDataProperty = mainEntityType.getProperty(mulBaseDataStr)) != null) {
            displayMulBaseDataName = mulBaseDataProperty.getDisplayName().toString();
        }
        if (StringUtils.isNotEmpty((String)fieldStr)) {
            Map allFields = mainEntityType.getAllFields();
            IDataEntityProperty fieldProperty = (IDataEntityProperty)allFields.get(fieldStr);
            if (fieldProperty != null) {
                displayFieldEntryName = fieldProperty.getDisplayName().toString();
            } else if ("seq".equals(fieldStr)) {
                displayFieldEntryName = ResManager.loadKDString((String)"\u5206\u5f55\u5e8f\u53f7", (String)"MetadataUtil_0", (String)"data-idi-core", (Object[])new Object[0]);
            }
        }
        List<String> displayNameList = Arrays.asList(displayEntryName, displaySubEntryName, displayMulBaseDataName, displayFieldEntryName);
        return displayNameList.stream().filter(StringUtils::isNotEmpty).collect(Collectors.joining("."));
    }

    public static Map<String, String> getEntryMapByScriptStr(MainEntityType mainEntityType, String scriptStr) {
        if (scriptStr == null || mainEntityType == null) {
            return null;
        }
        HashMap<String, String> entryMap = new HashMap<String, String>(5);
        String entryKey = null;
        String subEntryKey = null;
        String fieldKey = null;
        String mulBaseDataKey = null;
        Map allFields = mainEntityType.getAllFields();
        Map allEntities = mainEntityType.getAllEntities();
        String[] split = scriptStr.split("\\.");
        String baseDataIdFixFlag = "fbasedataid";
        for (String str : split) {
            IDataEntityProperty prop;
            EntityType entityType = (EntityType)allEntities.get(str);
            if (entityType != null) {
                if (entityType instanceof SubEntryType) {
                    subEntryKey = str;
                } else if (entityType instanceof EntryType) {
                    entryKey = str;
                }
            }
            if ("seq".equals(str)) {
                fieldKey = str;
            }
            if ((prop = (IDataEntityProperty)allFields.get(str)) == null) continue;
            if (prop instanceof MulBasedataProp) {
                mulBaseDataKey = str;
                fieldKey = scriptStr.endsWith(baseDataIdFixFlag) ? "id" : scriptStr.substring(scriptStr.indexOf(baseDataIdFixFlag) + baseDataIdFixFlag.length() + 1);
                continue;
            }
            if (subEntryKey != null) {
                fieldKey = scriptStr.substring(scriptStr.indexOf(subEntryKey) + subEntryKey.length() + 1);
                break;
            }
            if (entryKey != null) {
                fieldKey = scriptStr.substring(scriptStr.indexOf(entryKey) + entryKey.length() + 1);
                continue;
            }
            if (str == null || !(prop.getParent() instanceof BillEntityType)) continue;
            fieldKey = scriptStr.substring(scriptStr.indexOf(str));
            break;
        }
        entryMap.put("entryKey", entryKey);
        entryMap.put("subEntryKey", subEntryKey);
        entryMap.put("fieldKey", fieldKey);
        entryMap.put("mulBaseDataKey", mulBaseDataKey);
        return entryMap;
    }

    public static List<Object> getFieldValueList(DynamicObject billDy, Map<String, String> entryMap, String startConditionEntry, Collection<Integer> matchStartConditionEntryIndexList, EntryRowRelationDTO rowRelationDto) {
        boolean needFilterData;
        ArrayList<Object> valueList = new ArrayList<Object>(8);
        if (billDy == null || entryMap == null) {
            return valueList;
        }
        String entryKey = entryMap.get("entryKey");
        String subEntryKey = entryMap.get("subEntryKey");
        String fieldKey = entryMap.get("fieldKey");
        String mulBaseDataKey = entryMap.get("mulBaseDataKey");
        if (entryKey == null) {
            MetadataUtil.addFieldValueByType(mulBaseDataKey, fieldKey, billDy, valueList);
            return valueList;
        }
        DynamicObjectCollection entryCol = billDy.getDynamicObjectCollection(entryKey);
        boolean bl = needFilterData = matchStartConditionEntryIndexList != null && entryKey.equals(startConditionEntry);
        if (rowRelationDto == null) {
            for (int i = 0; i < entryCol.size(); ++i) {
                if (needFilterData && !matchStartConditionEntryIndexList.contains(i)) continue;
                DynamicObject entryObj = (DynamicObject)entryCol.get(i);
                if (subEntryKey == null) {
                    MetadataUtil.addFieldValueByType(mulBaseDataKey, fieldKey, entryObj, valueList);
                    continue;
                }
                DynamicObjectCollection subEntryCol = entryObj.getDynamicObjectCollection(subEntryKey);
                for (DynamicObject subEntryObj : subEntryCol) {
                    MetadataUtil.addFieldValueByType(mulBaseDataKey, fieldKey, subEntryObj, valueList);
                }
            }
            return valueList;
        }
        LinkedHashMap entryIdMap = rowRelationDto.getEntryIdMap();
        String entryFlag = rowRelationDto.getEntryFlag();
        String targetEntryFlag = rowRelationDto.getTargetEntryFlag();
        if (subEntryKey == null) {
            for (int i = 0; i < entryCol.size(); ++i) {
                if (needFilterData && !matchStartConditionEntryIndexList.contains(i) || entryKey.equals(entryFlag) && !entryIdMap.containsKey(i)) continue;
                if (entryKey.equals(targetEntryFlag)) {
                    boolean matchRowIndex = false;
                    for (Set indexSet : entryIdMap.values()) {
                        if (!indexSet.contains(i)) continue;
                        matchRowIndex = true;
                        break;
                    }
                    if (!matchRowIndex) continue;
                }
                MetadataUtil.addFieldValueByType(mulBaseDataKey, fieldKey, (DynamicObject)entryCol.get(i), valueList);
            }
            return valueList;
        }
        if (rowRelationDto.isTrueSubEntry()) {
            Map trueSubEntryCollectionMap = rowRelationDto.getTrueSubEntryCollectionMap();
            for (Map.Entry entry : entryIdMap.entrySet()) {
                Integer key = (Integer)entry.getKey();
                Set valueSet = (Set)entry.getValue();
                DynamicObjectCollection subEntryCol = (DynamicObjectCollection)trueSubEntryCollectionMap.get(key);
                valueSet.forEach(subEntryIndex -> MetadataUtil.addFieldValueByType(mulBaseDataKey, fieldKey, (DynamicObject)subEntryCol.get(subEntryIndex.intValue()), valueList));
            }
        } else {
            Map entryCollectionMap = rowRelationDto.getEntryCollectionMap();
            DynamicObjectCollection subEntryCol = (DynamicObjectCollection)entryCollectionMap.get(subEntryKey);
            if (subEntryKey.equals(entryFlag) && CollectionUtils.isNotEmpty((Collection)subEntryCol)) {
                entryIdMap.keySet().forEach(subEntryIndex -> MetadataUtil.addFieldValueByType(mulBaseDataKey, fieldKey, (DynamicObject)subEntryCol.get(subEntryIndex.intValue()), valueList));
            } else if (subEntryKey.equals(targetEntryFlag) && CollectionUtils.isNotEmpty((Collection)subEntryCol)) {
                for (Set subEntryIndexSet : entryIdMap.values()) {
                    subEntryIndexSet.forEach(subEntryIndex -> MetadataUtil.addFieldValueByType(mulBaseDataKey, fieldKey, (DynamicObject)subEntryCol.get(subEntryIndex.intValue()), valueList));
                }
            } else {
                DynamicObjectCollection entryDynCol = (DynamicObjectCollection)entryCollectionMap.get(entryKey);
                for (Map.Entry entry : entryIdMap.entrySet()) {
                    DynamicObjectCollection subEntryDynCol;
                    DynamicObject entryDynObj = (DynamicObject)entryDynCol.get(((Integer)entry.getKey()).intValue());
                    if (entryDynObj == null || CollectionUtils.isEmpty((Collection)(subEntryDynCol = entryDynObj.getDynamicObjectCollection(subEntryKey)))) continue;
                    subEntryDynCol.forEach(obj -> MetadataUtil.addFieldValueByType(mulBaseDataKey, fieldKey, obj, valueList));
                }
            }
        }
        return valueList;
    }

    public static void addFieldValueByType(String mulBaseDataKey, String fieldKey, DynamicObject dynObj, List<Object> valueList) {
        if (mulBaseDataKey != null) {
            MulBasedataDynamicObjectCollection col = (MulBasedataDynamicObjectCollection)dynObj.get(mulBaseDataKey);
            for (DynamicObject mulBaseDataObj : col) {
                Object obj = ((DynamicObject)mulBaseDataObj.get("fbasedataid")).get(fieldKey);
                valueList.add(obj instanceof DynamicObject ? ((DynamicObject)obj).getPkValue() : obj);
            }
        } else {
            Object obj = dynObj.get(fieldKey);
            valueList.add(obj instanceof DynamicObject ? ((DynamicObject)obj).getPkValue() : obj);
        }
    }

    public static Map<Integer, List<Object>> getFieldValueMap(DynamicObject billDy, Map<String, String> entryMap, String startConditionEntry, Collection<Integer> matchStartConditionEntryIndexList, EntryRowRelationDTO rowRelationDto) {
        HashMap<Integer, List<Object>> valueMap;
        block12: {
            DynamicObjectCollection entryDynCol;
            String targetEntryFlag;
            LinkedHashMap entryIdMap;
            String mulBaseDataKey;
            String fieldKey;
            String subEntryKey;
            String entryKey;
            block15: {
                Map entryCollectionMap;
                String entryFlag;
                block14: {
                    Map subParentIndexMap;
                    DynamicObjectCollection subEntryCol;
                    block13: {
                        block11: {
                            boolean needFilterData;
                            valueMap = new HashMap<Integer, List<Object>>(10);
                            if (billDy == null || entryMap == null) {
                                return valueMap;
                            }
                            entryKey = entryMap.get("entryKey");
                            subEntryKey = entryMap.get("subEntryKey");
                            fieldKey = entryMap.get("fieldKey");
                            mulBaseDataKey = entryMap.get("mulBaseDataKey");
                            if (StringUtils.isEmpty((String)subEntryKey)) {
                                return valueMap;
                            }
                            DynamicObjectCollection entryCol = billDy.getDynamicObjectCollection(entryKey);
                            boolean bl = needFilterData = matchStartConditionEntryIndexList != null && entryKey.equals(startConditionEntry);
                            if (rowRelationDto == null) {
                                for (int i = 0; i < entryCol.size(); ++i) {
                                    if (needFilterData && !matchStartConditionEntryIndexList.contains(i)) continue;
                                    DynamicObject entryObj = (DynamicObject)entryCol.get(i);
                                    DynamicObjectCollection subEntryCol2 = entryObj.getDynamicObjectCollection(subEntryKey);
                                    ArrayList<Object> valueList = new ArrayList<Object>(subEntryCol2.size());
                                    for (DynamicObject subEntryObj : subEntryCol2) {
                                        MetadataUtil.addFieldValueByType(mulBaseDataKey, fieldKey, subEntryObj, valueList);
                                    }
                                    valueMap.put(i, valueList);
                                }
                                return valueMap;
                            }
                            entryIdMap = rowRelationDto.getEntryIdMap();
                            entryFlag = rowRelationDto.getEntryFlag();
                            targetEntryFlag = rowRelationDto.getTargetEntryFlag();
                            if (!rowRelationDto.isTrueSubEntry() || !targetEntryFlag.equals(subEntryKey)) break block11;
                            Map trueSubEntryCollectionMap = rowRelationDto.getTrueSubEntryCollectionMap();
                            for (Map.Entry entry : entryIdMap.entrySet()) {
                                Integer key = (Integer)entry.getKey();
                                Set valueSet = (Set)entry.getValue();
                                DynamicObjectCollection subEntryCol3 = (DynamicObjectCollection)trueSubEntryCollectionMap.get(key);
                                ArrayList valueList = new ArrayList(10);
                                valueSet.forEach(subEntryIndex -> MetadataUtil.addFieldValueByType(mulBaseDataKey, fieldKey, (DynamicObject)subEntryCol3.get(subEntryIndex.intValue()), valueList));
                                valueMap.put(key, valueList);
                            }
                            break block12;
                        }
                        entryCollectionMap = rowRelationDto.getEntryCollectionMap();
                        subEntryCol = (DynamicObjectCollection)entryCollectionMap.get(subEntryKey);
                        Map parentEntryIndexMap = rowRelationDto.getParentEntryIndexMap();
                        subParentIndexMap = (Map)parentEntryIndexMap.get(entryKey);
                        if (!subEntryKey.equals(entryFlag) || !CollectionUtils.isNotEmpty((Collection)subEntryCol)) break block13;
                        entryIdMap.keySet().forEach(subEntryIndex -> {
                            Integer parentEntryIndex = (Integer)subParentIndexMap.get(subEntryIndex);
                            List valueList = valueMap.computeIfAbsent(parentEntryIndex, k -> new ArrayList(10));
                            MetadataUtil.addFieldValueByType(mulBaseDataKey, fieldKey, (DynamicObject)subEntryCol.get(subEntryIndex.intValue()), valueList);
                        });
                        break block12;
                    }
                    if (!subEntryKey.equals(targetEntryFlag) || !CollectionUtils.isNotEmpty((Collection)subEntryCol)) break block14;
                    for (Set subEntryIndexSet : entryIdMap.values()) {
                        subEntryIndexSet.forEach(subEntryIndex -> {
                            Integer parentEntryIndex = (Integer)subParentIndexMap.get(subEntryIndex);
                            List valueList = valueMap.computeIfAbsent(parentEntryIndex, k -> new ArrayList(10));
                            MetadataUtil.addFieldValueByType(mulBaseDataKey, fieldKey, (DynamicObject)subEntryCol.get(subEntryIndex.intValue()), valueList);
                        });
                    }
                    break block12;
                }
                entryDynCol = (DynamicObjectCollection)entryCollectionMap.get(entryKey);
                if (!entryKey.equals(entryFlag)) break block15;
                for (Map.Entry entry : entryIdMap.entrySet()) {
                    DynamicObjectCollection subEntryDynCol;
                    Integer entryIndex = (Integer)entry.getKey();
                    DynamicObject entryDynObj = (DynamicObject)entryDynCol.get(entryIndex.intValue());
                    if (entryDynObj == null || CollectionUtils.isEmpty((Collection)(subEntryDynCol = entryDynObj.getDynamicObjectCollection(subEntryKey)))) continue;
                    List valueList = valueMap.computeIfAbsent(entryIndex, k -> new ArrayList(10));
                    subEntryDynCol.forEach(obj -> MetadataUtil.addFieldValueByType(mulBaseDataKey, fieldKey, obj, valueList));
                }
                break block12;
            }
            if (!entryKey.equals(targetEntryFlag)) break block12;
            HashSet entryIndexSet = new HashSet(10);
            for (Map.Entry entry : entryIdMap.entrySet()) {
                entryIndexSet.addAll((Collection)entry.getValue());
            }
            if (!entryIndexSet.isEmpty()) {
                for (Integer entryIndex : entryIndexSet) {
                    DynamicObjectCollection subEntryDynCol;
                    DynamicObject entryDynObj = (DynamicObject)entryDynCol.get(entryIndex.intValue());
                    if (entryDynObj == null || CollectionUtils.isEmpty((Collection)(subEntryDynCol = entryDynObj.getDynamicObjectCollection(subEntryKey)))) continue;
                    List valueList = valueMap.computeIfAbsent(entryIndex, k -> new ArrayList(10));
                    subEntryDynCol.forEach(obj -> MetadataUtil.addFieldValueByType(mulBaseDataKey, fieldKey, obj, valueList));
                }
            }
        }
        return valueMap;
    }
}

