/*
 * Decompiled with CFR 0.152.
 */
package kd.data.idi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.data.idi.data.GeneralLedger;
import kd.data.idi.data.SchemaContext;

public class MulAccountHelper {
    public static Object queryTemplateId(Long templateId, String templateNumber) {
        List idList;
        if (StringUtils.isNotEmpty((String)templateNumber) && CollectionUtils.isNotEmpty((Collection)(idList = QueryServiceHelper.queryPrimaryKeys((String)"cvp_template_base", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)templateNumber)}, null, (int)1)))) {
            return idList.get(0);
        }
        return templateId;
    }

    public static Object queryRecognizerId(Long recognizerId, String recognizerNumber) {
        List idList;
        if (StringUtils.isNotEmpty((String)recognizerNumber) && CollectionUtils.isNotEmpty((Collection)(idList = QueryServiceHelper.queryPrimaryKeys((String)"cvp_cls_info", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)recognizerNumber)}, null, (int)1)))) {
            return idList.get(0);
        }
        return recognizerId;
    }

    public static DynamicObject getAccountTable(Number orgId, Number bookTypeId) {
        SchemaContext schemaContext = SchemaContext.get();
        if (schemaContext != null && schemaContext.getCurrentGLAccountTable(orgId, bookTypeId) != null) {
            return schemaContext.getCurrentGLAccountTable(orgId, bookTypeId);
        }
        QFilter orgFilter = new QFilter("org.id", "=", (Object)orgId);
        QFilter bookFilter = new QFilter("bookstype.id", "=", (Object)bookTypeId);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"gl_accountbook", (String)"accounttable.id accountTableId,accounttable.number accountTableNumber,periodtype.id periodTypeId", (QFilter[])new QFilter[]{orgFilter, bookFilter}, null);
        if (!collection.isEmpty()) {
            DynamicObject object = (DynamicObject)collection.get(0);
            if (schemaContext != null) {
                schemaContext.setCurrentGLAccountTable(orgId, bookTypeId, object);
            }
            return object;
        }
        return null;
    }

    public static Long achieveBookTypeId(GeneralLedger generalLedger) {
        List idList;
        String bookTypeNumber = generalLedger.getBookTypeNumber();
        Long bookTypeId = generalLedger.getBookTypeId();
        if (StringUtils.isNotEmpty((String)bookTypeNumber) && CollectionUtils.isNotEmpty((Collection)(idList = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountbookstype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bookTypeNumber)}, null, (int)1)))) {
            bookTypeId = (Long)idList.get(0);
        }
        return bookTypeId;
    }

    public static String achieveAsstactTypeFlexField(GeneralLedger generalLedger) {
        DynamicObject asstactTypeObj;
        String asstactTypeNumber = generalLedger.getAsstactTypeNumber();
        String asstactTypeFlexField = generalLedger.getAsstactTypeFlexField();
        if (StringUtils.isNotEmpty((String)asstactTypeNumber) && (asstactTypeObj = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"flexfield", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)asstactTypeNumber)})) != null) {
            asstactTypeFlexField = asstactTypeObj.getString("flexfield");
        }
        return asstactTypeFlexField;
    }

    public static Long achieveAsstactTypeId(GeneralLedger generalLedger) {
        List idList;
        String asstactTypeNumber = generalLedger.getAsstactTypeNumber();
        Long asstactTypeId = generalLedger.getAsstactTypeId();
        if (StringUtils.isNotEmpty((String)asstactTypeNumber) && CollectionUtils.isNotEmpty((Collection)(idList = QueryServiceHelper.queryPrimaryKeys((String)"bd_asstacttype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)asstactTypeNumber)}, null, (int)1)))) {
            asstactTypeId = (Long)idList.get(0);
        }
        return asstactTypeId;
    }

    public static List<Long> achieveAccountIds(GeneralLedger generalLedger) {
        Map<String, List<String>> orgToAccountMap = generalLedger.getOrgToAccountMap();
        ArrayList<Long> idList = new ArrayList<Long>(3);
        ArrayList<Long> retainIdList = new ArrayList<Long>(3);
        if (orgToAccountMap != null && !orgToAccountMap.isEmpty()) {
            HashSet accountViewNumbers = new HashSet(10);
            orgToAccountMap.forEach((orgNumber, accountNumberList) -> accountViewNumbers.addAll(accountNumberList));
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"MulAccountHelper.achieveAccountIds", (String)"bd_accountview", (String)"id,createorg.number", (QFilter[])new QFilter[]{new QFilter("number", "in", accountViewNumbers)}, null, (int)-1);){
                if (dataSet != null) {
                    for (Row row : dataSet) {
                        String orgNumber2 = row.getString("createorg.number");
                        if (!orgToAccountMap.containsKey(orgNumber2)) continue;
                        Long id = row.getLong("id");
                        idList.add(id);
                        retainIdList.add(id);
                    }
                }
            }
        }
        List<Long> accountViewIds = generalLedger.getAccountViewIds();
        if (CollectionUtils.isNotEmpty(idList)) {
            if (CollectionUtils.isNotEmpty(accountViewIds)) {
                retainIdList.retainAll(accountViewIds);
            }
            return CollectionUtils.isEmpty(retainIdList) ? idList : retainIdList;
        }
        if (CollectionUtils.isEmpty(accountViewIds)) {
            accountViewIds = new ArrayList<Long>(1);
            Long accountId = MulAccountHelper.achieveAccountId(generalLedger);
            if (accountId != null) {
                accountViewIds.add(accountId);
            }
        }
        return accountViewIds;
    }

    public static Long achieveAccountId(GeneralLedger generalLedger) {
        List accountIdList;
        Long accountId = generalLedger.getAccountId();
        String accountNUmber = generalLedger.getAccountNumber();
        String accountTableNUmber = generalLedger.getAccountTableNumber();
        if (StringUtils.isNotEmpty((String)accountNUmber) && StringUtils.isNotEmpty((String)accountTableNUmber) && CollectionUtils.isNotEmpty((Collection)(accountIdList = QueryServiceHelper.queryPrimaryKeys((String)"bd_accountview", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)accountNUmber), new QFilter("accounttable.number", "=", (Object)accountTableNUmber)}, null, (int)1)))) {
            accountId = (Long)accountIdList.get(0);
        }
        return accountId;
    }
}

